<?php
/**
 * Generated stub declarations for WooCommerce.
 * @see https://woocommerce.com
 * @see https://github.com/php-stubs/woocommerce-stubs
 */

namespace {
    /**
     * Abstract WC Data Class
     *
     * Implemented by classes using the same CRUD(s) pattern.
     *
     * @version  2.6.0
     * @package  WooCommerce\Abstracts
     */
    abstract class WC_Data
    {
        /**
         * ID for this object.
         *
         * @since 3.0.0
         * @var int
         */
        protected $id = 0;
        /**
         * Core data for this object. Name value pairs (name + default value).
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array();
        /**
         * Core data changes for this object.
         *
         * @since 3.0.0
         * @var array
         */
        protected $changes = array();
        /**
         * This is false until the object is read from the DB.
         *
         * @since 3.0.0
         * @var bool
         */
        protected $object_read = \false;
        /**
         * This is the name of this object type.
         *
         * @since 3.0.0
         * @var string
         */
        protected $object_type = 'data';
        /**
         * Extra data for this object. Name value pairs (name + default value).
         * Used as a standard way for sub classes (like product types) to add
         * additional information to an inherited class.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array();
        /**
         * Set to _data on construct so we can track and reset data if needed.
         *
         * @since 3.0.0
         * @var array
         */
        protected $default_data = array();
        /**
         * Contains a reference to the data store for this class.
         *
         * @since 3.0.0
         * @var object
         */
        protected $data_store;
        /**
         * Stores meta in cache for future reads.
         * A group must be set to to enable caching.
         *
         * @since 3.0.0
         * @var string
         */
        protected $cache_group = '';
        /**
         * Stores additional meta data.
         *
         * @since 3.0.0
         * @var array
         */
        protected $meta_data = \null;
        /**
         * List of properties that were earlier managed by data store. However, since DataStore is a not a stored entity in itself, they used to store data in metadata of the data object.
         * With custom tables, some of these are moved from metadata to their own columns, but existing code will still try to add them to metadata. This array is used to keep track of such properties.
         *
         * Only reason to add a property here is that you are moving properties from DataStore instance to data object. If you are adding a new property, consider adding it to to $data array instead.
         *
         * @var array
         */
        protected $legacy_datastore_props = array();
        /**
         * Default constructor.
         *
         * @param int|object|array $read ID to load from the DB (optional) or already queried data.
         */
        public function __construct($read = 0)
        {
        }
        /**
         * Only store the object ID to avoid serializing the data object instance.
         *
         * @return array
         */
        public function __sleep()
        {
        }
        /**
         * Re-run the constructor with the object ID.
         *
         * If the object no longer exists, remove the ID.
         */
        public function __wakeup()
        {
        }
        /**
         * When the object is cloned, make sure meta is duplicated correctly.
         *
         * @since 3.0.2
         */
        public function __clone()
        {
        }
        /**
         * Get the data store.
         *
         * @since  3.0.0
         * @return object
         */
        public function get_data_store()
        {
        }
        /**
         * Returns the unique ID for this object.
         *
         * @since  2.6.0
         * @return int
         */
        public function get_id()
        {
        }
        /**
         * Delete an object, set the ID to 0, and return result.
         *
         * @since  2.6.0
         * @param  bool $force_delete Should the date be deleted permanently.
         * @return bool result
         */
        public function delete($force_delete = \false)
        {
        }
        /**
         * Save should create or update based on object existence.
         *
         * @since  2.6.0
         * @return int
         */
        public function save()
        {
        }
        /**
         * Change data to JSON format.
         *
         * @since  2.6.0
         * @return string Data in JSON format.
         */
        public function __toString()
        {
        }
        /**
         * Returns all data for this object.
         *
         * @since  2.6.0
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Returns array of expected data keys for this object.
         *
         * @since   3.0.0
         * @return array
         */
        public function get_data_keys()
        {
        }
        /**
         * Returns all "extra" data keys for an object (for sub objects like product types).
         *
         * @since  3.0.0
         * @return array
         */
        public function get_extra_data_keys()
        {
        }
        /**
         * Filter null meta values from array.
         *
         * @since  3.0.0
         * @param mixed $meta Meta value to check.
         * @return bool
         */
        protected function filter_null_meta($meta)
        {
        }
        /**
         * Get All Meta Data.
         *
         * @since 2.6.0
         * @return array of objects.
         */
        public function get_meta_data()
        {
        }
        /**
         * Check if the key is an internal one.
         *
         * @since  3.2.0
         * @param  string $key Key to check.
         * @return bool   true if it's an internal key, false otherwise
         */
        protected function is_internal_meta_key($key)
        {
        }
        /**
         * Get Meta Data by Key.
         *
         * @since  2.6.0
         * @param  string $key Meta Key.
         * @param  bool   $single return first found meta with key, or all with $key.
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return mixed
         */
        public function get_meta($key = '', $single = \true, $context = 'view')
        {
        }
        /**
         * See if meta data exists, since get_meta always returns a '' or array().
         *
         * @since  3.0.0
         * @param  string $key Meta Key.
         * @return boolean
         */
        public function meta_exists($key = '')
        {
        }
        /**
         * Set all meta data from array.
         *
         * @since 2.6.0
         * @param array $data Key/Value pairs.
         */
        public function set_meta_data($data)
        {
        }
        /**
         * Add meta data.
         *
         * @since 2.6.0
         *
         * @param string       $key Meta key.
         * @param string|array $value Meta value.
         * @param bool         $unique Should this be a unique key?.
         */
        public function add_meta_data($key, $value, $unique = \false)
        {
        }
        /**
         * Update meta data by key or ID, if provided.
         *
         * @since  2.6.0
         *
         * @param  string       $key Meta key.
         * @param  string|array $value Meta value.
         * @param  int          $meta_id Meta ID.
         */
        public function update_meta_data($key, $value, $meta_id = 0)
        {
        }
        /**
         * Delete meta data.
         *
         * @since 2.6.0
         * @param string $key Meta key.
         */
        public function delete_meta_data($key)
        {
        }
        /**
         * Delete meta data with a matching value.
         *
         * @since 7.7.0
         * @param string $key   Meta key.
         * @param mixed  $value Meta value. Entries will only be removed that match the value.
         */
        public function delete_meta_data_value($key, $value)
        {
        }
        /**
         * Delete meta data.
         *
         * @since 2.6.0
         * @param int $mid Meta ID.
         */
        public function delete_meta_data_by_mid($mid)
        {
        }
        /**
         * Read meta data if null.
         *
         * @since 3.0.0
         */
        protected function maybe_read_meta_data()
        {
        }
        /**
         * Helper method to compute meta cache key. Different from WP Meta cache key in that meta data cached using this key also contains meta_id column.
         *
         * @since 4.7.0
         *
         * @return string
         */
        public function get_meta_cache_key()
        {
        }
        /**
         * Generate cache key from id and group.
         *
         * @since 4.7.0
         *
         * @param int|string $id          Object ID.
         * @param string     $cache_group Group name use to store cache. Whole group cache can be invalidated in one go.
         *
         * @return string Meta cache key.
         */
        public static function generate_meta_cache_key($id, $cache_group)
        {
        }
        /**
         * Prime caches for raw meta data. This includes meta_id column as well, which is not included by default in WP meta data.
         *
         * @since 4.7.0
         *
         * @param array  $raw_meta_data_collection Array of objects of { object_id => array( meta_row_1, meta_row_2, ... }.
         * @param string $cache_group              Name of cache group.
         */
        public static function prime_raw_meta_data_cache($raw_meta_data_collection, $cache_group)
        {
        }
        /**
         * Read Meta Data from the database. Ignore any internal properties.
         * Uses it's own caches because get_metadata does not provide meta_ids.
         *
         * @since 2.6.0
         * @param bool $force_read True to force a new DB read (and update cache).
         */
        public function read_meta_data($force_read = \false)
        {
        }
        /**
         * Helper function to initialize metadata entries from filtered raw meta data.
         *
         * @param array $filtered_meta_data Filtered metadata fetched from DB.
         */
        public function init_meta_data(array $filtered_meta_data = array())
        {
        }
        /**
         * Update Meta Data in the database.
         *
         * @since 2.6.0
         */
        public function save_meta_data()
        {
        }
        /**
         * Set ID.
         *
         * @since 3.0.0
         * @param int $id ID.
         */
        public function set_id($id)
        {
        }
        /**
         * Set all props to default values.
         *
         * @since 3.0.0
         */
        public function set_defaults()
        {
        }
        /**
         * Set object read property.
         *
         * @since 3.0.0
         * @param boolean $read Should read?.
         */
        public function set_object_read($read = \true)
        {
        }
        /**
         * Get object read property.
         *
         * @since  3.0.0
         * @return boolean
         */
        public function get_object_read()
        {
        }
        /**
         * Set a collection of props in one go, collect any errors, and return the result.
         * Only sets using public methods.
         *
         * @since  3.0.0
         *
         * @param array  $props Key value pairs to set. Key is the prop and should map to a setter function name.
         * @param string $context In what context to run this.
         *
         * @return bool|WP_Error
         */
        public function set_props($props, $context = 'set')
        {
        }
        /**
         * Sets a prop for a setter method.
         *
         * This stores changes in a special array so we can track what needs saving
         * the the DB later.
         *
         * @since 3.0.0
         * @param string $prop Name of prop to set.
         * @param mixed  $value Value of the prop.
         */
        protected function set_prop($prop, $value)
        {
        }
        /**
         * Return data changes only.
         *
         * @since 3.0.0
         * @return array
         */
        public function get_changes()
        {
        }
        /**
         * Merge changes with data and clear.
         *
         * @since 3.0.0
         */
        public function apply_changes()
        {
        }
        /**
         * Prefix for action and filter hooks on data.
         *
         * @since  3.0.0
         * @return string
         */
        protected function get_hook_prefix()
        {
        }
        /**
         * Gets a prop for a getter method.
         *
         * Gets the value from either current pending changes, or the data itself.
         * Context controls what happens to the value before it's returned.
         *
         * @since  3.0.0
         * @param  string $prop Name of prop to get.
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return mixed
         */
        protected function get_prop($prop, $context = 'view')
        {
        }
        /**
         * Sets a date prop whilst handling formatting and datetime objects.
         *
         * @since 3.0.0
         * @param string         $prop Name of prop to set.
         * @param string|integer $value Value of the prop.
         */
        protected function set_date_prop($prop, $value)
        {
        }
        /**
         * When invalid data is found, throw an exception unless reading from the DB.
         *
         * @throws WC_Data_Exception Data Exception.
         * @since 3.0.0
         * @param string $code             Error code.
         * @param string $message          Error message.
         * @param int    $http_status_code HTTP status code.
         * @param array  $data             Extra error data.
         */
        protected function error($code, $message, $http_status_code = 400, $data = array())
        {
        }
    }
    /**
     * WC_Deprecated_Hooks class maps old actions and filters to new ones. This is the base class for handling those deprecated hooks.
     *
     * Based on the WCS_Hook_Deprecator class by Prospress.
     */
    abstract class WC_Deprecated_Hooks
    {
        /**
         * Array of deprecated hooks we need to handle.
         *
         * @var array
         */
        protected $deprecated_hooks = array();
        /**
         * Array of versions on each hook has been deprecated.
         *
         * @var array
         */
        protected $deprecated_version = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Hook into the new hook so we can handle deprecated hooks once fired.
         *
         * @param string $hook_name Hook name.
         */
        public abstract function hook_in($hook_name);
        /**
         * Get old hooks to map to new hook.
         *
         * @param  string $new_hook New hook name.
         * @return array
         */
        public function get_old_hooks($new_hook)
        {
        }
        /**
         * If the hook is Deprecated, call the old hooks here.
         */
        public function maybe_handle_deprecated_hook()
        {
        }
        /**
         * If the old hook is in-use, trigger it.
         *
         * @param  string $new_hook          New hook name.
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @param  mixed  $return_value      Returned value.
         * @return mixed
         */
        public abstract function handle_deprecated_hook($new_hook, $old_hook, $new_callback_args, $return_value);
        /**
         * Get deprecated version.
         *
         * @param string $old_hook Old hook name.
         * @return string
         */
        protected function get_deprecated_version($old_hook)
        {
        }
        /**
         * Display a deprecated notice for old hooks.
         *
         * @param string $old_hook Old hook.
         * @param string $new_hook New hook.
         */
        protected function display_notice($old_hook, $new_hook)
        {
        }
        /**
         * Fire off a legacy hook with it's args.
         *
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @return mixed
         */
        protected abstract function trigger_hook($old_hook, $new_callback_args);
    }
    /**
     * WC_Settings_API class.
     */
    abstract class WC_Settings_API
    {
        /**
         * The plugin ID. Used for option names.
         *
         * @var string
         */
        public $plugin_id = 'woocommerce_';
        /**
         * ID of the class extending the settings API. Used in option names.
         *
         * @var string
         */
        public $id = '';
        /**
         * Validation errors.
         *
         * @var array of strings
         */
        public $errors = array();
        /**
         * Setting values.
         *
         * @var array
         */
        public $settings = array();
        /**
         * Form option fields.
         *
         * @var array
         */
        public $form_fields = array();
        /**
         * The posted settings data. When empty, $_POST data will be used.
         *
         * @var array
         */
        protected $data = array();
        /**
         * Get the form fields after they are initialized.
         *
         * @return array of options
         */
        public function get_form_fields()
        {
        }
        /**
         * Set default required properties for each field.
         *
         * @param array $field Setting field array.
         * @return array
         */
        protected function set_defaults($field)
        {
        }
        /**
         * Output the admin options table.
         */
        public function admin_options()
        {
        }
        /**
         * Initialise settings form fields.
         *
         * Add an array of fields to be displayed on the gateway's settings screen.
         *
         * @since  1.0.0
         */
        public function init_form_fields()
        {
        }
        /**
         * Return the name of the option in the WP DB.
         *
         * @since 2.6.0
         * @return string
         */
        public function get_option_key()
        {
        }
        /**
         * Get a fields type. Defaults to "text" if not set.
         *
         * @param  array $field Field key.
         * @return string
         */
        public function get_field_type($field)
        {
        }
        /**
         * Get a fields default value. Defaults to "" if not set.
         *
         * @param  array $field Field key.
         * @return string
         */
        public function get_field_default($field)
        {
        }
        /**
         * Get a field's posted and validated value.
         *
         * @param string $key Field key.
         * @param array  $field Field array.
         * @param array  $post_data Posted data.
         * @return string
         */
        public function get_field_value($key, $field, $post_data = array())
        {
        }
        /**
         * Sets the POSTed data. This method can be used to set specific data, instead of taking it from the $_POST array.
         *
         * @param array $data Posted data.
         */
        public function set_post_data($data = array())
        {
        }
        /**
         * Returns the POSTed data, to be used to save the settings.
         *
         * @return array
         */
        public function get_post_data()
        {
        }
        /**
         * Update a single option.
         *
         * @since 3.4.0
         * @param string $key Option key.
         * @param mixed  $value Value to set.
         * @return bool was anything saved?
         */
        public function update_option($key, $value = '')
        {
        }
        /**
         * Processes and saves options.
         * If there is an error thrown, will continue to save and validate fields, but will leave the erroring field out.
         *
         * @return bool was anything saved?
         */
        public function process_admin_options()
        {
        }
        /**
         * Add an error message for display in admin on save.
         *
         * @param string $error Error message.
         */
        public function add_error($error)
        {
        }
        /**
         * Get admin error messages.
         */
        public function get_errors()
        {
        }
        /**
         * Display admin error messages.
         */
        public function display_errors()
        {
        }
        /**
         * Initialise Settings.
         *
         * Store all settings in a single database entry
         * and make sure the $settings array is either the default
         * or the settings stored in the database.
         *
         * @since 1.0.0
         * @uses get_option(), add_option()
         */
        public function init_settings()
        {
        }
        /**
         * Get option from DB.
         *
         * Gets an option from the settings API, using defaults if necessary to prevent undefined notices.
         *
         * @param  string $key Option key.
         * @param  mixed  $empty_value Value when empty.
         * @return string The value specified for the option or a default value for the option.
         */
        public function get_option($key, $empty_value = \null)
        {
        }
        /**
         * Prefix key for settings.
         *
         * @param  string $key Field key.
         * @return string
         */
        public function get_field_key($key)
        {
        }
        /**
         * Generate Settings HTML.
         *
         * Generate the HTML for the fields on the "settings" screen.
         *
         * @param array $form_fields (default: array()) Array of form fields.
         * @param bool  $echo Echo or return.
         * @return string the html for the settings
         * @since  1.0.0
         * @uses   method_exists()
         */
        public function generate_settings_html($form_fields = array(), $echo = \true)
        {
        }
        /**
         * Get HTML for tooltips.
         *
         * @param  array $data Data for the tooltip.
         * @return string
         */
        public function get_tooltip_html($data)
        {
        }
        /**
         * Get HTML for descriptions.
         *
         * @param  array $data Data for the description.
         * @return string
         */
        public function get_description_html($data)
        {
        }
        /**
         * Get custom attributes.
         *
         * @param  array $data Field data.
         * @return string
         */
        public function get_custom_attribute_html($data)
        {
        }
        /**
         * Generate Text Input HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_text_html($key, $data)
        {
        }
        /**
         * Generates HTML for the 'safe_text' input type (mostly used for gateway-related settings).
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @return string
         *
         * @since 7.6.0
         */
        public function generate_safe_text_html($key, $data)
        {
        }
        /**
         * Generate Price Input HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_price_html($key, $data)
        {
        }
        /**
         * Generate Decimal Input HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_decimal_html($key, $data)
        {
        }
        /**
         * Generate Password Input HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_password_html($key, $data)
        {
        }
        /**
         * Generate Color Picker Input HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_color_html($key, $data)
        {
        }
        /**
         * Generate Textarea HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_textarea_html($key, $data)
        {
        }
        /**
         * Generate Checkbox HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_checkbox_html($key, $data)
        {
        }
        /**
         * Generate Select HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_select_html($key, $data)
        {
        }
        /**
         * Generate Multiselect HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_multiselect_html($key, $data)
        {
        }
        /**
         * Generate Title HTML.
         *
         * @param string $key Field key.
         * @param array  $data Field data.
         * @since  1.0.0
         * @return string
         */
        public function generate_title_html($key, $data)
        {
        }
        /**
         * Validate Text Field.
         *
         * Make sure the data is escaped correctly, etc.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_text_field($key, $value)
        {
        }
        /**
         * Sanitize 'Safe Text' fields.
         *
         * These fields are similar to regular text fields, but a much  smaller set of HTML tags are allowed. By default,
         * this means `<br>`, `<img>`, `<p>` and `<span>` tags.
         *
         * Note: this is a sanitization method, rather than a validation method (the name is due to some historic naming
         * choices).
         *
         * @param  string $key   Field key (currently unused).
         * @param  string $value Posted Value.
         *
         * @return string
         */
        public function validate_safe_text_field(string $key, ?string $value) : string
        {
        }
        /**
         * Validate Price Field.
         *
         * Make sure the data is escaped correctly, etc.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_price_field($key, $value)
        {
        }
        /**
         * Validate Decimal Field.
         *
         * Make sure the data is escaped correctly, etc.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_decimal_field($key, $value)
        {
        }
        /**
         * Validate Password Field. No input sanitization is used to avoid corrupting passwords.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_password_field($key, $value)
        {
        }
        /**
         * Validate Textarea Field.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_textarea_field($key, $value)
        {
        }
        /**
         * Validate Checkbox Field.
         *
         * If not set, return "no", otherwise return "yes".
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_checkbox_field($key, $value)
        {
        }
        /**
         * Validate Select Field.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string
         */
        public function validate_select_field($key, $value)
        {
        }
        /**
         * Validate Multiselect Field.
         *
         * @param  string $key Field key.
         * @param  string $value Posted Value.
         * @return string|array
         */
        public function validate_multiselect_field($key, $value)
        {
        }
        /**
         * Validate the data on the "Settings" form.
         *
         * @deprecated 2.6.0 No longer used.
         * @param array $form_fields Array of fields.
         */
        public function validate_settings_fields($form_fields = array())
        {
        }
        /**
         * Format settings if needed.
         *
         * @deprecated 2.6.0 Unused.
         * @param  array $value Value to format.
         * @return array
         */
        public function format_settings($value)
        {
        }
    }
    /**
     * Abstract Integration Class
     *
     * Extended by individual integrations to offer additional functionality.
     *
     * @class    WC_Integration
     * @extends  WC_Settings_API
     * @version  2.6.0
     * @package  WooCommerce\Abstracts
     */
    abstract class WC_Integration extends \WC_Settings_API
    {
        /**
         * Yes or no based on whether the integration is enabled.
         *
         * @var string
         */
        public $enabled = 'yes';
        /**
         * Integration title.
         *
         * @var string
         */
        public $method_title = '';
        /**
         * Integration description.
         *
         * @var string
         */
        public $method_description = '';
        /**
         * Return the title for admin screens.
         *
         * @return string
         */
        public function get_method_title()
        {
        }
        /**
         * Return the description for admin screens.
         *
         * @return string
         */
        public function get_method_description()
        {
        }
        /**
         * Output the gateway settings screen.
         */
        public function admin_options()
        {
        }
        /**
         * Init settings for gateways.
         */
        public function init_settings()
        {
        }
    }
    /**
     * Log Handler Interface
     *
     * @version 3.3.0
     * @package WooCommerce\Interface
     */
    /**
     * WC Log Handler Interface
     *
     * Functions that must be defined to correctly fulfill log handler API.
     *
     * @version 3.3.0
     */
    interface WC_Log_Handler_Interface
    {
        /**
         * Handle a log entry.
         *
         * @param int    $timestamp Log timestamp.
         * @param string $level emergency|alert|critical|error|warning|notice|info|debug.
         * @param string $message Log message.
         * @param array  $context Additional information for log handlers.
         *
         * @return bool False if value was not handled and true if value was handled.
         */
        public function handle($timestamp, $level, $message, $context);
    }
    /**
     * Abstract WC Log Handler Class
     *
     * @version        1.0.0
     * @package        WooCommerce\Abstracts
     */
    abstract class WC_Log_Handler implements \WC_Log_Handler_Interface
    {
        /**
         * Formats a timestamp for use in log messages.
         *
         * @param int $timestamp Log timestamp.
         * @return string Formatted time for use in log entry.
         */
        protected static function format_time($timestamp)
        {
        }
        /**
         * Builds a log entry text from level, timestamp and message.
         *
         * @param int    $timestamp Log timestamp.
         * @param string $level emergency|alert|critical|error|warning|notice|info|debug.
         * @param string $message Log message.
         * @param array  $context Additional information for log handlers.
         *
         * @return string Formatted log entry.
         */
        protected static function format_entry($timestamp, $level, $message, $context)
        {
        }
        /**
         * Get a backtrace that shows where the logging function was called.
         *
         * @return array
         */
        protected static function get_backtrace()
        {
        }
    }
    /**
     * Abstract WC Object Query Class
     *
     * Extended by classes to provide a query abstraction layer for safe object searching.
     *
     * @version  3.1.0
     * @package  WooCommerce\Abstracts
     */
    abstract class WC_Object_Query
    {
        /**
         * Stores query data.
         *
         * @var array
         */
        protected $query_vars = array();
        /**
         * Create a new query.
         *
         * @param array $args Criteria to query on in a format similar to WP_Query.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Get the current query vars.
         *
         * @return array
         */
        public function get_query_vars()
        {
        }
        /**
         * Get the value of a query variable.
         *
         * @param string $query_var Query variable to get value for.
         * @param mixed  $default Default value if query variable is not set.
         * @return mixed Query variable value if set, otherwise default.
         */
        public function get($query_var, $default = '')
        {
        }
        /**
         * Set a query variable.
         *
         * @param string $query_var Query variable to set.
         * @param mixed  $value Value to set for query variable.
         */
        public function set($query_var, $value)
        {
        }
        /**
         * Get the default allowed query vars.
         *
         * @return array
         */
        protected function get_default_query_vars()
        {
        }
    }
    /**
     * Legacy Abstract Order
     *
     * Legacy and deprecated functions are here to keep the WC_Abstract_Order clean.
     * This class will be removed in future versions.
     *
     * @version	 3.0.0
     * @package	 WooCommerce\Abstracts
     * @category	Abstract Class
     * @author	  WooThemes
     */
    abstract class WC_Abstract_Legacy_Order extends \WC_Data
    {
        /**
         * Add coupon code to the order.
         * @param string|array $code
         * @param int $discount tax amount.
         * @param int $discount_tax amount.
         * @return int order item ID
         * @throws WC_Data_Exception
         */
        public function add_coupon($code = array(), $discount = 0, $discount_tax = 0)
        {
        }
        /**
         * Add a tax row to the order.
         * @param int $tax_rate_id
         * @param int $tax_amount amount of tax.
         * @param int $shipping_tax_amount shipping amount.
         * @return int order item ID
         * @throws WC_Data_Exception
         */
        public function add_tax($tax_rate_id, $tax_amount = 0, $shipping_tax_amount = 0)
        {
        }
        /**
         * Add a shipping row to the order.
         * @param WC_Shipping_Rate shipping_rate
         * @return int order item ID
         * @throws WC_Data_Exception
         */
        public function add_shipping($shipping_rate)
        {
        }
        /**
         * Add a fee to the order.
         * Order must be saved prior to adding items.
         *
         * Fee is an amount of money charged for a particular piece of work
         * or for a particular right or service, and not supposed to be negative.
         *
         * @throws WC_Data_Exception
         * @param  object $fee Fee data.
         * @return int         Updated order item ID.
         */
        public function add_fee($fee)
        {
        }
        /**
         * Update a line item for the order.
         *
         * Note this does not update order totals.
         *
         * @param object|int $item order item ID or item object.
         * @param WC_Product $product
         * @param array $args data to update.
         * @return int updated order item ID
         * @throws WC_Data_Exception
         */
        public function update_product($item, $product, $args)
        {
        }
        /**
         * Update coupon for order. Note this does not update order totals.
         * @param object|int $item
         * @param array $args
         * @return int updated order item ID
         * @throws WC_Data_Exception
         */
        public function update_coupon($item, $args)
        {
        }
        /**
         * Update shipping method for order.
         *
         * Note this does not update the order total.
         *
         * @param object|int $item
         * @param array $args
         * @return int updated order item ID
         * @throws WC_Data_Exception
         */
        public function update_shipping($item, $args)
        {
        }
        /**
         * Update fee for order.
         *
         * Note this does not update order totals.
         *
         * @param object|int $item
         * @param array $args
         * @return int updated order item ID
         * @throws WC_Data_Exception
         */
        public function update_fee($item, $args)
        {
        }
        /**
         * Update tax line on order.
         * Note this does not update order totals.
         *
         * @since 3.0
         * @param object|int $item
         * @param array $args
         * @return int updated order item ID
         * @throws WC_Data_Exception
         */
        public function update_tax($item, $args)
        {
        }
        /**
         * Get a product (either product or variation).
         * @deprecated 4.4.0
         * @param object $item
         * @return WC_Product|bool
         */
        public function get_product_from_item($item)
        {
        }
        /**
         * Set the customer address.
         * @param array $address Address data.
         * @param string $type Type of address; 'billing' or 'shipping'.
         */
        public function set_address($address, $type = 'billing')
        {
        }
        /**
         * Set an order total.
         * @param float $amount
         * @param string $total_type
         * @return bool
         */
        public function legacy_set_total($amount, $total_type = 'total')
        {
        }
        /**
         * Magic __isset method for backwards compatibility. Handles legacy properties which could be accessed directly in the past.
         *
         * @param string $key
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic __get method for backwards compatibility.
         *
         * @param string $key
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * has_meta function for order items. This is different to the WC_Data
         * version and should be removed in future versions.
         *
         * @deprecated 3.0
         *
         * @param int $order_item_id
         *
         * @return array of meta data.
         */
        public function has_meta($order_item_id)
        {
        }
        /**
         * Display meta data belonging to an item.
         * @param  array $item
         */
        public function display_item_meta($item)
        {
        }
        /**
         * Display download links for an order item.
         * @param  array $item
         */
        public function display_item_downloads($item)
        {
        }
        /**
         * Get the Download URL.
         *
         * @param  int $product_id
         * @param  int $download_id
         * @return string
         */
        public function get_download_url($product_id, $download_id)
        {
        }
        /**
         * Get the downloadable files for an item in this order.
         *
         * @param  array $item
         * @return array
         */
        public function get_item_downloads($item)
        {
        }
        /**
         * Gets shipping total. Alias of WC_Order::get_shipping_total().
         * @deprecated 3.0.0 since this is an alias only.
         * @return float
         */
        public function get_total_shipping()
        {
        }
        /**
         * Get order item meta.
         * @deprecated 3.0.0
         * @param mixed $order_item_id
         * @param string $key (default: '')
         * @param bool $single (default: false)
         * @return array|string
         */
        public function get_item_meta($order_item_id, $key = '', $single = \false)
        {
        }
        /**
         * Get all item meta data in array format in the order it was saved. Does not group meta by key like get_item_meta().
         *
         * @param mixed $order_item_id
         * @return array of objects
         */
        public function get_item_meta_array($order_item_id)
        {
        }
        /**
         * Get coupon codes only.
         *
         * @deprecated 3.7.0 - Replaced with better named method to reflect the actual data being returned.
         * @return array
         */
        public function get_used_coupons()
        {
        }
        /**
         * Expand item meta into the $item array.
         * @deprecated 3.0.0 Item meta no longer expanded due to new order item
         *		classes. This function now does nothing to avoid data breakage.
         * @param array $item before expansion.
         * @return array
         */
        public function expand_item_meta($item)
        {
        }
        /**
         * Load the order object. Called from the constructor.
         * @deprecated 3.0.0 Logic moved to constructor
         * @param int|object|WC_Order $order Order to init.
         */
        protected function init($order)
        {
        }
        /**
         * Gets an order from the database.
         * @deprecated 3.0
         * @param int $id (default: 0).
         * @return bool
         */
        public function get_order($id = 0)
        {
        }
        /**
         * Populates an order from the loaded post data.
         * @deprecated 3.0
         * @param mixed $result
         */
        public function populate($result)
        {
        }
        /**
         * Cancel the order and restore the cart (before payment).
         * @deprecated 3.0.0 Moved to event handler.
         * @param string $note (default: '') Optional note to add.
         */
        public function cancel_order($note = '')
        {
        }
        /**
         * Record sales.
         * @deprecated 3.0.0
         */
        public function record_product_sales()
        {
        }
        /**
         * Increase applied coupon counts.
         * @deprecated 3.0.0
         */
        public function increase_coupon_usage_counts()
        {
        }
        /**
         * Decrease applied coupon counts.
         * @deprecated 3.0.0
         */
        public function decrease_coupon_usage_counts()
        {
        }
        /**
         * Reduce stock levels for all line items in the order.
         * @deprecated 3.0.0
         */
        public function reduce_order_stock()
        {
        }
        /**
         * Send the stock notifications.
         * @deprecated 3.0.0 No longer needs to be called directly.
         *
         * @param $product
         * @param $new_stock
         * @param $qty_ordered
         */
        public function send_stock_notifications($product, $new_stock, $qty_ordered)
        {
        }
        /**
         * Output items for display in html emails.
         * @deprecated 3.0.0 Moved to template functions.
         * @param array $args Items args.
         * @return string
         */
        public function email_order_items_table($args = array())
        {
        }
        /**
         * Get currency.
         * @deprecated 3.0.0
         */
        public function get_order_currency()
        {
        }
    }
    /**
     * Trait WC_Item_Totals.
     *
     * Right now this do not have much, but plan is to eventually move all shared calculation logic between Orders and Cart in this file.
     *
     * @since 3.9.0
     */
    trait WC_Item_Totals
    {
        /**
         * Line items to calculate. Define in child class.
         *
         * @since 3.9.0
         * @param string $field Field name to calculate upon.
         *
         * @return array having `total`|`subtotal` property.
         */
        protected abstract function get_values_for_total($field);
        /**
         * Return rounded total based on settings. Will be used by Cart and Orders.
         *
         * @since 3.9.0
         *
         * @param array $values Values to round. Should be with precision.
         *
         * @return float|int Appropriately rounded value.
         */
        public static function get_rounded_items_total($values)
        {
        }
        /**
         * Apply rounding to item subtotal before summing.
         *
         * @since 3.9.0
         * @param float $value Item subtotal value.
         * @return float
         */
        public static function round_item_subtotal($value)
        {
        }
        /**
         * Should always round at subtotal?
         *
         * @since 3.9.0
         * @return bool
         */
        protected static function round_at_subtotal()
        {
        }
        /**
         * Apply rounding to an array of taxes before summing. Rounds to store DP setting, ignoring precision.
         *
         * @since  3.2.6
         * @param  float $value    Tax value.
         * @param  bool  $in_cents Whether precision of value is in cents.
         * @return float
         */
        protected static function round_line_tax($value, $in_cents = \true)
        {
        }
    }
    /**
     * WC_Abstract_Order class.
     */
    abstract class WC_Abstract_Order extends \WC_Abstract_Legacy_Order
    {
        use \WC_Item_Totals;
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * Notes: cart_tax = cart_tax is the new name for the legacy 'order_tax'
         * which is the tax for items only, not shipping.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('parent_id' => 0, 'status' => '', 'currency' => '', 'version' => '', 'prices_include_tax' => \false, 'date_created' => \null, 'date_modified' => \null, 'discount_total' => 0, 'discount_tax' => 0, 'shipping_total' => 0, 'shipping_tax' => 0, 'cart_tax' => 0, 'total' => 0, 'total_tax' => 0);
        /**
         * List of properties that were earlier managed by data store. However, since DataStore is a not a stored entity in itself, they used to store data in metadata of the data object.
         * With custom tables, some of these are moved from metadata to their own columns, but existing code will still try to add them to metadata. This array is used to keep track of such properties.
         *
         * Only reason to add a property here is that you are moving properties from DataStore instance to data object. If you are adding a new property, consider adding it to to $data array instead.
         *
         * @var array
         */
        protected $legacy_datastore_props = array('_recorded_coupon_usage_counts');
        /**
         * Order items will be stored here, sometimes before they persist in the DB.
         *
         * @since 3.0.0
         * @var array
         */
        protected $items = array();
        /**
         * Order items that need deleting are stored here.
         *
         * @since 3.0.0
         * @var array
         */
        protected $items_to_delete = array();
        /**
         * Stores meta in cache for future reads.
         *
         * A group must be set to to enable caching.
         *
         * @var string
         */
        protected $cache_group = 'orders';
        /**
         * Which data store to load.
         *
         * @var string
         */
        protected $data_store_name = 'order';
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'order';
        /**
         * Get the order if ID is passed, otherwise the order is new and empty.
         * This class should NOT be instantiated, but the wc_get_order function or new WC_Order_Factory
         * should be used. It is possible, but the aforementioned are preferred and are the only
         * methods that will be maintained going forward.
         *
         * @param  int|object|WC_Order $order Order to read.
         */
        public function __construct($order = 0)
        {
        }
        /**
         * This method overwrites the base class's clone method to make it a no-op. In base class WC_Data, we are unsetting the meta_id to clone.
         * It seems like this was done to avoid conflicting the metadata when duplicating products. However, doing that does not seems necessary for orders.
         * In-fact, when we do that for orders, we lose the capability to clone orders with custom meta data by caching plugins. This is because, when we clone an order object for caching, it will clone the metadata without the ID. Unfortunately, when this cached object with nulled meta ID is retrieved, WC_Data will consider it as a new meta and will insert it as a new meta-data causing duplicates.
         *
         * Eventually, we should move away from overwriting the __clone method in base class itself, since it's easily possible to still duplicate the product without having to hook into the __clone method.
         *
         * @since 7.6.0
         */
        public function __clone()
        {
        }
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get all class data in array format.
         *
         * @since 3.0.0
         * @return array
         */
        public function get_data()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | CRUD methods
        |--------------------------------------------------------------------------
        |
        | Methods which create, read, update and delete orders from the database.
        | Written in abstract fashion so that the way orders are stored can be
        | changed more easily in the future.
        |
        | A save method is included for convenience (chooses update or create based
        | on if the order exists yet).
        |
        */
        /**
         * Save data to the database.
         *
         * @since 3.0.0
         * @return int order ID
         */
        public function save()
        {
        }
        /**
         * Log an error about this order is exception is encountered.
         *
         * @param Exception $e Exception object.
         * @param string    $message Message regarding exception thrown.
         * @since 3.7.0
         */
        protected function handle_exception($e, $message = 'Error')
        {
        }
        /**
         * Save all order items which are part of this order.
         */
        protected function save_items()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get parent order ID.
         *
         * @since 3.0.0
         * @param  string $context View or edit context.
         * @return integer
         */
        public function get_parent_id($context = 'view')
        {
        }
        /**
         * Gets order currency.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_currency($context = 'view')
        {
        }
        /**
         * Get order_version.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_version($context = 'view')
        {
        }
        /**
         * Get prices_include_tax.
         *
         * @param  string $context View or edit context.
         * @return bool
         */
        public function get_prices_include_tax($context = 'view')
        {
        }
        /**
         * Get date_created.
         *
         * @param  string $context View or edit context.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_created($context = 'view')
        {
        }
        /**
         * Get date_modified.
         *
         * @param  string $context View or edit context.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_modified($context = 'view')
        {
        }
        /**
         * Get date_modified.
         *
         * @param  string $context View or edit context.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_paid($context = 'view')
        {
        }
        /**
         * Get date_modified.
         *
         * @param  string $context View or edit context.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_completed($context = 'view')
        {
        }
        /**
         * Return the order statuses without wc- internal prefix.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_status($context = 'view')
        {
        }
        /**
         * Get discount_total.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_discount_total($context = 'view')
        {
        }
        /**
         * Get discount_tax.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_discount_tax($context = 'view')
        {
        }
        /**
         * Get shipping_total.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_shipping_total($context = 'view')
        {
        }
        /**
         * Get shipping_tax.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_shipping_tax($context = 'view')
        {
        }
        /**
         * Gets cart tax amount.
         *
         * @param  string $context View or edit context.
         * @return float
         */
        public function get_cart_tax($context = 'view')
        {
        }
        /**
         * Gets order grand total including taxes, shipping cost, fees, and coupon discounts. Used in gateways.
         *
         * @param  string $context View or edit context.
         * @return float
         */
        public function get_total($context = 'view')
        {
        }
        /**
         * Get total tax amount. Alias for get_order_tax().
         *
         * @param  string $context View or edit context.
         * @return float
         */
        public function get_total_tax($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Non-CRUD Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Gets the total discount amount.
         *
         * @param  bool $ex_tax Show discount excl any tax.
         * @return float
         */
        public function get_total_discount($ex_tax = \true)
        {
        }
        /**
         * Gets order subtotal. Order subtotal is the price of all items excluding taxes, fees, shipping cost, and coupon discounts.
         * If sale price is set on an item, the subtotal will include this sale discount. E.g. a product with a regular
         * price of $100 bought at a 50% discount will represent $50 of the subtotal for the order.
         *
         * @return float
         */
        public function get_subtotal()
        {
        }
        /**
         * Get taxes, merged by code, formatted ready for output.
         *
         * @return array
         */
        public function get_tax_totals()
        {
        }
        /**
         * Get all valid statuses for this order
         *
         * @since 3.0.0
         * @return array Internal status keys e.g. 'wc-processing'
         */
        protected function get_valid_statuses()
        {
        }
        /**
         * Get user ID. Used by orders, not other order types like refunds.
         *
         * @param  string $context View or edit context.
         * @return int
         */
        public function get_user_id($context = 'view')
        {
        }
        /**
         * Get user. Used by orders, not other order types like refunds.
         *
         * @return WP_User|false
         */
        public function get_user()
        {
        }
        /**
         * Gets information about whether coupon counts were updated.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         *
         * @return bool True if coupon counts were updated, false otherwise.
         */
        public function get_recorded_coupon_usage_counts($context = 'view')
        {
        }
        /**
         * Get basic order data in array format.
         *
         * @return array
         */
        public function get_base_data()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Functions for setting order data. These should not update anything in the
        | database itself and should only change what is stored in the class
        | object. However, for backwards compatibility pre 3.0.0 some of these
        | setters may handle both.
        */
        /**
         * Set parent order ID.
         *
         * @since 3.0.0
         * @param int $value Value to set.
         * @throws WC_Data_Exception Exception thrown if parent ID does not exist or is invalid.
         */
        public function set_parent_id($value)
        {
        }
        /**
         * Set order status.
         *
         * @since 3.0.0
         * @param string $new_status Status to change the order to. No internal wc- prefix is required.
         * @return array details of change
         */
        public function set_status($new_status)
        {
        }
        /**
         * Set order_version.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_version($value)
        {
        }
        /**
         * Set order_currency.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_currency($value)
        {
        }
        /**
         * Set prices_include_tax.
         *
         * @param bool $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_prices_include_tax($value)
        {
        }
        /**
         * Set date_created.
         *
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if there is no date.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_date_created($date = \null)
        {
        }
        /**
         * Set date_modified.
         *
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if there is no date.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_date_modified($date = \null)
        {
        }
        /**
         * Set discount_total.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_discount_total($value)
        {
        }
        /**
         * Set discount_tax.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_discount_tax($value)
        {
        }
        /**
         * Set shipping_total.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_shipping_total($value)
        {
        }
        /**
         * Set shipping_tax.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_shipping_tax($value)
        {
        }
        /**
         * Set cart tax.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_cart_tax($value)
        {
        }
        /**
         * Sets order tax (sum of cart and shipping tax). Used internally only.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        protected function set_total_tax($value)
        {
        }
        /**
         * Set total.
         *
         * @param string $value Value to set.
         * @param string $deprecated Function used to set different totals based on this.
         *
         * @return bool|void
         * @throws WC_Data_Exception Exception may be thrown if value is invalid.
         */
        public function set_total($value, $deprecated = '')
        {
        }
        /**
         * Stores information about whether the coupon usage were counted.
         *
         * @param bool|string $value True if counted, false if not.
         *
         * @return void
         */
        public function set_recorded_coupon_usage_counts($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Order Item Handling
        |--------------------------------------------------------------------------
        |
        | Order items are used for products, taxes, shipping, and fees within
        | each order.
        */
        /**
         * Remove all line items (products, coupons, shipping, taxes) from the order.
         *
         * @param string $type Order item type. Default null.
         */
        public function remove_order_items($type = \null)
        {
        }
        /**
         * Convert a type to a types group.
         *
         * @param string $type type to lookup.
         * @return string
         */
        protected function type_to_group($type)
        {
        }
        /**
         * Return an array of items/products within this order.
         *
         * @param string|array $types Types of line items to get (array or string).
         * @return WC_Order_Item[]
         */
        public function get_items($types = 'line_item')
        {
        }
        /**
         * Return array of values for calculations.
         *
         * @param string $field Field name to return.
         *
         * @return array Array of values.
         */
        protected function get_values_for_total($field)
        {
        }
        /**
         * Return an array of coupons within this order.
         *
         * @since  3.7.0
         * @return WC_Order_Item_Coupon[]
         */
        public function get_coupons()
        {
        }
        /**
         * Return an array of fees within this order.
         *
         * @return WC_Order_item_Fee[]
         */
        public function get_fees()
        {
        }
        /**
         * Return an array of taxes within this order.
         *
         * @return WC_Order_Item_Tax[]
         */
        public function get_taxes()
        {
        }
        /**
         * Return an array of shipping costs within this order.
         *
         * @return WC_Order_Item_Shipping[]
         */
        public function get_shipping_methods()
        {
        }
        /**
         * Gets formatted shipping method title.
         *
         * @return string
         */
        public function get_shipping_method()
        {
        }
        /**
         * Get used coupon codes only.
         *
         * @since 3.7.0
         * @return array
         */
        public function get_coupon_codes()
        {
        }
        /**
         * Gets the count of order items of a certain type.
         *
         * @param string $item_type Item type to lookup.
         * @return int|string
         */
        public function get_item_count($item_type = '')
        {
        }
        /**
         * Get an order item object, based on its type.
         *
         * @since  3.0.0
         * @param  int  $item_id ID of item to get.
         * @param  bool $load_from_db Prior to 3.2 this item was loaded direct from WC_Order_Factory, not this object. This param is here for backwards compatibility with that. If false, uses the local items variable instead.
         * @return WC_Order_Item|false
         */
        public function get_item($item_id, $load_from_db = \true)
        {
        }
        /**
         * Get key for where a certain item type is stored in _items.
         *
         * @since  3.0.0
         * @param  string $item object Order item (product, shipping, fee, coupon, tax).
         * @return string
         */
        protected function get_items_key($item)
        {
        }
        /**
         * Remove item from the order.
         *
         * @param int $item_id Item ID to delete.
         * @return false|void
         */
        public function remove_item($item_id)
        {
        }
        /**
         * Adds an order item to this order. The order item will not persist until save.
         *
         * @since 3.0.0
         * @param WC_Order_Item $item Order item object (product, shipping, fee, coupon, tax).
         * @return false|void
         */
        public function add_item($item)
        {
        }
        /**
         * Check and records coupon usage tentatively so that counts validation is correct. Display an error if coupon usage limit has been reached.
         *
         * If you are using this method, make sure to `release_held_coupons` in case an Exception is thrown.
         *
         * @throws Exception When not able to apply coupon.
         *
         * @param string $billing_email Billing email of order.
         */
        public function hold_applied_coupons($billing_email)
        {
        }
        /**
         * Hold coupon if a global usage limit is defined.
         *
         * @param WC_Coupon $coupon Coupon object.
         *
         * @return string    Meta key which indicates held coupon.
         * @throws Exception When can't be held.
         */
        private function hold_coupon($coupon)
        {
        }
        /**
         * Hold coupon if usage limit per customer is defined.
         *
         * @param WC_Coupon $coupon              Coupon object.
         * @param array     $user_ids_and_emails Array of user Id and emails to check for usage limit.
         * @param string    $user_alias          User ID or email to use to record current usage.
         *
         * @return string    Meta key which indicates held coupon.
         * @throws Exception When coupon can't be held.
         */
        private function hold_coupon_for_users($coupon, $user_ids_and_emails, $user_alias)
        {
        }
        /**
         * Helper method to get all aliases for current user and provide billing email.
         *
         * @param string $billing_email Billing email provided in form.
         *
         * @return array     Array of all aliases.
         * @throws Exception When validation fails.
         */
        private function get_billing_and_current_user_aliases($billing_email)
        {
        }
        /**
         * Apply a coupon to the order and recalculate totals.
         *
         * @since 3.2.0
         * @param string|WC_Coupon $raw_coupon Coupon code or object.
         * @return true|WP_Error True if applied, error if not.
         */
        public function apply_coupon($raw_coupon)
        {
        }
        /**
         * Remove a coupon from the order and recalculate totals.
         *
         * Coupons affect line item totals, but there is no relationship between
         * coupon and line total, so to remove a coupon we need to work from the
         * line subtotal (price before discount) and re-apply all coupons in this
         * order.
         *
         * Manual discounts are not affected; those are separate and do not affect
         * stored line totals.
         *
         * @since 3.2.0
         * @since 7.6.0 Returns a boolean indicating success.
         *
         * @param  string $code Coupon code.
         * @return bool TRUE if coupon was removed, FALSE otherwise.
         */
        public function remove_coupon($code)
        {
        }
        /**
         * Apply all coupons in this order again to all line items.
         * This method is public since WooCommerce 3.8.0.
         *
         * @since 3.2.0
         */
        public function recalculate_coupons()
        {
        }
        /**
         * After applying coupons via the WC_Discounts class, update line items.
         *
         * @since 3.2.0
         * @param WC_Discounts $discounts Discounts class.
         */
        protected function set_item_discount_amounts($discounts)
        {
        }
        /**
         * After applying coupons via the WC_Discounts class, update or create coupon items.
         *
         * @since 3.2.0
         * @param WC_Discounts $discounts Discounts class.
         */
        protected function set_coupon_discount_amounts($discounts)
        {
        }
        /**
         * Add a product line item to the order. This is the only line item type with
         * its own method because it saves looking up order amounts (costs are added up for you).
         *
         * @param  WC_Product $product Product object.
         * @param  int        $qty Quantity to add.
         * @param  array      $args Args for the added product.
         * @return int
         */
        public function add_product($product, $qty = 1, $args = array())
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Payment Token Handling
        |--------------------------------------------------------------------------
        |
        | Payment tokens are hashes used to take payments by certain gateways.
        |
        */
        /**
         * Add a payment token to an order
         *
         * @since 2.6
         * @param WC_Payment_Token $token Payment token object.
         * @return boolean|int The new token ID or false if it failed.
         */
        public function add_payment_token($token)
        {
        }
        /**
         * Returns a list of all payment tokens associated with the current order
         *
         * @since 2.6
         * @return array An array of payment token objects
         */
        public function get_payment_tokens()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Calculations.
        |--------------------------------------------------------------------------
        |
        | These methods calculate order totals and taxes based on the current data.
        |
        */
        /**
         * Calculate shipping total.
         *
         * @since 2.2
         * @return float
         */
        public function calculate_shipping()
        {
        }
        /**
         * Get all tax classes for items in the order.
         *
         * @since 2.6.3
         * @return array
         */
        public function get_items_tax_classes()
        {
        }
        /**
         * Get tax location for this order.
         *
         * @since 3.2.0
         * @param array $args array Override the location.
         * @return array
         */
        protected function get_tax_location($args = array())
        {
        }
        /**
         * Public wrapper for exposing get_tax_location() method, enabling 3rd parties to get the tax location for an order.
         *
         * @since 7.6.0
         * @param array $args array Override the location.
         * @return array
         */
        public function get_taxable_location($args = array())
        {
        }
        /**
         * Get tax rates for an order. Use order's shipping or billing address, defaults to base location.
         *
         * @param string $tax_class     Tax class to get rates for.
         * @param array  $location_args Location to compute rates for. Should be in form: array( country, state, postcode, city).
         * @param object $customer      Only used to maintain backward compatibility for filter `woocommerce-matched_rates`.
         *
         * @return mixed|void Tax rates.
         */
        protected function get_tax_rates($tax_class, $location_args = array(), $customer = \null)
        {
        }
        /**
         * Calculate taxes for all line items and shipping, and store the totals and tax rows.
         *
         * If by default the taxes are based on the shipping address and the current order doesn't
         * have any, it would use the billing address rather than using the Shopping base location.
         *
         * Will use the base country unless customer addresses are set.
         *
         * @param array $args Added in 3.0.0 to pass things like location.
         */
        public function calculate_taxes($args = array())
        {
        }
        /**
         * Calculate fees for all line items.
         *
         * @return float Fee total.
         */
        public function get_total_fees()
        {
        }
        /**
         * Update tax lines for the order based on the line item taxes themselves.
         */
        public function update_taxes()
        {
        }
        /**
         * Helper function.
         * If you add all items in this order in cart again, this would be the cart subtotal (assuming all other settings are same).
         *
         * @return float Cart subtotal.
         */
        protected function get_cart_subtotal_for_order()
        {
        }
        /**
         * Helper function.
         * If you add all items in this order in cart again, this would be the cart total (assuming all other settings are same).
         *
         * @return float Cart total.
         */
        protected function get_cart_total_for_order()
        {
        }
        /**
         * Calculate totals by looking at the contents of the order. Stores the totals and returns the orders final total.
         *
         * @since 2.2
         * @param  bool $and_taxes Calc taxes if true.
         * @return float calculated grand total.
         */
        public function calculate_totals($and_taxes = \true)
        {
        }
        /**
         * Get item subtotal - this is the cost before discount.
         *
         * @param object $item Item to get total from.
         * @param bool   $inc_tax (default: false).
         * @param bool   $round (default: true).
         * @return float
         */
        public function get_item_subtotal($item, $inc_tax = \false, $round = \true)
        {
        }
        /**
         * Get line subtotal - this is the cost before discount.
         *
         * @param object $item Item to get total from.
         * @param bool   $inc_tax (default: false).
         * @param bool   $round (default: true).
         * @return float
         */
        public function get_line_subtotal($item, $inc_tax = \false, $round = \true)
        {
        }
        /**
         * Calculate item cost - useful for gateways.
         *
         * @param object $item Item to get total from.
         * @param bool   $inc_tax (default: false).
         * @param bool   $round (default: true).
         * @return float
         */
        public function get_item_total($item, $inc_tax = \false, $round = \true)
        {
        }
        /**
         * Calculate line total - useful for gateways.
         *
         * @param object $item Item to get total from.
         * @param bool   $inc_tax (default: false).
         * @param bool   $round (default: true).
         * @return float
         */
        public function get_line_total($item, $inc_tax = \false, $round = \true)
        {
        }
        /**
         * Get item tax - useful for gateways.
         *
         * @param mixed $item Item to get total from.
         * @param bool  $round (default: true).
         * @return float
         */
        public function get_item_tax($item, $round = \true)
        {
        }
        /**
         * Get line tax - useful for gateways.
         *
         * @param mixed $item Item to get total from.
         * @return float
         */
        public function get_line_tax($item)
        {
        }
        /**
         * Gets line subtotal - formatted for display.
         *
         * @param object $item Item to get total from.
         * @param string $tax_display Incl or excl tax display mode.
         * @return string
         */
        public function get_formatted_line_subtotal($item, $tax_display = '')
        {
        }
        /**
         * Gets order total - formatted for display.
         *
         * @return string
         */
        public function get_formatted_order_total()
        {
        }
        /**
         * Gets subtotal - subtotal is shown before discounts, but with localised taxes.
         *
         * @param bool   $compound (default: false).
         * @param string $tax_display (default: the tax_display_cart value).
         * @return string
         */
        public function get_subtotal_to_display($compound = \false, $tax_display = '')
        {
        }
        /**
         * Gets shipping (formatted).
         *
         * @param string $tax_display Excl or incl tax display mode.
         * @return string
         */
        public function get_shipping_to_display($tax_display = '')
        {
        }
        /**
         * Get the discount amount (formatted).
         *
         * @since  2.3.0
         * @param string $tax_display Excl or incl tax display mode.
         * @return string
         */
        public function get_discount_to_display($tax_display = '')
        {
        }
        /**
         * Add total row for subtotal.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_subtotal_row(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for discounts.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_discount_row(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for shipping.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_shipping_row(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for fees.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_fee_rows(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for taxes.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_tax_rows(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for grand total.
         *
         * @param array  $total_rows Reference to total rows array.
         * @param string $tax_display Excl or incl tax display mode.
         */
        protected function add_order_item_totals_total_row(&$total_rows, $tax_display)
        {
        }
        /**
         * Get totals for display on pages and in emails.
         *
         * @param mixed $tax_display Excl or incl tax display mode.
         * @return array
         */
        public function get_order_item_totals($tax_display = '')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Conditionals
        |--------------------------------------------------------------------------
        |
        | Checks if a condition is true or false.
        |
        */
        /**
         * Checks the order status against a passed in status.
         *
         * @param array|string $status Status to check.
         * @return bool
         */
        public function has_status($status)
        {
        }
        /**
         * Check whether this order has a specific shipping method or not.
         *
         * @param string $method_id Method ID to check.
         * @return bool
         */
        public function has_shipping_method($method_id)
        {
        }
        /**
         * Returns true if the order contains a free product.
         *
         * @since 2.5.0
         * @return bool
         */
        public function has_free_item()
        {
        }
        /**
         * Get order title.
         *
         * @return string Order title.
         */
        public function get_title() : string
        {
        }
    }
    /**
     * WooCommerce Payment Gateway class.
     *
     * Extended by individual payment gateways to handle payments.
     *
     * @class       WC_Payment_Gateway
     * @extends     WC_Settings_API
     * @version     2.1.0
     * @package     WooCommerce\Abstracts
     */
    abstract class WC_Payment_Gateway extends \WC_Settings_API
    {
        /**
         * Set if the place order button should be renamed on selection.
         *
         * @var string
         */
        public $order_button_text;
        /**
         * Yes or no based on whether the method is enabled.
         *
         * @var string
         */
        public $enabled = 'yes';
        /**
         * Payment method title for the frontend.
         *
         * @var string
         */
        public $title;
        /**
         * Payment method description for the frontend.
         *
         * @var string
         */
        public $description;
        /**
         * Chosen payment method id.
         *
         * @var bool
         */
        public $chosen;
        /**
         * Gateway title.
         *
         * @var string
         */
        public $method_title = '';
        /**
         * Gateway description.
         *
         * @var string
         */
        public $method_description = '';
        /**
         * True if the gateway shows fields on the checkout.
         *
         * @var bool
         */
        public $has_fields;
        /**
         * Countries this gateway is allowed for.
         *
         * @var array
         */
        public $countries;
        /**
         * Available for all counties or specific.
         *
         * @var string
         */
        public $availability;
        /**
         * Icon for the gateway.
         *
         * @var string
         */
        public $icon;
        /**
         * Supported features such as 'default_credit_card_form', 'refunds'.
         *
         * @var array
         */
        public $supports = array('products');
        /**
         * Maximum transaction amount, zero does not define a maximum.
         *
         * @var int
         */
        public $max_amount = 0;
        /**
         * Optional URL to view a transaction.
         *
         * @var string
         */
        public $view_transaction_url = '';
        /**
         * Optional label to show for "new payment method" in the payment
         * method/token selection radio selection.
         *
         * @var string
         */
        public $new_method_label = '';
        /**
         * Pay button ID if supported.
         *
         * @var string
         */
        public $pay_button_id = '';
        /**
         * Contains a users saved tokens for this gateway.
         *
         * @var array
         */
        protected $tokens = array();
        /**
         * Returns a users saved tokens for this gateway.
         *
         * @since 2.6.0
         * @return array
         */
        public function get_tokens()
        {
        }
        /**
         * Return the title for admin screens.
         *
         * @return string
         */
        public function get_method_title()
        {
        }
        /**
         * Return the description for admin screens.
         *
         * @return string
         */
        public function get_method_description()
        {
        }
        /**
         * Output the gateway settings screen.
         */
        public function admin_options()
        {
        }
        /**
         * Init settings for gateways.
         */
        public function init_settings()
        {
        }
        /**
         * Return whether or not this gateway still requires setup to function.
         *
         * When this gateway is toggled on via AJAX, if this returns true a
         * redirect will occur to the settings page instead.
         *
         * @since 3.4.0
         * @return bool
         */
        public function needs_setup()
        {
        }
        /**
         * Get the return url (thank you page).
         *
         * @param WC_Order|null $order Order object.
         * @return string
         */
        public function get_return_url($order = \null)
        {
        }
        /**
         * Get a link to the transaction on the 3rd party gateway site (if applicable).
         *
         * @param  WC_Order $order the order object.
         * @return string transaction URL, or empty string.
         */
        public function get_transaction_url($order)
        {
        }
        /**
         * Get the order total in checkout and pay_for_order.
         *
         * @return float
         */
        protected function get_order_total()
        {
        }
        /**
         * Check if the gateway is available for use.
         *
         * @return bool
         */
        public function is_available()
        {
        }
        /**
         * Check if the gateway has fields on the checkout.
         *
         * @return bool
         */
        public function has_fields()
        {
        }
        /**
         * Return the gateway's title.
         *
         * @return string
         */
        public function get_title()
        {
        }
        /**
         * Return the gateway's description.
         *
         * @return string
         */
        public function get_description()
        {
        }
        /**
         * Return the gateway's icon.
         *
         * @return string
         */
        public function get_icon()
        {
        }
        /**
         * Return the gateway's pay button ID.
         *
         * @since 3.9.0
         * @return string
         */
        public function get_pay_button_id()
        {
        }
        /**
         * Set as current gateway.
         *
         * Set this as the current gateway.
         */
        public function set_current()
        {
        }
        /**
         * Process Payment.
         *
         * Process the payment. Override this in your gateway. When implemented, this should.
         * return the success and redirect in an array. e.g:
         *
         *        return array(
         *            'result'   => 'success',
         *            'redirect' => $this->get_return_url( $order )
         *        );
         *
         * @param int $order_id Order ID.
         * @return array
         */
        public function process_payment($order_id)
        {
        }
        /**
         * Process refund.
         *
         * If the gateway declares 'refunds' support, this will allow it to refund.
         * a passed in amount.
         *
         * @param  int        $order_id Order ID.
         * @param  float|null $amount Refund amount.
         * @param  string     $reason Refund reason.
         * @return bool|\WP_Error True or false based on success, or a WP_Error object.
         */
        public function process_refund($order_id, $amount = \null, $reason = '')
        {
        }
        /**
         * Validate frontend fields.
         *
         * Validate payment fields on the frontend.
         *
         * @return bool
         */
        public function validate_fields()
        {
        }
        /**
         * If There are no payment fields show the description if set.
         * Override this in your gateway if you have some.
         */
        public function payment_fields()
        {
        }
        /**
         * Check if a gateway supports a given feature.
         *
         * Gateways should override this to declare support (or lack of support) for a feature.
         * For backward compatibility, gateways support 'products' by default, but nothing else.
         *
         * @param string $feature string The name of a feature to test support for.
         * @return bool True if the gateway supports the feature, false otherwise.
         * @since 1.5.7
         */
        public function supports($feature)
        {
        }
        /**
         * Can the order be refunded via this gateway?
         *
         * Should be extended by gateways to do their own checks.
         *
         * @param  WC_Order $order Order object.
         * @return bool If false, the automatic refund button is hidden in the UI.
         */
        public function can_refund_order($order)
        {
        }
        /**
         * Core credit card form which gateways can use if needed. Deprecated - inherit WC_Payment_Gateway_CC instead.
         *
         * @param  array $args Arguments.
         * @param  array $fields Fields.
         */
        public function credit_card_form($args = array(), $fields = array())
        {
        }
        /**
         * Enqueues our tokenization script to handle some of the new form options.
         *
         * @since 2.6.0
         */
        public function tokenization_script()
        {
        }
        /**
         * Grab and display our saved payment methods.
         *
         * @since 2.6.0
         */
        public function saved_payment_methods()
        {
        }
        /**
         * Gets saved payment method HTML from a token.
         *
         * @since 2.6.0
         * @param  WC_Payment_Token $token Payment Token.
         * @return string Generated payment method HTML
         */
        public function get_saved_payment_method_option_html($token)
        {
        }
        /**
         * Displays a radio button for entering a new payment method (new CC details) instead of using a saved method.
         * Only displayed when a gateway supports tokenization.
         *
         * @since 2.6.0
         */
        public function get_new_payment_method_option_html()
        {
        }
        /**
         * Outputs a checkbox for saving a new payment method to the database.
         *
         * @since 2.6.0
         */
        public function save_payment_method_checkbox()
        {
        }
        /**
         * Add payment method via account screen. This should be extended by gateway plugins.
         *
         * @since 3.2.0 Included here from 3.2.0, but supported from 3.0.0.
         * @return array
         */
        public function add_payment_method()
        {
        }
    }
    /**
     * Legacy Payment Tokens.
     * Payment Tokens were introduced in 2.6.0 with create and update as methods.
     * Major CRUD changes occurred in 3.0, so these were deprecated (save and delete still work).
     * This legacy class is for backwards compatibility in case any code called ->read, ->update or ->create
     * directly on the object.
     *
     * @version  3.0.0
     * @package  WooCommerce\Classes
     * @category Class
     * @author   WooCommerce
     */
    abstract class WC_Legacy_Payment_Token extends \WC_Data
    {
        /**
         * Sets the type of this payment token (CC, eCheck, or something else).
         *
         * @param string Payment Token Type (CC, eCheck)
         */
        public function set_type($type)
        {
        }
        /**
         * Read a token by ID.
         * @deprecated 3.0.0 - Init a token class with an ID.
         *
         * @param int $token_id
         */
        public function read($token_id)
        {
        }
        /**
         * Update a token.
         * @deprecated 3.0.0 - Use ::save instead.
         */
        public function update()
        {
        }
        /**
         * Create a token.
         * @deprecated 3.0.0 - Use ::save instead.
         */
        public function create()
        {
        }
    }
    /**
     * WooCommerce Payment Token.
     *
     * Representation of a general payment token to be extended by individuals types of tokens
     * examples: Credit Card, eCheck.
     *
     * @class       WC_Payment_Token
     * @version     3.0.0
     * @since       2.6.0
     * @package     WooCommerce\Abstracts
     */
    abstract class WC_Payment_Token extends \WC_Legacy_Payment_Token
    {
        /**
         * Token Data (stored in the payment_tokens table).
         *
         * @var array
         */
        protected $data = array('gateway_id' => '', 'token' => '', 'is_default' => \false, 'user_id' => 0, 'type' => '');
        /**
         * Token Type (CC, eCheck, or a custom type added by an extension).
         * Set by child classes.
         *
         * @var string
         */
        protected $type = '';
        /**
         * Initialize a payment token.
         *
         * These fields are accepted by all payment tokens:
         * is_default   - boolean Optional - Indicates this is the default payment token for a user
         * token        - string  Required - The actual token to store
         * gateway_id   - string  Required - Identifier for the gateway this token is associated with
         * user_id      - int     Optional - ID for the user this token is associated with. 0 if this token is not associated with a user
         *
         * @since 2.6.0
         * @param mixed $token Token.
         */
        public function __construct($token = '')
        {
        }
        /*
         *--------------------------------------------------------------------------
         * Getters
         *--------------------------------------------------------------------------
         */
        /**
         * Returns the raw payment token.
         *
         * @since  2.6.0
         * @param  string $context Context in which to call this.
         * @return string Raw token
         */
        public function get_token($context = 'view')
        {
        }
        /**
         * Returns the type of this payment token (CC, eCheck, or something else).
         * Overwritten by child classes.
         *
         * @since  2.6.0
         * @param  string $deprecated Deprecated since WooCommerce 3.0.
         * @return string Payment Token Type (CC, eCheck)
         */
        public function get_type($deprecated = '')
        {
        }
        /**
         * Get type to display to user.
         * Get's overwritten by child classes.
         *
         * @since  2.6.0
         * @param  string $deprecated Deprecated since WooCommerce 3.0.
         * @return string
         */
        public function get_display_name($deprecated = '')
        {
        }
        /**
         * Returns the user ID associated with the token or false if this token is not associated.
         *
         * @since 2.6.0
         * @param  string $context In what context to execute this.
         * @return int User ID if this token is associated with a user or 0 if no user is associated
         */
        public function get_user_id($context = 'view')
        {
        }
        /**
         * Returns the ID of the gateway associated with this payment token.
         *
         * @since 2.6.0
         * @param  string $context In what context to execute this.
         * @return string Gateway ID
         */
        public function get_gateway_id($context = 'view')
        {
        }
        /**
         * Returns the ID of the gateway associated with this payment token.
         *
         * @since 2.6.0
         * @param  string $context In what context to execute this.
         * @return string Gateway ID
         */
        public function get_is_default($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set the raw payment token.
         *
         * @since 2.6.0
         * @param string $token Payment token.
         */
        public function set_token($token)
        {
        }
        /**
         * Set the user ID for the user associated with this order.
         *
         * @since 2.6.0
         * @param int $user_id User ID.
         */
        public function set_user_id($user_id)
        {
        }
        /**
         * Set the gateway ID.
         *
         * @since 2.6.0
         * @param string $gateway_id Gateway ID.
         */
        public function set_gateway_id($gateway_id)
        {
        }
        /**
         * Marks the payment as default or non-default.
         *
         * @since 2.6.0
         * @param boolean $is_default True or false.
         */
        public function set_default($is_default)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Other Methods
        |--------------------------------------------------------------------------
        */
        /**
         * Returns if the token is marked as default.
         *
         * @since 2.6.0
         * @return boolean True if the token is default
         */
        public function is_default()
        {
        }
        /**
         * Validate basic token info (token and type are required).
         *
         * @since 2.6.0
         * @return boolean True if the passed data is valid
         */
        public function validate()
        {
        }
    }
    /**
     * Abstract class that is intended to be extended by
     * specific privacy class. It handles the display
     * of the privacy message of the privacy id to the admin,
     * privacy data to be exported and privacy data to be deleted.
     *
     * @version  3.4.0
     * @package  WooCommerce\Abstracts
     */
    abstract class WC_Abstract_Privacy
    {
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        public $name;
        /**
         * This is a list of exporters.
         *
         * @var array
         */
        protected $exporters = array();
        /**
         * This is a list of erasers.
         *
         * @var array
         */
        protected $erasers = array();
        /**
         * This is a priority for the wp_privacy_personal_data_exporters filter
         *
         * @var int
         */
        protected $export_priority;
        /**
         * This is a priority for the wp_privacy_personal_data_erasers filter
         *
         * @var int
         */
        protected $erase_priority;
        /**
         * WC_Abstract_Privacy Constructor.
         *
         * @param string $name            Plugin identifier.
         * @param int    $export_priority Export priority.
         * @param int    $erase_priority  Erase priority.
         */
        public function __construct($name = '', $export_priority = 5, $erase_priority = 10)
        {
        }
        /**
         * Hook in events.
         */
        protected function init()
        {
        }
        /**
         * Adds the privacy message on WC privacy page.
         */
        public function add_privacy_message()
        {
        }
        /**
         * Gets the message of the privacy to display.
         * To be overloaded by the implementor.
         *
         * @return string
         */
        public function get_privacy_message()
        {
        }
        /**
         * Integrate this exporter implementation within the WordPress core exporters.
         *
         * @param array $exporters List of exporter callbacks.
         * @return array
         */
        public function register_exporters($exporters = array())
        {
        }
        /**
         * Integrate this eraser implementation within the WordPress core erasers.
         *
         * @param array $erasers List of eraser callbacks.
         * @return array
         */
        public function register_erasers($erasers = array())
        {
        }
        /**
         * Add exporter to list of exporters.
         *
         * @param string       $id       ID of the Exporter.
         * @param string       $name     Exporter name.
         * @param string|array $callback Exporter callback.
         *
         * @return array
         */
        public function add_exporter($id, $name, $callback)
        {
        }
        /**
         * Add eraser to list of erasers.
         *
         * @param string       $id       ID of the Eraser.
         * @param string       $name     Exporter name.
         * @param string|array $callback Exporter callback.
         *
         * @return array
         */
        public function add_eraser($id, $name, $callback)
        {
        }
    }
    /**
     * Legacy Abstract Product
     *
     * Legacy and deprecated functions are here to keep the WC_Abstract_Product
     * clean.
     * This class will be removed in future versions.
     *
     * @version  3.0.0
     * @package  WooCommerce\Abstracts
     * @category Abstract Class
     * @author   WooThemes
     */
    abstract class WC_Abstract_Legacy_Product extends \WC_Data
    {
        /**
         * Magic __isset method for backwards compatibility. Legacy properties which could be accessed directly in the past.
         *
         * @param  string $key Key name.
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic __get method for backwards compatibility. Maps legacy vars to new getters.
         *
         * @param  string $key Key name.
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * If set, get the default attributes for a variable product.
         *
         * @deprecated 3.0.0
         * @return array
         */
        public function get_variation_default_attributes()
        {
        }
        /**
         * Returns the gallery attachment ids.
         *
         * @deprecated 3.0.0
         * @return array
         */
        public function get_gallery_attachment_ids()
        {
        }
        /**
         * Set stock level of the product.
         *
         * @deprecated 3.0.0
         *
         * @param int $amount
         * @param string $mode
         *
         * @return int
         */
        public function set_stock($amount = \null, $mode = 'set')
        {
        }
        /**
         * Reduce stock level of the product.
         *
         * @deprecated 3.0.0
         * @param int $amount Amount to reduce by. Default: 1
         * @return int new stock level
         */
        public function reduce_stock($amount = 1)
        {
        }
        /**
         * Increase stock level of the product.
         *
         * @deprecated 3.0.0
         * @param int $amount Amount to increase by. Default 1.
         * @return int new stock level
         */
        public function increase_stock($amount = 1)
        {
        }
        /**
         * Check if the stock status needs changing.
         *
         * @deprecated 3.0.0 Sync is done automatically on read/save, so calling this should not be needed any more.
         */
        public function check_stock_status()
        {
        }
        /**
         * Get and return related products.
         * @deprecated 3.0.0 Use wc_get_related_products instead.
         *
         * @param int $limit
         *
         * @return array
         */
        public function get_related($limit = 5)
        {
        }
        /**
         * Retrieves related product terms.
         * @deprecated 3.0.0 Use wc_get_product_term_ids instead.
         *
         * @param $term
         *
         * @return array
         */
        protected function get_related_terms($term)
        {
        }
        /**
         * Builds the related posts query.
         * @deprecated 3.0.0 Use Product Data Store get_related_products_query instead.
         *
         * @param $cats_array
         * @param $tags_array
         * @param $exclude_ids
         * @param $limit
         */
        protected function build_related_query($cats_array, $tags_array, $exclude_ids, $limit)
        {
        }
        /**
         * Returns the child product.
         * @deprecated 3.0.0 Use wc_get_product instead.
         * @param mixed $child_id
         * @return WC_Product|WC_Product|WC_Product_variation
         */
        public function get_child($child_id)
        {
        }
        /**
         * Functions for getting parts of a price, in html, used by get_price_html.
         *
         * @deprecated 3.0.0
         * @return string
         */
        public function get_price_html_from_text()
        {
        }
        /**
         * Functions for getting parts of a price, in html, used by get_price_html.
         *
         * @deprecated 3.0.0 Use wc_format_sale_price instead.
         * @param  string $from String or float to wrap with 'from' text
         * @param  mixed $to String or float to wrap with 'to' text
         * @return string
         */
        public function get_price_html_from_to($from, $to)
        {
        }
        /**
         * Lists a table of attributes for the product page.
         * @deprecated 3.0.0 Use wc_display_product_attributes instead.
         */
        public function list_attributes()
        {
        }
        /**
         * Returns the price (including tax). Uses customer tax rates. Can work for a specific $qty for more accurate taxes.
         *
         * @deprecated 3.0.0 Use wc_get_price_including_tax instead.
         * @param  int $qty
         * @param  string $price to calculate, left blank to just use get_price()
         * @return string
         */
        public function get_price_including_tax($qty = 1, $price = '')
        {
        }
        /**
         * Returns the price including or excluding tax, based on the 'woocommerce_tax_display_shop' setting.
         *
         * @deprecated 3.0.0 Use wc_get_price_to_display instead.
         * @param  string  $price to calculate, left blank to just use get_price()
         * @param  integer $qty   passed on to get_price_including_tax() or get_price_excluding_tax()
         * @return string
         */
        public function get_display_price($price = '', $qty = 1)
        {
        }
        /**
         * Returns the price (excluding tax) - ignores tax_class filters since the price may *include* tax and thus needs subtracting.
         * Uses store base tax rates. Can work for a specific $qty for more accurate taxes.
         *
         * @deprecated 3.0.0 Use wc_get_price_excluding_tax instead.
         * @param  int $qty
         * @param  string $price to calculate, left blank to just use get_price()
         * @return string
         */
        public function get_price_excluding_tax($qty = 1, $price = '')
        {
        }
        /**
         * Adjust a products price dynamically.
         *
         * @deprecated 3.0.0
         * @param mixed $price
         */
        public function adjust_price($price)
        {
        }
        /**
         * Returns the product categories.
         *
         * @deprecated 3.0.0
         * @param string $sep (default: ', ').
         * @param string $before (default: '').
         * @param string $after (default: '').
         * @return string
         */
        public function get_categories($sep = ', ', $before = '', $after = '')
        {
        }
        /**
         * Returns the product tags.
         *
         * @deprecated 3.0.0
         * @param string $sep (default: ', ').
         * @param string $before (default: '').
         * @param string $after (default: '').
         * @return array
         */
        public function get_tags($sep = ', ', $before = '', $after = '')
        {
        }
        /**
         * Get the product's post data.
         *
         * @deprecated 3.0.0
         * @return WP_Post
         */
        public function get_post_data()
        {
        }
        /**
         * Get the parent of the post.
         *
         * @deprecated 3.0.0
         * @return int
         */
        public function get_parent()
        {
        }
        /**
         * Returns the upsell product ids.
         *
         * @deprecated 3.0.0
         * @return array
         */
        public function get_upsells()
        {
        }
        /**
         * Returns the cross sell product ids.
         *
         * @deprecated 3.0.0
         * @return array
         */
        public function get_cross_sells()
        {
        }
        /**
         * Check if variable product has default attributes set.
         *
         * @deprecated 3.0.0
         * @return bool
         */
        public function has_default_attributes()
        {
        }
        /**
         * Get variation ID.
         *
         * @deprecated 3.0.0
         * @return int
         */
        public function get_variation_id()
        {
        }
        /**
         * Get product variation description.
         *
         * @deprecated 3.0.0
         * @return string
         */
        public function get_variation_description()
        {
        }
        /**
         * Check if all variation's attributes are set.
         *
         * @deprecated 3.0.0
         * @return boolean
         */
        public function has_all_attributes_set()
        {
        }
        /**
         * Returns whether or not the variations parent is visible.
         *
         * @deprecated 3.0.0
         * @return bool
         */
        public function parent_is_visible()
        {
        }
        /**
         * Get total stock - This is the stock of parent and children combined.
         *
         * @deprecated 3.0.0
         * @return int
         */
        public function get_total_stock()
        {
        }
        /**
         * Get formatted variation data with WC < 2.4 back compat and proper formatting of text-based attribute names.
         *
         * @deprecated 3.0.0
         *
         * @param bool $flat
         *
         * @return string
         */
        public function get_formatted_variation_attributes($flat = \false)
        {
        }
        /**
         * Sync variable product prices with the children lowest/highest prices.
         *
         * @deprecated 3.0.0 not used in core.
         *
         * @param int $product_id
         */
        public function variable_product_sync($product_id = 0)
        {
        }
        /**
         * Sync the variable product's attributes with the variations.
         *
         * @param $product
         * @param bool $children
         */
        public static function sync_attributes($product, $children = \false)
        {
        }
        /**
         * Match a variation to a given set of attributes using a WP_Query.
         * @deprecated 3.0.0 in favour of Product data store's find_matching_product_variation.
         *
         * @param array $match_attributes
         */
        public function get_matching_variation($match_attributes = array())
        {
        }
        /**
         * Returns whether or not we are showing dimensions on the product page.
         * @deprecated 3.0.0 Unused.
         * @return bool
         */
        public function enable_dimensions_display()
        {
        }
        /**
         * Returns the product rating in html format.
         *
         * @deprecated 3.0.0
         * @param string $rating (default: '')
         * @return string
         */
        public function get_rating_html($rating = \null)
        {
        }
        /**
         * Sync product rating. Can be called statically.
         *
         * @deprecated 3.0.0
         * @param  int $post_id
         */
        public static function sync_average_rating($post_id)
        {
        }
        /**
         * Sync product rating count. Can be called statically.
         *
         * @deprecated 3.0.0
         * @param  int $post_id
         */
        public static function sync_rating_count($post_id)
        {
        }
        /**
         * Same as get_downloads in CRUD.
         *
         * @deprecated 3.0.0
         * @return array
         */
        public function get_files()
        {
        }
        /**
         * @deprecated 3.0.0 Sync is taken care of during save - no need to call this directly.
         */
        public function grouped_product_sync()
        {
        }
    }
    /**
     * Abstract Product Class
     *
     * The WooCommerce product class handles individual product data.
     *
     * @version 3.0.0
     * @package WooCommerce\Abstracts
     */
    class WC_Product extends \WC_Abstract_Legacy_Product
    {
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'product';
        /**
         * Post type.
         *
         * @var string
         */
        protected $post_type = 'product';
        /**
         * Cache group.
         *
         * @var string
         */
        protected $cache_group = 'products';
        /**
         * Stores product data.
         *
         * @var array
         */
        protected $data = array('name' => '', 'slug' => '', 'date_created' => \null, 'date_modified' => \null, 'status' => \false, 'featured' => \false, 'catalog_visibility' => 'visible', 'description' => '', 'short_description' => '', 'sku' => '', 'price' => '', 'regular_price' => '', 'sale_price' => '', 'date_on_sale_from' => \null, 'date_on_sale_to' => \null, 'total_sales' => '0', 'tax_status' => 'taxable', 'tax_class' => '', 'manage_stock' => \false, 'stock_quantity' => \null, 'stock_status' => 'instock', 'backorders' => 'no', 'low_stock_amount' => '', 'sold_individually' => \false, 'weight' => '', 'length' => '', 'width' => '', 'height' => '', 'upsell_ids' => array(), 'cross_sell_ids' => array(), 'parent_id' => 0, 'reviews_allowed' => \true, 'purchase_note' => '', 'attributes' => array(), 'default_attributes' => array(), 'menu_order' => 0, 'post_password' => '', 'virtual' => \false, 'downloadable' => \false, 'category_ids' => array(), 'tag_ids' => array(), 'shipping_class_id' => 0, 'downloads' => array(), 'image_id' => '', 'gallery_image_ids' => array(), 'download_limit' => -1, 'download_expiry' => -1, 'rating_counts' => array(), 'average_rating' => 0, 'review_count' => 0);
        /**
         * Supported features such as 'ajax_add_to_cart'.
         *
         * @var array
         */
        protected $supports = array();
        /**
         * Get the product if ID is passed, otherwise the product is new and empty.
         * This class should NOT be instantiated, but the wc_get_product() function
         * should be used. It is possible, but the wc_get_product() is preferred.
         *
         * @param int|WC_Product|object $product Product to init.
         */
        public function __construct($product = 0)
        {
        }
        /**
         * Get internal type. Should return string and *should be overridden* by child classes.
         *
         * The product_type property is deprecated but is used here for BW compatibility with child classes which may be defining product_type and not have a get_type method.
         *
         * @since  3.0.0
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get product name.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get product slug.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_slug($context = 'view')
        {
        }
        /**
         * Get product created date.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_created($context = 'view')
        {
        }
        /**
         * Get product modified date.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_modified($context = 'view')
        {
        }
        /**
         * Get product status.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_status($context = 'view')
        {
        }
        /**
         * If the product is featured.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return boolean
         */
        public function get_featured($context = 'view')
        {
        }
        /**
         * Get catalog visibility.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_catalog_visibility($context = 'view')
        {
        }
        /**
         * Get product description.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_description($context = 'view')
        {
        }
        /**
         * Get product short description.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_short_description($context = 'view')
        {
        }
        /**
         * Get SKU (Stock-keeping unit) - product unique ID.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_sku($context = 'view')
        {
        }
        /**
         * Returns the product's active price.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string price
         */
        public function get_price($context = 'view')
        {
        }
        /**
         * Returns the product's regular price.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string price
         */
        public function get_regular_price($context = 'view')
        {
        }
        /**
         * Returns the product's sale price.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string price
         */
        public function get_sale_price($context = 'view')
        {
        }
        /**
         * Get date on sale from.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_on_sale_from($context = 'view')
        {
        }
        /**
         * Get date on sale to.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_on_sale_to($context = 'view')
        {
        }
        /**
         * Get number total of sales.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_total_sales($context = 'view')
        {
        }
        /**
         * Returns the tax status.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_tax_status($context = 'view')
        {
        }
        /**
         * Returns the tax class.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_tax_class($context = 'view')
        {
        }
        /**
         * Return if product manage stock.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return boolean
         */
        public function get_manage_stock($context = 'view')
        {
        }
        /**
         * Returns number of items available for sale.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int|null
         */
        public function get_stock_quantity($context = 'view')
        {
        }
        /**
         * Return the stock status.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @since  3.0.0
         * @return string
         */
        public function get_stock_status($context = 'view')
        {
        }
        /**
         * Get backorders.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @since  3.0.0
         * @return string yes no or notify
         */
        public function get_backorders($context = 'view')
        {
        }
        /**
         * Get low stock amount.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @since  3.5.0
         * @return int|string Returns empty string if value not set
         */
        public function get_low_stock_amount($context = 'view')
        {
        }
        /**
         * Return if should be sold individually.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @since  3.0.0
         * @return boolean
         */
        public function get_sold_individually($context = 'view')
        {
        }
        /**
         * Returns the product's weight.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_weight($context = 'view')
        {
        }
        /**
         * Returns the product length.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_length($context = 'view')
        {
        }
        /**
         * Returns the product width.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_width($context = 'view')
        {
        }
        /**
         * Returns the product height.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_height($context = 'view')
        {
        }
        /**
         * Returns formatted dimensions.
         *
         * @param  bool $formatted True by default for legacy support - will be false/not set in future versions to return the array only. Use wc_format_dimensions for formatted versions instead.
         * @return string|array
         */
        public function get_dimensions($formatted = \true)
        {
        }
        /**
         * Get upsell IDs.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_upsell_ids($context = 'view')
        {
        }
        /**
         * Get cross sell IDs.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_cross_sell_ids($context = 'view')
        {
        }
        /**
         * Get parent ID.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_parent_id($context = 'view')
        {
        }
        /**
         * Return if reviews is allowed.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_reviews_allowed($context = 'view')
        {
        }
        /**
         * Get purchase note.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_purchase_note($context = 'view')
        {
        }
        /**
         * Returns product attributes.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_attributes($context = 'view')
        {
        }
        /**
         * Get default attributes.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_default_attributes($context = 'view')
        {
        }
        /**
         * Get menu order.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_menu_order($context = 'view')
        {
        }
        /**
         * Get post password.
         *
         * @since  3.6.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_post_password($context = 'view')
        {
        }
        /**
         * Get category ids.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_category_ids($context = 'view')
        {
        }
        /**
         * Get tag ids.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_tag_ids($context = 'view')
        {
        }
        /**
         * Get virtual.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_virtual($context = 'view')
        {
        }
        /**
         * Returns the gallery attachment ids.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_gallery_image_ids($context = 'view')
        {
        }
        /**
         * Get shipping class ID.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_shipping_class_id($context = 'view')
        {
        }
        /**
         * Get downloads.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_downloads($context = 'view')
        {
        }
        /**
         * Get download expiry.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_download_expiry($context = 'view')
        {
        }
        /**
         * Get downloadable.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_downloadable($context = 'view')
        {
        }
        /**
         * Get download limit.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_download_limit($context = 'view')
        {
        }
        /**
         * Get main image ID.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_image_id($context = 'view')
        {
        }
        /**
         * Get rating count.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array of counts
         */
        public function get_rating_counts($context = 'view')
        {
        }
        /**
         * Get average rating.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return float
         */
        public function get_average_rating($context = 'view')
        {
        }
        /**
         * Get review count.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_review_count($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Functions for setting product data. These should not update anything in the
        | database itself and should only change what is stored in the class
        | object.
        */
        /**
         * Set product name.
         *
         * @since 3.0.0
         * @param string $name Product name.
         */
        public function set_name($name)
        {
        }
        /**
         * Set product slug.
         *
         * @since 3.0.0
         * @param string $slug Product slug.
         */
        public function set_slug($slug)
        {
        }
        /**
         * Set product created date.
         *
         * @since 3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_created($date = \null)
        {
        }
        /**
         * Set product modified date.
         *
         * @since 3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_modified($date = \null)
        {
        }
        /**
         * Set product status.
         *
         * @since 3.0.0
         * @param string $status Product status.
         */
        public function set_status($status)
        {
        }
        /**
         * Set if the product is featured.
         *
         * @since 3.0.0
         * @param bool|string $featured Whether the product is featured or not.
         */
        public function set_featured($featured)
        {
        }
        /**
         * Set catalog visibility.
         *
         * @since  3.0.0
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         * @param  string $visibility Options: 'hidden', 'visible', 'search' and 'catalog'.
         */
        public function set_catalog_visibility($visibility)
        {
        }
        /**
         * Set product description.
         *
         * @since 3.0.0
         * @param string $description Product description.
         */
        public function set_description($description)
        {
        }
        /**
         * Set product short description.
         *
         * @since 3.0.0
         * @param string $short_description Product short description.
         */
        public function set_short_description($short_description)
        {
        }
        /**
         * Set SKU.
         *
         * @since  3.0.0
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         * @param  string $sku Product SKU.
         */
        public function set_sku($sku)
        {
        }
        /**
         * Set the product's active price.
         *
         * @param string $price Price.
         */
        public function set_price($price)
        {
        }
        /**
         * Set the product's regular price.
         *
         * @since 3.0.0
         * @param string $price Regular price.
         */
        public function set_regular_price($price)
        {
        }
        /**
         * Set the product's sale price.
         *
         * @since 3.0.0
         * @param string $price sale price.
         */
        public function set_sale_price($price)
        {
        }
        /**
         * Set date on sale from.
         *
         * @since 3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_on_sale_from($date = \null)
        {
        }
        /**
         * Set date on sale to.
         *
         * @since 3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_on_sale_to($date = \null)
        {
        }
        /**
         * Set number total of sales.
         *
         * @since 3.0.0
         * @param int $total Total of sales.
         */
        public function set_total_sales($total)
        {
        }
        /**
         * Set the tax status.
         *
         * @since  3.0.0
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         * @param  string $status Tax status.
         */
        public function set_tax_status($status)
        {
        }
        /**
         * Set the tax class.
         *
         * @since 3.0.0
         * @param string $class Tax class.
         */
        public function set_tax_class($class)
        {
        }
        /**
         * Return an array of valid tax classes
         *
         * @return array valid tax classes
         */
        protected function get_valid_tax_classes()
        {
        }
        /**
         * Set if product manage stock.
         *
         * @since 3.0.0
         * @param bool $manage_stock Whether or not manage stock is enabled.
         */
        public function set_manage_stock($manage_stock)
        {
        }
        /**
         * Set number of items available for sale.
         *
         * @since 3.0.0
         * @param float|null $quantity Stock quantity.
         */
        public function set_stock_quantity($quantity)
        {
        }
        /**
         * Set stock status.
         *
         * @param string $status New status.
         */
        public function set_stock_status($status = 'instock')
        {
        }
        /**
         * Set backorders.
         *
         * @since 3.0.0
         * @param string $backorders Options: 'yes', 'no' or 'notify'.
         */
        public function set_backorders($backorders)
        {
        }
        /**
         * Set low stock amount.
         *
         * @param int|string $amount Empty string if value not set.
         * @since 3.5.0
         */
        public function set_low_stock_amount($amount)
        {
        }
        /**
         * Set if should be sold individually.
         *
         * @since 3.0.0
         * @param bool $sold_individually Whether or not product is sold individually.
         */
        public function set_sold_individually($sold_individually)
        {
        }
        /**
         * Set the product's weight.
         *
         * @since 3.0.0
         * @param float|string $weight Total weight.
         */
        public function set_weight($weight)
        {
        }
        /**
         * Set the product length.
         *
         * @since 3.0.0
         * @param float|string $length Total length.
         */
        public function set_length($length)
        {
        }
        /**
         * Set the product width.
         *
         * @since 3.0.0
         * @param float|string $width Total width.
         */
        public function set_width($width)
        {
        }
        /**
         * Set the product height.
         *
         * @since 3.0.0
         * @param float|string $height Total height.
         */
        public function set_height($height)
        {
        }
        /**
         * Set upsell IDs.
         *
         * @since 3.0.0
         * @param array $upsell_ids IDs from the up-sell products.
         */
        public function set_upsell_ids($upsell_ids)
        {
        }
        /**
         * Set crosssell IDs.
         *
         * @since 3.0.0
         * @param array $cross_sell_ids IDs from the cross-sell products.
         */
        public function set_cross_sell_ids($cross_sell_ids)
        {
        }
        /**
         * Set parent ID.
         *
         * @since 3.0.0
         * @param int $parent_id Product parent ID.
         */
        public function set_parent_id($parent_id)
        {
        }
        /**
         * Set if reviews is allowed.
         *
         * @since 3.0.0
         * @param bool $reviews_allowed Reviews allowed or not.
         */
        public function set_reviews_allowed($reviews_allowed)
        {
        }
        /**
         * Set purchase note.
         *
         * @since 3.0.0
         * @param string $purchase_note Purchase note.
         */
        public function set_purchase_note($purchase_note)
        {
        }
        /**
         * Set product attributes.
         *
         * Attributes are made up of:
         *     id - 0 for product level attributes. ID for global attributes.
         *     name - Attribute name.
         *     options - attribute value or array of term ids/names.
         *     position - integer sort order.
         *     visible - If visible on frontend.
         *     variation - If used for variations.
         * Indexed by unique key to allow clearing old ones after a set.
         *
         * @since 3.0.0
         * @param array $raw_attributes Array of WC_Product_Attribute objects.
         */
        public function set_attributes($raw_attributes)
        {
        }
        /**
         * Set default attributes. These will be saved as strings and should map to attribute values.
         *
         * @since 3.0.0
         * @param array $default_attributes List of default attributes.
         */
        public function set_default_attributes($default_attributes)
        {
        }
        /**
         * Set menu order.
         *
         * @since 3.0.0
         * @param int $menu_order Menu order.
         */
        public function set_menu_order($menu_order)
        {
        }
        /**
         * Set post password.
         *
         * @since 3.6.0
         * @param int $post_password Post password.
         */
        public function set_post_password($post_password)
        {
        }
        /**
         * Set the product categories.
         *
         * @since 3.0.0
         * @param array $term_ids List of terms IDs.
         */
        public function set_category_ids($term_ids)
        {
        }
        /**
         * Set the product tags.
         *
         * @since 3.0.0
         * @param array $term_ids List of terms IDs.
         */
        public function set_tag_ids($term_ids)
        {
        }
        /**
         * Set if the product is virtual.
         *
         * @since 3.0.0
         * @param bool|string $virtual Whether product is virtual or not.
         */
        public function set_virtual($virtual)
        {
        }
        /**
         * Set shipping class ID.
         *
         * @since 3.0.0
         * @param int $id Product shipping class id.
         */
        public function set_shipping_class_id($id)
        {
        }
        /**
         * Set if the product is downloadable.
         *
         * @since 3.0.0
         * @param bool|string $downloadable Whether product is downloadable or not.
         */
        public function set_downloadable($downloadable)
        {
        }
        /**
         * Set downloads.
         *
         * @throws WC_Data_Exception If an error relating to one of the downloads is encountered.
         *
         * @param array $downloads_array Array of WC_Product_Download objects or arrays.
         *
         * @since 3.0.0
         */
        public function set_downloads($downloads_array)
        {
        }
        /**
         * Takes an array of downloadable file representations and converts it into an array of
         * WC_Product_Download objects, indexed by download ID.
         *
         * @param array[]|WC_Product_Download[] $downloads Download data to be re-mapped.
         *
         * @return WC_Product_Download[]
         */
        private function build_downloads_map(array $downloads) : array
        {
        }
        /**
         * Set download limit.
         *
         * @since 3.0.0
         * @param int|string $download_limit Product download limit.
         */
        public function set_download_limit($download_limit)
        {
        }
        /**
         * Set download expiry.
         *
         * @since 3.0.0
         * @param int|string $download_expiry Product download expiry.
         */
        public function set_download_expiry($download_expiry)
        {
        }
        /**
         * Set gallery attachment ids.
         *
         * @since 3.0.0
         * @param array $image_ids List of image ids.
         */
        public function set_gallery_image_ids($image_ids)
        {
        }
        /**
         * Set main image ID.
         *
         * @since 3.0.0
         * @param int|string $image_id Product image id.
         */
        public function set_image_id($image_id = '')
        {
        }
        /**
         * Set rating counts. Read only.
         *
         * @param array $counts Product rating counts.
         */
        public function set_rating_counts($counts)
        {
        }
        /**
         * Set average rating. Read only.
         *
         * @param float $average Product average rating.
         */
        public function set_average_rating($average)
        {
        }
        /**
         * Set review count. Read only.
         *
         * @param int $count Product review count.
         */
        public function set_review_count($count)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Other Methods
        |--------------------------------------------------------------------------
        */
        /**
         * Ensure properties are set correctly before save.
         *
         * @since 3.0.0
         */
        public function validate_props()
        {
        }
        /**
         * Save data (either create or update depending on if we are working on an existing product).
         *
         * @since  3.0.0
         * @return int
         */
        public function save()
        {
        }
        /**
         * Do any extra processing needed before the actual product save
         * (but after triggering the 'woocommerce_before_..._object_save' action)
         *
         * @return mixed A state value that will be passed to after_data_store_save_or_update.
         */
        protected function before_data_store_save_or_update()
        {
        }
        /**
         * Do any extra processing needed after the actual product save
         * (but before triggering the 'woocommerce_after_..._object_save' action)
         *
         * @param mixed $state The state object that was returned by before_data_store_save_or_update.
         */
        protected function after_data_store_save_or_update($state)
        {
        }
        /**
         * Delete the product, set its ID to 0, and return result.
         *
         * @param  bool $force_delete Should the product be deleted permanently.
         * @return bool result
         */
        public function delete($force_delete = \false)
        {
        }
        /**
         * If this is a child product, queue its parent for syncing at the end of the request.
         */
        protected function maybe_defer_product_sync()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Conditionals
        |--------------------------------------------------------------------------
        */
        /**
         * Check if a product supports a given feature.
         *
         * Product classes should override this to declare support (or lack of support) for a feature.
         *
         * @param  string $feature string The name of a feature to test support for.
         * @return bool True if the product supports the feature, false otherwise.
         * @since  2.5.0
         */
        public function supports($feature)
        {
        }
        /**
         * Returns whether or not the product post exists.
         *
         * @return bool
         */
        public function exists()
        {
        }
        /**
         * Checks the product type.
         *
         * Backwards compatibility with downloadable/virtual.
         *
         * @param  string|array $type Array or string of types.
         * @return bool
         */
        public function is_type($type)
        {
        }
        /**
         * Checks if a product is downloadable.
         *
         * @return bool
         */
        public function is_downloadable()
        {
        }
        /**
         * Checks if a product is virtual (has no shipping).
         *
         * @return bool
         */
        public function is_virtual()
        {
        }
        /**
         * Returns whether or not the product is featured.
         *
         * @return bool
         */
        public function is_featured()
        {
        }
        /**
         * Check if a product is sold individually (no quantities).
         *
         * @return bool
         */
        public function is_sold_individually()
        {
        }
        /**
         * Returns whether or not the product is visible in the catalog.
         *
         * @return bool
         */
        public function is_visible()
        {
        }
        /**
         * Returns whether or not the product is visible in the catalog (doesn't trigger filters).
         *
         * @return bool
         */
        protected function is_visible_core()
        {
        }
        /**
         * Returns false if the product cannot be bought.
         *
         * @return bool
         */
        public function is_purchasable()
        {
        }
        /**
         * Returns whether or not the product is on sale.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function is_on_sale($context = 'view')
        {
        }
        /**
         * Returns whether or not the product has dimensions set.
         *
         * @return bool
         */
        public function has_dimensions()
        {
        }
        /**
         * Returns whether or not the product has weight set.
         *
         * @return bool
         */
        public function has_weight()
        {
        }
        /**
         * Returns whether or not the product can be purchased.
         * This returns true for 'instock' and 'onbackorder' stock statuses.
         *
         * @return bool
         */
        public function is_in_stock()
        {
        }
        /**
         * Checks if a product needs shipping.
         *
         * @return bool
         */
        public function needs_shipping()
        {
        }
        /**
         * Returns whether or not the product is taxable.
         *
         * @return bool
         */
        public function is_taxable()
        {
        }
        /**
         * Returns whether or not the product shipping is taxable.
         *
         * @return bool
         */
        public function is_shipping_taxable()
        {
        }
        /**
         * Returns whether or not the product is stock managed.
         *
         * @return bool
         */
        public function managing_stock()
        {
        }
        /**
         * Returns whether or not the product can be backordered.
         *
         * @return bool
         */
        public function backorders_allowed()
        {
        }
        /**
         * Returns whether or not the product needs to notify the customer on backorder.
         *
         * @return bool
         */
        public function backorders_require_notification()
        {
        }
        /**
         * Check if a product is on backorder.
         *
         * @param  int $qty_in_cart (default: 0).
         * @return bool
         */
        public function is_on_backorder($qty_in_cart = 0)
        {
        }
        /**
         * Returns whether or not the product has enough stock for the order.
         *
         * @param  mixed $quantity Quantity of a product added to an order.
         * @return bool
         */
        public function has_enough_stock($quantity)
        {
        }
        /**
         * Returns whether or not the product has any visible attributes.
         *
         * @return boolean
         */
        public function has_attributes()
        {
        }
        /**
         * Returns whether or not the product has any child product.
         *
         * @return bool
         */
        public function has_child()
        {
        }
        /**
         * Does a child have dimensions?
         *
         * @since  3.0.0
         * @return bool
         */
        public function child_has_dimensions()
        {
        }
        /**
         * Does a child have a weight?
         *
         * @since  3.0.0
         * @return boolean
         */
        public function child_has_weight()
        {
        }
        /**
         * Check if downloadable product has a file attached.
         *
         * @since 1.6.2
         *
         * @param  string $download_id file identifier.
         * @return bool Whether downloadable product has a file attached.
         */
        public function has_file($download_id = '')
        {
        }
        /**
         * Returns whether or not the product has additional options that need
         * selecting before adding to cart.
         *
         * @since  3.0.0
         * @return boolean
         */
        public function has_options()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Non-CRUD Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get the product's title. For products this is the product name.
         *
         * @return string
         */
        public function get_title()
        {
        }
        /**
         * Product permalink.
         *
         * @return string
         */
        public function get_permalink()
        {
        }
        /**
         * Returns the children IDs if applicable. Overridden by child classes.
         *
         * @return array of IDs
         */
        public function get_children()
        {
        }
        /**
         * If the stock level comes from another product ID, this should be modified.
         *
         * @since  3.0.0
         * @return int
         */
        public function get_stock_managed_by_id()
        {
        }
        /**
         * Returns the price in html format.
         *
         * @param string $deprecated Deprecated param.
         *
         * @return string
         */
        public function get_price_html($deprecated = '')
        {
        }
        /**
         * Get product name with SKU or ID. Used within admin.
         *
         * @return string Formatted product name
         */
        public function get_formatted_name()
        {
        }
        /**
         * Get min quantity which can be purchased at once.
         *
         * @since  3.0.0
         * @return int
         */
        public function get_min_purchase_quantity()
        {
        }
        /**
         * Get max quantity which can be purchased at once.
         *
         * @since  3.0.0
         * @return int Quantity or -1 if unlimited.
         */
        public function get_max_purchase_quantity()
        {
        }
        /**
         * Get the add to url used mainly in loops.
         *
         * @return string
         */
        public function add_to_cart_url()
        {
        }
        /**
         * Get the add to cart button text for the single page.
         *
         * @return string
         */
        public function single_add_to_cart_text()
        {
        }
        /**
         * Get the aria-describedby description for the add to cart button.
         *
         * @return string
         */
        public function add_to_cart_aria_describedby()
        {
        }
        /**
         * Get the add to cart button text.
         *
         * @return string
         */
        public function add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text description - used in aria tags.
         *
         * @since  3.3.0
         * @return string
         */
        public function add_to_cart_description()
        {
        }
        /**
         * Returns the main product image.
         *
         * @param  string $size (default: 'woocommerce_thumbnail').
         * @param  array  $attr Image attributes.
         * @param  bool   $placeholder True to return $placeholder if no image is found, or false to return an empty string.
         * @return string
         */
        public function get_image($size = 'woocommerce_thumbnail', $attr = array(), $placeholder = \true)
        {
        }
        /**
         * Returns the product shipping class SLUG.
         *
         * @return string
         */
        public function get_shipping_class()
        {
        }
        /**
         * Returns a single product attribute as a string.
         *
         * @param  string $attribute to get.
         * @return string
         */
        public function get_attribute($attribute)
        {
        }
        /**
         * Get the total amount (COUNT) of ratings, or just the count for one rating e.g. number of 5 star ratings.
         *
         * @param  int $value Optional. Rating value to get the count for. By default returns the count of all rating values.
         * @return int
         */
        public function get_rating_count($value = \null)
        {
        }
        /**
         * Get a file by $download_id.
         *
         * @param  string $download_id file identifier.
         * @return array|false if not found
         */
        public function get_file($download_id = '')
        {
        }
        /**
         * Get file download path identified by $download_id.
         *
         * @param  string $download_id file identifier.
         * @return string
         */
        public function get_file_download_path($download_id)
        {
        }
        /**
         * Get the suffix to display after prices > 0.
         *
         * @param  string  $price to calculate, left blank to just use get_price().
         * @param  integer $qty   passed on to get_price_including_tax() or get_price_excluding_tax().
         * @return string
         */
        public function get_price_suffix($price = '', $qty = 1)
        {
        }
        /**
         * Returns the availability of the product.
         *
         * @return string[]
         */
        public function get_availability()
        {
        }
        /**
         * Get availability text based on stock status.
         *
         * @return string
         */
        protected function get_availability_text()
        {
        }
        /**
         * Get availability classname based on stock status.
         *
         * @return string
         */
        protected function get_availability_class()
        {
        }
    }
    /**
     * WC_Session
     */
    abstract class WC_Session
    {
        /**
         * Customer ID.
         *
         * @var int $_customer_id Customer ID.
         */
        protected $_customer_id;
        /**
         * Session Data.
         *
         * @var array $_data Data array.
         */
        protected $_data = array();
        /**
         * Dirty when the session needs saving.
         *
         * @var bool $_dirty When something changes
         */
        protected $_dirty = \false;
        /**
         * Init hooks and session data. Extended by child classes.
         *
         * @since 3.3.0
         */
        public function init()
        {
        }
        /**
         * Cleanup session data. Extended by child classes.
         */
        public function cleanup_sessions()
        {
        }
        /**
         * Magic get method.
         *
         * @param mixed $key Key to get.
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * Magic set method.
         *
         * @param mixed $key Key to set.
         * @param mixed $value Value to set.
         */
        public function __set($key, $value)
        {
        }
        /**
         * Magic isset method.
         *
         * @param mixed $key Key to check.
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic unset method.
         *
         * @param mixed $key Key to unset.
         */
        public function __unset($key)
        {
        }
        /**
         * Get a session variable.
         *
         * @param string $key Key to get.
         * @param mixed  $default used if the session variable isn't set.
         * @return array|string value of session variable
         */
        public function get($key, $default = \null)
        {
        }
        /**
         * Set a session variable.
         *
         * @param string $key Key to set.
         * @param mixed  $value Value to set.
         */
        public function set($key, $value)
        {
        }
        /**
         * Get customer ID.
         *
         * @return int
         */
        public function get_customer_id()
        {
        }
    }
    /**
     * WooCommerce Shipping Method Class.
     *
     * Extended by shipping methods to handle shipping calculations etc.
     *
     * @class       WC_Shipping_Method
     * @version     3.0.0
     * @package     WooCommerce\Abstracts
     */
    abstract class WC_Shipping_Method extends \WC_Settings_API
    {
        /**
         * Features this method supports. Possible features used by core:
         * - shipping-zones Shipping zone functionality + instances
         * - instance-settings Instance settings screens.
         * - settings Non-instance settings screens. Enabled by default for BW compatibility with methods before instances existed.
         * - instance-settings-modal Allows the instance settings to be loaded within a modal in the zones UI.
         *
         * @var array
         */
        public $supports = array('settings');
        /**
         * Unique ID for the shipping method - must be set.
         *
         * @var string
         */
        public $id = '';
        /**
         * Method title.
         *
         * @var string
         */
        public $method_title = '';
        /**
         * Method description.
         *
         * @var string
         */
        public $method_description = '';
        /**
         * Yes or no based on whether the method is enabled.
         *
         * @var string
         */
        public $enabled = 'yes';
        /**
         * Shipping method title for the frontend.
         *
         * @var string
         */
        public $title;
        /**
         * This is an array of rates - methods must populate this array to register shipping costs.
         *
         * @var array
         */
        public $rates = array();
        /**
         * If 'taxable' tax will be charged for this method (if applicable).
         *
         * @var string
         */
        public $tax_status = 'taxable';
        /**
         * Fee for the method (if applicable).
         *
         * @var string
         */
        public $fee = \null;
        /**
         * Minimum fee for the method (if applicable).
         *
         * @var string
         */
        public $minimum_fee = \null;
        /**
         * Instance ID if used.
         *
         * @var int
         */
        public $instance_id = 0;
        /**
         * Instance form fields.
         *
         * @var array
         */
        public $instance_form_fields = array();
        /**
         * Instance settings.
         *
         * @var array
         */
        public $instance_settings = array();
        /**
         * Availability - legacy. Used for method Availability.
         * No longer useful for instance based shipping methods.
         *
         * @deprecated 2.6.0
         * @var string
         */
        public $availability;
        /**
         * Availability countries - legacy. Used for method Availability.
         * No longer useful for instance based shipping methods.
         *
         * @deprecated 2.6.0
         * @var array
         */
        public $countries = array();
        /**
         * Shipping method order.
         *
         * @var int
         */
        public $method_order;
        /**
         * Whether the shipping method has settings or not. Preferably, use {@see has_settings()} instead.
         *
         * @var bool
         */
        public $has_settings;
        /**
         * When the method supports the settings modal, this is the admin settings HTML.
         * Preferably, use {@see get_admin_options_html()} instead.
         *
         * @var string|bool
         */
        public $settings_html;
        /**
         * Constructor.
         *
         * @param int $instance_id Instance ID.
         */
        public function __construct($instance_id = 0)
        {
        }
        /**
         * Check if a shipping method supports a given feature.
         *
         * Methods should override this to declare support (or lack of support) for a feature.
         *
         * @param string $feature The name of a feature to test support for.
         * @return bool True if the shipping method supports the feature, false otherwise.
         */
        public function supports($feature)
        {
        }
        /**
         * Called to calculate shipping rates for this method. Rates can be added using the add_rate() method.
         *
         * @param array $package Package array.
         */
        public function calculate_shipping($package = array())
        {
        }
        /**
         * Whether or not we need to calculate tax on top of the shipping rate.
         *
         * @return boolean
         */
        public function is_taxable()
        {
        }
        /**
         * Whether or not this method is enabled in settings.
         *
         * @since 2.6.0
         * @return boolean
         */
        public function is_enabled()
        {
        }
        /**
         * Return the shipping method instance ID.
         *
         * @since 2.6.0
         * @return int
         */
        public function get_instance_id()
        {
        }
        /**
         * Return the shipping method title.
         *
         * @since 2.6.0
         * @return string
         */
        public function get_method_title()
        {
        }
        /**
         * Return the shipping method description.
         *
         * @since 2.6.0
         * @return string
         */
        public function get_method_description()
        {
        }
        /**
         * Return the shipping title which is user set.
         *
         * @return string
         */
        public function get_title()
        {
        }
        /**
         * Return calculated rates for a package.
         *
         * @since 2.6.0
         * @param array $package Package array.
         * @return array
         */
        public function get_rates_for_package($package)
        {
        }
        /**
         * Returns a rate ID based on this methods ID and instance, with an optional
         * suffix if distinguishing between multiple rates.
         *
         * @since 2.6.0
         * @param string $suffix Suffix.
         * @return string
         */
        public function get_rate_id($suffix = '')
        {
        }
        /**
         * Add a shipping rate. If taxes are not set they will be calculated based on cost.
         *
         * @param array $args Arguments (default: array()).
         */
        public function add_rate($args = array())
        {
        }
        /**
         * Calc taxes per item being shipping in costs array.
         *
         * @since 2.6.0
         * @param  array $costs Costs.
         * @return array of taxes
         */
        protected function get_taxes_per_item($costs)
        {
        }
        /**
         * Is this method available?
         *
         * @param array $package Package.
         * @return bool
         */
        public function is_available($package)
        {
        }
        /**
         * Get fee to add to shipping cost.
         *
         * @param string|float $fee Fee.
         * @param float        $total Total.
         * @return float
         */
        public function get_fee($fee, $total)
        {
        }
        /**
         * Does this method have a settings page?
         *
         * @return bool
         */
        public function has_settings()
        {
        }
        /**
         * Return admin options as a html string.
         *
         * @return string
         */
        public function get_admin_options_html()
        {
        }
        /**
         * Output the shipping settings screen.
         */
        public function admin_options()
        {
        }
        /**
         * Get_option function.
         *
         * Gets and option from the settings API, using defaults if necessary to prevent undefined notices.
         *
         * @param  string $key Key.
         * @param  mixed  $empty_value Empty value.
         * @return mixed  The value specified for the option or a default value for the option.
         */
        public function get_option($key, $empty_value = \null)
        {
        }
        /**
         * Gets an option from the settings API, using defaults if necessary to prevent undefined notices.
         *
         * @param  string $key Key.
         * @param  mixed  $empty_value Empty value.
         * @return mixed  The value specified for the option or a default value for the option.
         */
        public function get_instance_option($key, $empty_value = \null)
        {
        }
        /**
         * Get settings fields for instances of this shipping method (within zones).
         * Should be overridden by shipping methods to add options.
         *
         * @since 2.6.0
         * @return array
         */
        public function get_instance_form_fields()
        {
        }
        /**
         * Return the name of the option in the WP DB.
         *
         * @since 2.6.0
         * @return string
         */
        public function get_instance_option_key()
        {
        }
        /**
         * Initialise Settings for instances.
         *
         * @since 2.6.0
         */
        public function init_instance_settings()
        {
        }
        /**
         * Processes and saves global shipping method options in the admin area.
         *
         * This method is usually attached to woocommerce_update_options_x hooks.
         *
         * @since 2.6.0
         * @return bool was anything saved?
         */
        public function process_admin_options()
        {
        }
    }
    /**
     * WC_Widget
     *
     * @package  WooCommerce\Abstracts
     * @version  2.5.0
     * @extends  WP_Widget
     */
    abstract class WC_Widget extends \WP_Widget
    {
        /**
         * CSS class.
         *
         * @var string
         */
        public $widget_cssclass;
        /**
         * Widget description.
         *
         * @var string
         */
        public $widget_description;
        /**
         * Widget ID.
         *
         * @var string
         */
        public $widget_id;
        /**
         * Widget name.
         *
         * @var string
         */
        public $widget_name;
        /**
         * Settings.
         *
         * @var array
         */
        public $settings;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get cached widget.
         *
         * @param  array $args Arguments.
         * @return bool true if the widget is cached otherwise false
         */
        public function get_cached_widget($args)
        {
        }
        /**
         * Cache the widget.
         *
         * @param  array  $args Arguments.
         * @param  string $content Content.
         * @return string the content that was cached
         */
        public function cache_widget($args, $content)
        {
        }
        /**
         * Flush the cache.
         */
        public function flush_widget_cache()
        {
        }
        /**
         * Get this widgets title.
         *
         * @param array $instance Array of instance options.
         * @return string
         */
        protected function get_instance_title($instance)
        {
        }
        /**
         * Output the html at the start of a widget.
         *
         * @param array $args Arguments.
         * @param array $instance Instance.
         */
        public function widget_start($args, $instance)
        {
        }
        /**
         * Output the html at the end of a widget.
         *
         * @param  array $args Arguments.
         */
        public function widget_end($args)
        {
        }
        /**
         * Updates a particular instance of a widget.
         *
         * @see    WP_Widget->update
         * @param  array $new_instance New instance.
         * @param  array $old_instance Old instance.
         * @return array
         */
        public function update($new_instance, $old_instance)
        {
        }
        /**
         * Outputs the settings update form.
         *
         * @see   WP_Widget->form
         *
         * @param array $instance Instance.
         */
        public function form($instance)
        {
        }
        /**
         * Get current page URL with various filtering props supported by WC.
         *
         * @return string
         * @since  3.3.0
         */
        protected function get_current_page_url()
        {
        }
        /**
         * Get widget id plus scheme/protocol to prevent serving mixed content from (persistently) cached widgets.
         *
         * @since  3.4.0
         * @param  string $widget_id Id of the cached widget.
         * @param  string $scheme    Scheme for the widget id.
         * @return string            Widget id including scheme/protocol.
         */
        protected function get_widget_id_for_cache($widget_id, $scheme = '')
        {
        }
    }
    /**
     * Abstract WP_Async_Request class.
     */
    abstract class WP_Async_Request
    {
        /**
         * Prefix
         *
         * (default value: 'wp')
         *
         * @var string
         * @access protected
         */
        protected $prefix = 'wp';
        /**
         * Action
         *
         * (default value: 'async_request')
         *
         * @var string
         * @access protected
         */
        protected $action = 'async_request';
        /**
         * Identifier
         *
         * @var mixed
         * @access protected
         */
        protected $identifier;
        /**
         * Data
         *
         * (default value: array())
         *
         * @var array
         * @access protected
         */
        protected $data = array();
        /**
         * Initiate new async request
         */
        public function __construct()
        {
        }
        /**
         * Set data used during the request
         *
         * @param array $data Data.
         *
         * @return $this
         */
        public function data($data)
        {
        }
        /**
         * Dispatch the async request
         *
         * @return array|WP_Error
         */
        public function dispatch()
        {
        }
        /**
         * Get query args
         *
         * @return array
         */
        protected function get_query_args()
        {
        }
        /**
         * Get query URL
         *
         * @return string
         */
        protected function get_query_url()
        {
        }
        /**
         * Get post args
         *
         * @return array
         */
        protected function get_post_args()
        {
        }
        /**
         * Maybe handle
         *
         * Check for correct nonce and pass to handler.
         */
        public function maybe_handle()
        {
        }
        /**
         * Handle
         *
         * Override this method to perform any actions required
         * during the async request.
         */
        protected abstract function handle();
    }
    /**
     * Abstract WP_Background_Process class.
     */
    abstract class WP_Background_Process extends \WP_Async_Request
    {
        /**
         * Action
         *
         * (default value: 'background_process')
         *
         * @var string
         * @access protected
         */
        protected $action = 'background_process';
        /**
         * Start time of current process.
         *
         * (default value: 0)
         *
         * @var int
         * @access protected
         */
        protected $start_time = 0;
        /**
         * Cron_hook_identifier
         *
         * @var mixed
         * @access protected
         */
        protected $cron_hook_identifier;
        /**
         * Cron_interval_identifier
         *
         * @var mixed
         * @access protected
         */
        protected $cron_interval_identifier;
        /**
         * Initiate new background process
         */
        public function __construct()
        {
        }
        /**
         * Dispatch
         *
         * @access public
         * @return void
         */
        public function dispatch()
        {
        }
        /**
         * Push to queue
         *
         * @param mixed $data Data.
         *
         * @return $this
         */
        public function push_to_queue($data)
        {
        }
        /**
         * Save queue
         *
         * @return $this
         */
        public function save()
        {
        }
        /**
         * Update queue
         *
         * @param string $key Key.
         * @param array  $data Data.
         *
         * @return $this
         */
        public function update($key, $data)
        {
        }
        /**
         * Delete queue
         *
         * @param string $key Key.
         *
         * @return $this
         */
        public function delete($key)
        {
        }
        /**
         * Generate key
         *
         * Generates a unique key based on microtime. Queue items are
         * given a unique key so that they can be merged upon save.
         *
         * @param int $length Length.
         *
         * @return string
         */
        protected function generate_key($length = 64)
        {
        }
        /**
         * Maybe process queue
         *
         * Checks whether data exists within the queue and that
         * the process is not already running.
         */
        public function maybe_handle()
        {
        }
        /**
         * Is queue empty
         *
         * @return bool
         */
        protected function is_queue_empty()
        {
        }
        /**
         * Is process running
         *
         * Check whether the current process is already running
         * in a background process.
         */
        protected function is_process_running()
        {
        }
        /**
         * Lock process
         *
         * Lock the process so that multiple instances can't run simultaneously.
         * Override if applicable, but the duration should be greater than that
         * defined in the time_exceeded() method.
         */
        protected function lock_process()
        {
        }
        /**
         * Unlock process
         *
         * Unlock the process so that other instances can spawn.
         *
         * @return $this
         */
        protected function unlock_process()
        {
        }
        /**
         * Get batch
         *
         * @return stdClass Return the first batch from the queue
         */
        protected function get_batch()
        {
        }
        /**
         * Handle
         *
         * Pass each queue item to the task handler, while remaining
         * within server memory and time limit constraints.
         */
        protected function handle()
        {
        }
        /**
         * Memory exceeded
         *
         * Ensures the batch process never exceeds 90%
         * of the maximum WordPress memory.
         *
         * @return bool
         */
        protected function memory_exceeded()
        {
        }
        /**
         * Get memory limit
         *
         * @return int
         */
        protected function get_memory_limit()
        {
        }
        /**
         * Time exceeded.
         *
         * Ensures the batch never exceeds a sensible time limit.
         * A timeout limit of 30s is common on shared hosting.
         *
         * @return bool
         */
        protected function time_exceeded()
        {
        }
        /**
         * Complete.
         *
         * Override if applicable, but ensure that the below actions are
         * performed, or, call parent::complete().
         */
        protected function complete()
        {
        }
        /**
         * Schedule cron healthcheck
         *
         * @access public
         * @param mixed $schedules Schedules.
         * @return mixed
         */
        public function schedule_cron_healthcheck($schedules)
        {
        }
        /**
         * Handle cron healthcheck
         *
         * Restart the background process if not already running
         * and data exists in the queue.
         */
        public function handle_cron_healthcheck()
        {
        }
        /**
         * Schedule event
         */
        protected function schedule_event()
        {
        }
        /**
         * Clear scheduled event
         */
        protected function clear_scheduled_event()
        {
        }
        /**
         * Cancel Process
         *
         * Stop processing queue items, clear cronjob and delete batch.
         *
         */
        public function cancel_process()
        {
        }
        /**
         * Task
         *
         * Override this method to perform any actions required on each
         * queue item. Return the modified item for further processing
         * in the next pass through. Or, return false to remove the
         * item from the queue.
         *
         * @param mixed $item Queue item to iterate over.
         *
         * @return mixed
         */
        protected abstract function task($item);
    }
    /**
     * WC_Background_Process class.
     */
    abstract class WC_Background_Process extends \WP_Background_Process
    {
        /**
         * Is queue empty.
         *
         * @return bool
         */
        protected function is_queue_empty()
        {
        }
        /**
         * Get batch.
         *
         * @return stdClass Return the first batch from the queue.
         */
        protected function get_batch()
        {
        }
        /**
         * See if the batch limit has been exceeded.
         *
         * @return bool
         */
        protected function batch_limit_exceeded()
        {
        }
        /**
         * Handle.
         *
         * Pass each queue item to the task handler, while remaining
         * within server memory and time limit constraints.
         */
        protected function handle()
        {
        }
        /**
         * Get memory limit.
         *
         * @return int
         */
        protected function get_memory_limit()
        {
        }
        /**
         * Schedule cron healthcheck.
         *
         * @param array $schedules Schedules.
         * @return array
         */
        public function schedule_cron_healthcheck($schedules)
        {
        }
        /**
         * Delete all batches.
         *
         * @return WC_Background_Process
         */
        public function delete_all_batches()
        {
        }
        /**
         * Kill process.
         *
         * Stop processing queue items, clear cronjob and delete all batches.
         */
        public function kill_process()
        {
        }
    }
    /**
     * WC_Admin_Addons Class.
     */
    class WC_Admin_Addons
    {
        /**
         * Get featured for the addons screen
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @return array of objects
         */
        public static function get_featured()
        {
        }
        /**
         * Render featured products and banners using WCCOM's the Featured 2.0 Endpoint
         *
         * @return void
         */
        public static function render_featured()
        {
        }
        /**
         * Fetch featured products from WCCOM's the Featured 2.0 Endpoint and cache the data for a day.
         *
         * @return array|WP_Error
         */
        public static function fetch_featured()
        {
        }
        /**
         * Check if the error is due to an SSL error
         *
         * @param string $error_message Error message.
         *
         * @return bool True if SSL error, false otherwise
         */
        public static function is_ssl_error($error_message)
        {
        }
        /**
         * Build url parameter string
         *
         * @param  string $category Addon (sub) category.
         * @param  string $term     Search terms.
         * @param  string $country  Store country.
         *
         * @return string url parameter string
         */
        public static function build_parameter_string($category, $term, $country)
        {
        }
        /**
         * Call API to get extensions
         *
         * @param  string $category Addon (sub) category.
         * @param  string $term     Search terms.
         * @param  string $country  Store country.
         *
         * @return object|WP_Error  Object with products and promotions properties, or WP_Error
         */
        public static function get_extension_data($category, $term, $country)
        {
        }
        /**
         * Get sections for the addons screen
         *
         * @return array of objects
         */
        public static function get_sections()
        {
        }
        /**
         * Get section for the addons screen.
         *
         * @param  string $section_id Required section ID.
         *
         * @return object|bool
         */
        public static function get_section($section_id)
        {
        }
        /**
         * Get section content for the addons screen.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param  string $section_id Required section ID.
         *
         * @return array
         */
        public static function get_section_data($section_id)
        {
        }
        /**
         * Handles the outputting of a contextually aware Storefront link (points to child themes if Storefront is already active).
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         */
        public static function output_storefront_button()
        {
        }
        /**
         * Handles the outputting of a banner block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Banner data.
         */
        public static function output_banner_block($block)
        {
        }
        /**
         * Handles the outputting of a column.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Column data.
         */
        public static function output_column($block)
        {
        }
        /**
         * Handles the outputting of a column block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Column block data.
         */
        public static function output_column_block($block)
        {
        }
        /**
         * Handles the outputting of a small light block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Block data.
         */
        public static function output_small_light_block($block)
        {
        }
        /**
         * Handles the outputting of a small dark block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Block data.
         */
        public static function output_small_dark_block($block)
        {
        }
        /**
         * Handles the outputting of the WooCommerce Services banner block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Block data.
         */
        public static function output_wcs_banner_block($block = array())
        {
        }
        /**
         * Handles the outputting of the WooCommerce Pay banner block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param object $block Block data.
         */
        public static function output_wcpay_banner_block($block = array())
        {
        }
        /**
         * Output the HTML for the promotion block.
         *
         * @param array $promotion Array of promotion block data.
         * @return void
         */
        public static function output_search_promotion_block(array $promotion)
        {
        }
        /**
         * Handles the output of a full-width block.
         *
         * @deprecated 5.9.0 No longer used in In-App Marketplace
         *
         * @param array $section Section data.
         */
        public static function output_promotion_block($section)
        {
        }
        /**
         * Handles the outputting of featured sections
         *
         * @param array $sections Section data.
         */
        public static function output_featured_sections($sections)
        {
        }
        /**
         * Handles the outputting of featured page
         *
         * @param array $blocks Featured page's blocks.
         */
        private static function output_featured($blocks)
        {
        }
        /**
         * Render a group block including products
         *
         * @param mixed $block Block of the page for rendering.
         *
         * @return void
         */
        private static function output_group($block)
        {
        }
        /**
         * Render a banner contains a product
         *
         * @param mixed $block Block of the page for rendering.
         *
         * @return void
         */
        private static function output_banner($block)
        {
        }
        /**
         * Returns in-app-purchase URL params.
         */
        public static function get_in_app_purchase_url_params()
        {
        }
        /**
         * Add in-app-purchase URL params to link.
         *
         * Adds various url parameters to a url to support a streamlined
         * flow for obtaining and setting up WooCommerce extensons.
         *
         * @param string $url    Destination URL.
         */
        public static function add_in_app_purchase_url_params($url)
        {
        }
        /**
         * Outputs a button.
         *
         * @param string $url    Destination URL.
         * @param string $text   Button label text.
         * @param string $style  Button style class.
         * @param string $plugin The plugin the button is promoting.
         */
        public static function output_button($url, $text, $style, $plugin = '')
        {
        }
        /**
         * Output HTML for a promotion action.
         *
         * @param array $action Array of action properties.
         *
         * @return void
         */
        public static function output_promotion_action(array $action)
        {
        }
        /**
         * Output HTML for a promotion action if data couldn't be fetched.
         *
         * @param string $message Error message.
         *
         * @return void
         */
        public static function output_empty($message = '')
        {
        }
        /**
         * Handles output of the addons page in admin.
         */
        public static function output()
        {
        }
        /**
         * Install WooCommerce Services from Extensions screens.
         */
        public static function install_woocommerce_services_addon()
        {
        }
        /**
         * Install WooCommerce Payments from the Extensions screens.
         *
         * @param string $section Optional. Extensions tab.
         *
         * @return void
         */
        public static function install_woocommerce_payments_addon($section = '_featured')
        {
        }
        /**
         * We're displaying page=wc-addons and page=wc-addons&section=helper as two separate pages.
         * When we're on those pages, add body classes to distinguishe them.
         *
         * @param string $admin_body_class Unfiltered body class.
         *
         * @return string Body class with added class for Marketplace or My Subscriptions page.
         */
        public static function filter_admin_body_classes(string $admin_body_class = '') : string
        {
        }
        /**
         * Determine which class should be used for a rating star:
         * - golden
         * - half-filled (50/50 golden and gray)
         * - gray
         *
         * Consider ratings from 3.0 to 4.0 as an example
         * 3.0 will produce 3 stars
         * 3.1 to 3.5 will produce 3 stars and a half star
         * 3.6 to 4.0 will product 4 stars
         *
         * @param float $rating Rating of a product.
         * @param int   $index  Index of a star in a row.
         *
         * @return string CSS class to use.
         */
        public static function get_star_class($rating, $index)
        {
        }
        /**
         * Take an action object and return the URL based on properties of the action.
         *
         * @param object $action Action object.
         * @return string URL.
         */
        public static function get_action_url($action) : string
        {
        }
        /**
         * Format the promotion data ready for display, ie fetch locales and actions.
         *
         * @param array $promotions Array of promotoin objects.
         * @return array Array of formatted promotions ready for output.
         */
        public static function format_promotions(array $promotions) : array
        {
        }
        /**
         * Map data from different endpoints to a universal format
         *
         * Search and featured products has a slightly different products' field names.
         * Mapping converts different data structures into a universal one for further processing.
         *
         * @param mixed $data Product Card Data.
         *
         * @return object Converted data.
         */
        public static function map_product_card_data($data)
        {
        }
        /**
         * Render a product card
         *
         * There's difference in data structure (e.g. field names) between endpoints such as search and
         * featured. Inner mapping helps to use universal field names for further work.
         *
         * @param mixed  $data       Product data.
         * @param string $block_type Block type that's different from the default product card, e.g. a banner.
         *
         * @return void
         */
        public static function render_product_card($data, $block_type = \null)
        {
        }
        /**
         * Retrieves the locale data from a transient.
         *
         * Transient value is an array of locale data in the following format:
         * array(
         *    'en_US' => ...,
         *    'fr_FR' => ...,
         * )
         *
         * If the transient does not exist, does not have a value, or has expired,
         * then the return value will be false.
         *
         * @param string $transient Transient name. Expected to not be SQL-escaped.
         * @param string $locale  Locale to retrieve.
         * @return mixed Value of transient.
         */
        private static function get_locale_data_from_transient($transient, $locale)
        {
        }
        /**
         * Sets the locale data in a transient.
         *
         * Transient value is an array of locale data in the following format:
         * array(
         *    'en_US' => ...,
         *    'fr_FR' => ...,
         * )
         *
         * @param string $transient  Transient name. Expected to not be SQL-escaped.
         *                           Must be 172 characters or fewer in length.
         * @param mixed  $value      Transient value. Must be serializable if non-scalar.
         *                           Expected to not be SQL-escaped.
         * @param string $locale  Locale to set.
         * @param int    $expiration Optional. Time until expiration in seconds. Default 0 (no expiration).
         * @return bool True if the value was set, false otherwise.
         */
        private static function set_locale_data_in_transient($transient, $value, $locale, $expiration = 0)
        {
        }
    }
    /**
     * API Keys table list class.
     */
    class WC_Admin_API_Keys_Table_List extends \WP_List_Table
    {
        /**
         * Initialize the API key table list.
         */
        public function __construct()
        {
        }
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Get list columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Column cb.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_cb($key)
        {
        }
        /**
         * Return title column.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_title($key)
        {
        }
        /**
         * Return truncated consumer key column.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_truncated_key($key)
        {
        }
        /**
         * Return user column.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_user($key)
        {
        }
        /**
         * Return permissions column.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_permissions($key)
        {
        }
        /**
         * Return last access column.
         *
         * @param  array $key Key data.
         * @return string
         */
        public function column_last_access($key)
        {
        }
        /**
         * Get bulk actions.
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Search box.
         *
         * @param  string $text     Button text.
         * @param  string $input_id Input ID.
         */
        public function search_box($text, $input_id)
        {
        }
        /**
         * Prepare table list items.
         */
        public function prepare_items()
        {
        }
    }
    /**
     * WC_Admin_API_Keys.
     */
    class WC_Admin_API_Keys
    {
        /**
         * Initialize the API Keys admin actions.
         */
        public function __construct()
        {
        }
        /**
         * Check if should allow save settings.
         * This prevents "Your settings have been saved." notices on the table list.
         *
         * @param  bool $allow If allow save settings.
         * @return bool
         */
        public function allow_save_settings($allow)
        {
        }
        /**
         * Check if is API Keys settings page.
         *
         * @return bool
         */
        private function is_api_keys_settings_page()
        {
        }
        /**
         * Page output.
         */
        public static function page_output()
        {
        }
        /**
         * Add screen option.
         */
        public function screen_option()
        {
        }
        /**
         * Table list output.
         */
        private static function table_list_output()
        {
        }
        /**
         * Get key data.
         *
         * @param  int $key_id API Key ID.
         * @return array
         */
        private static function get_key_data($key_id)
        {
        }
        /**
         * API Keys admin actions.
         */
        public function actions()
        {
        }
        /**
         * Notices.
         */
        public static function notices()
        {
        }
        /**
         * Revoke key.
         */
        private function revoke_key()
        {
        }
        /**
         * Bulk actions.
         */
        private function bulk_actions()
        {
        }
        /**
         * Bulk revoke key.
         *
         * @param array $keys API Keys.
         */
        private function bulk_revoke_key($keys)
        {
        }
        /**
         * Remove key.
         *
         * @param  int $key_id API Key ID.
         * @return bool
         */
        private function remove_key($key_id)
        {
        }
    }
    /**
     * WC_Admin_Assets Class.
     */
    class WC_Admin_Assets
    {
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Enqueue styles.
         */
        public function admin_styles()
        {
        }
        /**
         * Enqueue scripts.
         */
        public function admin_scripts()
        {
        }
        /**
         * Enqueue block editor assets.
         *
         * @return void
         */
        public function enqueue_block_editor_assets()
        {
        }
        /**
         * Helper function to determine whether the current screen is an order edit screen.
         *
         * @param string $screen_id Screen ID.
         *
         * @return bool Whether the current screen is an order edit screen.
         */
        private function is_order_meta_box_screen($screen_id)
        {
        }
    }
    /**
     * WC_Admin_Attributes Class.
     */
    class WC_Admin_Attributes
    {
        /**
         * Edited attribute ID.
         *
         * @var int
         */
        private static $edited_attribute_id;
        /**
         * Handles output of the attributes page in admin.
         *
         * Shows the created attributes and lets you add new ones or edit existing ones.
         * The added attributes are stored in the database and can be used for layered navigation.
         */
        public static function output()
        {
        }
        /**
         * Get and sanitize posted attribute data.
         *
         * @return array
         */
        private static function get_posted_attribute()
        {
        }
        /**
         * Add an attribute.
         *
         * @return bool|WP_Error
         */
        private static function process_add_attribute()
        {
        }
        /**
         * Edit an attribute.
         *
         * @return bool|WP_Error
         */
        private static function process_edit_attribute()
        {
        }
        /**
         * Delete an attribute.
         *
         * @return bool
         */
        private static function process_delete_attribute()
        {
        }
        /**
         * Edit Attribute admin panel.
         *
         * Shows the interface for changing an attributes type between select and text.
         */
        public static function edit_attribute()
        {
        }
        /**
         * Add Attribute admin panel.
         *
         * Shows the interface for adding new attributes.
         */
        public static function add_attribute()
        {
        }
    }
    /**
     * WC_Admin_Customize Class.
     */
    class WC_Admin_Customize
    {
        /**
         * Initialize customize actions.
         */
        public function __construct()
        {
        }
        /**
         * Register customize new nav menu item types.
         * This will register WooCommerce account endpoints as a nav menu item type.
         *
         * @since  3.1.0
         * @param  array $item_types Menu item types.
         * @return array
         */
        public function register_customize_nav_menu_item_types($item_types)
        {
        }
        /**
         * Register account endpoints to customize nav menu items.
         *
         * @since  3.1.0
         * @param  array   $items  List of nav menu items.
         * @param  string  $type   Nav menu type.
         * @param  string  $object Nav menu object.
         * @param  integer $page   Page number.
         * @return array
         */
        public function register_customize_nav_menu_items($items = array(), $type = '', $object = '', $page = 0)
        {
        }
    }
    /**
     * WC_Admin_Dashboard_Setup Class.
     */
    class WC_Admin_Dashboard_Setup
    {
        /**
         * Check for task list initialization.
         */
        private $initalized = \false;
        /**
         * The task list.
         */
        private $task_list = \null;
        /**
         * The tasks.
         */
        private $tasks = \null;
        /**
         * # of completed tasks.
         *
         * @var int
         */
        private $completed_tasks_count = 0;
        /**
         * WC_Admin_Dashboard_Setup constructor.
         */
        public function __construct()
        {
        }
        /**
         * Render meta box output.
         */
        public function render()
        {
        }
        /**
         * Get the button link for a given task.
         *
         * @param Task $task Task.
         * @return string
         */
        public function get_button_link($task)
        {
        }
        /**
         * Get the task list.
         *
         * @return array
         */
        public function get_task_list()
        {
        }
        /**
         * Set the task list.
         */
        public function set_task_list($task_list)
        {
        }
        /**
         * Get the tasks.
         *
         * @return array
         */
        public function get_tasks()
        {
        }
        /**
         * Return # of completed tasks
         *
         * @return integer
         */
        public function get_completed_tasks_count()
        {
        }
        /**
         * Get the next task.
         *
         * @return array|null
         */
        private function get_next_task()
        {
        }
        /**
         * Check to see if we should display the widget
         *
         * @return bool
         */
        public function should_display_widget()
        {
        }
    }
    /**
     * WC_Admin_Dashboard Class.
     */
    class WC_Admin_Dashboard
    {
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Init dashboard widgets.
         */
        public function init()
        {
        }
        /**
         * Register the network order dashboard widget.
         */
        public function register_network_order_widget()
        {
        }
        /**
         * Check to see if we should display the widget.
         *
         * @return bool
         */
        private function should_display_widget()
        {
        }
        /**
         * Get top seller from DB.
         *
         * @return object
         */
        private function get_top_seller()
        {
        }
        /**
         * Get sales report data.
         *
         * @return object
         */
        private function get_sales_report_data()
        {
        }
        /**
         * Show status widget.
         */
        public function status_widget()
        {
        }
        /**
         * Show order data is status widget.
         */
        private function status_widget_order_rows()
        {
        }
        /**
         * Show stock data is status widget.
         *
         * @param bool $is_wc_admin_disabled if woocommerce admin is disabled.
         */
        private function status_widget_stock_rows($is_wc_admin_disabled)
        {
        }
        /**
         * Recent reviews widget.
         */
        public function recent_reviews()
        {
        }
        /**
         * Network orders widget.
         */
        public function network_orders()
        {
        }
        /**
         * Gets the sales performance data from the new WooAdmin store.
         *
         * @return stdClass|WP_Error|WP_REST_Response
         */
        private function get_wc_admin_performance_data()
        {
        }
        /**
         * Overwrites the original sparkline to use the new reports data if WooAdmin is enabled.
         * Prepares a sparkline to show sales in the last X days.
         *
         * @param  WC_Admin_Report $reports old class for getting reports.
         * @param  bool            $is_wc_admin_disabled If WC Admin is disabled or not.
         * @param  int             $id ID of the product to show. Blank to get all orders.
         * @param  string          $type Type of sparkline to get. Ignored if ID is not set.
         * @return string
         */
        private function sales_sparkline($reports, $is_wc_admin_disabled = \false, $id = '', $type = 'sales')
        {
        }
    }
    /**
     * WC_Admin_Duplicate_Product Class.
     */
    class WC_Admin_Duplicate_Product
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Show the "Duplicate" link in admin products list.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Post object.
         * @return array
         */
        public function dupe_link($actions, $post)
        {
        }
        /**
         * Show the dupe product link in admin.
         */
        public function dupe_button()
        {
        }
        /**
         * Duplicate a product action.
         */
        public function duplicate_product_action()
        {
        }
        /**
         * Function to create the duplicate of the product.
         *
         * @param WC_Product $product The product to duplicate.
         * @return WC_Product The duplicate.
         */
        public function product_duplicate($product)
        {
        }
        /**
         * Get a product from the database to duplicate.
         *
         * @deprecated 3.0.0
         * @param mixed $id The ID of the product to duplicate.
         * @return object|bool
         * @see duplicate_product
         */
        private function get_product_to_duplicate($id)
        {
        }
        /**
         * Generates a unique slug for a given product. We do this so that we can override the
         * behavior of wp_unique_post_slug(). The normal slug generation will run single
         * select queries on every non-unique slug, resulting in very bad performance.
         *
         * @param WC_Product $product The product to generate a slug for.
         * @since 3.9.0
         */
        private function generate_unique_slug($product)
        {
        }
    }
    /**
     * WC_Admin_Exporters Class.
     */
    class WC_Admin_Exporters
    {
        /**
         * Array of exporter IDs.
         *
         * @var string[]
         */
        protected $exporters = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Return true if WooCommerce export is allowed for current user, false otherwise.
         *
         * @return bool Whether current user can perform export.
         */
        protected function export_allowed()
        {
        }
        /**
         * Add menu items for our custom exporters.
         */
        public function add_to_menus()
        {
        }
        /**
         * Hide menu items from view so the pages exist, but the menu items do not.
         */
        public function hide_from_menus()
        {
        }
        /**
         * Enqueue scripts.
         */
        public function admin_scripts()
        {
        }
        /**
         * Export page UI.
         */
        public function product_exporter()
        {
        }
        /**
         * Serve the generated file.
         */
        public function download_export_file()
        {
        }
        /**
         * AJAX callback for doing the actual export to the CSV file.
         */
        public function do_ajax_product_export()
        {
        }
        /**
         * Gets the product types that can be exported.
         *
         * @since 5.1.0
         * @return array The product types keys and labels.
         */
        public static function get_product_types()
        {
        }
    }
    /**
     * WC_Admin_Help Class.
     */
    class WC_Admin_Help
    {
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Add help tabs.
         */
        public function add_tabs()
        {
        }
    }
    /**
     * WC_Admin_Importers Class.
     */
    class WC_Admin_Importers
    {
        /**
         * Array of importer IDs.
         *
         * @var string[]
         */
        protected $importers = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Return true if WooCommerce imports are allowed for current user, false otherwise.
         *
         * @return bool Whether current user can perform imports.
         */
        protected function import_allowed()
        {
        }
        /**
         * Add menu items for our custom importers.
         */
        public function add_to_menus()
        {
        }
        /**
         * Hide menu items from view so the pages exist, but the menu items do not.
         */
        public function hide_from_menus()
        {
        }
        /**
         * Register importer scripts.
         */
        public function admin_scripts()
        {
        }
        /**
         * The product importer.
         *
         * This has a custom screen - the Tools > Import item is a placeholder.
         * If we're on that screen, redirect to the custom one.
         */
        public function product_importer()
        {
        }
        /**
         * Register WordPress based importers.
         */
        public function register_importers()
        {
        }
        /**
         * The tax rate importer which extends WP_Importer.
         */
        public function tax_rates_importer()
        {
        }
        /**
         * When running the WP XML importer, ensure attributes exist.
         *
         * WordPress import should work - however, it fails to import custom product attribute taxonomies.
         * This code grabs the file before it is imported and ensures the taxonomies are created.
         */
        public function post_importer_compatibility()
        {
        }
        /**
         * Ajax callback for importing one batch of products from a CSV.
         */
        public function do_ajax_product_import()
        {
        }
    }
    class WC_Admin_Log_Table_List extends \WP_List_Table
    {
        /**
         * The key for the user option of how many list table items to display per page.
         *
         * @const string
         */
        public const PER_PAGE_USER_OPTION_KEY = 'woocommerce_status_log_items_per_page';
        /**
         * Initialize the log table list.
         */
        public function __construct()
        {
        }
        /**
         * Display level dropdown
         *
         * @global wpdb $wpdb
         */
        public function level_dropdown()
        {
        }
        /**
         * Generates the table rows.
         *
         * @return void
         */
        public function display_rows()
        {
        }
        /**
         * Render the additional table row that contains extra log context data.
         *
         * @param array $log Log entry data.
         *
         * @return void
         */
        protected function context_row($log)
        {
        }
        /**
         * Get list columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Column cb.
         *
         * @param  array $log
         * @return string
         */
        public function column_cb($log)
        {
        }
        /**
         * Timestamp column.
         *
         * @param  array $log
         * @return string
         */
        public function column_timestamp($log)
        {
        }
        /**
         * Level column.
         *
         * @param  array $log
         * @return string
         */
        public function column_level($log)
        {
        }
        /**
         * Message column.
         *
         * @param  array $log
         * @return string
         */
        public function column_message($log)
        {
        }
        /**
         * Source column.
         *
         * @param  array $log
         * @return string
         */
        public function column_source($log)
        {
        }
        /**
         * Context column.
         *
         * @param array $log Log entry data.
         *
         * @return string
         */
        public function column_context($log)
        {
        }
        /**
         * Get bulk actions.
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Extra controls to be displayed between bulk actions and pagination.
         *
         * @param string $which
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * Get a list of sortable columns.
         *
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Display source dropdown
         *
         * @global wpdb $wpdb
         */
        protected function source_dropdown()
        {
        }
        /**
         * Prepare table list items.
         *
         * @global wpdb $wpdb
         */
        public function prepare_items()
        {
        }
        /**
         * Get prepared LIMIT clause for items query
         *
         * @global wpdb $wpdb
         *
         * @return string Prepared LIMIT clause for items query.
         */
        protected function get_items_query_limit()
        {
        }
        /**
         * Get prepared OFFSET clause for items query
         *
         * @global wpdb $wpdb
         *
         * @return string Prepared OFFSET clause for items query.
         */
        protected function get_items_query_offset()
        {
        }
        /**
         * Get prepared ORDER BY clause for items query
         *
         * @return string Prepared ORDER BY clause for items query.
         */
        protected function get_items_query_order()
        {
        }
        /**
         * Get prepared WHERE clause for items query
         *
         * @global wpdb $wpdb
         *
         * @return string Prepared WHERE clause for items query.
         */
        protected function get_items_query_where()
        {
        }
        /**
         * Set _column_headers property for table list
         */
        protected function prepare_column_headers()
        {
        }
        /**
         * Helper to get the default value for the per_page arg.
         *
         * @return int
         */
        public function get_per_page_default() : int
        {
        }
    }
    /**
     * WC_Admin_Menus Class.
     */
    class WC_Admin_Menus
    {
        /**
         * The CSS classes used to hide the submenu items in navigation.
         *
         * @var string
         */
        const HIDE_CSS_CLASS = 'hide-if-js';
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Add menu items.
         */
        public function admin_menu()
        {
        }
        /**
         * Add menu item.
         */
        public function reports_menu()
        {
        }
        /**
         * Add menu item.
         */
        public function settings_menu()
        {
        }
        /**
         * Check if the user can access the top-level WooCommerce item.
         */
        public static function can_view_woocommerce_menu_item()
        {
        }
        /**
         * Loads gateways and shipping methods into memory for use within settings.
         */
        public function settings_page_init()
        {
        }
        /**
         * Handle saving of settings.
         *
         * @return void
         */
        public function save_settings()
        {
        }
        /**
         * Add menu item.
         */
        public function status_menu()
        {
        }
        /**
         * Addons menu item.
         */
        public function addons_menu()
        {
        }
        /**
         * Registers the wc-addons page within the WooCommerce menu.
         * Temporary measure till we convert the whole page to React.
         *
         * @return void
         */
        public function addons_my_subscriptions()
        {
        }
        /**
         * Highlights the correct top level admin menu item for post type add screens.
         */
        public function menu_highlight()
        {
        }
        /**
         * Adds the order processing count to the menu.
         */
        public function menu_order_count()
        {
        }
        /**
         * Reorder the WC menu items in admin.
         *
         * @param int $menu_order Menu order.
         * @return array
         */
        public function menu_order($menu_order)
        {
        }
        /**
         * Custom menu order.
         *
         * @param bool $enabled Whether custom menu ordering is already enabled.
         * @return bool
         */
        public function custom_menu_order($enabled)
        {
        }
        /**
         * Validate screen options on update.
         *
         * @param bool|int $status Screen option value. Default false to skip.
         * @param string   $option The option name.
         * @param int      $value  The number of rows to use.
         */
        public function set_screen_option($status, $option, $value)
        {
        }
        /**
         * Init the reports page.
         */
        public function reports_page()
        {
        }
        /**
         * Init the settings page.
         */
        public function settings_page()
        {
        }
        /**
         * Init the attributes page.
         */
        public function attributes_page()
        {
        }
        /**
         * Init the status page.
         */
        public function status_page()
        {
        }
        /**
         * Init the addons page.
         */
        public function addons_page()
        {
        }
        /**
         * Link to the order admin list table from the main WooCommerce menu.
         *
         * @return void
         */
        public function orders_menu() : void
        {
        }
        /**
         * Add custom nav meta box.
         *
         * Adapted from http://www.johnmorrisonline.com/how-to-add-a-fully-functional-custom-meta-box-to-wordpress-navigation-menus/.
         */
        public function add_nav_menu_meta_boxes()
        {
        }
        /**
         * Output menu links.
         */
        public function nav_menu_links()
        {
        }
        /**
         * Add the "Visit Store" link in admin bar main menu.
         *
         * @since 2.4.0
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance.
         */
        public function admin_bar_menus($wp_admin_bar)
        {
        }
        /**
         * Maybe add new management product experience.
         */
        public function maybe_add_new_product_management_experience()
        {
        }
        /**
         * Hide the submenu page based on slug and return the item that was hidden.
         *
         * Borrowed from Jetpack's Base_Admin_Menu class.
         *
         * Instead of actually removing the submenu item, a safer approach is to hide it and filter it in the API response.
         * In this manner we'll avoid breaking third-party plugins depending on items that no longer exist.
         *
         * A false|array value is returned to be consistent with remove_submenu_page() function
         *
         * @param string $menu_slug The parent menu slug.
         * @param string $submenu_slug The submenu slug that should be hidden.
         * @return false|array
         */
        public function hide_submenu_page($menu_slug, $submenu_slug)
        {
        }
        /**
         * Apply the hide-if-js CSS class to a submenu item.
         *
         * Borrowed from Jetpack's Base_Admin_Menu class.
         *
         * @param int    $index The position of a submenu item in the submenu array.
         * @param string $parent_slug The parent slug.
         * @param array  $item The submenu item.
         */
        public function hide_submenu_element($index, $parent_slug, $item)
        {
        }
    }
    /**
     * WC_Admin_Meta_Boxes.
     */
    class WC_Admin_Meta_Boxes
    {
        /**
         * Name of the option used to store errors to be displayed at the next suitable opportunity.
         *
         * @since 6.5.0
         */
        public const ERROR_STORE = 'woocommerce_meta_box_errors';
        /**
         * Is meta boxes saved once?
         *
         * @var boolean
         */
        private static $saved_meta_boxes = \false;
        /**
         * Meta box error messages.
         *
         * @var array
         */
        public static $meta_box_errors = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Add an error message.
         *
         * @param string $text Error to add.
         */
        public static function add_error($text)
        {
        }
        /**
         * Save errors to an option.
         *
         * Note that calling this will overwrite any errors that have already been stored via the Options API.
         * Unless you are sure you want this, consider using the append_to_error_store() method instead.
         */
        public function save_errors()
        {
        }
        /**
         * If additional errors have been added in the current request (ie, via the add_error() method) then they
         * will be added to the persistent error store via the Options API.
         *
         * @since 6.5.0
         */
        public function append_to_error_store()
        {
        }
        /**
         * Show any stored error messages.
         */
        public function output_errors()
        {
        }
        /**
         * Add WC Meta boxes.
         */
        public function add_meta_boxes()
        {
        }
        /**
         * Add default sort order for meta boxes on product page.
         */
        public function add_product_boxes_sort_order()
        {
        }
        /**
         * Remove bloat.
         */
        public function remove_meta_boxes()
        {
        }
        /**
         * Rename core meta boxes.
         */
        public function rename_meta_boxes()
        {
        }
        /**
         * Check if we're saving, the trigger an action based on the post type.
         *
         * @param  int    $post_id Post ID.
         * @param  object $post Post object.
         */
        public function save_meta_boxes($post_id, $post)
        {
        }
        /**
         * Remove irrelevant block templates from the list of available templates for products.
         * This will also remove custom created templates.
         *
         * @param string[] $templates Array of template header names keyed by the template file name.
         *
         * @return string[] Templates array excluding block-based templates.
         */
        public function remove_block_templates($templates)
        {
        }
    }
}
namespace Automattic\WooCommerce\Internal\Traits {
    /**
     * This trait allows making private methods of a class accessible from outside.
     * This is useful to define hook handlers with the [$this, 'method'] or [__CLASS__, 'method'] syntax
     * without having to make the method public (and thus having to keep it forever for backwards compatibility).
     *
     * Example:
     *
     * class Foobar {
     *   use AccessiblePrivateMethods;
     *
     *   public function __construct() {
     *     self::add_action('some_action', [$this, 'handle_some_action']);
     *   }
     *
     *   public static function init() {
     *     self::add_filter('some_filter', [__CLASS__, 'handle_some_filter']);
     *   }
     *
     *   private function handle_some_action() {
     *   }
     *
     *   private static function handle_some_filter() {
     *   }
     * }
     *
     * For this to work the callback must be an array and the first element of the array must be either '$this', '__CLASS__',
     * or another instance of the same class; otherwise the method won't be marked as accessible
     * (but the corresponding WordPress 'add_action' and 'add_filter' functions will still be called).
     *
     * No special procedure is needed to remove hooks set up with these methods, the regular 'remove_action'
     * and 'remove_filter' functions provided by WordPress can be used as usual.
     */
    trait AccessiblePrivateMethods
    {
        //phpcs:disable PSR2.Classes.PropertyDeclaration.Underscore
        /**
         * List of instance methods marked as externally accessible.
         *
         * @var array
         */
        private $_accessible_private_methods = array();
        /**
         * List of static methods marked as externally accessible.
         *
         * @var array
         */
        private static $_accessible_static_private_methods = array();
        //phpcs:enable PSR2.Classes.PropertyDeclaration.Underscore
        /**
         * Register a WordPress action.
         * If the callback refers to a private or protected instance method in this class, the method is marked as externally accessible.
         *
         * $callback can be a standard callable, or a string representing the name of a method in this class.
         *
         * @param string          $hook_name       The name of the action to add the callback to.
         * @param callable|string $callback        The callback to be run when the action is called.
         * @param int             $priority        Optional. Used to specify the order in which the functions
         *                                         associated with a particular action are executed.
         *                                         Lower numbers correspond with earlier execution,
         *                                         and functions with the same priority are executed
         *                                         in the order in which they were added to the action. Default 10.
         * @param int             $accepted_args   Optional. The number of arguments the function accepts. Default 1.
         */
        protected static function add_action(string $hook_name, $callback, int $priority = 10, int $accepted_args = 1) : void
        {
        }
        /**
         * Register a WordPress filter.
         * If the callback refers to a private or protected instance method in this class, the method is marked as externally accessible.
         *
         * $callback can be a standard callable, or a string representing the name of a method in this class.
         *
         * @param string          $hook_name       The name of the filter to add the callback to.
         * @param callable|string $callback        The callback to be run when the filter is called.
         * @param int             $priority        Optional. Used to specify the order in which the functions
         *                                         associated with a particular filter are executed.
         *                                         Lower numbers correspond with earlier execution,
         *                                         and functions with the same priority are executed
         *                                         in the order in which they were added to the filter. Default 10.
         * @param int             $accepted_args   Optional. The number of arguments the function accepts. Default 1.
         */
        protected static function add_filter(string $hook_name, $callback, int $priority = 10, int $accepted_args = 1) : void
        {
        }
        /**
         * Do the required processing to a callback before invoking the WordPress 'add_action' or 'add_filter' function.
         *
         * @param callable $callback The callback to process.
         * @return void
         */
        protected static function process_callback_before_hooking($callback) : void
        {
        }
        /**
         * Register a private or protected instance method of this class as externally accessible.
         *
         * @param string $method_name Method name.
         * @return bool True if the method has been marked as externally accessible, false if the method doesn't exist.
         */
        protected function mark_method_as_accessible(string $method_name) : bool
        {
        }
        /**
         * Register a private or protected static method of this class as externally accessible.
         *
         * @param string $method_name Method name.
         * @return bool True if the method has been marked as externally accessible, false if the method doesn't exist.
         */
        protected static function mark_static_method_as_accessible(string $method_name) : bool
        {
        }
        /**
         * Undefined/inaccessible instance method call handler.
         *
         * @param string $name Called method name.
         * @param array  $arguments Called method arguments.
         * @return mixed
         * @throws \Error The called instance method doesn't exist or is private/protected and not marked as externally accessible.
         */
        public function __call($name, $arguments)
        {
        }
        /**
         * Undefined/inaccessible static method call handler.
         *
         * @param string $name Called method name.
         * @param array  $arguments Called method arguments.
         * @return mixed
         * @throws \Error The called static method doesn't exist or is private/protected and not marked as externally accessible.
         */
        public static function __callStatic($name, $arguments)
        {
        }
    }
}
namespace {
    /**
     * WC_Admin_Notices Class.
     */
    class WC_Admin_Notices
    {
        use \Automattic\WooCommerce\Internal\Traits\AccessiblePrivateMethods;
        /**
         * Stores notices.
         *
         * @var array
         */
        private static $notices = array();
        /**
         * Array of notices - name => callback.
         *
         * @var array
         */
        private static $core_notices = array('update' => 'update_notice', 'template_files' => 'template_file_check_notice', 'legacy_shipping' => 'legacy_shipping_notice', 'no_shipping_methods' => 'no_shipping_methods_notice', 'regenerating_thumbnails' => 'regenerating_thumbnails_notice', 'regenerating_lookup_table' => 'regenerating_lookup_table_notice', 'no_secure_connection' => 'secure_connection_notice', 'maxmind_license_key' => 'maxmind_missing_license_key_notice', 'redirect_download_method' => 'redirect_download_method_notice', 'uploads_directory_is_unprotected' => 'uploads_directory_is_unprotected_notice', 'base_tables_missing' => 'base_tables_missing_notice', 'download_directories_sync_complete' => 'download_directories_sync_complete');
        /**
         * Constructor.
         */
        public static function init()
        {
        }
        /**
         * Parses query to create nonces when available.
         *
         * @deprecated 5.4.0
         * @param object $response The WP_REST_Response we're working with.
         * @return object $response The prepared WP_REST_Response object.
         */
        public static function prepare_note_with_nonce($response)
        {
        }
        /**
         * Store notices to DB
         */
        public static function store_notices()
        {
        }
        /**
         * Get notices
         *
         * @return array
         */
        public static function get_notices()
        {
        }
        /**
         * Remove all notices.
         */
        public static function remove_all_notices()
        {
        }
        /**
         * Reset notices for themes when switched or a new version of WC is installed.
         */
        public static function reset_admin_notices()
        {
        }
        // phpcs:disable Generic.Commenting.Todo.TaskFound
        /**
         * Add an admin notice about the removal of the Legacy REST API if the said API is enabled,
         * and a notice about soon to be unsupported webhooks with Legacy API payload if at least one of these exist.
         *
         * TODO: Change this method in WooCommerce 9.0 so that it checks if the Legacy REST API extension is installed, and if not, it points to the extension URL in the WordPress plugins directory.
         */
        private static function maybe_add_legacy_api_removal_notice()
        {
        }
        /**
         * Remove the admin notice about the removal of the Legacy REST API if the said API is disabled
         * or if the Legacy REST API extension is installed, and remove the notice about Legacy webhooks
         * if no such webhooks exist anymore or if the Legacy REST API extension is installed.
         *
         * TODO: Change this method in WooCommerce 9.0 so that the notice gets removed if the Legacy REST API extension is installed and active.
         */
        private static function maybe_remove_legacy_api_removal_notice()
        {
        }
        // phpcs:enable Generic.Commenting.Todo.TaskFound
        /**
         * Show a notice.
         *
         * @param string $name Notice name.
         * @param bool   $force_save Force saving inside this method instead of at the 'shutdown'.
         */
        public static function add_notice($name, $force_save = \false)
        {
        }
        /**
         * Remove a notice from being displayed.
         *
         * @param string $name Notice name.
         * @param bool   $force_save Force saving inside this method instead of at the 'shutdown'.
         */
        public static function remove_notice($name, $force_save = \false)
        {
        }
        /**
         * See if a notice is being shown.
         *
         * @param string $name Notice name.
         *
         * @return boolean
         */
        public static function has_notice($name)
        {
        }
        /**
         * Hide a notice if the GET variable is set.
         */
        public static function hide_notices()
        {
        }
        /**
         * Hide a single notice.
         *
         * @param string $name Notice name.
         */
        private static function hide_notice($name)
        {
        }
        /**
         * Check if a given user has dismissed a given admin notice.
         *
         * @since 8.5.0
         *
         * @param string   $name The name of the admin notice to check.
         * @param int|null $user_id User id, or null for the current user.
         * @return bool True if the user has dismissed the notice.
         */
        public static function user_has_dismissed_notice(string $name, ?int $user_id = \null) : bool
        {
        }
        /**
         * Add notices + styles if needed.
         */
        public static function add_notices()
        {
        }
        /**
         * Add a custom notice.
         *
         * @param string $name        Notice name.
         * @param string $notice_html Notice HTML.
         */
        public static function add_custom_notice($name, $notice_html)
        {
        }
        /**
         * Output any stored custom notices.
         */
        public static function output_custom_notices()
        {
        }
        /**
         * If we need to update the database, include a message with the DB update button.
         */
        public static function update_notice()
        {
        }
        /**
         * If we have just installed, show a message with the install pages button.
         *
         * @deprecated 4.6.0
         */
        public static function install_notice()
        {
        }
        /**
         * Show a notice highlighting bad template files.
         */
        public static function template_file_check_notice()
        {
        }
        /**
         * Show a notice asking users to convert to shipping zones.
         *
         * @todo remove in 4.0.0
         */
        public static function legacy_shipping_notice()
        {
        }
        /**
         * No shipping methods.
         */
        public static function no_shipping_methods_notice()
        {
        }
        /**
         * Notice shown when regenerating thumbnails background process is running.
         */
        public static function regenerating_thumbnails_notice()
        {
        }
        /**
         * Notice about secure connection.
         */
        public static function secure_connection_notice()
        {
        }
        /**
         * Notice shown when regenerating thumbnails background process is running.
         *
         * @since 3.6.0
         */
        public static function regenerating_lookup_table_notice()
        {
        }
        /**
         * Add notice about minimum PHP and WordPress requirement.
         *
         * @since 3.6.5
         */
        public static function add_min_version_notice()
        {
        }
        /**
         * Notice about WordPress and PHP minimum requirements.
         *
         * @deprecated 8.2.0 WordPress and PHP minimum requirements notices are no longer shown.
         *
         * @since 3.6.5
         * @return void
         */
        public static function wp_php_min_requirements_notice()
        {
        }
        /**
         * Add MaxMind missing license key notice.
         *
         * @since 3.9.0
         */
        public static function add_maxmind_missing_license_key_notice()
        {
        }
        /**
         *  Add notice about Redirect-only download method, nudging user to switch to a different method instead.
         */
        public static function add_redirect_download_method_notice()
        {
        }
        /**
         * Notice about the completion of the product downloads sync, with further advice for the site operator.
         */
        public static function download_directories_sync_complete()
        {
        }
        /**
         * Display MaxMind missing license key notice.
         *
         * @since 3.9.0
         */
        public static function maxmind_missing_license_key_notice()
        {
        }
        /**
         * Notice about Redirect-Only download method.
         *
         * @since 4.0
         */
        public static function redirect_download_method_notice()
        {
        }
        /**
         * Notice about uploads directory begin unprotected.
         *
         * @since 4.2.0
         */
        public static function uploads_directory_is_unprotected_notice()
        {
        }
        /**
         * Notice about base tables missing.
         */
        public static function base_tables_missing_notice()
        {
        }
        /**
         * Determine if the store is running SSL.
         *
         * @return bool Flag SSL enabled.
         * @since  3.5.1
         */
        protected static function is_ssl()
        {
        }
        /**
         * Wrapper for is_plugin_active.
         *
         * @param string $plugin Plugin to check.
         * @return boolean
         */
        protected static function is_plugin_active($plugin)
        {
        }
        /**
         * Simplify Commerce is no longer in core.
         *
         * @deprecated 3.6.0 No longer shown.
         */
        public static function simplify_commerce_notice()
        {
        }
        /**
         * Show the Theme Check notice.
         *
         * @deprecated 3.3.0 No longer shown.
         */
        public static function theme_check_notice()
        {
        }
        /**
         * Check if uploads directory is protected.
         *
         * @since 4.2.0
         * @return bool
         */
        protected static function is_uploads_directory_protected()
        {
        }
    }
    /**
     * WC_Admin_Permalink_Settings Class.
     */
    class WC_Admin_Permalink_Settings
    {
        /**
         * Permalink settings.
         *
         * @var array
         */
        private $permalinks = array();
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Init our settings.
         */
        public function settings_init()
        {
        }
        /**
         * Show a slug input box.
         */
        public function product_category_slug_input()
        {
        }
        /**
         * Show a slug input box.
         */
        public function product_tag_slug_input()
        {
        }
        /**
         * Show a slug input box.
         */
        public function product_attribute_slug_input()
        {
        }
        /**
         * Show the settings.
         */
        public function settings()
        {
        }
        /**
         * Save the settings.
         */
        public function settings_save()
        {
        }
    }
    /**
     * WC_Admin_Pointers Class.
     */
    class WC_Admin_Pointers
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Setup pointers for screen.
         */
        public function setup_pointers_for_screen()
        {
        }
        /**
         * Pointers for creating a product.
         */
        public function create_product_tutorial()
        {
        }
        /**
         * Pointers for creating a variable product.
         */
        public function create_variable_product_tutorial()
        {
        }
        /**
         * Pointers for accessing In-App Marketplace.
         */
        public function create_wc_addons_tutorial()
        {
        }
    }
    /**
     * WC_Admin_Post_Types Class.
     *
     * Handles the edit posts views and some functionality on the edit post screen for WC post types.
     */
    class WC_Admin_Post_Types
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Looks at the current screen and loads the correct list table handler.
         *
         * @since 3.3.0
         */
        public function setup_screen()
        {
        }
        /**
         * Change messages when a post type is updated.
         *
         * @param  array $messages Array of messages.
         * @return array
         */
        public function post_updated_messages($messages)
        {
        }
        /**
         * Add messages when an order is updated.
         *
         * @param array $messages Array of messages.
         *
         * @return array
         */
        public function order_updated_messages(array $messages)
        {
        }
        /**
         * Specify custom bulk actions messages for different post types.
         *
         * @param  array $bulk_messages Array of messages.
         * @param  array $bulk_counts Array of how many objects were updated.
         * @return array
         */
        public function bulk_post_updated_messages($bulk_messages, $bulk_counts)
        {
        }
        /**
         * Custom bulk edit - form.
         *
         * @param string $column_name Column being shown.
         * @param string $post_type Post type being shown.
         */
        public function bulk_edit($column_name, $post_type)
        {
        }
        /**
         * Custom quick edit - form.
         *
         * @param string $column_name Column being shown.
         * @param string $post_type Post type being shown.
         */
        public function quick_edit($column_name, $post_type)
        {
        }
        /**
         * Offers a way to hook into save post without causing an infinite loop
         * when quick/bulk saving product info.
         *
         * @since 3.0.0
         * @param int    $post_id Post ID being saved.
         * @param object $post Post object being saved.
         */
        public function bulk_and_quick_edit_hook($post_id, $post)
        {
        }
        /**
         * Quick and bulk edit saving.
         *
         * @param int    $post_id Post ID being saved.
         * @param object $post Post object being saved.
         * @return int
         */
        public function bulk_and_quick_edit_save_post($post_id, $post)
        {
        }
        /**
         * Quick edit.
         *
         * @param int        $post_id Post ID being saved.
         * @param WC_Product $product Product object.
         */
        private function quick_edit_save($post_id, $product)
        {
        }
        /**
         * Bulk edit.
         *
         * @param int        $post_id Post ID being saved.
         * @param WC_Product $product Product object.
         */
        public function bulk_edit_save($post_id, $product)
        {
        }
        /**
         * Disable the auto-save functionality for Orders.
         */
        public function disable_autosave()
        {
        }
        /**
         * Output extra data on post forms.
         *
         * @param WP_Post $post Current post object.
         */
        public function edit_form_top($post)
        {
        }
        /**
         * Change title boxes in admin.
         *
         * @param string  $text Text to shown.
         * @param WP_Post $post Current post object.
         * @return string
         */
        public function enter_title_here($text, $post)
        {
        }
        /**
         * Print coupon description textarea field.
         *
         * @param WP_Post $post Current post object.
         */
        public function edit_form_after_title($post)
        {
        }
        /**
         * Hidden default Meta-Boxes.
         *
         * @param  array  $hidden Hidden boxes.
         * @param  object $screen Current screen.
         * @return array
         */
        public function hidden_meta_boxes($hidden, $screen)
        {
        }
        /**
         * Output product visibility options.
         */
        public function product_data_visibility()
        {
        }
        /**
         * Grant downloadable file access to any newly added files on any existing.
         * orders for this product that have previously been granted downloadable file access.
         *
         * @param int   $product_id product identifier.
         * @param int   $variation_id optional product variation identifier.
         * @param array $downloadable_files newly set files.
         * @deprecated 3.3.0 and moved to post-data class.
         */
        public function process_product_file_download_paths($product_id, $variation_id, $downloadable_files)
        {
        }
        /**
         * When editing the shop page, we should hide templates.
         *
         * @param array   $page_templates Templates array.
         * @param string  $theme Classname.
         * @param WP_Post $post The current post object.
         * @return array
         */
        public function hide_cpt_archive_templates($page_templates, $theme, $post)
        {
        }
        /**
         * Show a notice above the CPT archive.
         *
         * @param WP_Post $post The current post object.
         */
        public function show_cpt_archive_notice($post)
        {
        }
        /**
         * Add a post display state for special WC pages in the page list table.
         *
         * @param array   $post_states An array of post display states.
         * @param WP_Post $post        The current post object.
         */
        public function add_display_post_states($post_states, $post)
        {
        }
        /**
         * Apply product type constraints to stock status.
         *
         * @param WC_Product  $product The product whose stock status will be adjusted.
         * @param string|null $stock_status The stock status to use for adjustment, or null if no new stock status has been supplied in the request.
         * @return WC_Product The supplied product, or the synced product if it was a variable product.
         */
        private function maybe_update_stock_status($product, $stock_status)
        {
        }
        /**
         * Set the new regular or sale price if requested.
         *
         * @param WC_Product $product The product to set the new price for.
         * @param string     $price_type 'regular' or 'sale'.
         * @return bool true if a new price has been set, false otherwise.
         */
        private function set_new_price($product, $price_type)
        {
        }
        /**
         * Get the current request data ($_REQUEST superglobal).
         * This method is added to ease unit testing.
         *
         * @return array The $_REQUEST superglobal.
         */
        protected function request_data()
        {
        }
    }
    /**
     * WC_Admin_Profile Class.
     */
    class WC_Admin_Profile
    {
        /**
         * Hook in tabs.
         */
        public function __construct()
        {
        }
        /**
         * Get Address Fields for the edit user pages.
         *
         * @return array Fields to display which are filtered through woocommerce_customer_meta_fields before being returned
         */
        public function get_customer_meta_fields()
        {
        }
        /**
         * Show Address Fields on edit user pages.
         *
         * @param WP_User $user
         */
        public function add_customer_meta_fields($user)
        {
        }
        /**
         * Save Address Fields on edit user pages.
         *
         * @param int $user_id User ID of the user being saved
         */
        public function save_customer_meta_fields($user_id)
        {
        }
        /**
         * Get user meta for a given key, with fallbacks to core user info for pre-existing fields.
         *
         * @since 3.1.0
         * @param int    $user_id User ID of the user being edited
         * @param string $key     Key for user meta field
         * @return string
         */
        protected function get_user_meta($user_id, $key)
        {
        }
    }
    /**
     * WC_Admin_Reports Class.
     */
    class WC_Admin_Reports
    {
        /**
         * Handles output of the reports page in admin.
         */
        public static function output()
        {
        }
        /**
         * Returns the definitions for the reports to show in admin.
         *
         * @return array
         */
        public static function get_reports()
        {
        }
        /**
         * Get a report from our reports subfolder.
         *
         * @param string $name
         */
        public static function get_report($name)
        {
        }
    }
    /**
     * WC_Admin_Settings Class.
     */
    class WC_Admin_Settings
    {
        /**
         * Setting pages.
         *
         * @var array
         */
        private static $settings = array();
        /**
         * Error messages.
         *
         * @var array
         */
        private static $errors = array();
        /**
         * Update messages.
         *
         * @var array
         */
        private static $messages = array();
        /**
         * Include the settings page classes.
         */
        public static function get_settings_pages()
        {
        }
        /**
         * Save the settings.
         */
        public static function save()
        {
        }
        /**
         * Add a message.
         *
         * @param string $text Message.
         */
        public static function add_message($text)
        {
        }
        /**
         * Add an error.
         *
         * @param string $text Message.
         */
        public static function add_error($text)
        {
        }
        /**
         * Output messages + errors.
         */
        public static function show_messages()
        {
        }
        /**
         * Settings page.
         *
         * Handles the display of the main woocommerce settings page in admin.
         */
        public static function output()
        {
        }
        /**
         * Get a setting from the settings API.
         *
         * @param string $option_name Option name.
         * @param mixed  $default     Default value.
         * @return mixed
         */
        public static function get_option($option_name, $default = '')
        {
        }
        /**
         * Output admin fields.
         *
         * Loops through the woocommerce options array and outputs each field.
         *
         * @param array[] $options Opens array to output.
         */
        public static function output_fields($options)
        {
        }
        /**
         * Helper function to get the formatted description and tip HTML for a
         * given form field. Plugins can call this when implementing their own custom
         * settings types.
         *
         * @param  array $value The form field value array.
         * @return array The description and tip as a 2 element array.
         */
        public static function get_field_description($value)
        {
        }
        /**
         * Save admin fields.
         *
         * Loops through the woocommerce options array and outputs each field.
         *
         * @param array $options Options array to output.
         * @param array $data    Optional. Data to use for saving. Defaults to $_POST.
         * @return bool
         */
        public static function save_fields($options, $data = \null)
        {
        }
        /**
         * Checks which method we're using to serve downloads.
         *
         * If using force or x-sendfile, this ensures the .htaccess is in place.
         */
        public static function check_download_folder_protection()
        {
        }
    }
    /**
     * WC_Admin_Setup_Wizard class.
     */
    class WC_Admin_Setup_Wizard
    {
        /**
         * Current step
         *
         * @var string
         */
        private $step = '';
        /**
         * Steps for the setup wizard
         *
         * @var array
         */
        private $steps = array();
        /**
         * Actions to be executed after the HTTP response has completed
         *
         * @var array
         */
        private $deferred_actions = array();
        /**
         * Tweets user can optionally send after install
         *
         * @var array
         */
        private $tweets = array('Someone give me woo-t, I just set up a new store with #WordPress and @WooCommerce!', 'Someone give me high five, I just set up a new store with #WordPress and @WooCommerce!');
        /**
         * The version of WordPress required to run the WooCommerce Admin plugin
         *
         * @var string
         */
        private $wc_admin_plugin_minimum_wordpress_version = '5.3';
        /**
         * Hook in tabs.
         *
         * @deprecated 4.6.0
         */
        public function __construct()
        {
        }
        /**
         * Add admin menus/screens.
         *
         * @deprecated 4.6.0
         */
        public function admin_menus()
        {
        }
        /**
         * The theme "extra" should only be shown if the current user can modify themes
         * and the store doesn't already have a WooCommerce theme.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_theme()
        {
        }
        /**
         * The "automated tax" extra should only be shown if the current user can
         * install plugins and the store is in a supported country.
         *
         * @deprecated 4.6.0
         */
        protected function should_show_automated_tax()
        {
        }
        /**
         * Should we show the MailChimp install option?
         * True only if the user can install plugins.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_mailchimp()
        {
        }
        /**
         * Should we show the Facebook install option?
         * True only if the user can install plugins,
         * and up until the end date of the recommendation.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_facebook()
        {
        }
        /**
         * Is the WooCommerce Admin actively included in the WooCommerce core?
         * Based on presence of a basic WC Admin function.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function is_wc_admin_active()
        {
        }
        /**
         * Should we show the WooCommerce Admin install option?
         * True only if the user can install plugins,
         * and is running the correct version of WordPress.
         *
         * @see WC_Admin_Setup_Wizard::$wc_admin_plugin_minimum_wordpress_version
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_wc_admin()
        {
        }
        /**
         * Should we show the new WooCommerce Admin onboarding experience?
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_wc_admin_onboarding()
        {
        }
        /**
         * Should we display the 'Recommended' step?
         * True if at least one of the recommendations will be displayed.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        protected function should_show_recommended_step()
        {
        }
        /**
         * Register/enqueue scripts and styles for the Setup Wizard.
         *
         * Hooked onto 'admin_enqueue_scripts'.
         *
         * @deprecated 4.6.0
         */
        public function enqueue_scripts()
        {
        }
        /**
         * Show the setup wizard.
         *
         * @deprecated 4.6.0
         */
        public function setup_wizard()
        {
        }
        /**
         * Get the URL for the next step's screen.
         *
         * @param string $step  slug (default: current step).
         * @return string       URL for next step if a next step exists.
         *                      Admin URL if it's the last step.
         *                      Empty string on failure.
         *
         * @deprecated 4.6.0
         * @since 3.0.0
         */
        public function get_next_step_link($step = '')
        {
        }
        /**
         * Setup Wizard Header.
         *
         * @deprecated 4.6.0
         */
        public function setup_wizard_header()
        {
        }
        /**
         * Setup Wizard Footer.
         *
         * @deprecated 4.6.0
         */
        public function setup_wizard_footer()
        {
        }
        /**
         * Output the steps.
         *
         * @deprecated 4.6.0
         */
        public function setup_wizard_steps()
        {
        }
        /**
         * Output the content for the current step.
         *
         * @deprecated 4.6.0
         */
        public function setup_wizard_content()
        {
        }
        /**
         * Display's a prompt for users to try out the new improved WooCommerce onboarding experience in WooCommerce Admin.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_new_onboarding()
        {
        }
        /**
         * Installs WooCommerce admin and redirects to the new onboarding experience.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_new_onboarding_save()
        {
        }
        /**
         * Initial "store setup" step.
         * Location, product type, page setup, and tracking opt-in.
         */
        public function wc_setup_store_setup()
        {
        }
        /**
         * Template for the usage tracking modal.
         *
         * @deprecated 4.6.0
         */
        public function tracking_modal()
        {
        }
        /**
         * Save initial store settings.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_store_setup_save()
        {
        }
        /**
         * Finishes replying to the client, but keeps the process running for further (async) code execution.
         *
         * @see https://core.trac.wordpress.org/ticket/41358 .
         */
        protected function close_http_connection()
        {
        }
        /**
         * Function called after the HTTP request is finished, so it's executed without the client having to wait for it.
         *
         * @see WC_Admin_Setup_Wizard::install_plugin
         * @see WC_Admin_Setup_Wizard::install_theme
         *
         * @deprecated 4.6.0
         */
        public function run_deferred_actions()
        {
        }
        /**
         * Helper method to queue the background install of a plugin.
         *
         * @param string $plugin_id  Plugin id used for background install.
         * @param array  $plugin_info Plugin info array containing name and repo-slug, and optionally file if different from [repo-slug].php.
         *
         * @deprecated 4.6.0
         */
        protected function install_plugin($plugin_id, $plugin_info)
        {
        }
        /**
         * Helper method to queue the background install of a theme.
         *
         * @param string $theme_id  Theme id used for background install.
         *
         * @deprecated 4.6.0
         */
        protected function install_theme($theme_id)
        {
        }
        /**
         * Helper method to install Jetpack.
         *
         * @deprecated 4.6.0
         */
        protected function install_jetpack()
        {
        }
        /**
         * Helper method to install WooCommerce Services and its Jetpack dependency.
         *
         * @deprecated 4.6.0
         */
        protected function install_woocommerce_services()
        {
        }
        /**
         * Retrieve info for missing WooCommerce Services and/or Jetpack plugin.
         *
         * @deprecated 4.6.0
         * @return array
         */
        protected function get_wcs_requisite_plugins()
        {
        }
        /**
         * Plugin install info message markup with heading.
         *
         * @deprecated 4.6.0
         */
        public function plugin_install_info()
        {
        }
        /**
         * Get shipping methods based on country code.
         *
         * @param string $country_code Country code.
         * @param string $currency_code Currency code.
         *
         * @deprecated 4.6.0
         * @return array
         */
        protected function get_wizard_shipping_methods($country_code, $currency_code)
        {
        }
        /**
         * Render the available shipping methods for a given country code.
         *
         * @param string $country_code Country code.
         * @param string $currency_code Currency code.
         * @param string $input_prefix Input prefix.
         *
         * @deprecated 4.6.0
         */
        protected function shipping_method_selection_form($country_code, $currency_code, $input_prefix)
        {
        }
        /**
         * Render a product weight unit dropdown.
         *
         * @deprecated 4.6.0
         * @return string
         */
        protected function get_product_weight_selection()
        {
        }
        /**
         * Render a product dimension unit dropdown.
         *
         * @deprecated 4.6.0
         * @return string
         */
        protected function get_product_dimension_selection()
        {
        }
        /**
         * Shipping.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_shipping()
        {
        }
        /**
         * Save shipping options.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_shipping_save()
        {
        }
        /**
         * Is Stripe country supported
         * https://stripe.com/global .
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_stripe_supported_country($country_code)
        {
        }
        /**
         * Is PayPal currency supported.
         *
         * @param string $currency Currency code.
         * @return boolean
         *
         * @deprecated 4.6.0
         */
        protected function is_paypal_supported_currency($currency)
        {
        }
        /**
         * Is Klarna Checkout country supported.
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_klarna_checkout_supported_country($country_code)
        {
        }
        /**
         * Is Klarna Payments country supported.
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_klarna_payments_supported_country($country_code)
        {
        }
        /**
         * Is Square country supported
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_square_supported_country($country_code)
        {
        }
        /**
         * Is eWAY Payments country supported
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_eway_payments_supported_country($country_code)
        {
        }
        /**
         * Is ShipStation country supported
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_shipstation_supported_country($country_code)
        {
        }
        /**
         * Is WooCommerce Services shipping label country supported
         *
         * @param string $country_code Country code.
         *
         * @deprecated 4.6.0
         */
        protected function is_wcs_shipping_labels_supported_country($country_code)
        {
        }
        /**
         * Helper method to retrieve the current user's email address.
         *
         * @deprecated 4.6.0
         * @return string Email address
         */
        protected function get_current_user_email()
        {
        }
        /**
         * Array of all possible "in cart" gateways that can be offered.
         *
         * @deprecated 4.6.0
         * @return array
         */
        protected function get_wizard_available_in_cart_payment_gateways()
        {
        }
        /**
         * Simple array of "in cart" gateways to show in wizard.
         *
         * @deprecated 4.6.0
         * @return array
         */
        public function get_wizard_in_cart_payment_gateways()
        {
        }
        /**
         * Simple array of "manual" gateways to show in wizard.
         *
         * @deprecated 4.6.0
         * @return array
         */
        public function get_wizard_manual_payment_gateways()
        {
        }
        /**
         * Display service item in list.
         *
         * @param int   $item_id Item ID.
         * @param array $item_info Item info array.
         *
         * @deprecated 4.6.0
         */
        public function display_service_item($item_id, $item_info)
        {
        }
        /**
         * Is it a featured service?
         *
         * @param array $service Service info array.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        public function is_featured_service($service)
        {
        }
        /**
         * Is this a non featured service?
         *
         * @param array $service Service info array.
         *
         * @deprecated 4.6.0
         * @return boolean
         */
        public function is_not_featured_service($service)
        {
        }
        /**
         * Payment Step.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_payment()
        {
        }
        /**
         * Payment Step save.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_payment_save()
        {
        }
        protected function display_recommended_item($item_info)
        {
        }
        /**
         * Recommended step
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_recommended()
        {
        }
        /**
         * Recommended step save.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_recommended_save()
        {
        }
        /**
         * Go to the next step if Jetpack was connected.
         */
        protected function wc_setup_activate_actions()
        {
        }
        /**
         *
         * @deprecated 4.6.0
         */
        protected function wc_setup_activate_get_feature_list()
        {
        }
        /**
         *
         * @deprecated 4.6.0
         */
        protected function wc_setup_activate_get_feature_list_str()
        {
        }
        /**
         * Activate step.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_activate()
        {
        }
        /**
         *
         * @deprecated 4.6.0
         */
        protected function get_all_activate_errors()
        {
        }
        /**
         *
         * @deprecated 4.6.0
         */
        protected function get_activate_error_message($code = '')
        {
        }
        /**
         * Activate step save.
         *
         * Install, activate, and launch connection flow for Jetpack.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_activate_save()
        {
        }
        /**
         * Final step.
         *
         * @deprecated 4.6.0
         */
        public function wc_setup_ready()
        {
        }
    }
    /**
     * WC_Admin_Status Class.
     */
    class WC_Admin_Status
    {
        /**
         * An instance of the DB log handler list table.
         *
         * @var WC_Admin_Log_Table_List
         */
        private static $db_log_list_table;
        /**
         * Handles output of the reports page in admin.
         */
        public static function output()
        {
        }
        /**
         * Handles output of report.
         */
        public static function status_report()
        {
        }
        /**
         * Handles output of tools.
         */
        public static function status_tools()
        {
        }
        /**
         * Get tools.
         *
         * @return array of tools
         */
        public static function get_tools()
        {
        }
        /**
         * Show the logs page.
         */
        public static function status_logs()
        {
        }
        /**
         * Show the log page contents for file log handler.
         */
        public static function status_logs_file()
        {
        }
        /**
         * Show the log page contents for db log handler.
         */
        public static function status_logs_db()
        {
        }
        /**
         * Retrieve metadata from a file. Based on WP Core's get_file_data function.
         *
         * @since  2.1.1
         * @param  string $file Path to the file.
         * @return string
         */
        public static function get_file_version($file)
        {
        }
        /**
         * Return the log file handle.
         *
         * @param string $filename Filename to get the handle for.
         * @return string
         */
        public static function get_log_file_handle($filename)
        {
        }
        /**
         * Scan the template files.
         *
         * @param  string $template_path Path to the template directory.
         * @return array
         */
        public static function scan_template_files($template_path)
        {
        }
        /**
         * Scan the log files.
         *
         * @return array
         */
        public static function scan_log_files()
        {
        }
        /**
         * Get latest version of a theme by slug.
         *
         * @param  object $theme WP_Theme object.
         * @return string Version number if found.
         */
        public static function get_latest_theme_version($theme)
        {
        }
        /**
         * Remove/delete the chosen file.
         */
        public static function remove_log()
        {
        }
        /**
         * Return a stored instance of the DB log list table class.
         *
         * @return WC_Admin_Log_Table_List
         */
        public static function get_db_log_list_table()
        {
        }
        /**
         * Clear DB log table.
         *
         * @since 3.0.0
         */
        private static function flush_db_logs()
        {
        }
        /**
         * Bulk DB log table actions.
         *
         * @since 3.0.0
         */
        private static function log_table_bulk_actions()
        {
        }
        /**
         * Prints table info if a base table is not present.
         */
        private static function output_tables_info()
        {
        }
        /**
         * Prints the information about plugins for the system status report.
         * Used for both active and inactive plugins sections.
         *
         * @param array $plugins List of plugins to display.
         * @param array $untested_plugins List of plugins that haven't been tested with the current WooCommerce version.
         * @return void
         */
        private static function output_plugins_info($plugins, $untested_plugins)
        {
        }
    }
    /**
     * WC_Admin_Taxonomies class.
     */
    class WC_Admin_Taxonomies
    {
        /**
         * Class instance.
         *
         * @var WC_Admin_Taxonomies instance
         */
        protected static $instance = \false;
        /**
         * Default category ID.
         *
         * @var int
         */
        private $default_cat_id = 0;
        /**
         * Get class instance
         */
        public static function get_instance()
        {
        }
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Order term when created (put in position 0).
         *
         * @param mixed  $term_id Term ID.
         * @param mixed  $tt_id Term taxonomy ID.
         * @param string $taxonomy Taxonomy slug.
         */
        public function create_term($term_id, $tt_id = '', $taxonomy = '')
        {
        }
        /**
         * When a term is deleted, delete its meta.
         *
         * @deprecated 3.6.0 No longer needed.
         * @param mixed $term_id Term ID.
         */
        public function delete_term($term_id)
        {
        }
        /**
         * Category thumbnail fields.
         */
        public function add_category_fields()
        {
        }
        /**
         * Edit category thumbnail field.
         *
         * @param mixed $term Term (category) being edited.
         */
        public function edit_category_fields($term)
        {
        }
        /**
         * Save category fields
         *
         * @param mixed  $term_id Term ID being saved.
         * @param mixed  $tt_id Term taxonomy ID.
         * @param string $taxonomy Taxonomy slug.
         */
        public function save_category_fields($term_id, $tt_id = '', $taxonomy = '')
        {
        }
        /**
         * Description for product_cat page to aid users.
         */
        public function product_cat_description()
        {
        }
        /**
         * Add some notes to describe the behavior of the default category.
         */
        public function product_cat_notes()
        {
        }
        /**
         * Description for shipping class page to aid users.
         */
        public function product_attribute_description()
        {
        }
        /**
         * Thumbnail column added to category admin.
         *
         * @param mixed $columns Columns array.
         * @return array
         */
        public function product_cat_columns($columns)
        {
        }
        /**
         * Adjust row actions.
         *
         * @param array  $actions Array of actions.
         * @param object $term Term object.
         * @return array
         */
        public function product_cat_row_actions($actions, $term)
        {
        }
        /**
         * Handle custom row actions.
         */
        public function handle_product_cat_row_actions()
        {
        }
        /**
         * Thumbnail column value added to category admin.
         *
         * @param string $columns Column HTML output.
         * @param string $column Column name.
         * @param int    $id Product ID.
         *
         * @return string
         */
        public function product_cat_column($columns, $column, $id)
        {
        }
        /**
         * Maintain term hierarchy when editing a product.
         *
         * @param  array $args Term checklist args.
         * @return array
         */
        public function disable_checked_ontop($args)
        {
        }
        /**
         * Admin footer scripts for the product categories admin screen
         *
         * @return void
         */
        public function scripts_at_product_cat_screen_footer()
        {
        }
    }
    /**
     * WC_Admin_Upload_Downloadable_Product Class.
     */
    class WC_Admin_Upload_Downloadable_Product
    {
        /**
         * Add hooks.
         */
        public function __construct()
        {
        }
        /**
         * Change upload dir for downloadable files.
         *
         * @param array $pathdata Array of paths.
         * @return array
         */
        public function upload_dir($pathdata)
        {
        }
        /**
         * Change filename for WooCommerce uploads and prepend unique chars for security.
         *
         * @param string $full_filename Original filename.
         * @param string $ext           Extension of file.
         * @param string $dir           Directory path.
         *
         * @return string New filename with unique hash.
         * @since 4.0
         */
        public function update_filename($full_filename, $ext, $dir)
        {
        }
        /**
         * Change filename to append random text.
         *
         * @param string $full_filename Original filename with extension.
         * @param string $ext           Extension.
         *
         * @return string Modified filename.
         */
        public function unique_filename($full_filename, $ext)
        {
        }
        /**
         * Run a filter when uploading a downloadable product.
         */
        public function woocommerce_media_upload_downloadable_product()
        {
        }
    }
    /**
     * Webhooks table list class.
     */
    class WC_Admin_Webhooks_Table_List extends \WP_List_Table
    {
        /**
         * Initialize the webhook table list.
         */
        public function __construct()
        {
        }
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Get list columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Column cb.
         *
         * @param  WC_Webhook $webhook Webhook instance.
         * @return string
         */
        public function column_cb($webhook)
        {
        }
        /**
         * Return title column.
         *
         * @param  WC_Webhook $webhook Webhook instance.
         * @return string
         */
        public function column_title($webhook)
        {
        }
        /**
         * Return status column.
         *
         * @param  WC_Webhook $webhook Webhook instance.
         * @return string
         */
        public function column_status($webhook)
        {
        }
        /**
         * Return topic column.
         *
         * @param  WC_Webhook $webhook Webhook instance.
         * @return string
         */
        public function column_topic($webhook)
        {
        }
        /**
         * Return delivery URL column.
         *
         * @param  WC_Webhook $webhook Webhook instance.
         * @return string
         */
        public function column_delivery_url($webhook)
        {
        }
        /**
         * Get the status label for webhooks.
         *
         * @param string $status_name Status name.
         * @param int    $amount      Amount of webhooks.
         * @return array
         */
        private function get_status_label($status_name, $amount)
        {
        }
        /**
         * Table list views.
         *
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * Get bulk actions.
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Process bulk actions.
         */
        public function process_bulk_action()
        {
        }
        /**
         * Generate the table navigation above or below the table.
         * Included to remove extra nonce input.
         *
         * @param string $which The location of the extra table nav markup: 'top' or 'bottom'.
         */
        protected function display_tablenav($which)
        {
        }
        /**
         * Search box.
         *
         * @param  string $text     Button text.
         * @param  string $input_id Input ID.
         */
        public function search_box($text, $input_id)
        {
        }
        /**
         * Prepare table list items.
         */
        public function prepare_items()
        {
        }
    }
    /**
     * WC_Admin_Webhooks.
     */
    class WC_Admin_Webhooks
    {
        /**
         * Initialize the webhooks admin actions.
         */
        public function __construct()
        {
        }
        /**
         * Check if should allow save settings.
         * This prevents "Your settings have been saved." notices on the table list.
         *
         * @param  bool $allow If allow save settings.
         * @return bool
         */
        public function allow_save_settings($allow)
        {
        }
        /**
         * Check if is webhook settings page.
         *
         * @return bool
         */
        private function is_webhook_settings_page()
        {
        }
        /**
         * Save method.
         */
        private function save()
        {
        }
        /**
         * Bulk delete.
         *
         * @param array $webhooks List of webhooks IDs.
         */
        public static function bulk_delete($webhooks)
        {
        }
        /**
         * Delete webhook.
         */
        private function delete()
        {
        }
        /**
         * Webhooks admin actions.
         */
        public function actions()
        {
        }
        /**
         * Page output.
         */
        public static function page_output()
        {
        }
        /**
         * Notices.
         */
        public static function notices()
        {
        }
        /**
         * Add screen option.
         */
        public function screen_option()
        {
        }
        /**
         * Table list output.
         */
        private static function table_list_output()
        {
        }
        /**
         * Logs output.
         *
         * @deprecated 3.3.0
         * @param WC_Webhook $webhook Deprecated.
         */
        public static function logs_output($webhook = 'deprecated')
        {
        }
        /**
         * Get the webhook topic data.
         *
         * @param WC_Webhook $webhook Webhook instance.
         *
         * @return array
         */
        public static function get_topic_data($webhook)
        {
        }
        /**
         * Get the logs navigation.
         *
         * @deprecated 3.3.0
         * @param int        $total Deprecated.
         * @param WC_Webhook $webhook Deprecated.
         */
        public static function get_logs_navigation($total, $webhook)
        {
        }
    }
    /**
     * WC_Admin class.
     */
    class WC_Admin
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Output buffering allows admin screens to make redirects later on.
         */
        public function buffer()
        {
        }
        /**
         * Include any classes we need within admin.
         */
        public function includes()
        {
        }
        /**
         * Include admin files conditionally.
         */
        public function conditional_includes()
        {
        }
        /**
         * Handle redirects to setup/welcome page after install and updates.
         *
         * The user must have access rights, and we must ignore the network/bulk plugin updaters.
         */
        public function admin_redirects()
        {
        }
        /**
         * Prevent any user who cannot 'edit_posts' (subscribers, customers etc) from accessing admin.
         */
        public function prevent_admin_access()
        {
        }
        /**
         * Preview email template.
         */
        public function preview_emails()
        {
        }
        /**
         * Change the admin footer text on WooCommerce admin pages.
         *
         * @since  2.3
         * @param  string $footer_text text to be rendered in the footer.
         * @return string
         */
        public function admin_footer_text($footer_text)
        {
        }
        /**
         * Check on a Jetpack install queued by the Setup Wizard.
         *
         * See: WC_Admin_Setup_Wizard::install_jetpack()
         */
        public function setup_wizard_check_jetpack()
        {
        }
        /**
         * Disable WXR export of scheduled action posts.
         *
         * @since 3.6.2
         *
         * @param array $args Scheduled action post type registration args.
         *
         * @return array
         */
        public function disable_webhook_post_export($args)
        {
        }
        /**
         * Include admin classes.
         *
         * @since 4.2.0
         * @param string $classes Body classes string.
         * @return string
         */
        public function include_admin_body_class($classes)
        {
        }
    }
    /**
     * WC_Helper Class
     *
     * The main entry-point for all things related to the Helper.
     * The Helper manages the connection between the store and
     * an account on Woo.com.
     */
    class WC_Helper_Admin
    {
        /**
         * Loads the class, runs on init
         *
         * @return void
         */
        public static function load()
        {
        }
        /**
         * Pushes settings onto the WooCommerce Admin global settings object (wcSettings).
         *
         * @param mixed $settings The settings object we're amending.
         *
         * @return mixed $settings
         */
        public static function add_marketplace_settings($settings)
        {
        }
        /**
         * Generates the URL for connecting or disconnecting the store to/from Woo.com.
         * Approach taken from existing helper code that isn't exposed.
         *
         * @return string
         */
        public static function get_connection_url()
        {
        }
        /**
         * Registers the REST routes for the featured products endpoint.
         * This endpoint is used by the WooCommerce > Extensions > Discover
         * page.
         */
        public static function register_rest_routes()
        {
        }
        /**
         * The Extensions page can only be accessed by users with the manage_woocommerce
         * capability. So the API mimics that behavior.
         */
        public static function get_permission()
        {
        }
        /**
         * Fetch featured products from Woo.com and serve them
         * as JSON.
         */
        public static function get_featured()
        {
        }
    }
    /**
     * WC_Helper_API Class
     *
     * Provides a communication interface with the Woo.com Helper API.
     */
    class WC_Helper_API
    {
        /**
         * Base path for API routes.
         *
         * @var $api_base
         */
        public static $api_base;
        /**
         * Load
         *
         * Allow devs to point the API base to a local API development or staging server.
         * Note that sslverify will be turned off for the woocommerce.dev + WP_DEBUG combination.
         * The URL can be changed on plugins_loaded before priority 10.
         */
        public static function load()
        {
        }
        /**
         * Perform an HTTP request to the Helper API.
         *
         * @param string $endpoint The endpoint to request.
         * @param array  $args Additional data for the request. Set authenticated to a truthy value to enable auth.
         *
         * @return array|WP_Error The response from wp_safe_remote_request()
         */
        public static function request($endpoint, $args = array())
        {
        }
        /**
         * Adds authentication headers to an HTTP request.
         *
         * @param string $url The request URI.
         * @param array  $args By-ref, the args that will be passed to wp_remote_request().
         * @return bool Were the headers added?
         */
        private static function _authenticate(&$url, &$args)
        {
        }
        /**
         * Wrapper for self::request().
         *
         * @param string $endpoint The helper API endpoint to request.
         * @param array  $args Arguments passed to wp_remote_request().
         *
         * @return array The response object from wp_safe_remote_request().
         */
        public static function get($endpoint, $args = array())
        {
        }
        /**
         * Wrapper for self::request().
         *
         * @param string $endpoint The helper API endpoint to request.
         * @param array  $args Arguments passed to wp_remote_request().
         *
         * @return array The response object from wp_safe_remote_request().
         */
        public static function post($endpoint, $args = array())
        {
        }
        /**
         * Wrapper for self::request().
         *
         * @param string $endpoint The helper API endpoint to request.
         * @param array  $args Arguments passed to wp_remote_request().
         *
         * @return array The response object from wp_safe_remote_request().
         */
        public static function put($endpoint, $args = array())
        {
        }
        /**
         * Using the API base, form a request URL from a given endpoint.
         *
         * @param string $endpoint The endpoint to request.
         * @param string $query_string Optional query string to append to the URL.
         *
         * @return string The absolute endpoint URL.
         */
        public static function url($endpoint, $query_string = '')
        {
        }
    }
    /**
     * WC_Helper_Compat Class
     *
     * Some level of compatibility with the legacy WooCommerce Helper plugin.
     */
    class WC_Helper_Compat
    {
        /**
         * Loads the class, runs on init.
         */
        public static function load()
        {
        }
        /**
         * Runs during woocommerce_helper_loaded
         */
        public static function helper_loaded()
        {
        }
        /**
         * Remove legacy helper actions (notices, menus, etc.)
         */
        public static function remove_actions()
        {
        }
        /**
         * Attempt to migrate a legacy connection to a new one.
         */
        public static function migrate_connection()
        {
        }
        /**
         * Attempt to deactivate the legacy helper plugin.
         */
        public static function deactivate_plugin()
        {
        }
        /**
         * Display admin notice directing the user where to go.
         */
        public static function plugin_deactivation_notice()
        {
        }
        /**
         * Register menu item.
         */
        public static function admin_menu()
        {
        }
        /**
         * Render the legacy helper compat view.
         */
        public static function render_compat_menu()
        {
        }
    }
    /**
     * WC_Helper_Options Class
     *
     * An interface to the woocommerce_helper_data entry in the wp_options table.
     */
    class WC_Helper_Options
    {
        /**
         * The option name used to store the helper data.
         *
         * @var string
         */
        private static $option_name = 'woocommerce_helper_data';
        /**
         * Update an option by key
         *
         * All helper options are grouped in a single options entry. This method
         * is not thread-safe, use with caution.
         *
         * @param string $key The key to update.
         * @param mixed  $value The new option value.
         *
         * @return bool True if the option has been updated.
         */
        public static function update($key, $value)
        {
        }
        /**
         * Get an option by key
         *
         * @see self::update
         *
         * @param string $key The key to fetch.
         * @param mixed  $default The default option to return if the key does not exist.
         *
         * @return mixed An option or the default.
         */
        public static function get($key, $default = \false)
        {
        }
    }
    /**
     * WC_Helper_Plugin_Info Class
     *
     * Provides the "View Information" core modals with data for Woo.com
     * hosted extensions.
     */
    class WC_Helper_Plugin_Info
    {
        /**
         * Loads the class, runs on init.
         */
        public static function load()
        {
        }
        /**
         * Plugin information callback for Woo extensions.
         *
         * @param object $response The response core needs to display the modal.
         * @param string $action The requested plugins_api() action.
         * @param object $args Arguments passed to plugins_api().
         *
         * @return object An updated $response.
         */
        public static function plugins_api($response, $action, $args)
        {
        }
        /**
         * Theme information callback for Woo themes.
         *
         * @param object $response The response core needs to display the modal.
         * @param string $action The requested themes_api() action.
         * @param object $args Arguments passed to themes_api().
         */
        public static function themes_api($response, $action, $args)
        {
        }
        /**
         * Override the products API to fetch data from the Helper API if it's a Woo product.
         *
         * @param object $response The response core needs to display the modal.
         * @param string $action The requested action.
         * @param object $args Arguments passed to the API.
         */
        public static function maybe_override_products_api($response, $action, $args)
        {
        }
    }
    /**
     * WC_Helper_Subscriptions_API
     *
     * The main entry-point for all things related to the Marketplace Subscriptions API.
     * The Subscriptions API manages WooCommerce.com Subscriptions.
     */
    class WC_Helper_Subscriptions_API
    {
        /**
         * Loads the class, runs on init
         *
         * @return void
         */
        public static function load()
        {
        }
        /**
         * Registers the REST routes for the Marketplace Subscriptions API.
         * These endpoints are used by the Marketplace Subscriptions React UI.
         */
        public static function register_rest_routes()
        {
        }
        /**
         * The Extensions page can only be accessed by users with the manage_woocommerce
         * capability. So the API mimics that behavior.
         */
        public static function get_permission()
        {
        }
        /**
         * Fetch subscriptions from WooCommerce.com and serve them
         * as JSON.
         */
        public static function get_subscriptions()
        {
        }
        /**
         * Refresh account and subscriptions from WooCommerce.com and serve subscriptions
         * as JSON.
         */
        public static function refresh()
        {
        }
        /**
         * Connect a WooCommerce.com subscription.
         *
         * @param WP_REST_Request $request Request object.
         */
        public static function connect($request)
        {
        }
        /**
         * Disconnect a WooCommerce.com subscription.
         *
         * @param WP_REST_Request $request Request object.
         */
        public static function disconnect($request)
        {
        }
        /**
         * Activate a WooCommerce.com product.
         * This activates the plugin/theme on the site.
         *
         * @param WP_REST_Request $request Request object.
         */
        public static function activate($request)
        {
        }
        /**
         * Get the install URL for a WooCommerce.com product.
         *
         * @param WP_REST_Request $request Request object.
         */
        public static function install_url($request)
        {
        }
    }
    /**
     * WC_Helper_Updater Class
     *
     * Contains the logic to fetch available updates and hook into Core's update
     * routines to serve Woo.com-provided packages.
     */
    class WC_Helper_Updater
    {
        /**
         * Loads the class, runs on init.
         */
        public static function load()
        {
        }
        /**
         * Runs in a cron thread, or in a visitor thread if triggered
         * by _maybe_update_plugins(), or in an auto-update thread.
         *
         * @param object $transient The update_plugins transient object.
         *
         * @return object The same or a modified version of the transient.
         */
        public static function transient_update_plugins($transient)
        {
        }
        /**
         * Runs on pre_set_site_transient_update_themes, provides custom
         * packages for Woo.com-hosted extensions.
         *
         * @param object $transient The update_themes transient object.
         *
         * @return object The same or a modified version of the transient.
         */
        public static function transient_update_themes($transient)
        {
        }
        /**
         * Get update data for all plugins.
         *
         * @return array Update data {product_id => data}
         * @see get_update_data
         */
        public static function get_available_extensions_downloads_data()
        {
        }
        /**
         * Get update data for all extensions.
         *
         * Scans through all subscriptions for the connected user, as well
         * as all Woo extensions without a subscription, and obtains update
         * data for each product.
         *
         * @return array Update data {product_id => data}
         */
        public static function get_update_data()
        {
        }
        /**
         * Get translations updates information.
         *
         * Scans through all subscriptions for the connected user, as well
         * as all Woo extensions without a subscription, and obtains update
         * data for each product.
         *
         * @return array Update data {product_id => data}
         */
        public static function get_translations_update_data()
        {
        }
        /**
         * Run an update check API call.
         *
         * The call is cached based on the payload (product ids, file ids). If
         * the payload changes, the cache is going to miss.
         *
         * @param array $payload Information about the plugin to update.
         * @return array Update data for each requested product.
         */
        private static function _update_check($payload)
        {
        }
        /**
         * Check for an active subscription.
         *
         * Checks a given product id against all subscriptions on
         * the current site. Returns true if at least one active
         * subscription is found.
         *
         * @param int $product_id The product id to look for.
         *
         * @return bool True if active subscription found.
         */
        private static function _has_active_subscription($product_id)
        {
        }
        /**
         * Get the number of products that have updates.
         *
         * @return int The number of products with updates.
         */
        public static function get_updates_count()
        {
        }
        /**
         * Return the updates count markup.
         *
         * @return string Updates count markup, empty string if no updates avairable.
         */
        public static function get_updates_count_html()
        {
        }
        /**
         * Flushes cached update data.
         */
        public static function flush_updates_cache()
        {
        }
        /**
         * Fires when a user successfully updated a theme or a plugin.
         */
        public static function upgrader_process_complete()
        {
        }
        /**
         * Hooked into the upgrader_pre_download filter in order to better handle error messaging around expired
         * plugin updates. Initially we were using an empty string, but the error message that no_package
         * results in does not fit the cause.
         *
         * @since 4.1.0
         * @param bool   $reply Holds the current filtered response.
         * @param string $package The path to the package file for the update.
         * @return false|WP_Error False to proceed with the update as normal, anything else to be returned instead of updating.
         */
        public static function block_expired_updates($reply, $package)
        {
        }
    }
    /**
     * WC_Helper Class
     *
     * The main entry-point for all things related to the Helper.
     */
    class WC_Helper
    {
        /**
         * A log object returned by wc_get_logger().
         *
         * @var $log
         */
        public static $log;
        /**
         * Get an absolute path to the requested helper view.
         *
         * @param string $view The requested view file.
         *
         * @return string The absolute path to the view file.
         */
        public static function get_view_filename($view)
        {
        }
        /**
         * Loads the helper class, runs on init.
         */
        public static function load()
        {
        }
        /**
         * Include supporting helper classes.
         */
        protected static function includes()
        {
        }
        /**
         * Render the helper section content based on context.
         */
        public static function render_helper_output()
        {
        }
        /**
         * Add tracking parameters to buttons (Renew, Purchase, etc.) on subscriptions page
         *
         * @param string $url URL to product page or to https://woo.com/my-account/my-subscriptions/.
         * @param string $utm_content value of utm_content query parameter used for tracking
         *
         * @return string URL including utm parameters for tracking
         */
        public static function add_utm_params_to_url_for_subscription_link($url, $utm_content)
        {
        }
        /**
         * Get available subscriptions filters.
         *
         * @return array An array of filter keys and labels.
         */
        public static function get_filters()
        {
        }
        /**
         * Get counts data for the filters array.
         *
         * @param array $subscriptions The array of all available subscriptions.
         *
         * @return array Filter counts (filter => count).
         */
        public static function get_filters_counts($subscriptions = \null)
        {
        }
        /**
         * Get current filter.
         *
         * @return string The current filter.
         */
        public static function get_current_filter()
        {
        }
        /**
         * Filter an array of subscriptions by $filter.
         *
         * @param array  $subscriptions The subscriptions array, passed by ref.
         * @param string $filter The filter.
         */
        private static function _filter(&$subscriptions, $filter)
        {
        }
        /**
         * Enqueue admin scripts and styles.
         */
        public static function admin_enqueue_scripts()
        {
        }
        /**
         * Various success/error notices.
         *
         * Runs during admin page render, so no headers/redirects here.
         *
         * @return array Array pairs of message/type strings with notices.
         */
        private static function _get_return_notices()
        {
        }
        /**
         * Various early-phase actions with possible redirects.
         *
         * @param object $screen WP screen object.
         */
        public static function current_screen($screen)
        {
        }
        /**
         * Maybe redirect to the new Marketplace installer.
         */
        private static function maybe_redirect_to_new_marketplace_installer()
        {
        }
        /**
         * Get helper redirect URL.
         *
         * @param array  $args Query args.
         * @param bool   $redirect_to_wc_admin Whether to redirect to WC Admin.
         * @param string $install_product_key Optional Product key to install.
         * @return string
         */
        private static function get_helper_redirect_url($args = array(), $redirect_to_wc_admin = \false, $install_product_key = '')
        {
        }
        /**
         * Initiate a new OAuth connection.
         */
        private static function _helper_auth_connect()
        {
        }
        /**
         * Return from Woo.com OAuth flow.
         */
        private static function _helper_auth_return()
        {
        }
        /**
         * Disconnect from Woo.com, clear OAuth tokens.
         */
        private static function _helper_auth_disconnect()
        {
        }
        /**
         * User hit the Refresh button, clear all caches.
         */
        private static function _helper_auth_refresh()
        {
        }
        /**
         * Flush helper authentication cache.
         */
        public static function refresh_helper_subscriptions()
        {
        }
        /**
         * Active a product subscription.
         */
        private static function _helper_subscription_activate()
        {
        }
        /**
         * Activate helper subscription.
         *
         * @throws Exception If the subscription could not be activated or found.
         * @param string $product_key Subscription product key.
         * @return bool True if activated, false otherwise.
         */
        public static function activate_helper_subscription($product_key)
        {
        }
        /**
         * Deactivate a product subscription.
         */
        private static function helper_subscription_deactivate()
        {
        }
        /**
         * Deactivate a product subscription.
         *
         * @throws Exception If the subscription could not be deactivated or found.
         * @param string $product_key Subscription product key.
         * @return bool True if deactivated, false otherwise.
         */
        public static function deactivate_helper_subscription($product_key)
        {
        }
        /**
         * Get a subscriptions install URL.
         *
         * @param string $product_key Subscription product key.
         * @return string
         */
        public static function get_subscription_install_url($product_key)
        {
        }
        /**
         * Deactivate a plugin.
         */
        private static function _helper_plugin_deactivate()
        {
        }
        /**
         * Get a local plugin/theme entry from product_id.
         *
         * @param int $product_id The product id.
         *
         * @return array|bool The array containing the local plugin/theme data or false.
         */
        private static function _get_local_from_product_id($product_id)
        {
        }
        /**
         * Checks whether current site has product subscription of a given ID.
         *
         * @since 3.7.0
         *
         * @param int $product_id The product id.
         *
         * @return bool Returns true if product subscription exists, false otherwise.
         */
        public static function has_product_subscription($product_id)
        {
        }
        /**
         * Get a subscription entry from product_id. If multiple subscriptions are
         * found with the same product id and $single is set to true, will return the
         * first one in the list, so you can use this method to get things like extension
         * name, version, etc.
         *
         * @param int  $product_id The product id.
         * @param bool $single Whether to return a single subscription or all matching a product id.
         *
         * @return array|bool The array containing sub data or false.
         */
        private static function _get_subscriptions_from_product_id($product_id, $single = \true)
        {
        }
        /**
         * Get locally installed plugins
         *
         * @return array
         */
        public static function get_local_plugins()
        {
        }
        /**
         * Get locally installed themes.
         *
         * @return array
         */
        public static function get_local_themes()
        {
        }
        /**
         * Obtain a list of data about locally installed Woo extensions.
         */
        public static function get_local_woo_plugins()
        {
        }
        /**
         * Get locally installed Woo themes.
         */
        public static function get_local_woo_themes()
        {
        }
        /**
         * Get the connected user's subscriptions.
         *
         * @return array
         */
        public static function get_subscriptions()
        {
        }
        /**
         * Get subscription data for a given product key.
         *
         * @param string $product_key Subscription product key.
         * @return array|bool The array containing sub data or false.
         */
        public static function get_subscription($product_key)
        {
        }
        /**
         * Get the connected user's subscription list data.
         * This is used by the My Subscriptions page.
         *
         * @return array
         */
        public static function get_subscription_list_data()
        {
        }
        /**
         * Check if a subscription is available to use.
         * That is, is not already active and hasn't expired, and there are no other subscriptions
         * for this product already active on this site.
         *
         * @param array $subscription The subscription we're checking.
         * @param array $subscriptions The list of all the user's subscriptions.
         * @return bool True if multiple licenses exist, false otherwise.
         */
        public static function is_subscription_available($subscription, $subscriptions)
        {
        }
        /**
         * Check if product relating to a subscription is installed.
         * This method will return true if the product is installed, but will exclude subscriptions for the same product that are not in use.
         * If a product is installed and inactive, this will ensure that one subscription is marked as installed.
         *
         * @param array $subscription The subscription we're checking.
         * @param array $subscriptions The list of all the user's subscriptions.
         * @return bool True if installed, false otherwise.
         */
        public static function is_subscription_installed($subscription, $subscriptions)
        {
        }
        /**
         * Add local data to a subscription.
         *
         * @param array $subscription The subscription data.
         * @return array The subscription data with local data added.
         */
        public static function get_subscription_local_data(array $subscription)
        {
        }
        /**
         * Runs when any plugin is activated.
         *
         * Depending on the activated plugin attempts to look through available
         * subscriptions and auto-activate one if possible, so the user does not
         * need to visit the Helper UI at all after installing a new extension.
         *
         * @param string $filename The filename of the activated plugin.
         */
        public static function activated_plugin($filename)
        {
        }
        /**
         * Runs when any plugin is deactivated.
         *
         * When a user deactivates a plugin, attempt to deactivate any subscriptions
         * associated with the extension.
         *
         * @param string $filename The filename of the deactivated plugin.
         */
        public static function deactivated_plugin($filename)
        {
        }
        /**
         * Various Helper-related admin notices.
         */
        public static function admin_notices()
        {
        }
        /**
         * Get an update notice if one or more Woo extensions has an update available.
         *
         * @return string|null The update notice or null if everything is up to date.
         */
        private static function _get_extensions_update_notice()
        {
        }
        /**
         * Whether WooCommerce has an update available.
         *
         * @return bool True if a Woo core update is available.
         */
        private static function _woo_core_update_available()
        {
        }
        /**
         * Flush subscriptions cache.
         */
        public static function _flush_subscriptions_cache()
        {
        }
        /**
         * Flush auth cache.
         */
        public static function _flush_authentication_cache()
        {
        }
        /**
         * Flush updates cache.
         */
        private static function _flush_updates_cache()
        {
        }
        /**
         * Sort subscriptions by the product_name.
         *
         * @param array $a Subscription array.
         * @param array $b Subscription array.
         *
         * @return int
         */
        public static function _sort_by_product_name($a, $b)
        {
        }
        /**
         * Sort subscriptions by the Name.
         *
         * @param array $a Product array.
         * @param array $b Product array.
         *
         * @return int
         */
        public static function _sort_by_name($a, $b)
        {
        }
        /**
         * Log a helper event.
         *
         * @param string $message Log message.
         * @param string $level Optional, defaults to info, valid levels: emergency|alert|critical|error|warning|notice|info|debug.
         */
        public static function log($message, $level = 'info')
        {
        }
        /**
         * Handles WC Helper disconnect tasks.
         *
         * @return void
         */
        public static function disconnect()
        {
        }
        /**
         * Checks if `access_token` exists in `auth` option.
         *
         * @return bool
         */
        public static function is_site_connected() : bool
        {
        }
        /**
         * Allows to connect with WCCOM using application password. used it to connect via CLI
         *
         * @param string $password The application password.
         *
         * @return void|WP_Error
         */
        public static function connect_with_password(string $password)
        {
        }
        /**
         * Updates auth options and flushes cache
         *
         * @param string $access_token The access token.
         * @param string $access_token_secret The secret access token.
         * @param int    $site_id The site id returned by the API.
         *
         * @return void
         */
        public static function update_auth_option(string $access_token, string $access_token_secret, int $site_id) : void
        {
        }
    }
    /**
     * Product importer controller - handles file upload and forms in admin.
     *
     * @package     WooCommerce\Admin\Importers
     * @version     3.1.0
     */
    class WC_Product_CSV_Importer_Controller
    {
        /**
         * The path to the current file.
         *
         * @var string
         */
        protected $file = '';
        /**
         * The current import step.
         *
         * @var string
         */
        protected $step = '';
        /**
         * Progress steps.
         *
         * @var array
         */
        protected $steps = array();
        /**
         * Errors.
         *
         * @var array
         */
        protected $errors = array();
        /**
         * The current delimiter for the file being read.
         *
         * @var string
         */
        protected $delimiter = ',';
        /**
         * Whether to use previous mapping selections.
         *
         * @var bool
         */
        protected $map_preferences = \false;
        /**
         * Whether to skip existing products.
         *
         * @var bool
         */
        protected $update_existing = \false;
        /**
         * The character encoding to use to interpret the input file, or empty string for autodetect.
         *
         * @var string
         */
        protected $character_encoding = 'UTF-8';
        /**
         * Get importer instance.
         *
         * @param  string $file File to import.
         * @param  array  $args Importer arguments.
         * @return WC_Product_CSV_Importer
         */
        public static function get_importer($file, $args = array())
        {
        }
        /**
         * Check whether a file is a valid CSV file.
         *
         * @param string $file File path.
         * @param bool   $check_path Whether to also check the file is located in a valid location (Default: true).
         * @return bool
         */
        public static function is_file_valid_csv($file, $check_path = \true)
        {
        }
        /**
         * Get all the valid filetypes for a CSV file.
         *
         * @return array
         */
        protected static function get_valid_csv_filetypes()
        {
        }
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get the URL for the next step's screen.
         *
         * @param string $step  slug (default: current step).
         * @return string       URL for next step if a next step exists.
         *                      Admin URL if it's the last step.
         *                      Empty string on failure.
         */
        public function get_next_step_link($step = '')
        {
        }
        /**
         * Output header view.
         */
        protected function output_header()
        {
        }
        /**
         * Output steps view.
         */
        protected function output_steps()
        {
        }
        /**
         * Output footer view.
         */
        protected function output_footer()
        {
        }
        /**
         * Add error message.
         *
         * @param string $message Error message.
         * @param array  $actions List of actions with 'url' and 'label'.
         */
        protected function add_error($message, $actions = array())
        {
        }
        /**
         * Add error message.
         */
        protected function output_errors()
        {
        }
        /**
         * Dispatch current step and show correct view.
         */
        public function dispatch()
        {
        }
        /**
         * Output information about the uploading process.
         */
        protected function upload_form()
        {
        }
        /**
         * Handle the upload form and store options.
         */
        public function upload_form_handler()
        {
        }
        /**
         * Handles the CSV upload and initial parsing of the file to prepare for
         * displaying author import options.
         *
         * @return string|WP_Error
         */
        public function handle_upload()
        {
        }
        /**
         * Mapping step.
         */
        protected function mapping_form()
        {
        }
        /**
         * Import the file if it exists and is valid.
         */
        public function import()
        {
        }
        /**
         * Done step.
         */
        protected function done()
        {
        }
        /**
         * Columns to normalize.
         *
         * @param  array $columns List of columns names and keys.
         * @return array
         */
        protected function normalize_columns_names($columns)
        {
        }
        /**
         * Auto map column names.
         *
         * @param  array $raw_headers Raw header columns.
         * @param  bool  $num_indexes If should use numbers or raw header columns as indexes.
         * @return array
         */
        protected function auto_map_columns($raw_headers, $num_indexes = \true)
        {
        }
        /**
         * Map columns using the user's latest import mappings.
         *
         * @param  array $headers Header columns.
         * @return array
         */
        public function auto_map_user_preferences($headers)
        {
        }
        /**
         * Sanitize special column name regex.
         *
         * @param  string $value Raw special column name.
         * @return string
         */
        protected function sanitize_special_column_name_regex($value)
        {
        }
        /**
         * Get special columns.
         *
         * @param  array $columns Raw special columns.
         * @return array
         */
        protected function get_special_columns($columns)
        {
        }
        /**
         * Get mapping options.
         *
         * @param  string $item Item name.
         * @return array
         */
        protected function get_mapping_options($item = '')
        {
        }
    }
    /**
     * Tax Rates importer - import tax rates and local tax rates into WooCommerce.
     *
     * @package     WooCommerce\Admin\Importers
     * @version     2.3.0
     */
    class WC_Tax_Rate_Importer extends \WP_Importer
    {
        /**
         * The current file id.
         *
         * @var int
         */
        public $id;
        /**
         * The current file url.
         *
         * @var string
         */
        public $file_url;
        /**
         * The current import page.
         *
         * @var string
         */
        public $import_page;
        /**
         * The current delimiter.
         *
         * @var string
         */
        public $delimiter;
        /**
         * Error message for import.
         *
         * @var string
         */
        public $import_error_message;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Registered callback function for the WordPress Importer.
         *
         * Manages the three separate stages of the CSV import process.
         */
        public function dispatch()
        {
        }
        /**
         * Import is starting.
         */
        private function import_start()
        {
        }
        /**
         * UTF-8 encode the data if `$enc` value isn't UTF-8.
         *
         * @param mixed  $data Data.
         * @param string $enc Encoding.
         * @return string
         */
        public function format_data_from_csv($data, $enc)
        {
        }
        /**
         * Import the file if it exists and is valid.
         *
         * @param mixed $file File.
         */
        public function import($file)
        {
        }
        /**
         * Performs post-import cleanup of files and the cache.
         */
        public function import_end()
        {
        }
        /**
         * Set the import error message.
         *
         * @param string $message Error message.
         */
        protected function set_import_error_message($message)
        {
        }
        /**
         * Handles the CSV upload and initial parsing of the file to prepare for.
         * displaying author import options.
         *
         * @return bool False if error uploading or invalid file, true otherwise
         */
        public function handle_upload()
        {
        }
        /**
         * Output header html.
         */
        public function header()
        {
        }
        /**
         * Output footer html.
         */
        public function footer()
        {
        }
        /**
         * Output information about the uploading process.
         */
        public function greet()
        {
        }
        /**
         * Show import error and quit.
         *
         * @param  string $message Error message.
         */
        private function import_error($message = '')
        {
        }
        /**
         * Added to http_request_timeout filter to force timeout at 60 seconds during import.
         *
         * @param  int $val Value.
         * @return int 60
         */
        public function bump_request_timeout($val)
        {
        }
    }
    /**
     * WC_Admin_List_Table Class.
     */
    abstract class WC_Admin_List_Table
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $list_table_type = '';
        /**
         * Object being shown on the row.
         *
         * @var object|null
         */
        protected $object = \null;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Show blank slate.
         *
         * @param string $which String which tablenav is being shown.
         */
        public function maybe_render_blank_state($which)
        {
        }
        /**
         * Render blank state. Extend to add content.
         */
        protected function render_blank_state()
        {
        }
        /**
         * Removes this type from list of post types that support "View Mode" switching.
         * View mode is seen on posts where you can switch between list or excerpt. Our post types don't support
         * it, so we want to hide the useless UI from the screen options tab.
         *
         * @param  array $post_types Array of post types supporting view mode.
         * @return array             Array of post types supporting view mode, without this type.
         */
        public function disable_view_mode($post_types)
        {
        }
        /**
         * See if we should render search filters or not.
         */
        public function restrict_manage_posts()
        {
        }
        /**
         * Handle any filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        public function request_query($query_vars)
        {
        }
        /**
         * Render any custom filters and search inputs for the list table.
         */
        protected function render_filters()
        {
        }
        /**
         * Handle any custom filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        protected function query_filters($query_vars)
        {
        }
        /**
         * Set row actions.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Current post object.
         * @return array
         */
        public function row_actions($actions, $post)
        {
        }
        /**
         * Get row actions to show in the list table.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Current post object.
         * @return array
         */
        protected function get_row_actions($actions, $post)
        {
        }
        /**
         * Adjust which columns are displayed by default.
         *
         * @param array  $hidden Current hidden columns.
         * @param object $screen Current screen.
         * @return array
         */
        public function default_hidden_columns($hidden, $screen)
        {
        }
        /**
         * Set list table primary column.
         *
         * @param  string $default Default value.
         * @param  string $screen_id Current screen ID.
         * @return string
         */
        public function list_table_primary_column($default, $screen_id)
        {
        }
        /**
         * Define primary column.
         *
         * @return array
         */
        protected function get_primary_column()
        {
        }
        /**
         * Define hidden columns.
         *
         * @return array
         */
        protected function define_hidden_columns()
        {
        }
        /**
         * Define which columns are sortable.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_sortable_columns($columns)
        {
        }
        /**
         * Define which columns to show on this screen.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_columns($columns)
        {
        }
        /**
         * Define bulk actions.
         *
         * @param array $actions Existing actions.
         * @return array
         */
        public function define_bulk_actions($actions)
        {
        }
        /**
         * Pre-fetch any data for the row each column has access to it.
         *
         * @param int $post_id Post ID being shown.
         */
        protected function prepare_row_data($post_id)
        {
        }
        /**
         * Render individual columns.
         *
         * @param string $column Column ID to render.
         * @param int    $post_id Post ID being shown.
         */
        public function render_columns($column, $post_id)
        {
        }
        /**
         * Handle bulk actions.
         *
         * @param  string $redirect_to URL to redirect to.
         * @param  string $action      Action name.
         * @param  array  $ids         List of ids.
         * @return string
         */
        public function handle_bulk_actions($redirect_to, $action, $ids)
        {
        }
    }
    /**
     * WC_Admin_List_Table_Coupons Class.
     */
    class WC_Admin_List_Table_Coupons extends \WC_Admin_List_Table
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $list_table_type = 'shop_coupon';
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Render blank state.
         */
        protected function render_blank_state()
        {
        }
        /**
         * Define primary column.
         *
         * @return string
         */
        protected function get_primary_column()
        {
        }
        /**
         * Get row actions to show in the list table.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Current post object.
         * @return array
         */
        protected function get_row_actions($actions, $post)
        {
        }
        /**
         * Define which columns to show on this screen.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_columns($columns)
        {
        }
        /**
         * Pre-fetch any data for the row each column has access to it. the_coupon global is there for bw compat.
         *
         * @param int $post_id Post ID being shown.
         */
        protected function prepare_row_data($post_id)
        {
        }
        /**
         * Render column: coupon_code.
         */
        protected function render_coupon_code_column()
        {
        }
        /**
         * Render column: type.
         */
        protected function render_type_column()
        {
        }
        /**
         * Render column: amount.
         */
        protected function render_amount_column()
        {
        }
        /**
         * Render column: products.
         */
        protected function render_products_column()
        {
        }
        /**
         * Render column: usage_limit.
         */
        protected function render_usage_limit_column()
        {
        }
        /**
         * Render column: usage.
         */
        protected function render_usage_column()
        {
        }
        /**
         * Render column: expiry_date.
         */
        protected function render_expiry_date_column()
        {
        }
        /**
         * Render column: description.
         */
        protected function render_description_column()
        {
        }
        /**
         * Render any custom filters and search inputs for the list table.
         */
        protected function render_filters()
        {
        }
        /**
         * Handle any custom filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        protected function query_filters($query_vars)
        {
        }
    }
    /**
     * WC_Admin_List_Table_Orders Class.
     */
    class WC_Admin_List_Table_Orders extends \WC_Admin_List_Table
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $list_table_type = 'shop_order';
        /**
         * The data store-agnostic list table implementation (introduced to support custom order tables),
         * which we use here to render columns.
         *
         * @var ListTable $orders_list_table
         */
        private $orders_list_table;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Render blank state.
         */
        protected function render_blank_state()
        {
        }
        /**
         * Define primary column.
         *
         * @return string
         */
        protected function get_primary_column()
        {
        }
        /**
         * Get row actions to show in the list table.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Current post object.
         * @return array
         */
        protected function get_row_actions($actions, $post)
        {
        }
        /**
         * Define hidden columns.
         *
         * @return array
         */
        protected function define_hidden_columns()
        {
        }
        /**
         * Define which columns are sortable.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_sortable_columns($columns)
        {
        }
        /**
         * Define which columns to show on this screen.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_columns($columns)
        {
        }
        /**
         * Define bulk actions.
         *
         * @param array $actions Existing actions.
         * @return array
         */
        public function define_bulk_actions($actions)
        {
        }
        /**
         * Pre-fetch any data for the row each column has access to it. the_order global is there for bw compat.
         *
         * @param int $post_id Post ID being shown.
         */
        protected function prepare_row_data($post_id)
        {
        }
        /**
         * Render column: order_number.
         */
        protected function render_order_number_column()
        {
        }
        /**
         * Render column: order_status.
         */
        protected function render_order_status_column()
        {
        }
        /**
         * Render column: order_date.
         */
        protected function render_order_date_column()
        {
        }
        /**
         * Render column: order_total.
         */
        protected function render_order_total_column()
        {
        }
        /**
         * Render column: wc_actions.
         */
        protected function render_wc_actions_column()
        {
        }
        /**
         * Render column: billing_address.
         */
        protected function render_billing_address_column()
        {
        }
        /**
         * Render column: shipping_address.
         */
        protected function render_shipping_address_column()
        {
        }
        /**
         * Template for order preview.
         *
         * @since 3.3.0
         */
        public function order_preview_template()
        {
        }
        /**
         * Get items to display in the preview as HTML.
         *
         * @param  WC_Order $order Order object.
         * @return string
         */
        public static function get_order_preview_item_html($order)
        {
        }
        /**
         * Get actions to display in the preview as HTML.
         *
         * @param  WC_Order $order Order object.
         * @return string
         */
        public static function get_order_preview_actions_html($order)
        {
        }
        /**
         * Get order details to send to the ajax endpoint for previews.
         *
         * @param  WC_Order $order Order object.
         * @return array
         */
        public static function order_preview_get_order_details($order)
        {
        }
        /**
         * Handle bulk actions.
         *
         * @param  string $redirect_to URL to redirect to.
         * @param  string $action      Action name.
         * @param  array  $ids         List of ids.
         * @return string
         */
        public function handle_bulk_actions($redirect_to, $action, $ids)
        {
        }
        /**
         * Show confirmation message that order status changed for number of orders.
         */
        public function bulk_admin_notices()
        {
        }
        /**
         * See if we should render search filters or not.
         */
        public function restrict_manage_posts()
        {
        }
        /**
         * Render any custom filters and search inputs for the list table.
         */
        protected function render_filters()
        {
        }
        /**
         * Handle any filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        public function request_query($query_vars)
        {
        }
        /**
         * Handle any custom filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        protected function query_filters($query_vars)
        {
        }
        /**
         * Change the label when searching orders.
         *
         * @param mixed $query Current search query.
         * @return string
         */
        public function search_label($query)
        {
        }
        /**
         * Query vars for custom searches.
         *
         * @param mixed $public_query_vars Array of query vars.
         * @return array
         */
        public function add_custom_query_var($public_query_vars)
        {
        }
        /**
         * Search custom fields as well as content.
         *
         * @param WP_Query $wp Query object.
         */
        public function search_custom_fields($wp)
        {
        }
    }
    /**
     * WC_Admin_List_Table_Products Class.
     */
    class WC_Admin_List_Table_Products extends \WC_Admin_List_Table
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $list_table_type = 'product';
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Render blank state.
         */
        protected function render_blank_state()
        {
        }
        /**
         * Define primary column.
         *
         * @return string
         */
        protected function get_primary_column()
        {
        }
        /**
         * Get row actions to show in the list table.
         *
         * @param array   $actions Array of actions.
         * @param WP_Post $post Current post object.
         * @return array
         */
        protected function get_row_actions($actions, $post)
        {
        }
        /**
         * Define which columns are sortable.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_sortable_columns($columns)
        {
        }
        /**
         * Define which columns to show on this screen.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function define_columns($columns)
        {
        }
        /**
         * Pre-fetch any data for the row each column has access to it. the_product global is there for bw compat.
         *
         * @param int $post_id Post ID being shown.
         */
        protected function prepare_row_data($post_id)
        {
        }
        /**
         * Render column: thumb.
         */
        protected function render_thumb_column()
        {
        }
        /**
         * Render column: name.
         */
        protected function render_name_column()
        {
        }
        /**
         * Render column: sku.
         */
        protected function render_sku_column()
        {
        }
        /**
         * Render column: price.
         */
        protected function render_price_column()
        {
        }
        /**
         * Render column: product_cat.
         */
        protected function render_product_cat_column()
        {
        }
        /**
         * Render column: product_tag.
         */
        protected function render_product_tag_column()
        {
        }
        /**
         * Render column: featured.
         */
        protected function render_featured_column()
        {
        }
        /**
         * Render column: is_in_stock.
         */
        protected function render_is_in_stock_column()
        {
        }
        /**
         * Query vars for custom searches.
         *
         * @param mixed $public_query_vars Array of query vars.
         * @return array
         */
        public function add_custom_query_var($public_query_vars)
        {
        }
        /**
         * Render any custom filters and search inputs for the list table.
         */
        protected function render_filters()
        {
        }
        /**
         * Render the product category filter for the list table.
         *
         * @since 3.5.0
         */
        protected function render_products_category_filter()
        {
        }
        /**
         * Render the product type filter for the list table.
         *
         * @since 3.5.0
         */
        protected function render_products_type_filter()
        {
        }
        /**
         * Render the stock status filter for the list table.
         *
         * @since 3.5.0
         */
        public function render_products_stock_status_filter()
        {
        }
        /**
         * Search by SKU or ID for products.
         *
         * @deprecated 4.4.0 Logic moved to query_filters.
         * @param string $where Where clause SQL.
         * @return string
         */
        public function sku_search($where)
        {
        }
        /**
         * Change views on the edit product screen.
         *
         * @param  array $views Array of views.
         * @return array
         */
        public function product_views($views)
        {
        }
        /**
         * Change the label when searching products
         *
         * @param string $query Search Query.
         * @return string
         */
        public function search_label($query)
        {
        }
        /**
         * Handle any custom filters.
         *
         * @param array $query_vars Query vars.
         * @return array
         */
        protected function query_filters($query_vars)
        {
        }
        /**
         * Undocumented function
         *
         * @param array    $args  Array of SELECT statement pieces (from, where, etc).
         * @param WP_Query $query WP_Query instance.
         * @return array
         */
        public function posts_clauses($args, $query)
        {
        }
        /**
         * Remove ordering queries.
         *
         * @param array $posts Posts array, keeping this for backwards compatibility defaulting to empty array.
         * @return array
         */
        public function remove_ordering_args($posts = array())
        {
        }
        /**
         * Handle numeric price sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_price_asc_post_clauses($args)
        {
        }
        /**
         * Handle numeric price sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_price_desc_post_clauses($args)
        {
        }
        /**
         * Handle sku sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_sku_asc_post_clauses($args)
        {
        }
        /**
         * Handle sku sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_sku_desc_post_clauses($args)
        {
        }
        /**
         * Filter by type.
         *
         * @param array $args Query args.
         * @return array
         */
        public function filter_downloadable_post_clauses($args)
        {
        }
        /**
         * Filter by type.
         *
         * @param array $args Query args.
         * @return array
         */
        public function filter_virtual_post_clauses($args)
        {
        }
        /**
         * Filter by stock status.
         *
         * @param array $args Query args.
         * @return array
         */
        public function filter_stock_status_post_clauses($args)
        {
        }
        /**
         * Join wc_product_meta_lookup to posts if not already joined.
         *
         * @param string $sql SQL join.
         * @return string
         */
        private function append_product_sorting_table_join($sql)
        {
        }
        /**
         * Modifies post query so that it includes parent products whose variations have particular shipping class assigned.
         *
         * @param array    $pieces   Array of SELECT statement pieces (from, where, etc).
         * @param WP_Query $wp_query WP_Query instance.
         * @return array             Array of products, including parents of variations.
         */
        public function add_variation_parents_for_shipping_class($pieces, $wp_query)
        {
        }
    }
    /**
     * Marketplace suggestions core behaviour.
     */
    class WC_Marketplace_Suggestions
    {
        /**
         * Initialise.
         */
        public static function init()
        {
        }
        /**
         * Product data tabs filter
         *
         * Adds a new Extensions tab to the product data meta box.
         *
         * @param array $tabs Existing tabs.
         *
         * @return array
         */
        public static function product_data_tabs($tabs)
        {
        }
        /**
         * Render additional panels in the product data metabox.
         */
        public static function product_data_panels()
        {
        }
        /**
         * Return an array of suggestions the user has dismissed.
         */
        public static function get_dismissed_suggestions()
        {
        }
        /**
         * POST handler for adding a dismissed suggestion.
         */
        public static function post_add_dismissed_suggestion_handler()
        {
        }
        /**
         * Render suggestions containers in products list empty state.
         */
        public static function render_products_list_empty_state()
        {
        }
        /**
         * Render suggestions containers in orders list empty state.
         */
        public static function render_orders_list_empty_state()
        {
        }
        /**
         * Render a suggestions container element, with the specified context.
         *
         * @param string $context Suggestion context name (rendered as a css class).
         */
        public static function render_suggestions_container($context)
        {
        }
        /**
         * Should suggestions be displayed?
         *
         * @param string $screen_id The current admin screen.
         *
         * @return bool
         */
        public static function show_suggestions_for_screen($screen_id)
        {
        }
        /**
         * Should suggestions be displayed?
         *
         * @return bool
         */
        public static function allow_suggestions()
        {
        }
        /**
         * Pull suggestion data from options. This is retrieved from a remote endpoint.
         *
         * @return array of json API data
         */
        public static function get_suggestions_api_data()
        {
        }
    }
    /**
     * Marketplace Suggestions Updater
     */
    class WC_Marketplace_Updater
    {
        /**
         * Setup.
         */
        public static function load()
        {
        }
        /**
         * Schedule events and hook appropriate actions.
         */
        public static function init()
        {
        }
        /**
         * Fetches new marketplace data, updates wc_marketplace_suggestions.
         */
        public static function update_marketplace_suggestions()
        {
        }
        /**
         * Used when an error has occurred when fetching suggestions.
         * Re-schedules the job earlier than the main weekly one.
         */
        public static function retry()
        {
        }
    }
    /**
     * WC_Meta_Box_Coupon_Data Class.
     */
    class WC_Meta_Box_Coupon_Data
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post $post
         */
        public static function output($post)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int     $post_id
         * @param WP_Post $post
         */
        public static function save($post_id, $post)
        {
        }
    }
    /**
     * WC_Meta_Box_Order_Actions Class.
     */
    class WC_Meta_Box_Order_Actions
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post|WC_Order $post Post or order object.
         */
        public static function output($post)
        {
        }
        /**
         * Forms a trash/delete order URL.
         *
         * @param int $order_id The order ID for which we want a trash/delete URL.
         *
         * @return string
         */
        private static function get_trash_or_delete_order_link(int $order_id) : string
        {
        }
        /**
         * Save meta box data.
         *
         * @param int     $post_id Post ID.
         * @param WP_Post $post Post Object.
         */
        public static function save($post_id, $post)
        {
        }
        /**
         * Set the correct message ID.
         *
         * @param string $location Location.
         * @since  2.3.0
         * @static
         * @return string
         */
        public static function set_email_sent_message($location)
        {
        }
        /**
         * Get the available order actions for a given order.
         *
         * @since 5.8.0
         *
         * @param WC_Order|null $order The order object or null if no order is available.
         *
         * @return array
         */
        private static function get_available_order_actions_for_order($order)
        {
        }
    }
    /**
     * WC_Meta_Box_Order_Data Class.
     */
    class WC_Meta_Box_Order_Data
    {
        /**
         * Billing fields.
         *
         * @var array
         */
        protected static $billing_fields = array();
        /**
         * Shipping fields.
         *
         * @var array
         */
        protected static $shipping_fields = array();
        /**
         * Init billing and shipping fields we display + save.
         */
        public static function init_address_fields()
        {
        }
        /**
         * Output the metabox.
         *
         * @param WP_Post|WC_Order $post Post or order object.
         */
        public static function output($post)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int $order_id Order ID.
         * @throws Exception Required request data is missing.
         */
        public static function save($order_id)
        {
        }
    }
    /**
     * WC_Meta_Box_Order_Downloads Class.
     */
    class WC_Meta_Box_Order_Downloads
    {
        /**
         * Output the metabox.
         *
         * @param WC_Order|WP_Post $post Post or order object.
         */
        public static function output($post)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int     $post_id Post ID.
         * @param WP_Post $post Post object.
         */
        public static function save($post_id, $post)
        {
        }
    }
    /**
     * WC_Meta_Box_Order_Items Class.
     */
    class WC_Meta_Box_Order_Items
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post|WC_Order $post Post or order object.
         */
        public static function output($post)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int $post_id
         */
        public static function save($post_id)
        {
        }
    }
    /**
     * WC_Meta_Box_Order_Notes Class.
     */
    class WC_Meta_Box_Order_Notes
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post|WC_Order $post Post or order object.
         */
        public static function output($post)
        {
        }
    }
    /**
     * WC_Meta_Box_Product_Categories Class.
     */
    class WC_Meta_Box_Product_Categories
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post $post Current post object.
         * @param array   $box {
         *     Categories meta box arguments.
         *
         *     @type string   $id       Meta box 'id' attribute.
         *     @type string   $title    Meta box title.
         *     @type callable $callback Meta box display callback.
         *     @type array    $args {
         *         Extra meta box arguments.
         *
         *         @type string $taxonomy Taxonomy. Default 'category'.
         *     }
         * }
         */
        public static function output($post, $box)
        {
        }
    }
    /**
     * WC_Meta_Box_Product_Data Class.
     */
    class WC_Meta_Box_Product_Data
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post $post Post object.
         */
        public static function output($post)
        {
        }
        /**
         * Show tab content/settings.
         */
        private static function output_tabs()
        {
        }
        /**
         * Return array of product type options.
         *
         * @return array
         */
        private static function get_product_type_options()
        {
        }
        /**
         * Return array of tabs to show.
         *
         * @return array
         */
        private static function get_product_data_tabs()
        {
        }
        /**
         * Callback to sort product data tabs on priority.
         *
         * @since 3.1.0
         * @param int $a First item.
         * @param int $b Second item.
         *
         * @return bool
         */
        private static function product_data_tabs_sort($a, $b)
        {
        }
        /**
         * Filter callback for finding variation attributes.
         *
         * @param  WC_Product_Attribute $attribute Product attribute.
         * @return bool
         */
        private static function filter_variation_attributes($attribute)
        {
        }
        /**
         * Filter callback for finding non-variation attributes.
         *
         * @param  WC_Product_Attribute $attribute Product attribute.
         * @return bool
         */
        private static function filter_non_variation_attributes($attribute)
        {
        }
        /**
         * Show options for the variable product type.
         */
        public static function output_variations()
        {
        }
        /**
         * Prepare downloads for save.
         *
         * @param array $file_names File names.
         * @param array $file_urls File urls.
         * @param array $file_hashes File hashes.
         *
         * @return array
         */
        private static function prepare_downloads($file_names, $file_urls, $file_hashes)
        {
        }
        /**
         * Prepare children for save.
         *
         * @return array
         */
        private static function prepare_children()
        {
        }
        /**
         * Prepare attributes for save.
         *
         * @param array $data Attribute data.
         *
         * @return array
         */
        public static function prepare_attributes($data = \false)
        {
        }
        /**
         * Prepare attributes for a specific variation or defaults.
         *
         * @param  array  $all_attributes List of attribute keys.
         * @param  string $key_prefix Attribute key prefix.
         * @param  int    $index Attribute array index.
         * @return array
         */
        private static function prepare_set_attributes($all_attributes, $key_prefix = 'attribute_', $index = \null)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int     $post_id WP post id.
         * @param WP_Post $post Post object.
         */
        public static function save($post_id, $post)
        {
        }
        /**
         * Save variation meta box data.
         *
         * @param int     $post_id WP post id.
         * @param WP_Post $post Post object.
         */
        public static function save_variations($post_id, $post)
        {
        }
    }
    /**
     * WC_Meta_Box_Product_Images Class.
     */
    class WC_Meta_Box_Product_Images
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post $post
         */
        public static function output($post)
        {
        }
        /**
         * Save meta box data.
         *
         * @param int     $post_id
         * @param WP_Post $post
         */
        public static function save($post_id, $post)
        {
        }
    }
    /**
     * WC_Meta_Box_Product_Reviews
     */
    class WC_Meta_Box_Product_Reviews
    {
        /**
         * Output the metabox.
         *
         * @param object $comment Comment being shown.
         */
        public static function output($comment)
        {
        }
        /**
         * Save meta box data
         *
         * @param mixed $data Data to save.
         * @return mixed
         */
        public static function save($data)
        {
        }
    }
    /**
     * WC_Meta_Box_Product_Short_Description Class.
     */
    class WC_Meta_Box_Product_Short_Description
    {
        /**
         * Output the metabox.
         *
         * @param WP_Post $post Post object.
         */
        public static function output($post)
        {
        }
    }
    /**
     * WC_Notes_Refund_Returns.
     */
    class WC_Notes_Refund_Returns
    {
        /**
         * Name of the note for use in the database.
         */
        const NOTE_NAME = 'wc-refund-returns-page';
        /**
         * Attach hooks.
         */
        public static function init()
        {
        }
        /**
         * Maybe add a note to the inbox.
         *
         * @param int $page_id The ID of the page.
         */
        public static function possibly_add_note($page_id)
        {
        }
        /**
         * Get the note.
         *
         * @param int $page_id The ID of the page.
         * @return object $note The note object.
         */
        public static function get_note($page_id)
        {
        }
        /**
         * Get the note.
         *
         * @param Note $note_from_db The note object from the database.
         * @return Note $note The note object.
         */
        public static function get_note_from_db($note_from_db)
        {
        }
    }
    /**
     * WC_Notes_Run_Db_Update.
     */
    class WC_Notes_Run_Db_Update
    {
        const NOTE_NAME = 'wc-update-db-reminder';
        /**
         * Attach hooks.
         */
        public function __construct()
        {
        }
        /**
         * Get current notice id from the database.
         *
         * Retrieves the first notice of this type.
         *
         * @return int|void Note id or null in case no note was found.
         */
        private static function get_current_notice()
        {
        }
        /**
         * Set this notice to an actioned one, so that it's no longer displayed.
         */
        public static function set_notice_actioned()
        {
        }
        /**
         * Check whether the note is up to date for a fresh display.
         *
         * The check tests if
         *  - actions are set up for the first 'Update database' notice, and
         *  - URL for note's action is equal to the given URL (to check for potential nonce update).
         *
         * @param Note               $note            Note to check.
         * @param string             $update_url      URL to check the note against.
         * @param array<int, string> $current_actions List of actions to check for.
         * @return bool
         */
        private static function note_up_to_date($note, $update_url, $current_actions)
        {
        }
        /**
         * Create and set up the first (out of 3) 'Database update needed' notice and store it in the database.
         *
         * If a $note_id is given, the method updates the note instead of creating a new one.
         *
         * @param integer $note_id Note db record to update.
         * @return int Created/Updated note id
         */
        private static function update_needed_notice($note_id = \null)
        {
        }
        /**
         * Update the existing note with $note_id with information about the db upgrade being in progress.
         *
         * This is the second out of 3 notices displayed to the user.
         *
         * @param int $note_id Note id to update.
         */
        private static function update_in_progress_notice($note_id)
        {
        }
        /**
         * Update the existing note with $note_id with information that db upgrade is done.
         *
         * This is the last notice (3 out of 3 notices) displayed to the user.
         *
         * @param int $note_id Note id to update.
         */
        private static function update_done_notice($note_id)
        {
        }
        /**
         * Prepare the correct content of the db update note to be displayed by WC Admin.
         *
         * This one gets called on each page load, so try to bail quickly.
         *
         * If the db needs an update, the notice should be always shown.
         * If the db does not need an update, but the notice has *not* been actioned (i.e. after the db update, when
         * store owner hasn't acknowledged the successful db update), still show the Thanks notice.
         * If the db does not need an update, and the notice has been actioned, then notice should *not* be shown.
         * The notice should also be hidden if the db does not need an update and the notice does not exist.
         */
        public static function show_reminder()
        {
        }
    }
    /**
     * WC_Admin_Plugin_Updates Class.
     */
    class WC_Plugin_Updates
    {
        /**
         * This is the header used by extensions to show requirements.
         *
         * @var string
         */
        const VERSION_REQUIRED_HEADER = 'WC requires at least';
        /**
         * This is the header used by extensions to show testing.
         *
         * @var string
         */
        const VERSION_TESTED_HEADER = 'WC tested up to';
        /**
         * The version for the update to WooCommerce.
         *
         * @var string
         */
        protected $new_version = '';
        /**
         * Array of plugins lacking testing with the major version.
         *
         * @var array
         */
        protected $major_untested_plugins = array();
        /**
         * Common JS for initializing and managing thickbox-based modals.
         */
        protected function generic_modal_js()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Message Helpers
        |--------------------------------------------------------------------------
        |
        | Methods for getting messages.
        */
        /**
         * Get the inline warning notice for major version updates.
         *
         * @return string
         */
        protected function get_extensions_inline_warning_major()
        {
        }
        /**
         * Get the warning notice for the modal window.
         *
         * @return string
         */
        protected function get_extensions_modal_warning()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Data Helpers
        |--------------------------------------------------------------------------
        |
        | Methods for getting & manipulating data.
        */
        /**
         * Get installed plugins that have a tested version lower than the input version.
         *
         * In case of testing major version compatibility and if current WC version is >= major version part
         * of the $new_version, no plugins are returned, even if they don't explicitly declare compatibility
         * with the $new_version.
         *
         * @param string $new_version WooCommerce version to test against.
         * @param string $release 'major', 'minor', or 'none'.
         * @return array of plugin info arrays
         */
        public function get_untested_plugins($new_version, $release)
        {
        }
        /**
         * Get plugins that have a valid value for a specific header.
         *
         * @param string $header Plugin header to search for.
         * @return array Array of plugins that contain the searched header.
         */
        protected function get_plugins_with_header($header)
        {
        }
        /**
         * Get plugins which "maybe" are for WooCommerce.
         *
         * @return array of plugin info arrays
         */
        protected function get_plugins_for_woocommerce()
        {
        }
    }
    /**
     * Class WC_Plugins_Screen_Updates
     */
    class WC_Plugins_Screen_Updates extends \WC_Plugin_Updates
    {
        /**
         * The upgrade notice shown inline.
         *
         * @var string
         */
        protected $upgrade_notice = '';
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Show plugin changes on the plugins screen. Code adapted from W3 Total Cache.
         *
         * @param array    $args Unused parameter.
         * @param stdClass $response Plugin update response.
         */
        public function in_plugin_update_message($args, $response)
        {
        }
        /**
         * Get the upgrade notice from WordPress.org.
         *
         * @param  string $version WooCommerce new version.
         * @return string
         */
        protected function get_upgrade_notice($version)
        {
        }
        /**
         * Parse update notice from readme file.
         *
         * @param  string $content WooCommerce readme file content.
         * @param  string $new_version WooCommerce new version.
         * @return string
         */
        private function parse_update_notice($content, $new_version)
        {
        }
        /**
         * JS for the modal window on the plugins screen.
         */
        public function plugin_screen_modal_js()
        {
        }
    }
    /**
     * Class WC_Updates_Screen_Updates
     */
    class WC_Updates_Screen_Updates extends \WC_Plugin_Updates
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Show a warning message on the upgrades screen if the user tries to upgrade and has untested plugins.
         */
        public function update_screen_modal()
        {
        }
        /**
         * JS for the modal window on the updates screen.
         */
        protected function update_screen_modal_js()
        {
        }
    }
    /**
     * Admin Report.
     *
     * Extended by reports to show charts and stats in admin.
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Admin_Report
    {
        /**
         * List of transients name that have been updated and need persisting.
         *
         * @var array
         */
        protected static $transients_to_update = array();
        /**
         * The list of transients.
         *
         * @var array
         */
        protected static $cached_results = array();
        /**
         * The chart interval.
         *
         * @var int
         */
        public $chart_interval;
        /**
         * Group by SQL query.
         *
         * @var string
         */
        public $group_by_query;
        /**
         * The bar width.
         *
         * @var int
         */
        public $barwidth;
        /**
         * Group chart item by day or month.
         *
         * @var string
         */
        public $chart_groupby;
        /**
         * The start date of the report.
         *
         * @var int timestamp
         */
        public $start_date;
        /**
         * The end date of the report.
         *
         * @var int timestamp
         */
        public $end_date;
        /**
         * Get report totals such as order totals and discount amounts.
         *
         * Data example:
         *
         * '_order_total' => array(
         *     'type'     => 'meta',
         *     'function' => 'SUM',
         *     'name'     => 'total_sales'
         * )
         *
         * @param  array $args arguments for the report.
         * @return mixed depending on query_type
         */
        public function get_order_report_data($args = array())
        {
        }
        /**
         * Init the static hooks of the class.
         */
        protected static function add_update_transients_hook()
        {
        }
        /**
         * Enables big mysql selects for reports, just once for this session.
         */
        protected static function enable_big_selects()
        {
        }
        /**
         * Get the cached query result or null if it's not in the cache.
         *
         * @param string $query_hash The query hash.
         *
         * @return mixed
         */
        protected function get_cached_query($query_hash)
        {
        }
        /**
         * Set the cached query result.
         *
         * @param string $query_hash The query hash.
         * @param mixed  $data The data to cache.
         */
        protected function set_cached_query($query_hash, $data)
        {
        }
        /**
         * Function to update the modified transients at the end of the request.
         */
        public static function maybe_update_transients()
        {
        }
        /**
         * Put data with post_date's into an array of times.
         *
         * @param  array  $data array of your data.
         * @param  string $date_key key for the 'date' field. e.g. 'post_date'.
         * @param  string $data_key key for the data you are charting.
         * @param  int    $interval interval to use.
         * @param  string $start_date start date.
         * @param  string $group_by group by.
         * @return array
         */
        public function prepare_chart_data($data, $date_key, $data_key, $interval, $start_date, $group_by)
        {
        }
        /**
         * Prepares a sparkline to show sales in the last X days.
         *
         * @param  int    $id ID of the product to show. Blank to get all orders.
         * @param  int    $days Days of stats to get.
         * @param  string $type Type of sparkline to get. Ignored if ID is not set.
         * @return string
         */
        public function sales_sparkline($id = '', $days = 7, $type = 'sales')
        {
        }
        /**
         * Get the current range and calculate the start and end dates.
         *
         * @param  string $current_range Type of range.
         */
        public function calculate_current_range($current_range)
        {
        }
        /**
         * Return currency tooltip JS based on WooCommerce currency position settings.
         *
         * @return string
         */
        public function get_currency_tooltip()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Get chart widgets.
         *
         * @return array
         */
        public function get_chart_widgets()
        {
        }
        /**
         * Get an export link if needed.
         */
        public function get_export_button()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Check nonce for current range.
         *
         * @since  3.0.4
         * @param  string $current_range Current range.
         */
        public function check_current_range_nonce($current_range)
        {
        }
    }
    /**
     * WC_Report_Coupon_Usage
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Coupon_Usage extends \WC_Admin_Report
    {
        /**
         * Chart colors.
         *
         * @var array
         */
        public $chart_colours = array();
        /**
         * Coupon codes.
         *
         * @var array
         */
        public $coupon_codes = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get chart widgets.
         *
         * @return array
         */
        public function get_chart_widgets()
        {
        }
        /**
         * Output coupons widget.
         */
        public function coupons_widget()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Customer_List.
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Customer_List extends \WP_List_Table
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get column value.
         *
         * @param WP_User $user WP User object.
         * @param string  $column_name Column name.
         * @return string
         */
        public function column_default($user, $column_name)
        {
        }
        /**
         * Get columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Order users by name.
         *
         * @param WP_User_Query $query Query that gets passed through.
         * @return WP_User_Query
         */
        public function order_by_last_name($query)
        {
        }
        /**
         * Prepare customer list items.
         */
        public function prepare_items()
        {
        }
    }
    /**
     * WC_Report_Customers
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Customers extends \WC_Admin_Report
    {
        /**
         * Chart colors.
         *
         * @var array
         */
        public $chart_colours = array();
        /**
         * Customers.
         *
         * @var array
         */
        public $customers = array();
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Get chart widgets.
         *
         * @return array
         */
        public function get_chart_widgets()
        {
        }
        /**
         * Output customers vs guests chart.
         */
        public function customers_vs_guests()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Output the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Downloads.
     */
    class WC_Report_Downloads extends \WP_List_Table
    {
        /**
         * Max items.
         *
         * @var int
         */
        protected $max_items;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Don't need this.
         *
         * @param string $position Top or bottom.
         */
        public function display_tablenav($position)
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get column value.
         *
         * @param mixed  $item Item being displayed.
         * @param string $column_name Column name.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Get columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Prepare download list items.
         */
        public function prepare_items()
        {
        }
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Get filters from querystring.
         *
         * @return object
         */
        protected function get_filter_vars()
        {
        }
        /**
         * Get downloads matching criteria.
         *
         * @param int $current_page Current viewed page.
         * @param int $per_page How many results to show per page.
         */
        public function get_items($current_page, $per_page)
        {
        }
    }
    /**
     * WC_Report_Stock.
     *
     * @author      WooThemes
     * @category    Admin
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Stock extends \WP_List_Table
    {
        /**
         * Max items.
         *
         * @var int
         */
        protected $max_items;
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Don't need this.
         *
         * @param string $position
         */
        public function display_tablenav($position)
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get column value.
         *
         * @param mixed  $item
         * @param string $column_name
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Get columns.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Prepare customer list items.
         */
        public function prepare_items()
        {
        }
    }
    /**
     * Low stock report class.
     */
    class WC_Report_Low_In_Stock extends \WC_Report_Stock
    {
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Get Products matching stock criteria.
         *
         * @param int $current_page Current page number.
         * @param int $per_page How many results to show per page.
         */
        public function get_items($current_page, $per_page)
        {
        }
    }
    /**
     * WC_Report_Most_Stocked.
     */
    class WC_Report_Most_Stocked extends \WC_Report_Stock
    {
        /**
         * Get Products matching stock criteria.
         *
         * @param int $current_page Current page number.
         * @param int $per_page How many results to show per page.
         */
        public function get_items($current_page, $per_page)
        {
        }
    }
    /**
     * WC_Report_Out_Of_Stock class.
     */
    class WC_Report_Out_Of_Stock extends \WC_Report_Stock
    {
        /**
         * No items found text.
         */
        public function no_items()
        {
        }
        /**
         * Get Products matching stock criteria.
         *
         * @param int $current_page Current page number.
         * @param int $per_page How many results to show per page.
         */
        public function get_items($current_page, $per_page)
        {
        }
    }
    /**
     * WC_Report_Sales_By_Category
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Sales_By_Category extends \WC_Admin_Report
    {
        /**
         * Chart colors.
         *
         * @var array
         */
        public $chart_colours = array();
        /**
         * Categories ids.
         *
         * @var array
         */
        public $show_categories = array();
        /**
         * Item sales.
         *
         * @var array
         */
        private $item_sales = array();
        /**
         * Item sales and times.
         *
         * @var array
         */
        private $item_sales_and_times = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get all product ids in a category (and its children).
         *
         * @param  int $category_id Category ID.
         * @return array
         */
        public function get_products_in_category($category_id)
        {
        }
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get chart widgets.
         *
         * @return array
         */
        public function get_chart_widgets()
        {
        }
        /**
         * Output category widget.
         */
        public function category_widget()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Sales_By_Date
     */
    class WC_Report_Sales_By_Date extends \WC_Admin_Report
    {
        /**
         * Chart colors.
         *
         * @var array
         */
        public $chart_colours = array();
        /**
         * The report data.
         *
         * @var stdClass
         */
        private $report_data;
        /**
         * Get report data.
         *
         * @return stdClass
         */
        public function get_report_data()
        {
        }
        /**
         * Get all data needed for this report and store in the class.
         */
        private function query_report_data()
        {
        }
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Round our totals correctly.
         *
         * @param array|string $amount Chart total.
         *
         * @return array|string
         */
        private function round_chart_totals($amount)
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Sales_By_Product
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Sales_By_Product extends \WC_Admin_Report
    {
        /**
         * Chart colors.
         *
         * @var array
         */
        public $chart_colours = array();
        /**
         * Product ids.
         *
         * @var array
         */
        public $product_ids = array();
        /**
         * Product ids with titles.
         *
         * @var array
         */
        public $product_ids_titles = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get chart widgets.
         *
         * @return array
         */
        public function get_chart_widgets()
        {
        }
        /**
         * Output current filters.
         */
        public function current_filters()
        {
        }
        /**
         * Output products widget.
         */
        public function products_widget()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Taxes_By_Code
     *
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Taxes_By_Code extends \WC_Admin_Report
    {
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Report_Taxes_By_Date
     *
     * @author      WooThemes
     * @category    Admin
     * @package     WooCommerce\Admin\Reports
     * @version     2.1.0
     */
    class WC_Report_Taxes_By_Date extends \WC_Admin_Report
    {
        /**
         * Get the legend for the main chart sidebar.
         *
         * @return array
         */
        public function get_chart_legend()
        {
        }
        /**
         * Output an export link.
         */
        public function get_export_button()
        {
        }
        /**
         * Output the report.
         */
        public function output_report()
        {
        }
        /**
         * Get the main chart.
         */
        public function get_main_chart()
        {
        }
    }
    /**
     * WC_Settings_Page.
     */
    abstract class WC_Settings_Page
    {
        /**
         * Setting page id.
         *
         * @var string
         */
        protected $id = '';
        /**
         * Setting page label.
         *
         * @var string
         */
        protected $label = '';
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get settings page ID.
         *
         * @since 3.0.0
         * @return string
         */
        public function get_id()
        {
        }
        /**
         * Get settings page label.
         *
         * @since 3.0.0
         * @return string
         */
        public function get_label()
        {
        }
        /**
         * Add this page to settings.
         *
         * @param array $pages The settings array where we'll add ourselves.
         *
         * @return mixed
         */
        public function add_settings_page($pages)
        {
        }
        /**
         * Get settings array for the default section.
         *
         * External settings classes (registered via 'woocommerce_get_settings_pages' filter)
         * might have redefined this method as "get_settings($section_id='')", thus we need
         * to use this method internally instead of 'get_settings_for_section' to register settings
         * and render settings pages.
         *
         * *But* we can't just redefine the method as "get_settings($section_id='')" here, since this
         * will break on PHP 8 if any external setting class have it as 'get_settings()'.
         *
         * Thus we leave the method signature as is and use 'func_get_arg' to get the setting id
         * if it's supplied, and we use this method internally; but it's deprecated and should
         * otherwise never be used.
         *
         * @deprecated 5.4.0 Use 'get_settings_for_section' (passing an empty string for default section)
         *
         * @return array Settings array, each item being an associative array representing a setting.
         */
        public function get_settings()
        {
        }
        /**
         * Get settings array.
         *
         * The strategy for getting the settings is as follows:
         *
         * - If a method named 'get_settings_for_{section_id}_section' exists in the class
         *   it will be invoked (for the default '' section, the method name is 'get_settings_for_default_section').
         *   Derived classes can implement these methods as required.
         *
         * - Otherwise, 'get_settings_for_section_core' will be invoked. Derived classes can override it
         *   as an alternative to implementing 'get_settings_for_{section_id}_section' methods.
         *
         * @param string $section_id The id of the section to return settings for, an empty string for the default section.
         *
         * @return array Settings array, each item being an associative array representing a setting.
         */
        public final function get_settings_for_section($section_id)
        {
        }
        /**
         * Get the settings for a given section.
         * This method is invoked from 'get_settings_for_section' when no 'get_settings_for_{current_section}_section'
         * method exists in the class.
         *
         * When overriding, note that the 'woocommerce_get_settings_' filter must NOT be triggered,
         * as this is already done by 'get_settings_for_section'.
         *
         * @param string $section_id The section name to get the settings for.
         *
         * @return array Settings array, each item being an associative array representing a setting.
         */
        protected function get_settings_for_section_core($section_id)
        {
        }
        /**
         * Get all sections for this page, both the own ones and the ones defined via filters.
         *
         * @return array
         */
        public function get_sections()
        {
        }
        /**
         * Get own sections for this page.
         * Derived classes should override this method if they define sections.
         * There should always be one default section with an empty string as identifier.
         *
         * Example:
         * return array(
         *   ''        => __( 'General', 'woocommerce' ),
         *   'foobars' => __( 'Foos & Bars', 'woocommerce' ),
         * );
         *
         * @return array An associative array where keys are section identifiers and the values are translated section names.
         */
        protected function get_own_sections()
        {
        }
        /**
         * Output sections.
         */
        public function output_sections()
        {
        }
        /**
         * Output the HTML for the settings.
         */
        public function output()
        {
        }
        /**
         * Save settings and trigger the 'woocommerce_update_options_'.id action.
         */
        public function save()
        {
        }
        /**
         * Save settings for current section.
         */
        protected function save_settings_for_current_section()
        {
        }
        /**
         * Trigger the 'woocommerce_update_options_'.id action.
         *
         * @param string $section_id Section to trigger the action for, or null for current section.
         */
        protected function do_update_options_action($section_id = \null)
        {
        }
    }
    /**
     * WC_Settings_Accounts.
     */
    class WC_Settings_Accounts extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get settings array.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
    }
    /**
     * WC_Settings_Advanced.
     */
    class WC_Settings_Advanced extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Get settings for the default section.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Get settings for the Woo.com section.
         *
         * @return array
         */
        protected function get_settings_for_woocommerce_com_section()
        {
        }
        /**
         * Get settings for the legacy API section.
         *
         * @return array
         */
        protected function get_settings_for_legacy_api_section()
        {
        }
        /**
         * Form method.
         *
         * @deprecated 3.4.4
         *
         * @param  string $method Method name.
         *
         * @return string
         */
        public function form_method($method)
        {
        }
        /**
         * Notices.
         */
        private function notices()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
        /**
         * Save settings.
         */
        public function save()
        {
        }
    }
    // phpcs:disable Generic.Files.OneObjectStructurePerFile.MultipleFound, Generic.Commenting.Todo.CommentFound
    /**
     * WC_Settings_Rest_API class.
     *
     * @deprecated 3.4 in favour of WC_Settings_Advanced.
     */
    class WC_Settings_Rest_API extends \WC_Settings_Advanced
    {
    }
    /**
     * WC_Settings_Emails.
     */
    class WC_Settings_Emails extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Get settings array.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
        /**
         * Run the 'admin_options' method on a given email.
         * This method exists to easy unit testing.
         *
         * @param object $email The email object to run the method on.
         */
        protected function run_email_admin_options($email)
        {
        }
        /**
         * Save settings.
         */
        public function save()
        {
        }
        /**
         * Output email notification settings.
         */
        public function email_notification_setting()
        {
        }
    }
    /**
     * WC_Admin_Settings_General.
     */
    class WC_Settings_General extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get settings or the default section.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Output a color picker input box.
         *
         * @param mixed  $name Name of input.
         * @param string $id ID of input.
         * @param mixed  $value Value of input.
         * @param string $desc (default: '') Description for input.
         */
        public function color_picker($name, $id, $value, $desc = '')
        {
        }
    }
    /**
     * WC_Settings_Integrations.
     */
    class WC_Settings_Integrations extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Is WC_INSTALLING constant defined?
         * This method exists to ease unit testing.
         *
         * @return bool True is the WC_INSTALLING constant is defined.
         */
        protected function wc_is_installing()
        {
        }
        /**
         * Get the currently available integrations.
         * This method exists to ease unit testing.
         *
         * @return array Currently available integrations.
         */
        protected function get_integrations()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
    }
    /**
     * WC_Settings_Payment_Gateways.
     */
    class WC_Settings_Payment_Gateways extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Get settings array.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
        /**
         * Run the 'admin_options' method on a given gateway.
         * This method exists to easy unit testing.
         *
         * @param object $gateway The gateway object to run the method on.
         */
        protected function run_gateway_admin_options($gateway)
        {
        }
        /**
         * Creates the React mount point for the embedded banner.
         */
        public function payment_gateways_banner()
        {
        }
        /**
         * Output payment gateway settings.
         */
        public function payment_gateways_setting()
        {
        }
        /**
         * Save settings.
         */
        public function save()
        {
        }
    }
    /**
     * WC_Settings_Products.
     */
    class WC_Settings_Products extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Get settings for the default section.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Get settings for the inventory section.
         *
         * @return array
         */
        protected function get_settings_for_inventory_section()
        {
        }
        /**
         * Get settings for the downloadable section.
         *
         * @return array
         */
        protected function get_settings_for_downloadable_section()
        {
        }
        /**
         * Save settings and trigger the 'woocommerce_update_options_'.id action.
         */
        public function save()
        {
        }
    }
    /**
     * WC_Settings_Shipping.
     */
    class WC_Settings_Shipping extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Add this page to settings.
         *
         * @param array $pages Current pages.
         * @return array|mixed
         */
        public function add_settings_page($pages)
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Is WC_INSTALLING constant defined?
         * This method exists to ease unit testing.
         *
         * @return bool True is the WC_INSTALLING constant is defined.
         */
        protected function wc_is_installing()
        {
        }
        /**
         * Get the currently available shipping methods.
         * This method exists to ease unit testing.
         *
         * @return array Currently available shipping methods.
         */
        protected function get_shipping_methods()
        {
        }
        /**
         * Get settings for the default section.
         *
         * The original implementation of 'get_settings' was returning the settings for the "Options" section
         * when the supplied value for $current_section was ''.
         *
         * @return array
         */
        protected function get_settings_for_default_section()
        {
        }
        /**
         * Get settings for the options section.
         *
         * @return array
         */
        protected function get_settings_for_options_section()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
        /**
         * Save settings.
         */
        public function save()
        {
        }
        /**
         * Handles output of the shipping zones page in admin.
         */
        protected function output_zones_screen()
        {
        }
        /**
         * Get all available regions.
         *
         * @param int $allowed_countries Zone ID.
         * @param int $shipping_continents Zone ID.
         */
        protected function get_region_options($allowed_countries, $shipping_continents)
        {
        }
        /**
         * Show method for a zone
         *
         * @param int $zone_id Zone ID.
         */
        protected function zone_methods_screen($zone_id)
        {
        }
        /**
         * Show zones
         */
        protected function zones_screen()
        {
        }
        /**
         * Show instance settings
         *
         * @param int $instance_id Shipping instance ID.
         */
        protected function instance_settings_screen($instance_id)
        {
        }
        /**
         * Handles output of the shipping class settings screen.
         */
        protected function output_shipping_class_screen()
        {
        }
    }
    /**
     * WC_Settings_Tax.
     */
    class WC_Settings_Tax extends \WC_Settings_Page
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Creates the React mount point for the embedded banner.
         */
        public function conflict_error()
        {
        }
        /**
         * Add this page to settings.
         *
         * @param array $pages Existing pages.
         * @return array|mixed
         */
        public function add_settings_page($pages)
        {
        }
        /**
         * Get own sections.
         *
         * @return array
         */
        protected function get_own_sections()
        {
        }
        /**
         * Get settings array.
         *
         * @return array
         */
        public function get_settings_for_default_section()
        {
        }
        /**
         * Output the settings.
         */
        public function output()
        {
        }
        /**
         * Save settings.
         */
        public function save()
        {
        }
        /**
         * Saves tax classes defined in the textarea to the tax class table instead of an option.
         *
         * @param string $raw_tax_classes Posted value.
         * @return null
         */
        public function save_tax_classes($raw_tax_classes)
        {
        }
        /**
         * Output tax rate tables.
         */
        public function output_tax_rates()
        {
        }
        /**
         * Get tax class being edited.
         *
         * @return string
         */
        private static function get_current_tax_class()
        {
        }
        /**
         * Get a posted tax rate.
         *
         * @param string $key   Key of tax rate in the post data array.
         * @param int    $order Position/order of rate.
         * @param string $class Tax class for rate.
         * @return array
         */
        private function get_posted_tax_rate($key, $order, $class)
        {
        }
        /**
         * Save tax rates.
         */
        public function save_tax_rates()
        {
        }
    }
    /**
     * Blocks Utility class.
     */
    class WC_Blocks_Utils
    {
        /**
         * Get blocks from a woocommerce page.
         *
         * @param string $woo_page_name A woocommerce page e.g. `checkout` or `cart`.
         * @return array Array of blocks as returned by parse_blocks().
         */
        private static function get_all_blocks_from_page($woo_page_name)
        {
        }
        /**
         * Get all instances of the specified block on a specific woo page
         * (e.g. `cart` or `checkout` page).
         *
         * @param string $block_name The name (id) of a block, e.g. `woocommerce/cart`.
         * @param string $woo_page_name The woo page to search, e.g. `cart`.
         * @return array Array of blocks as returned by parse_blocks().
         */
        public static function get_blocks_from_page($block_name, $woo_page_name)
        {
        }
        /**
         * Check if a given page contains a particular block.
         *
         * @param int|WP_Post $page Page post ID or post object.
         * @param string      $block_name The name (id) of a block, e.g. `woocommerce/cart`.
         * @return bool Boolean value if the page contains the block or not. Null in case the page does not exist.
         */
        public static function has_block_in_page($page, $block_name)
        {
        }
    }
    /**
     * WC_Ajax class.
     */
    class WC_AJAX
    {
        /**
         * Hook in ajax handlers.
         */
        public static function init()
        {
        }
        /**
         * Get WC Ajax Endpoint.
         *
         * @param string $request Optional.
         *
         * @return string
         */
        public static function get_endpoint($request = '')
        {
        }
        /**
         * Set WC AJAX constant and headers.
         */
        public static function define_ajax()
        {
        }
        /**
         * Send headers for WC Ajax Requests.
         *
         * @since 2.5.0
         */
        private static function wc_ajax_headers()
        {
        }
        /**
         * Check for WC Ajax request and fire action.
         */
        public static function do_wc_ajax()
        {
        }
        /**
         * Hook in methods - uses WordPress ajax handlers (admin-ajax).
         */
        public static function add_ajax_events()
        {
        }
        /**
         * Get a refreshed cart fragment, including the mini cart HTML.
         */
        public static function get_refreshed_fragments()
        {
        }
        /**
         * AJAX apply coupon on checkout page.
         */
        public static function apply_coupon()
        {
        }
        /**
         * AJAX remove coupon on cart and checkout page.
         */
        public static function remove_coupon()
        {
        }
        /**
         * AJAX update shipping method on cart page.
         */
        public static function update_shipping_method()
        {
        }
        /**
         * AJAX receive updated cart_totals div.
         */
        public static function get_cart_totals()
        {
        }
        /**
         * Session has expired.
         */
        private static function update_order_review_expired()
        {
        }
        /**
         * AJAX update order review on checkout.
         */
        public static function update_order_review()
        {
        }
        /**
         * AJAX add to cart.
         */
        public static function add_to_cart()
        {
        }
        /**
         * AJAX remove from cart.
         */
        public static function remove_from_cart()
        {
        }
        /**
         * Process ajax checkout form.
         */
        public static function checkout()
        {
        }
        /**
         * Get a matching variation based on posted attributes.
         */
        public static function get_variation()
        {
        }
        /**
         * Locate user via AJAX.
         */
        public static function get_customer_location()
        {
        }
        /**
         * Toggle Featured status of a product from admin.
         */
        public static function feature_product()
        {
        }
        /**
         * Mark an order with a status.
         */
        public static function mark_order_status()
        {
        }
        /**
         * Get order details.
         */
        public static function get_order_details()
        {
        }
        /**
         * Add an attribute row.
         */
        public static function add_attribute()
        {
        }
        /**
         * Add a new attribute via ajax function.
         */
        public static function add_new_attribute()
        {
        }
        /**
         * Delete variations via ajax function.
         */
        public static function remove_variations()
        {
        }
        /**
         * Save attributes via ajax.
         */
        public static function save_attributes()
        {
        }
        /**
         * Save attributes and variations via ajax.
         */
        public static function add_attributes_and_variations()
        {
        }
        /**
         * Create product with attributes from POST data.
         *
         * @param  array $data Attribute data.
         * @return mixed Product class.
         */
        private static function create_product_with_attributes($data)
        {
        }
        /**
         * Create all product variations from existing attributes.
         *
         * @param mixed $product Product class.
         * @returns int Number of variations created.
         */
        private static function create_all_product_variations($product)
        {
        }
        /**
         * Add variation via ajax function.
         */
        public static function add_variation()
        {
        }
        /**
         * Link all variations via ajax function.
         */
        public static function link_all_variations()
        {
        }
        /**
         * Delete download permissions via ajax function.
         */
        public static function revoke_access_to_download()
        {
        }
        /**
         * Grant download permissions via ajax function.
         */
        public static function grant_access_to_download()
        {
        }
        /**
         * Get customer details via ajax.
         */
        public static function get_customer_details()
        {
        }
        /**
         * Add order item via ajax. Used on the edit order screen in WP Admin.
         *
         * @throws Exception If order is invalid.
         */
        public static function add_order_item()
        {
        }
        /**
         * Add order item via AJAX. This is refactored for better unit testing.
         *
         * @param int          $order_id     ID of order to add items to.
         * @param string|array $items        Existing items in order. Empty string if no items to add.
         * @param array        $items_to_add Array of items to add.
         *
         * @return array     Fragments to render and notes HTML.
         * @throws Exception When unable to add item.
         */
        private static function maybe_add_order_item($order_id, $items, $items_to_add)
        {
        }
        /**
         * Add order fee via ajax.
         *
         * @throws Exception If order is invalid.
         */
        public static function add_order_fee()
        {
        }
        /**
         * Add order shipping cost via ajax.
         *
         * @throws Exception If order is invalid.
         */
        public static function add_order_shipping()
        {
        }
        /**
         * Add order tax column via ajax.
         *
         * @throws Exception If order or tax rate is invalid.
         */
        public static function add_order_tax()
        {
        }
        /**
         * Add order discount via ajax.
         *
         * @throws Exception If order or coupon is invalid.
         */
        public static function add_coupon_discount()
        {
        }
        /**
         * Remove coupon from an order via ajax.
         *
         * @throws Exception If order or coupon is invalid.
         */
        public static function remove_order_coupon()
        {
        }
        /**
         * Remove an order item.
         *
         * @throws Exception If order is invalid.
         */
        public static function remove_order_item()
        {
        }
        /**
         * Remove an order tax.
         *
         * @throws Exception If there is an error whilst deleting the rate.
         */
        public static function remove_order_tax()
        {
        }
        /**
         * Calc line tax.
         */
        public static function calc_line_taxes()
        {
        }
        /**
         * Save order items via ajax.
         */
        public static function save_order_items()
        {
        }
        /**
         * Load order items via ajax.
         */
        public static function load_order_items()
        {
        }
        /**
         * Add order note via ajax.
         */
        public static function add_order_note()
        {
        }
        /**
         * Delete order note via ajax.
         */
        public static function delete_order_note()
        {
        }
        /**
         * Search for products and echo json.
         *
         * @param string $term (default: '') Term to search for.
         * @param bool   $include_variations in search or not.
         */
        public static function json_search_products($term = '', $include_variations = \false)
        {
        }
        /**
         * Search for product variations and return json.
         *
         * @see WC_AJAX::json_search_products()
         */
        public static function json_search_products_and_variations()
        {
        }
        /**
         * Search for downloadable product variations and return json.
         *
         * @see WC_AJAX::json_search_products()
         */
        public static function json_search_downloadable_products_and_variations()
        {
        }
        /**
         * Search for customers and return json.
         */
        public static function json_search_customers()
        {
        }
        /**
         * Search for categories and return json.
         */
        public static function json_search_categories()
        {
        }
        /**
         * Search for categories and return json.
         */
        public static function json_search_categories_tree()
        {
        }
        /**
         * Search for taxonomy terms and return json.
         */
        public static function json_search_taxonomy_terms()
        {
        }
        /**
         * Search for product attributes and return json.
         */
        public static function json_search_product_attributes()
        {
        }
        /**
         * Ajax request handling for page searching.
         */
        public static function json_search_pages()
        {
        }
        /**
         * Ajax request handling for categories ordering.
         */
        public static function term_ordering()
        {
        }
        /**
         * Ajax request handling for product ordering.
         *
         * Based on Simple Page Ordering by 10up (https://wordpress.org/plugins/simple-page-ordering/).
         */
        public static function product_ordering()
        {
        }
        /**
         * Handle a refund via the edit order screen.
         *
         * @throws Exception To return errors.
         */
        public static function refund_line_items()
        {
        }
        /**
         * Delete a refund.
         */
        public static function delete_refund()
        {
        }
        /**
         * Triggered when clicking the rating footer.
         */
        public static function rated()
        {
        }
        /**
         * Create/Update API key.
         *
         * @throws Exception On invalid or empty description, user, or permissions.
         */
        public static function update_api_key()
        {
        }
        /**
         * Load variations via AJAX.
         */
        public static function load_variations()
        {
        }
        /**
         * Save variations via AJAX.
         */
        public static function save_variations()
        {
        }
        /**
         * Bulk action - Toggle Enabled.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_toggle_enabled($variations, $data)
        {
        }
        /**
         * Bulk action - Toggle Downloadable Checkbox.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_toggle_downloadable($variations, $data)
        {
        }
        /**
         * Bulk action - Toggle Virtual Checkbox.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_toggle_virtual($variations, $data)
        {
        }
        /**
         * Bulk action - Toggle Manage Stock Checkbox.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_toggle_manage_stock($variations, $data)
        {
        }
        /**
         * Bulk action - Set Regular Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_regular_price($variations, $data)
        {
        }
        /**
         * Bulk action - Set Sale Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_sale_price($variations, $data)
        {
        }
        /**
         * Bulk action - Set Stock Status as In Stock.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_stock_status_instock($variations, $data)
        {
        }
        /**
         * Bulk action - Set Stock Status as Out of Stock.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_stock_status_outofstock($variations, $data)
        {
        }
        /**
         * Bulk action - Set Stock Status as On Backorder.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_stock_status_onbackorder($variations, $data)
        {
        }
        /**
         * Bulk action - Set Stock.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_stock($variations, $data)
        {
        }
        /**
         * Bulk action - Set Low Stock Amount.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_low_stock_amount($variations, $data)
        {
        }
        /**
         * Bulk action - Set Weight.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_weight($variations, $data)
        {
        }
        /**
         * Bulk action - Set Length.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_length($variations, $data)
        {
        }
        /**
         * Bulk action - Set Width.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_width($variations, $data)
        {
        }
        /**
         * Bulk action - Set Height.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_height($variations, $data)
        {
        }
        /**
         * Bulk action - Set Download Limit.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_download_limit($variations, $data)
        {
        }
        /**
         * Bulk action - Set Download Expiry.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_download_expiry($variations, $data)
        {
        }
        /**
         * Bulk action - Delete all.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_delete_all($variations, $data)
        {
        }
        /**
         * Bulk action - Sale Schedule.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_sale_schedule($variations, $data)
        {
        }
        /**
         * Bulk action - Increase Regular Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_regular_price_increase($variations, $data)
        {
        }
        /**
         * Bulk action - Decrease Regular Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_regular_price_decrease($variations, $data)
        {
        }
        /**
         * Bulk action - Increase Sale Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_sale_price_increase($variations, $data)
        {
        }
        /**
         * Bulk action - Decrease Sale Prices.
         *
         * @param array $variations List of variations.
         * @param array $data Data to set.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_action_variable_sale_price_decrease($variations, $data)
        {
        }
        /**
         * Bulk action - Set Price.
         *
         * @param array  $variations List of variations.
         * @param string $field price being adjusted _regular_price or _sale_price.
         * @param string $operator + or -.
         * @param string $value Price or Percent.
         *
         * @used-by bulk_edit_variations
         */
        private static function variation_bulk_adjust_price($variations, $field, $operator, $value)
        {
        }
        /**
         * Bulk set convenience function.
         *
         * @param array  $variations List of variations.
         * @param string $field Field to set.
         * @param string $value to set.
         */
        private static function variation_bulk_set($variations, $field, $value)
        {
        }
        /**
         * Bulk toggle convenience function.
         *
         * @param array  $variations List of variations.
         * @param string $field Field to toggle.
         */
        private static function variation_bulk_toggle($variations, $field)
        {
        }
        /**
         * Bulk edit variations via AJAX.
         *
         * @uses WC_AJAX::variation_bulk_set()
         * @uses WC_AJAX::variation_bulk_adjust_price()
         * @uses WC_AJAX::variation_bulk_action_variable_sale_price_decrease()
         * @uses WC_AJAX::variation_bulk_action_variable_sale_price_increase()
         * @uses WC_AJAX::variation_bulk_action_variable_regular_price_decrease()
         * @uses WC_AJAX::variation_bulk_action_variable_regular_price_increase()
         * @uses WC_AJAX::variation_bulk_action_variable_sale_schedule()
         * @uses WC_AJAX::variation_bulk_action_delete_all()
         * @uses WC_AJAX::variation_bulk_action_variable_download_expiry()
         * @uses WC_AJAX::variation_bulk_action_variable_download_limit()
         * @uses WC_AJAX::variation_bulk_action_variable_height()
         * @uses WC_AJAX::variation_bulk_action_variable_width()
         * @uses WC_AJAX::variation_bulk_action_variable_length()
         * @uses WC_AJAX::variation_bulk_action_variable_weight()
         * @uses WC_AJAX::variation_bulk_action_variable_stock()
         * @uses WC_AJAX::variation_bulk_action_variable_sale_price()
         * @uses WC_AJAX::variation_bulk_action_variable_regular_price()
         * @uses WC_AJAX::variation_bulk_action_toggle_manage_stock()
         * @uses WC_AJAX::variation_bulk_action_toggle_virtual()
         * @uses WC_AJAX::variation_bulk_action_toggle_downloadable()
         * @uses WC_AJAX::variation_bulk_action_toggle_enabled
         * @uses WC_AJAX::variation_bulk_action_variable_low_stock_amount()
         */
        public static function bulk_edit_variations()
        {
        }
        /**
         * Handle submissions from assets/js/settings-views-html-settings-tax.js Backbone model.
         */
        public static function tax_rates_save_changes()
        {
        }
        /**
         * Handle submissions from assets/js/wc-shipping-zones.js Backbone model.
         */
        public static function shipping_zones_save_changes()
        {
        }
        /**
         * Handle submissions from assets/js/wc-shipping-zone-methods.js Backbone model.
         */
        public static function shipping_zone_add_method()
        {
        }
        /**
         * Handle submissions from assets/js/wc-shipping-zone-methods.js Backbone model.
         */
        public static function shipping_zone_remove_method()
        {
        }
        /**
         * Handle submissions from assets/js/wc-shipping-zone-methods.js Backbone model.
         */
        public static function shipping_zone_methods_save_changes()
        {
        }
        /**
         * Save method settings
         */
        public static function shipping_zone_methods_save_settings()
        {
        }
        /**
         * Handle submissions from assets/js/wc-shipping-classes.js Backbone model.
         */
        public static function shipping_classes_save_changes()
        {
        }
        /**
         * Toggle payment gateway on or off via AJAX.
         *
         * @since 3.4.0
         */
        public static function toggle_gateway_enabled()
        {
        }
        /**
         * Reimplementation of WP core's `wp_ajax_add_meta` method to support order custom meta updates with custom tables.
         */
        private static function order_add_meta()
        {
        }
        /**
         * Reimplementation of WP core's `wp_ajax_delete_meta` method to support order custom meta updates with custom tables.
         *
         * @return void
         */
        private static function order_delete_meta() : void
        {
        }
        /**
         * Hooked to 'heartbeat_received' on the edit order page to refresh the lock on an order being edited by the current user.
         *
         * @param array $response The heartbeat response to be sent.
         * @param array $data     Data sent through the heartbeat.
         * @return array Response to be sent.
         */
        private static function order_refresh_lock($response, $data)
        {
        }
        /**
         * Hooked to 'heartbeat_received' on the orders screen to refresh the locked status of orders in the list table.
         *
         * @since 7.8.0
         *
         * @param array $response The heartbeat response to be sent.
         * @param array $data     Data sent through the heartbeat.
         * @return array Response to be sent.
         */
        private static function check_locked_orders($response, $data)
        {
        }
    }
    /**
     * Legacy API.
     */
    class WC_Legacy_API
    {
        use \Automattic\WooCommerce\Internal\Traits\AccessiblePrivateMethods;
        /**
         * This is the major version for the REST API and takes
         * first-order position in endpoint URLs.
         *
         * @deprecated 2.6.0
         * @var string
         */
        const VERSION = '3.1.0';
        /**
         * The REST API server.
         *
         * @deprecated 2.6.0
         * @var WC_API_Server
         */
        public $server;
        /**
         * REST API authentication class instance.
         *
         * @deprecated 2.6.0
         * @var WC_API_Authentication
         */
        public $authentication;
        /**
         * Init the legacy API.
         */
        public function init()
        {
        }
        /**
         * Add new query vars.
         *
         * @since 2.0
         * @param array $vars Vars.
         * @return string[]
         */
        public function add_query_vars($vars)
        {
        }
        /**
         * Write a log entry and update the last usage options, for a Legacy REST API request.
         *
         * @param string      $route The Legacy REST API route requested.
         * @param string|null $user_agent The content of the user agent HTTP header in the request, null if not available.
         */
        private function maybe_log_rest_api_request(string $route, ?string $user_agent)
        {
        }
        /**
         * Add new endpoints.
         *
         * @since 2.0
         */
        public static function add_endpoint()
        {
        }
        /**
         * Handle REST API requests.
         *
         * @since 2.2
         * @deprecated 2.6.0
         */
        public function handle_rest_api_requests()
        {
        }
        /**
         * Display an admin notice with information about the last Legacy REST API usage,
         * if the corresponding transient is available and unless the Legacy REST API
         * extension is installed or the user has dismissed the notice.
         */
        private function maybe_display_legacy_wc_api_usage_notice() : void
        {
        }
        /**
         * Include required files for REST API request.
         *
         * @since 2.1
         * @deprecated 2.6.0
         */
        public function includes()
        {
        }
        /**
         * Register available API resources.
         *
         * @since 2.1
         * @deprecated 2.6.0
         * @param WC_API_Server $server the REST server.
         */
        public function register_resources($server)
        {
        }
        /**
         * Handle legacy v1 REST API requests.
         *
         * @since 2.2
         * @deprecated 2.6.0
         */
        private function handle_v1_rest_api_request()
        {
        }
        /**
         * Handle legacy v2 REST API requests.
         *
         * @since 2.4
         * @deprecated 2.6.0
         */
        private function handle_v2_rest_api_request()
        {
        }
        /**
         * Rest API Init.
         *
         * @deprecated 3.7.0 - REST API classes autoload.
         */
        public function rest_api_init()
        {
        }
        /**
         * Include REST API classes.
         *
         * @deprecated 3.7.0 - REST API classes autoload.
         */
        public function rest_api_includes()
        {
        }
        /**
         * Register REST API routes.
         *
         * @deprecated 3.7.0
         */
        public function register_rest_routes()
        {
        }
    }
    /**
     * WC_API class.
     */
    class WC_API extends \WC_Legacy_API
    {
        /**
         * Init the API by setting up action and filter hooks.
         */
        public function init()
        {
        }
        /**
         * Get the version of the REST API package being ran. Since API package was merged into core, this now follows WC version.
         *
         * @since 3.7.0
         * @return string|null
         */
        public function get_rest_api_package_version()
        {
        }
        /**
         * Get the version of the REST API package being ran.
         *
         * @since 3.7.0
         * @return string
         */
        public function get_rest_api_package_path()
        {
        }
        /**
         * Return if the rest API classes were already loaded.
         *
         * @since 3.7.0
         * @return boolean
         */
        protected function is_rest_api_loaded()
        {
        }
        /**
         * Get data from a WooCommerce API endpoint.
         *
         * @since 3.7.0
         * @param string $endpoint Endpoint.
         * @param array  $params Params to pass with request.
         * @return array|\WP_Error
         */
        public function get_endpoint_data($endpoint, $params = array())
        {
        }
        /**
         * Add new query vars.
         *
         * @since 2.0
         * @param array $vars Query vars.
         * @return string[]
         */
        public function add_query_vars($vars)
        {
        }
        /**
         * WC API for payment gateway IPNs, etc.
         *
         * @since 2.0
         */
        public static function add_endpoint()
        {
        }
        /**
         * API request - Trigger any API requests.
         *
         * @since   2.0
         * @version 2.4
         */
        public function handle_api_requests()
        {
        }
        /**
         * Register WC settings from WP-API to the REST API.
         *
         * @since  3.0.0
         */
        public function register_wp_admin_settings()
        {
        }
    }
    /**
     * Auth class.
     */
    class WC_Auth
    {
        /**
         * Version.
         *
         * @var int
         */
        const VERSION = 1;
        /**
         * Setup class.
         *
         * @since 2.4.0
         */
        public function __construct()
        {
        }
        /**
         * Add query vars.
         *
         * @since  2.4.0
         * @param  array $vars Query variables.
         * @return string[]
         */
        public function add_query_vars($vars)
        {
        }
        /**
         * Add auth endpoint.
         *
         * @since 2.4.0
         */
        public static function add_endpoint()
        {
        }
        /**
         * Get scope name.
         *
         * @since 2.4.0
         * @param  string $scope Permission scope.
         * @return string
         */
        protected function get_i18n_scope($scope)
        {
        }
        /**
         * Return a list of permissions a scope allows.
         *
         * @since  2.4.0
         * @param  string $scope Permission scope.
         * @return array
         */
        protected function get_permissions_in_scope($scope)
        {
        }
        /**
         * Build auth urls.
         *
         * @since  2.4.0
         * @param  array  $data     Data to build URL.
         * @param  string $endpoint Endpoint.
         * @return string
         */
        protected function build_url($data, $endpoint)
        {
        }
        /**
         * Decode and format a URL.
         *
         * @param  string $url URL.
         * @return string
         */
        protected function get_formatted_url($url)
        {
        }
        /**
         * Make validation.
         *
         * @since  2.4.0
         * @throws Exception When validate fails.
         */
        protected function make_validation()
        {
        }
        /**
         * Create keys.
         *
         * @since  2.4.0
         *
         * @param  string $app_name    App name.
         * @param  string $app_user_id User ID.
         * @param  string $scope       Scope.
         *
         * @return array
         */
        protected function create_keys($app_name, $app_user_id, $scope)
        {
        }
        /**
         * Post consumer data.
         *
         * @since  2.4.0
         *
         * @throws Exception When validation fails.
         * @param  array  $consumer_data Consumer data.
         * @param  string $url           URL.
         * @return bool
         */
        protected function post_consumer_data($consumer_data, $url)
        {
        }
        /**
         * Handle auth requests.
         *
         * @since 2.4.0
         * @throws Exception When auth_endpoint validation fails.
         */
        public function handle_auth_requests()
        {
        }
        /**
         * Auth endpoint.
         *
         * @since 2.4.0
         * @throws Exception When validation fails.
         * @param string $route Route.
         */
        protected function auth_endpoint($route)
        {
        }
        /**
         * Maybe delete key.
         *
         * @since 2.4.0
         *
         * @param array $key Key.
         */
        private function maybe_delete_key($key)
        {
        }
    }
    /**
     * Autoloader class.
     */
    class WC_Autoloader
    {
        /**
         * Path to the includes directory.
         *
         * @var string
         */
        private $include_path = '';
        /**
         * The Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Take a class name and turn it into a file name.
         *
         * @param  string $class Class name.
         * @return string
         */
        private function get_file_name_from_class($class)
        {
        }
        /**
         * Include a class file.
         *
         * @param  string $path File path.
         * @return bool Successful or not.
         */
        private function load_file($path)
        {
        }
        /**
         * Auto-load WC classes on demand to reduce memory consumption.
         *
         * @param string $class Class name.
         */
        public function autoload($class)
        {
        }
    }
    /**
     * WC_Background_Emailer Class.
     */
    class WC_Background_Emailer extends \WC_Background_Process
    {
        /**
         * Initiate new background process.
         */
        public function __construct()
        {
        }
        /**
         * Schedule fallback event.
         */
        protected function schedule_event()
        {
        }
        /**
         * Task
         *
         * Override this method to perform any actions required on each
         * queue item. Return the modified item for further processing
         * in the next pass through. Or, return false to remove the
         * item from the queue.
         *
         * @param array $callback Update callback function.
         * @return mixed
         */
        protected function task($callback)
        {
        }
        /**
         * Finishes replying to the client, but keeps the process running for further (async) code execution.
         *
         * @see https://core.trac.wordpress.org/ticket/41358 .
         */
        protected function close_http_connection()
        {
        }
        /**
         * Save and run queue.
         */
        public function dispatch_queue()
        {
        }
        /**
         * Get post args
         *
         * @return array
         */
        protected function get_post_args()
        {
        }
        /**
         * Handle
         *
         * Pass each queue item to the task handler, while remaining
         * within server memory and time limit constraints.
         */
        protected function handle()
        {
        }
    }
    /**
     * WC_Background_Updater Class.
     */
    class WC_Background_Updater extends \WC_Background_Process
    {
        /**
         * Initiate new background process.
         */
        public function __construct()
        {
        }
        /**
         * Dispatch updater.
         *
         * Updater will still run via cron job if this fails for any reason.
         */
        public function dispatch()
        {
        }
        /**
         * Handle cron healthcheck
         *
         * Restart the background process if not already running
         * and data exists in the queue.
         */
        public function handle_cron_healthcheck()
        {
        }
        /**
         * Schedule fallback event.
         */
        protected function schedule_event()
        {
        }
        /**
         * Is the updater running?
         *
         * @return boolean
         */
        public function is_updating()
        {
        }
        /**
         * Task
         *
         * Override this method to perform any actions required on each
         * queue item. Return the modified item for further processing
         * in the next pass through. Or, return false to remove the
         * item from the queue.
         *
         * @param string $callback Update callback function.
         * @return string|bool
         */
        protected function task($callback)
        {
        }
        /**
         * Complete
         *
         * Override if applicable, but ensure that the below actions are
         * performed, or, call parent::complete().
         */
        protected function complete()
        {
        }
        /**
         * See if the batch limit has been exceeded.
         *
         * @return bool
         */
        public function is_memory_exceeded()
        {
        }
    }
    /**
     * Breadcrumb class.
     */
    class WC_Breadcrumb
    {
        /**
         * Breadcrumb trail.
         *
         * @var array
         */
        protected $crumbs = array();
        /**
         * Add a crumb so we don't get lost.
         *
         * @param string $name Name.
         * @param string $link Link.
         */
        public function add_crumb($name, $link = '')
        {
        }
        /**
         * Reset crumbs.
         */
        public function reset()
        {
        }
        /**
         * Get the breadcrumb.
         *
         * @return array
         */
        public function get_breadcrumb()
        {
        }
        /**
         * Generate breadcrumb trail.
         *
         * @return array of breadcrumbs
         */
        public function generate()
        {
        }
        /**
         * Prepend the shop page to shop breadcrumbs.
         */
        protected function prepend_shop_page()
        {
        }
        /**
         * Is home trail..
         */
        protected function add_crumbs_home()
        {
        }
        /**
         * 404 trail.
         */
        protected function add_crumbs_404()
        {
        }
        /**
         * Attachment trail.
         */
        protected function add_crumbs_attachment()
        {
        }
        /**
         * Single post trail.
         *
         * @param int    $post_id   Post ID.
         * @param string $permalink Post permalink.
         */
        protected function add_crumbs_single($post_id = 0, $permalink = '')
        {
        }
        /**
         * Page trail.
         */
        protected function add_crumbs_page()
        {
        }
        /**
         * Product category trail.
         */
        protected function add_crumbs_product_category()
        {
        }
        /**
         * Product tag trail.
         */
        protected function add_crumbs_product_tag()
        {
        }
        /**
         * Shop breadcrumb.
         */
        protected function add_crumbs_shop()
        {
        }
        /**
         * Post type archive trail.
         */
        protected function add_crumbs_post_type_archive()
        {
        }
        /**
         * Category trail.
         */
        protected function add_crumbs_category()
        {
        }
        /**
         * Tag trail.
         */
        protected function add_crumbs_tag()
        {
        }
        /**
         * Add crumbs for date based archives.
         */
        protected function add_crumbs_date()
        {
        }
        /**
         * Add crumbs for taxonomies
         */
        protected function add_crumbs_tax()
        {
        }
        /**
         * Add a breadcrumb for author archives.
         */
        protected function add_crumbs_author()
        {
        }
        /**
         * Add crumbs for a term.
         *
         * @param int    $term_id  Term ID.
         * @param string $taxonomy Taxonomy.
         */
        protected function term_ancestors($term_id, $taxonomy)
        {
        }
        /**
         * Endpoints.
         */
        protected function endpoint_trail()
        {
        }
        /**
         * Add a breadcrumb for search results.
         */
        protected function search_trail()
        {
        }
        /**
         * Add a breadcrumb for pagination.
         */
        protected function paged_trail()
        {
        }
    }
}
namespace Automattic\WooCommerce\Caching {
    /**
     * Implements namespacing algorithm to simulate grouping and namespacing for wp_cache, memcache and other caching engines that don't support grouping natively.
     *
     * See the algorithm details here: https://github.com/memcached/memcached/wiki/ProgrammingTricks#namespacing.
     *
     * To use the namespacing algorithm in the CacheEngine class:
     * 1. Use a group string to identify all objects of a type.
     * 2. Before setting cache, prefix the cache key by using the `get_cache_prefix`.
     * 3. Use `invalidate_cache_group` function to invalidate all caches in entire group at once.
     */
    trait CacheNameSpaceTrait
    {
        /**
         * Get prefix for use with wp_cache_set. Allows all cache in a group to be invalidated at once.
         *
         * @param  string $group Group of cache to get.
         * @return string Prefix.
         */
        public static function get_cache_prefix($group)
        {
        }
        /**
         * Increment group cache prefix (invalidates cache).
         *
         * @param string $group Group of cache to clear.
         */
        public static function incr_cache_prefix($group)
        {
        }
        /**
         * Invalidate cache group.
         *
         * @param string $group Group of cache to clear.
         * @since 3.9.0
         */
        public static function invalidate_cache_group($group)
        {
        }
        /**
         * Helper method to get prefixed key.
         *
         * @param  string $key   Key to prefix.
         * @param  string $group Group of cache to get.
         *
         * @return string Prefixed key.
         */
        public static function get_prefixed_key($key, $group)
        {
        }
    }
}
namespace {
    /**
     * WC_Cache_Helper.
     */
    class WC_Cache_Helper
    {
        use \Automattic\WooCommerce\Caching\CacheNameSpaceTrait;
        /**
         * Transients to delete on shutdown.
         *
         * @var array Array of transient keys.
         */
        private static $delete_transients = array();
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Set additional nocache headers.
         *
         * @param array $headers Header names and field values.
         * @since 3.6.0
         */
        public static function additional_nocache_headers($headers)
        {
        }
        /**
         * Add a transient to delete on shutdown.
         *
         * @since 3.6.0
         * @param string|array $keys Transient key or keys.
         */
        public static function queue_delete_transient($keys)
        {
        }
        /**
         * Transients that don't need to be cleaned right away can be deleted on shutdown to avoid repetition.
         *
         * @since 3.6.0
         */
        public static function delete_transients_on_shutdown()
        {
        }
        /**
         * Used to clear layered nav counts based on passed attribute names.
         *
         * @since 3.6.0
         * @param array $attribute_keys Attribute keys.
         */
        public static function invalidate_attribute_count($attribute_keys)
        {
        }
        /**
         * Get a hash of the customer location.
         *
         * @return string
         */
        public static function geolocation_ajax_get_location_hash()
        {
        }
        /**
         * Prevent caching on certain pages
         */
        public static function prevent_caching()
        {
        }
        /**
         * When using geolocation via ajax, to bust cache, redirect if the location hash does not equal the querystring.
         *
         * This prevents caching of the wrong data for this request.
         */
        public static function geolocation_ajax_redirect()
        {
        }
        /**
         * Updates the `woocommerce_geo_hash` cookie, which is used to help ensure we display
         * the correct pricing etc to customers, according to their billing country.
         *
         * Note that:
         *
         * A) This only sets the cookie if the default customer address is set to "Geolocate (with
         *    Page Caching Support)".
         *
         * B) It is hooked into the `wc_ajax_update_order_review` action, which has the benefit of
         *    ensuring we update the cookie any time the billing country is changed.
         */
        public static function update_geolocation_hash()
        {
        }
        /**
         * Get transient version.
         *
         * When using transients with unpredictable names, e.g. those containing an md5
         * hash in the name, we need a way to invalidate them all at once.
         *
         * When using default WP transients we're able to do this with a DB query to
         * delete transients manually.
         *
         * With external cache however, this isn't possible. Instead, this function is used
         * to append a unique string (based on time()) to each transient. When transients
         * are invalidated, the transient version will increment and data will be regenerated.
         *
         * Raised in issue https://github.com/woocommerce/woocommerce/issues/5777.
         * Adapted from ideas in http://tollmanz.com/invalidation-schemes/.
         *
         * @param  string  $group   Name for the group of transients we need to invalidate.
         * @param  boolean $refresh true to force a new version.
         * @return string transient version based on time(), 10 digits.
         */
        public static function get_transient_version($group, $refresh = \false)
        {
        }
        /**
         * Set constants to prevent caching by some plugins.
         *
         * @param  mixed $return Value to return. Previously hooked into a filter.
         * @return mixed
         */
        public static function set_nocache_constants($return = \true)
        {
        }
        /**
         * Notices function.
         */
        public static function notices()
        {
        }
        /**
         * Clean term caches added by WooCommerce.
         *
         * @since 3.3.4
         * @param array|int $ids Array of ids or single ID to clear cache for.
         * @param string    $taxonomy Taxonomy name.
         */
        public static function clean_term_cache($ids, $taxonomy)
        {
        }
        /**
         * When the transient version increases, this is used to remove all past transients to avoid filling the DB.
         *
         * Note; this only works on transients appended with the transient version, and when object caching is not being used.
         *
         * @deprecated 3.6.0 Adjusted transient usage to include versions within the transient values, making this cleanup obsolete.
         * @since  2.3.10
         * @param string $version Version of the transient to remove.
         */
        public static function delete_version_transients($version = '')
        {
        }
    }
    /**
     * WC_Cart_Fees class.
     *
     * @since 3.2.0
     */
    final class WC_Cart_Fees
    {
        /**
         * An array of fee objects.
         *
         * @var object[]
         */
        private $fees = array();
        /**
         * New fees are made out of these props.
         *
         * @var array
         */
        private $default_fee_props = array('id' => '', 'name' => '', 'tax_class' => '', 'taxable' => \false, 'amount' => 0, 'total' => 0);
        /**
         * Constructor. Reference to the cart.
         *
         * @param null $deprecated Deprecated since WooCommerce 8.2.0.
         *
         * @since 3.2.0
         */
        public function __construct($deprecated = \null)
        {
        }
        /**
         * Register methods for this object on the appropriate WordPress hooks.
         */
        public function init()
        {
        }
        /**
         * Add a fee. Fee IDs must be unique.
         *
         * @since 3.2.0
         * @param array $args Array of fee properties.
         * @return object Either a fee object if added, or a WP_Error if it failed.
         */
        public function add_fee($args = array())
        {
        }
        /**
         * Get fees.
         *
         * @return array
         */
        public function get_fees()
        {
        }
        /**
         * Set fees.
         *
         * @param object[] $raw_fees Array of fees.
         */
        public function set_fees($raw_fees = array())
        {
        }
        /**
         * Remove all fees.
         *
         * @since 3.2.0
         */
        public function remove_all_fees()
        {
        }
        /**
         * Sort fees by amount.
         *
         * @param stdClass $a Fee object.
         * @param stdClass $b Fee object.
         * @return int
         */
        protected function sort_fees_callback($a, $b)
        {
        }
        /**
         * Generate a unique ID for the fee being added.
         *
         * @param string $fee Fee object.
         * @return string fee key.
         */
        private function generate_id($fee)
        {
        }
    }
    /**
     * WC_Cart_Session class.
     *
     * @since 3.2.0
     */
    final class WC_Cart_Session
    {
        /**
         * Reference to cart object.
         *
         * @since 3.2.0
         * @var WC_Cart
         */
        protected $cart;
        /**
         * Sets up the items provided, and calculate totals.
         *
         * @since 3.2.0
         * @throws Exception If missing WC_Cart object.
         *
         * @param WC_Cart $cart Cart object to calculate totals for.
         */
        public function __construct($cart)
        {
        }
        /**
         * Sets the cart instance.
         *
         * @param WC_Cart $cart Cart object.
         */
        public function set_cart(\WC_Cart $cart)
        {
        }
        /**
         * Register methods for this object on the appropriate WordPress hooks.
         */
        public function init()
        {
        }
        /**
         * Get the cart data from the PHP session and store it in class variables.
         *
         * @since 3.2.0
         */
        public function get_cart_from_session()
        {
        }
        /**
         * Destroy cart session data.
         *
         * @since 3.2.0
         */
        public function destroy_cart_session()
        {
        }
        /**
         * Will set cart cookies if needed and when possible.
         *
         * Headers are only updated if headers have not yet been sent.
         *
         * @since 3.2.0
         */
        public function maybe_set_cart_cookies()
        {
        }
        /**
         * Remove duplicate cookies from the response.
         */
        private function dedupe_cookies()
        {
        }
        /**
         * Find a cookie by name in an array of cookies.
         *
         * @param  string $cookie_name Name of the cookie to find.
         * @param  array  $cookies     Array of cookies to search.
         * @return mixed               Key of the cookie if found, false if not.
         */
        private function find_cookie_by_name($cookie_name, $cookies)
        {
        }
        /**
         * Sets the php session data for the cart and coupons.
         */
        public function set_session()
        {
        }
        /**
         * Returns the contents of the cart in an array without the 'data' element.
         *
         * @return array contents of the cart
         */
        public function get_cart_for_session()
        {
        }
        /**
         * Save the persistent cart when the cart is updated.
         */
        public function persistent_cart_update()
        {
        }
        /**
         * Delete the persistent cart permanently.
         */
        public function persistent_cart_destroy()
        {
        }
        /**
         * Set cart hash cookie and items in cart if not already set.
         *
         * @param bool $set Should cookies be set (true) or unset.
         */
        private function set_cart_cookies($set = \true)
        {
        }
        /**
         * Get the persistent cart from the database.
         *
         * @since  3.5.0
         * @return array
         */
        private function get_saved_cart()
        {
        }
        /**
         * Get a cart from an order, if user has permission.
         *
         * @since  3.5.0
         *
         * @param int   $order_id Order ID to try to load.
         * @param array $cart Current cart array.
         *
         * @return array
         */
        private function populate_cart_from_order($order_id, $cart)
        {
        }
    }
    /**
     * WC_Cart_Totals class.
     *
     * @since 3.2.0
     */
    final class WC_Cart_Totals
    {
        use \WC_Item_Totals;
        /**
         * Reference to cart object.
         *
         * @since 3.2.0
         * @var WC_Cart
         */
        protected $cart;
        /**
         * Reference to customer object.
         *
         * @since 3.2.0
         * @var array
         */
        protected $customer;
        /**
         * Line items to calculate.
         *
         * @since 3.2.0
         * @var array
         */
        protected $items = array();
        /**
         * Fees to calculate.
         *
         * @since 3.2.0
         * @var array
         */
        protected $fees = array();
        /**
         * Shipping costs.
         *
         * @since 3.2.0
         * @var array
         */
        protected $shipping = array();
        /**
         * Applied coupon objects.
         *
         * @since 3.2.0
         * @var array
         */
        protected $coupons = array();
        /**
         * Item/coupon discount totals.
         *
         * @since 3.2.0
         * @var array
         */
        protected $coupon_discount_totals = array();
        /**
         * Item/coupon discount tax totals.
         *
         * @since 3.2.0
         * @var array
         */
        protected $coupon_discount_tax_totals = array();
        /**
         * Should taxes be calculated?
         *
         * @var boolean
         */
        protected $calculate_tax = \true;
        /**
         * Stores totals.
         *
         * @since 3.2.0
         * @var array
         */
        protected $totals = array('fees_total' => 0, 'fees_total_tax' => 0, 'items_subtotal' => 0, 'items_subtotal_tax' => 0, 'items_total' => 0, 'items_total_tax' => 0, 'total' => 0, 'shipping_total' => 0, 'shipping_tax_total' => 0, 'discounts_total' => 0);
        /**
         * Cache of tax rates for a given tax class.
         *
         * @var array
         */
        protected $item_tax_rates;
        /**
         * Sets up the items provided, and calculate totals.
         *
         * @since 3.2.0
         * @throws Exception If missing WC_Cart object.
         * @param WC_Cart $cart Cart object to calculate totals for.
         */
        public function __construct(&$cart = \null)
        {
        }
        /**
         * Run all calculation methods on the given items in sequence.
         *
         * @since 3.2.0
         */
        protected function calculate()
        {
        }
        /**
         * Get default blank set of props used per item.
         *
         * @since  3.2.0
         * @return array
         */
        protected function get_default_item_props()
        {
        }
        /**
         * Get default blank set of props used per fee.
         *
         * @since  3.2.0
         * @return array
         */
        protected function get_default_fee_props()
        {
        }
        /**
         * Get default blank set of props used per shipping row.
         *
         * @since  3.2.0
         * @return array
         */
        protected function get_default_shipping_props()
        {
        }
        /**
         * Handles a cart or order object passed in for calculation. Normalises data
         * into the same format for use by this class.
         *
         * Each item is made up of the following props, in addition to those returned by get_default_item_props() for totals.
         *  - key: An identifier for the item (cart item key or line item ID).
         *  - cart_item: For carts, the cart item from the cart which may include custom data.
         *  - quantity: The qty for this line.
         *  - price: The line price in cents.
         *  - product: The product object this cart item is for.
         *
         * @since 3.2.0
         */
        protected function get_items_from_cart()
        {
        }
        /**
         * Get item costs grouped by tax class.
         *
         * @since  3.2.0
         * @return array
         */
        protected function get_tax_class_costs()
        {
        }
        /**
         * Get fee objects from the cart. Normalises data
         * into the same format for use by this class.
         *
         * @since 3.2.0
         */
        protected function get_fees_from_cart()
        {
        }
        /**
         * Get shipping methods from the cart and normalise.
         *
         * @since 3.2.0
         */
        protected function get_shipping_from_cart()
        {
        }
        /**
         * Return array of coupon objects from the cart. Normalises data
         * into the same format for use by this class.
         *
         * @since  3.2.0
         */
        protected function get_coupons_from_cart()
        {
        }
        /**
         * Sort coupons so discounts apply consistently across installs.
         *
         * In order of priority;
         *  - sort param
         *  - usage restriction
         *  - coupon value
         *  - ID
         *
         * @param WC_Coupon $a Coupon object.
         * @param WC_Coupon $b Coupon object.
         * @return int
         */
        protected function sort_coupons_callback($a, $b)
        {
        }
        /**
         * Ran to remove all base taxes from an item. Used when prices include tax, and the customer is tax exempt.
         *
         * @since 3.2.2
         * @param object $item Item to adjust the prices of.
         * @return object
         */
        protected function remove_item_base_taxes($item)
        {
        }
        /**
         * Only ran if woocommerce_adjust_non_base_location_prices is true.
         *
         * If the customer is outside of the base location, this removes the base
         * taxes. This is off by default unless the filter is used.
         *
         * Uses edit context so unfiltered tax class is returned.
         *
         * @since 3.2.0
         * @param object $item Item to adjust the prices of.
         * @return object
         */
        protected function adjust_non_base_location_price($item)
        {
        }
        /**
         * Get discounted price of an item with precision (in cents).
         *
         * @since  3.2.0
         * @param  object $item_key Item to get the price of.
         * @return int
         */
        protected function get_discounted_price_in_cents($item_key)
        {
        }
        /**
         * Get tax rates for an item. Caches rates in class to avoid multiple look ups.
         *
         * @param  object $item Item to get tax rates for.
         * @return array of taxes
         */
        protected function get_item_tax_rates($item)
        {
        }
        /**
         * Get item costs grouped by tax class.
         *
         * @since  3.2.0
         * @return array
         */
        protected function get_item_costs_by_tax_class()
        {
        }
        /**
         * Get a single total with or without precision (in cents).
         *
         * @since  3.2.0
         * @param  string $key Total to get.
         * @param  bool   $in_cents Should the totals be returned in cents, or without precision.
         * @return int|float
         */
        public function get_total($key = 'total', $in_cents = \false)
        {
        }
        /**
         * Set a single total.
         *
         * @since  3.2.0
         * @param string $key Total name you want to set.
         * @param int    $total Total to set.
         */
        protected function set_total($key, $total)
        {
        }
        /**
         * Get all totals with or without precision (in cents).
         *
         * @since  3.2.0
         * @param  bool $in_cents Should the totals be returned in cents, or without precision.
         * @return array.
         */
        public function get_totals($in_cents = \false)
        {
        }
        /**
         * Returns array of values for totals calculation.
         *
         * @param string $field Field name. Will probably be `total` or `subtotal`.
         * @return array Items object
         */
        protected function get_values_for_total($field)
        {
        }
        /**
         * Get taxes merged by type.
         *
         * @since 3.2.0
         * @param  bool         $in_cents If returned value should be in cents.
         * @param  array|string $types    Types to merge and return. Defaults to all.
         * @return array
         */
        protected function get_merged_taxes($in_cents = \false, $types = array('items', 'fees', 'shipping'))
        {
        }
        /**
         * Round merged taxes.
         *
         * @deprecated 3.9.0 `calculate_item_subtotals` should already appropriately round the tax values.
         * @since 3.5.4
         * @param array $taxes Taxes to round.
         * @return array
         */
        protected function round_merged_taxes($taxes)
        {
        }
        /**
         * Combine item taxes into a single array, preserving keys.
         *
         * @since 3.2.0
         * @param array $item_taxes Taxes to combine.
         * @return array
         */
        protected function combine_item_taxes($item_taxes)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Calculation methods.
        |--------------------------------------------------------------------------
        */
        /**
         * Calculate item totals.
         *
         * @since 3.2.0
         */
        protected function calculate_item_totals()
        {
        }
        /**
         * Subtotals are costs before discounts.
         *
         * To prevent rounding issues we need to work with the inclusive price where possible
         * otherwise we'll see errors such as when working with a 9.99 inc price, 20% VAT which would
         * be 8.325 leading to totals being 1p off.
         *
         * Pre tax coupons come off the price the customer thinks they are paying - tax is calculated
         * afterwards.
         *
         * e.g. $100 bike with $10 coupon = customer pays $90 and tax worked backwards from that.
         *
         * @since 3.2.0
         */
        protected function calculate_item_subtotals()
        {
        }
        /**
         * Calculate COUPON based discounts which change item prices.
         *
         * @since 3.2.0
         * @uses  WC_Discounts class.
         */
        protected function calculate_discounts()
        {
        }
        /**
         * Triggers the cart fees API, grabs the list of fees, and calculates taxes.
         *
         * Note: This class sets the totals for the 'object' as they are calculated. This is so that APIs like the fees API can see these totals if needed.
         *
         * @since 3.2.0
         */
        protected function calculate_fee_totals()
        {
        }
        /**
         * Calculate any shipping taxes.
         *
         * @since 3.2.0
         */
        protected function calculate_shipping_totals()
        {
        }
        /**
         * Main cart totals.
         *
         * @since 3.2.0
         */
        protected function calculate_totals()
        {
        }
    }
    /**
     * Legacy cart class.
     */
    #[\AllowDynamicProperties]
    abstract class WC_Legacy_Cart
    {
        /**
         * Array of defaults. Not used since 3.2.
         *
         * @deprecated 3.2.0
         */
        public $cart_session_data = array('cart_contents_total' => 0, 'total' => 0, 'subtotal' => 0, 'subtotal_ex_tax' => 0, 'tax_total' => 0, 'taxes' => array(), 'shipping_taxes' => array(), 'discount_cart' => 0, 'discount_cart_tax' => 0, 'shipping_total' => 0, 'shipping_tax_total' => 0, 'coupon_discount_amounts' => array(), 'coupon_discount_tax_amounts' => array(), 'fee_total' => 0, 'fees' => array());
        /**
         * Contains an array of coupon usage counts after they have been applied.
         *
         * @deprecated 3.2.0
         * @var array
         */
        public $coupon_applied_count = array();
        /**
         * Map legacy variables.
         *
         * @param string $name Property name.
         * @param mixed  $value Value to set.
         */
        public function __isset($name)
        {
        }
        /**
         * Magic getters.
         *
         * If you add/remove cases here please update $legacy_keys in __isset accordingly.
         *
         * @param string $name Property name.
         * @return mixed
         */
        public function &__get($name)
        {
        }
        /**
         * Map legacy variables to setters.
         *
         * @param string $name Property name.
         * @param mixed  $value Value to set.
         */
        public function __set($name, $value)
        {
        }
        /**
         * Methods moved to session class in 3.2.0.
         */
        public function get_cart_from_session()
        {
        }
        public function maybe_set_cart_cookies()
        {
        }
        public function set_session()
        {
        }
        public function get_cart_for_session()
        {
        }
        public function persistent_cart_update()
        {
        }
        public function persistent_cart_destroy()
        {
        }
        /**
         * Get the total of all cart discounts.
         *
         * @return float
         */
        public function get_cart_discount_total()
        {
        }
        /**
         * Get the total of all cart tax discounts (used for discounts on tax inclusive prices).
         *
         * @return float
         */
        public function get_cart_discount_tax_total()
        {
        }
        /**
         * Renamed for consistency.
         *
         * @param string $coupon_code
         * @return bool	True if the coupon is applied, false if it does not exist or cannot be applied.
         */
        public function add_discount($coupon_code)
        {
        }
        /**
         * Remove taxes.
         *
         * @deprecated 3.2.0 Taxes are never calculated if customer is tax except making this function unused.
         */
        public function remove_taxes()
        {
        }
        /**
         * Init.
         *
         * @deprecated 3.2.0 Session is loaded via hooks rather than directly.
         */
        public function init()
        {
        }
        /**
         * Function to apply discounts to a product and get the discounted price (before tax is applied).
         *
         * @deprecated 3.2.0 Calculation and coupon logic is handled in WC_Cart_Totals.
         * @param mixed $values Cart item.
         * @param mixed $price Price of item.
         * @param bool  $add_totals Legacy.
         * @return float price
         */
        public function get_discounted_price($values, $price, $add_totals = \false)
        {
        }
        /**
         * Gets the url to the cart page.
         *
         * @deprecated 2.5.0 in favor to wc_get_cart_url()
         * @return string url to page
         */
        public function get_cart_url()
        {
        }
        /**
         * Gets the url to the checkout page.
         *
         * @deprecated 2.5.0 in favor to wc_get_checkout_url()
         * @return string url to page
         */
        public function get_checkout_url()
        {
        }
        /**
         * Sees if we need a shipping address.
         *
         * @deprecated 2.5.0 in favor to wc_ship_to_billing_address_only()
         * @return bool
         */
        public function ship_to_billing_address_only()
        {
        }
        /**
         * Coupons enabled function. Filterable.
         *
         * @deprecated 2.5.0
         * @return bool
         */
        public function coupons_enabled()
        {
        }
        /**
         * Gets the total (product) discount amount - these are applied before tax.
         *
         * @deprecated 2.3.0 Order discounts (after tax) removed in 2.3 so multiple methods for discounts are no longer required.
         * @return mixed formatted price or false if there are none.
         */
        public function get_discounts_before_tax()
        {
        }
        /**
         * Get the total of all order discounts (after tax discounts).
         *
         * @deprecated 2.3.0 Order discounts (after tax) removed in 2.3.
         * @return int
         */
        public function get_order_discount_total()
        {
        }
        /**
         * Function to apply cart discounts after tax.
         *
         * @deprecated 2.3.0 Coupons can not be applied after tax.
         * @param $values
         * @param $price
         */
        public function apply_cart_discounts_after_tax($values, $price)
        {
        }
        /**
         * Function to apply product discounts after tax.
         *
         * @deprecated 2.3.0 Coupons can not be applied after tax.
         *
         * @param $values
         * @param $price
         */
        public function apply_product_discounts_after_tax($values, $price)
        {
        }
        /**
         * Gets the order discount amount - these are applied after tax.
         *
         * @deprecated 2.3.0 Coupons can not be applied after tax.
         */
        public function get_discounts_after_tax()
        {
        }
    }
    /**
     * WC_Cart class.
     */
    class WC_Cart extends \WC_Legacy_Cart
    {
        /**
         * Contains an array of cart items.
         *
         * @var array
         */
        public $cart_contents = array();
        /**
         * Contains an array of removed cart items so we can restore them if needed.
         *
         * @var array
         */
        public $removed_cart_contents = array();
        /**
         * Contains an array of coupon codes applied to the cart.
         *
         * @var array
         */
        public $applied_coupons = array();
        /**
         * This stores the chosen shipping methods for the cart item packages.
         *
         * @var array
         */
        protected $shipping_methods;
        /**
         * Total defaults used to reset.
         *
         * @var array
         */
        protected $default_totals = array('subtotal' => 0, 'subtotal_tax' => 0, 'shipping_total' => 0, 'shipping_tax' => 0, 'shipping_taxes' => array(), 'discount_total' => 0, 'discount_tax' => 0, 'cart_contents_total' => 0, 'cart_contents_tax' => 0, 'cart_contents_taxes' => array(), 'fee_total' => 0, 'fee_tax' => 0, 'fee_taxes' => array(), 'total' => 0, 'total_tax' => 0);
        /**
         * Store calculated totals.
         *
         * @var array
         */
        protected $totals = array();
        /**
         * Reference to the cart session handling class.
         *
         * @var WC_Cart_Session
         */
        protected $session;
        /**
         * Reference to the cart fees API class.
         *
         * @var WC_Cart_Fees
         */
        protected $fees_api;
        /**
         * Constructor for the cart class. Loads options and hooks in the init method.
         */
        public function __construct()
        {
        }
        /**
         * When cloning, ensure object properties are handled.
         *
         * These properties store a reference to the cart, so we use new instead of clone.
         */
        public function __clone()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters.
        |--------------------------------------------------------------------------
        |
        | Methods to retrieve class properties and avoid direct access.
        */
        /**
         * Gets cart contents.
         *
         * @since 3.2.0
         * @return array of cart items
         */
        public function get_cart_contents()
        {
        }
        /**
         * Return items removed from the cart.
         *
         * @since 3.2.0
         * @return array
         */
        public function get_removed_cart_contents()
        {
        }
        /**
         * Gets the array of applied coupon codes.
         *
         * @return array of applied coupons
         */
        public function get_applied_coupons()
        {
        }
        /**
         * Return all calculated coupon totals.
         *
         * @since 3.2.0
         * @return array
         */
        public function get_coupon_discount_totals()
        {
        }
        /**
         * Return all calculated coupon tax totals.
         *
         * @since 3.2.0
         * @return array
         */
        public function get_coupon_discount_tax_totals()
        {
        }
        /**
         * Return all calculated totals.
         *
         * @since 3.2.0
         * @return array
         */
        public function get_totals()
        {
        }
        /**
         * Get a total.
         *
         * @since 3.2.0
         * @param string $key Key of element in $totals array.
         * @return mixed
         */
        protected function get_totals_var($key)
        {
        }
        /**
         * Get subtotal.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_subtotal()
        {
        }
        /**
         * Get subtotal_tax.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_subtotal_tax()
        {
        }
        /**
         * Get discount_total.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_discount_total()
        {
        }
        /**
         * Get discount_tax.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_discount_tax()
        {
        }
        /**
         * Get shipping_total.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_shipping_total()
        {
        }
        /**
         * Get shipping_tax.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_shipping_tax()
        {
        }
        /**
         * Gets cart total. This is the total of items in the cart, but after discounts. Subtotal is before discounts.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_cart_contents_total()
        {
        }
        /**
         * Gets cart tax amount.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_cart_contents_tax()
        {
        }
        /**
         * Gets cart total after calculation.
         *
         * @since 3.2.0
         * @param string $context If the context is view, the value will be formatted for display. This keeps it compatible with pre-3.2 versions.
         * @return float|string
         */
        public function get_total($context = 'view')
        {
        }
        /**
         * Get total tax amount.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_total_tax()
        {
        }
        /**
         * Get total fee amount.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_fee_total()
        {
        }
        /**
         * Get total fee tax amount.
         *
         * @since 3.2.0
         * @return float
         */
        public function get_fee_tax()
        {
        }
        /**
         * Get taxes.
         *
         * @since 3.2.0
         */
        public function get_shipping_taxes()
        {
        }
        /**
         * Get taxes.
         *
         * @since 3.2.0
         */
        public function get_cart_contents_taxes()
        {
        }
        /**
         * Get taxes.
         *
         * @since 3.2.0
         */
        public function get_fee_taxes()
        {
        }
        /**
         * Return whether or not the cart is displaying prices including tax, rather than excluding tax.
         *
         * @since 3.3.0
         * @return bool
         */
        public function display_prices_including_tax()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters.
        |--------------------------------------------------------------------------
        |
        | Methods to set class properties and avoid direct access.
        */
        /**
         * Sets the contents of the cart.
         *
         * @param array $value Cart array.
         */
        public function set_cart_contents($value)
        {
        }
        /**
         * Set items removed from the cart.
         *
         * @since 3.2.0
         * @param array $value Item array.
         */
        public function set_removed_cart_contents($value = array())
        {
        }
        /**
         * Sets the array of applied coupon codes.
         *
         * @param array $value List of applied coupon codes.
         */
        public function set_applied_coupons($value = array())
        {
        }
        /**
         * Sets the array of calculated coupon totals.
         *
         * @since 3.2.0
         * @param array $value Value to set.
         */
        public function set_coupon_discount_totals($value = array())
        {
        }
        /**
         * Sets the array of calculated coupon tax totals.
         *
         * @since 3.2.0
         * @param array $value Value to set.
         */
        public function set_coupon_discount_tax_totals($value = array())
        {
        }
        /**
         * Set all calculated totals.
         *
         * @since 3.2.0
         * @param array $value Value to set.
         */
        public function set_totals($value = array())
        {
        }
        /**
         * Set subtotal.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_subtotal($value)
        {
        }
        /**
         * Set subtotal.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_subtotal_tax($value)
        {
        }
        /**
         * Set discount_total.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_discount_total($value)
        {
        }
        /**
         * Set discount_tax.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_discount_tax($value)
        {
        }
        /**
         * Set shipping_total.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_shipping_total($value)
        {
        }
        /**
         * Set shipping_tax.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_shipping_tax($value)
        {
        }
        /**
         * Set cart_contents_total.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_cart_contents_total($value)
        {
        }
        /**
         * Set cart tax amount.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_cart_contents_tax($value)
        {
        }
        /**
         * Set cart total.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_total($value)
        {
        }
        /**
         * Set total tax amount.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_total_tax($value)
        {
        }
        /**
         * Set fee amount.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_fee_total($value)
        {
        }
        /**
         * Set fee tax.
         *
         * @since 3.2.0
         * @param string $value Value to set.
         */
        public function set_fee_tax($value)
        {
        }
        /**
         * Set taxes.
         *
         * @since 3.2.0
         * @param array $value Tax values.
         */
        public function set_shipping_taxes($value)
        {
        }
        /**
         * Set taxes.
         *
         * @since 3.2.0
         * @param array $value Tax values.
         */
        public function set_cart_contents_taxes($value)
        {
        }
        /**
         * Set taxes.
         *
         * @since 3.2.0
         * @param array $value Tax values.
         */
        public function set_fee_taxes($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Helper methods.
        |--------------------------------------------------------------------------
        */
        /**
         * Returns the cart and shipping taxes, merged.
         *
         * @return array merged taxes
         */
        public function get_taxes()
        {
        }
        /**
         * Returns the contents of the cart in an array.
         *
         * @return array contents of the cart
         */
        public function get_cart()
        {
        }
        /**
         * Returns a specific item in the cart.
         *
         * @param string $item_key Cart item key.
         * @return array Item data
         */
        public function get_cart_item($item_key)
        {
        }
        /**
         * Checks if the cart is empty.
         *
         * @return bool
         */
        public function is_empty()
        {
        }
        /**
         * Empties the cart and optionally the persistent cart too.
         *
         * @param bool $clear_persistent_cart Should the persistent cart be cleared too. Defaults to true.
         */
        public function empty_cart($clear_persistent_cart = \true)
        {
        }
        /**
         * Get number of items in the cart.
         *
         * @return int
         */
        public function get_cart_contents_count()
        {
        }
        /**
         * Get weight of items in the cart.
         *
         * @since 2.5.0
         * @return float
         */
        public function get_cart_contents_weight()
        {
        }
        /**
         * Get cart items quantities - merged so we can do accurate stock checks on items across multiple lines.
         *
         * @return array
         */
        public function get_cart_item_quantities()
        {
        }
        /**
         * Check all cart items for errors.
         */
        public function check_cart_items()
        {
        }
        /**
         * Check cart coupons for errors.
         */
        public function check_cart_coupons()
        {
        }
        /**
         * Looks through cart items and checks the posts are not trashed or deleted.
         *
         * @return bool|WP_Error
         */
        public function check_cart_item_validity()
        {
        }
        /**
         * Looks through the cart to check each item is in stock. If not, add an error.
         *
         * @return bool|WP_Error
         */
        public function check_cart_item_stock()
        {
        }
        /**
         * Gets and formats a list of cart item data + variations for display on the frontend.
         *
         * @param array $cart_item Cart item object.
         * @param bool  $flat Should the data be returned flat or in a list.
         * @return string
         */
        public function get_item_data($cart_item, $flat = \false)
        {
        }
        /**
         * Gets cross sells based on the items in the cart.
         *
         * @return array cross_sells (item ids)
         */
        public function get_cross_sells()
        {
        }
        /**
         * Gets the url to remove an item from the cart.
         *
         * @param string $cart_item_key contains the id of the cart item.
         * @return string url to page
         */
        public function get_remove_url($cart_item_key)
        {
        }
        /**
         * Gets the url to re-add an item into the cart.
         *
         * @param  string $cart_item_key Cart item key to undo.
         * @return string url to page
         */
        public function get_undo_url($cart_item_key)
        {
        }
        /**
         * Get taxes, merged by code, formatted ready for output.
         *
         * @return array
         */
        public function get_tax_totals()
        {
        }
        /**
         * Get all tax classes for items in the cart.
         *
         * @return array
         */
        public function get_cart_item_tax_classes()
        {
        }
        /**
         * Get all tax classes for shipping based on the items in the cart.
         *
         * @return array
         */
        public function get_cart_item_tax_classes_for_shipping()
        {
        }
        /**
         * Determines the value that the customer spent and the subtotal
         * displayed, used for things like coupon validation.
         *
         * Since the coupon lines are displayed based on the TAX DISPLAY value
         * of cart, this is used to determine the spend.
         *
         * If cart totals are shown including tax, use the subtotal.
         * If cart totals are shown excluding tax, use the subtotal ex tax
         * (tax is shown after coupons).
         *
         * @since 2.6.0
         * @return string
         */
        public function get_displayed_subtotal()
        {
        }
        /**
         * Check if product is in the cart and return cart item key.
         *
         * Cart item key will be unique based on the item and its properties, such as variations.
         *
         * @param mixed $cart_id id of product to find in the cart.
         * @return string cart item key
         */
        public function find_product_in_cart($cart_id = \false)
        {
        }
        /**
         * Generate a unique ID for the cart item being added.
         *
         * @param int   $product_id - id of the product the key is being generated for.
         * @param int   $variation_id of the product the key is being generated for.
         * @param array $variation data for the cart item.
         * @param array $cart_item_data other cart item data passed which affects this items uniqueness in the cart.
         * @return string cart item key
         */
        public function generate_cart_id($product_id, $variation_id = 0, $variation = array(), $cart_item_data = array())
        {
        }
        /**
         * Add a product to the cart.
         *
         * @throws Exception Plugins can throw an exception to prevent adding to cart.
         * @param int   $product_id contains the id of the product to add to the cart.
         * @param int   $quantity contains the quantity of the item to add.
         * @param int   $variation_id ID of the variation being added to the cart.
         * @param array $variation attribute values.
         * @param array $cart_item_data extra cart item data we want to pass into the item.
         * @return string|bool $cart_item_key
         */
        public function add_to_cart($product_id = 0, $quantity = 1, $variation_id = 0, $variation = array(), $cart_item_data = array())
        {
        }
        /**
         * Remove a cart item.
         *
         * @since  2.3.0
         * @param  string $cart_item_key Cart item key to remove from the cart.
         * @return bool
         */
        public function remove_cart_item($cart_item_key)
        {
        }
        /**
         * Restore a cart item.
         *
         * @param  string $cart_item_key Cart item key to restore to the cart.
         * @return bool
         */
        public function restore_cart_item($cart_item_key)
        {
        }
        /**
         * Set the quantity for an item in the cart using it's key.
         *
         * @param string $cart_item_key contains the id of the cart item.
         * @param int    $quantity contains the quantity of the item.
         * @param bool   $refresh_totals whether or not to calculate totals after setting the new qty. Can be used to defer calculations if setting quantities in bulk.
         * @return bool
         */
        public function set_quantity($cart_item_key, $quantity = 1, $refresh_totals = \true)
        {
        }
        /**
         * Get cart's owner.
         *
         * @since  3.2.0
         * @return WC_Customer
         */
        public function get_customer()
        {
        }
        /**
         * Calculate totals for the items in the cart.
         *
         * @uses WC_Cart_Totals
         */
        public function calculate_totals()
        {
        }
        /**
         * Looks at the totals to see if payment is actually required.
         *
         * @return bool
         */
        public function needs_payment()
        {
        }
        /*
         * Shipping related functions.
         */
        /**
         * Uses the shipping class to calculate shipping then gets the totals when its finished.
         */
        public function calculate_shipping()
        {
        }
        /**
         * Given a set of packages with rates, get the chosen ones only.
         *
         * @since 3.2.0
         * @param array $calculated_shipping_packages Array of packages.
         * @return array
         */
        protected function get_chosen_shipping_methods($calculated_shipping_packages = array())
        {
        }
        /**
         * Filter items needing shipping callback.
         *
         * @since  3.0.0
         * @param  array $item Item to check for shipping.
         * @return bool
         */
        protected function filter_items_needing_shipping($item)
        {
        }
        /**
         * Get only items that need shipping.
         *
         * @since  3.0.0
         * @return array
         */
        protected function get_items_needing_shipping()
        {
        }
        /**
         * Get packages to calculate shipping for.
         *
         * This lets us calculate costs for carts that are shipped to multiple locations.
         *
         * Shipping methods are responsible for looping through these packages.
         *
         * By default we pass the cart itself as a package - plugins can change this.
         * through the filter and break it up.
         *
         * @since 1.5.4
         * @return array of cart items
         */
        public function get_shipping_packages()
        {
        }
        /**
         * Looks through the cart to see if shipping is actually required.
         *
         * @return bool whether or not the cart needs shipping
         */
        public function needs_shipping()
        {
        }
        /**
         * Should the shipping address form be shown.
         *
         * @return bool
         */
        public function needs_shipping_address()
        {
        }
        /**
         * Sees if the customer has entered enough data to calc the shipping yet.
         *
         * @return bool
         */
        public function show_shipping()
        {
        }
        /**
         * Gets the shipping total (after calculation).
         *
         * @return string price or string for the shipping total
         */
        public function get_cart_shipping_total()
        {
        }
        /**
         * Check for user coupons (now that we have billing email). If a coupon is invalid, add an error.
         *
         * Checks two types of coupons:
         *  1. Where a list of customer emails are set (limits coupon usage to those defined).
         *  2. Where a usage_limit_per_user is set (limits coupon usage to a number based on user ID and email).
         *
         * @param array $posted Post data.
         */
        public function check_customer_coupons($posted)
        {
        }
        /**
         * Checks if the given email address(es) matches the ones specified on the coupon.
         *
         * @param array $check_emails Array of customer email addresses.
         * @param array $restrictions Array of allowed email addresses.
         * @return bool
         */
        public function is_coupon_emails_allowed($check_emails, $restrictions)
        {
        }
        /**
         * Returns whether or not a discount has been applied.
         *
         * @param string $coupon_code Coupon code to check.
         * @return bool
         */
        public function has_discount($coupon_code = '')
        {
        }
        /**
         * Applies a coupon code passed to the method.
         *
         * @param string $coupon_code - The code to apply.
         * @return bool True if the coupon is applied, false if it does not exist or cannot be applied.
         */
        public function apply_coupon($coupon_code)
        {
        }
        /**
         * Get array of applied coupon objects and codes.
         *
         * @param null $deprecated No longer used.
         * @return array of applied coupons
         */
        public function get_coupons($deprecated = \null)
        {
        }
        /**
         * Get the discount amount for a used coupon.
         *
         * @param  string $code coupon code.
         * @param  bool   $ex_tax inc or ex tax.
         * @return float discount amount
         */
        public function get_coupon_discount_amount($code, $ex_tax = \true)
        {
        }
        /**
         * Get the discount tax amount for a used coupon (for tax inclusive prices).
         *
         * @param  string $code coupon code.
         * @return float discount amount
         */
        public function get_coupon_discount_tax_amount($code)
        {
        }
        /**
         * Remove coupons from the cart of a defined type. Type 1 is before tax, type 2 is after tax.
         *
         * @param null $deprecated No longer used.
         */
        public function remove_coupons($deprecated = \null)
        {
        }
        /**
         * Remove a single coupon by code.
         *
         * @param  string $coupon_code Code of the coupon to remove.
         * @return bool
         */
        public function remove_coupon($coupon_code)
        {
        }
        /**
         * Trigger an action so 3rd parties can add custom fees.
         *
         * @since 2.0.0
         */
        public function calculate_fees()
        {
        }
        /**
         * Return reference to fees API.
         *
         * @since  3.2.0
         * @return WC_Cart_Fees
         */
        public function fees_api()
        {
        }
        /**
         * Add additional fee to the cart.
         *
         * This method should be called on a callback attached to the
         * woocommerce_cart_calculate_fees action during cart/checkout. Fees do not
         * persist.
         *
         * @uses WC_Cart_Fees::add_fee
         * @param string $name      Unique name for the fee. Multiple fees of the same name cannot be added.
         * @param float  $amount    Fee amount (do not enter negative amounts).
         * @param bool   $taxable   Is the fee taxable? (default: false).
         * @param string $tax_class The tax class for the fee if taxable. A blank string is standard tax class. (default: '').
         */
        public function add_fee($name, $amount, $taxable = \false, $tax_class = '')
        {
        }
        /**
         * Return all added fees from the Fees API.
         *
         * @uses WC_Cart_Fees::get_fees
         * @return array
         */
        public function get_fees()
        {
        }
        /**
         * Gets the total excluding taxes.
         *
         * @return string formatted price
         */
        public function get_total_ex_tax()
        {
        }
        /**
         * Gets the cart contents total (after calculation).
         *
         * @return string formatted price
         */
        public function get_cart_total()
        {
        }
        /**
         * Gets the sub total (after calculation).
         *
         * @param bool $compound whether to include compound taxes.
         * @return string formatted price
         */
        public function get_cart_subtotal($compound = \false)
        {
        }
        /**
         * Get the product row price per item.
         *
         * @param WC_Product $product Product object.
         * @return string formatted price
         */
        public function get_product_price($product)
        {
        }
        /**
         * Get the product row subtotal.
         *
         * Gets the tax etc to avoid rounding issues.
         *
         * When on the checkout (review order), this will get the subtotal based on the customer's tax rate rather than the base rate.
         *
         * @param WC_Product $product Product object.
         * @param int        $quantity Quantity being purchased.
         * @return string formatted price
         */
        public function get_product_subtotal($product, $quantity)
        {
        }
        /**
         * Gets the cart tax (after calculation).
         *
         * @return string formatted price
         */
        public function get_cart_tax()
        {
        }
        /**
         * Get a tax amount.
         *
         * @param  string $tax_rate_id ID of the tax rate to get taxes for.
         * @return float amount
         */
        public function get_tax_amount($tax_rate_id)
        {
        }
        /**
         * Get a tax amount.
         *
         * @param  string $tax_rate_id ID of the tax rate to get taxes for.
         * @return float amount
         */
        public function get_shipping_tax_amount($tax_rate_id)
        {
        }
        /**
         * Get tax row amounts with or without compound taxes includes.
         *
         * @param  bool $compound True if getting compound taxes.
         * @param  bool $display  True if getting total to display.
         * @return float price
         */
        public function get_taxes_total($compound = \true, $display = \true)
        {
        }
        /**
         * Gets the total discount amount.
         *
         * @return mixed formatted price or false if there are none
         */
        public function get_total_discount()
        {
        }
        /**
         * Reset cart totals to the defaults. Useful before running calculations.
         */
        private function reset_totals()
        {
        }
        /**
         * Returns 'incl' if tax should be included in cart, otherwise returns 'excl'.
         *
         * @return string
         */
        public function get_tax_price_display_mode()
        {
        }
        /**
         * Returns the hash based on cart contents.
         *
         * @since 3.6.0
         * @return string hash for cart content
         */
        public function get_cart_hash()
        {
        }
    }
    /**
     * Checkout class.
     */
    class WC_Checkout
    {
        /**
         * The single instance of the class.
         *
         * @var WC_Checkout|null
         */
        protected static $instance = \null;
        /**
         * Checkout fields are stored here.
         *
         * @var array|null
         */
        protected $fields = \null;
        /**
         * Holds posted data for backwards compatibility.
         *
         * @var array
         */
        protected $legacy_posted_data = array();
        /**
         * Caches customer object. @see get_value.
         *
         * @var WC_Customer
         */
        private $logged_in_customer = \null;
        /**
         * Gets the main WC_Checkout Instance.
         *
         * @since 2.1
         * @static
         * @return WC_Checkout Main instance
         */
        public static function instance()
        {
        }
        /**
         * See if variable is set. Used to support legacy public variables which are no longer defined.
         *
         * @param string $key Key.
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Sets the legacy public variables for backwards compatibility.
         *
         * @param string $key   Key.
         * @param mixed  $value Value.
         */
        public function __set($key, $value)
        {
        }
        /**
         * Gets the legacy public variables for backwards compatibility.
         *
         * @param string $key Key.
         * @return array|string
         */
        public function __get($key)
        {
        }
        /**
         * Cloning is forbidden.
         */
        public function __clone()
        {
        }
        /**
         * Unserializing instances of this class is forbidden.
         */
        public function __wakeup()
        {
        }
        /**
         * Is registration required to checkout?
         *
         * @since  3.0.0
         * @return boolean
         */
        public function is_registration_required()
        {
        }
        /**
         * Is registration enabled on the checkout page?
         *
         * @since  3.0.0
         * @return boolean
         */
        public function is_registration_enabled()
        {
        }
        /**
         * Get an array of checkout fields.
         *
         * @param  string $fieldset to get.
         * @return array
         */
        public function get_checkout_fields($fieldset = '')
        {
        }
        /**
         * When we process the checkout, lets ensure cart items are rechecked to prevent checkout.
         */
        public function check_cart_items()
        {
        }
        /**
         * Output the billing form.
         */
        public function checkout_form_billing()
        {
        }
        /**
         * Output the shipping form.
         */
        public function checkout_form_shipping()
        {
        }
        /**
         * Create an order. Error codes:
         *      520 - Cannot insert order into the database.
         *      521 - Cannot get order after creation.
         *      522 - Cannot update order.
         *      525 - Cannot create line item.
         *      526 - Cannot create fee item.
         *      527 - Cannot create shipping item.
         *      528 - Cannot create tax item.
         *      529 - Cannot create coupon item.
         *
         * @throws Exception When checkout validation fails.
         * @param  array $data Posted data.
         * @return int|WP_ERROR
         */
        public function create_order($data)
        {
        }
        /**
         * Copy line items, tax, totals data from cart to order.
         *
         * @param WC_Order $order Order object.
         *
         * @throws Exception When unable to create order.
         */
        public function set_data_from_cart(&$order)
        {
        }
        /**
         * Add line items to the order.
         *
         * @param WC_Order $order Order instance.
         * @param WC_Cart  $cart  Cart instance.
         */
        public function create_order_line_items(&$order, $cart)
        {
        }
        /**
         * Add fees to the order.
         *
         * @param WC_Order $order Order instance.
         * @param WC_Cart  $cart  Cart instance.
         */
        public function create_order_fee_lines(&$order, $cart)
        {
        }
        /**
         * Add shipping lines to the order.
         *
         * @param WC_Order $order                   Order Instance.
         * @param array    $chosen_shipping_methods Chosen shipping methods.
         * @param array    $packages                Packages.
         */
        public function create_order_shipping_lines(&$order, $chosen_shipping_methods, $packages)
        {
        }
        /**
         * Add tax lines to the order.
         *
         * @param WC_Order $order Order instance.
         * @param WC_Cart  $cart  Cart instance.
         */
        public function create_order_tax_lines(&$order, $cart)
        {
        }
        /**
         * Add coupon lines to the order.
         *
         * @param WC_Order $order Order instance.
         * @param WC_Cart  $cart  Cart instance.
         */
        public function create_order_coupon_lines(&$order, $cart)
        {
        }
        /**
         * See if a fieldset should be skipped.
         *
         * @since 3.0.0
         * @param string $fieldset_key Fieldset key.
         * @param array  $data         Posted data.
         * @return bool
         */
        protected function maybe_skip_fieldset($fieldset_key, $data)
        {
        }
        /**
         * Get posted data from the checkout form.
         *
         * @since  3.1.0
         * @return array of data.
         */
        public function get_posted_data()
        {
        }
        /**
         * Validates the posted checkout data based on field properties.
         *
         * @since  3.0.0
         * @param  array    $data   An array of posted data.
         * @param  WP_Error $errors Validation error.
         */
        protected function validate_posted_data(&$data, &$errors)
        {
        }
        /**
         * Validates that the checkout has enough info to proceed.
         *
         * @since  3.0.0
         * @param  array    $data   An array of posted data.
         * @param  WP_Error $errors Validation errors.
         */
        protected function validate_checkout(&$data, &$errors)
        {
        }
        /**
         * Set address field for customer.
         *
         * @since 3.0.7
         * @param string $field String to update.
         * @param string $key   Field key.
         * @param array  $data  Array of data to get the value from.
         */
        protected function set_customer_address_fields($field, $key, $data)
        {
        }
        /**
         * Update customer and session data from the posted checkout data.
         *
         * @since 3.0.0
         * @param array $data Posted data.
         */
        protected function update_session($data)
        {
        }
        /**
         * Process an order that does require payment.
         *
         * @since 3.0.0
         * @param int    $order_id       Order ID.
         * @param string $payment_method Payment method.
         */
        protected function process_order_payment($order_id, $payment_method)
        {
        }
        /**
         * Process an order that doesn't require payment.
         *
         * @since 3.0.0
         * @param int $order_id Order ID.
         */
        protected function process_order_without_payment($order_id)
        {
        }
        /**
         * Create a new customer account if needed.
         *
         * @throws Exception When not able to create customer.
         * @param array $data Posted data.
         */
        protected function process_customer($data)
        {
        }
        /**
         * If checkout failed during an AJAX call, send failure response.
         */
        protected function send_ajax_failure_response()
        {
        }
        /**
         * Process the checkout after the confirm order button is pressed.
         *
         * @throws Exception When validation fails.
         */
        public function process_checkout()
        {
        }
        /**
         * Get a posted address field after sanitization and validation.
         *
         * @param string $key  Field key.
         * @param string $type Type of address; 'billing' or 'shipping'.
         * @return string
         */
        public function get_posted_address_data($key, $type = 'billing')
        {
        }
        /**
         * Gets the value either from POST, or from the customer object. Sets the default values in checkout fields.
         *
         * @param string $input Name of the input we want to grab data for. e.g. billing_country.
         * @return string The default value.
         */
        public function get_value($input)
        {
        }
    }
    /**
     * CLI class.
     */
    class WC_CLI
    {
        /**
         * Load required files and hooks to make the CLI work.
         */
        public function __construct()
        {
        }
        /**
         * Load command files.
         */
        private function includes()
        {
        }
        /**
         * Sets up and hooks WP CLI to our CLI code.
         */
        private function hooks()
        {
        }
    }
    /**
     * Comments class.
     */
    class WC_Comments
    {
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * See if comments are open.
         *
         * @since  3.1.0
         * @param  bool $open    Whether the current post is open for comments.
         * @param  int  $post_id Post ID.
         * @return bool
         */
        public static function comments_open($open, $post_id)
        {
        }
        /**
         * Exclude order comments from queries and RSS.
         *
         * This code should exclude shop_order comments from queries. Some queries (like the recent comments widget on the dashboard) are hardcoded.
         * and are not filtered, however, the code current_user_can( 'read_post', $comment->comment_post_ID ) should keep them safe since only admin and.
         * shop managers can view orders anyway.
         *
         * The frontend view order pages get around this filter by using remove_filter('comments_clauses', array( 'WC_Comments' ,'exclude_order_comments'), 10, 1 );
         *
         * @param  array $clauses A compacted array of comment query clauses.
         * @return array
         */
        public static function exclude_order_comments($clauses)
        {
        }
        /**
         * Exclude order comments from feed.
         *
         * @deprecated 3.1
         * @param mixed $join Deprecated.
         */
        public static function exclude_order_comments_from_feed_join($join)
        {
        }
        /**
         * Exclude order comments from queries and RSS.
         *
         * @param  string $where The WHERE clause of the query.
         * @return string
         */
        public static function exclude_order_comments_from_feed_where($where)
        {
        }
        /**
         * Exclude webhook comments from queries and RSS.
         *
         * @since  2.2
         * @param  array $clauses A compacted array of comment query clauses.
         * @return array
         */
        public static function exclude_webhook_comments($clauses)
        {
        }
        /**
         * Exclude webhooks comments from feed.
         *
         * @deprecated 3.1
         * @param mixed $join Deprecated.
         */
        public static function exclude_webhook_comments_from_feed_join($join)
        {
        }
        /**
         * Exclude webhook comments from queries and RSS.
         *
         * @since  2.1
         * @param  string $where The WHERE clause of the query.
         * @return string
         */
        public static function exclude_webhook_comments_from_feed_where($where)
        {
        }
        /**
         * Validate the comment ratings.
         *
         * @param  array $comment_data Comment data.
         * @return array
         */
        public static function check_comment_rating($comment_data)
        {
        }
        /**
         * Rating field for comments.
         *
         * @param int $comment_id Comment ID.
         */
        public static function add_comment_rating($comment_id)
        {
        }
        /**
         * Modify recipient of review email.
         *
         * @param array $emails     Emails.
         * @param int   $comment_id Comment ID.
         * @return array
         */
        public static function comment_moderation_recipients($emails, $comment_id)
        {
        }
        /**
         * Ensure product average rating and review count is kept up to date.
         *
         * @param int $post_id Post ID.
         */
        public static function clear_transients($post_id)
        {
        }
        /**
         * Delete comments count cache whenever there is
         * new comment or the status of a comment changes. Cache
         * will be regenerated next time WC_Comments::wp_count_comments()
         * is called.
         */
        public static function delete_comments_count_cache()
        {
        }
        /**
         * Remove order notes, webhook delivery logs, and product reviews from wp_count_comments().
         *
         * @since  2.2
         * @param  object $stats   Comment stats.
         * @param  int    $post_id Post ID.
         * @return object
         */
        public static function wp_count_comments($stats, $post_id)
        {
        }
        /**
         * Make sure WP displays avatars for comments with the `review` type.
         *
         * @since  2.3
         * @param  array $comment_types Comment types.
         * @return array
         */
        public static function add_avatar_for_review_comment_type($comment_types)
        {
        }
        /**
         * Add Product Reviews filter for `review` comment type.
         *
         * @since 6.0.0
         *
         * @param array $comment_types Array of comment type labels keyed by their name.
         *
         * @return array
         */
        public static function add_review_comment_filter(array $comment_types) : array
        {
        }
        /**
         * Determine if a review is from a verified owner at submission.
         *
         * @param int $comment_id Comment ID.
         * @return bool
         */
        public static function add_comment_purchase_verification($comment_id)
        {
        }
        /**
         * Get product rating for a product. Please note this is not cached.
         *
         * @since 3.0.0
         * @param WC_Product $product Product instance.
         * @return float
         */
        public static function get_average_rating_for_product(&$product)
        {
        }
        /**
         * Utility function for getting review counts for multiple products in one query. This is not cached.
         *
         * @since 5.0.0
         *
         * @param array $product_ids Array of product IDs.
         *
         * @return array
         */
        public static function get_review_counts_for_product_ids($product_ids)
        {
        }
        /**
         * Get product review count for a product (not replies). Please note this is not cached.
         *
         * @since 3.0.0
         * @param WC_Product $product Product instance.
         * @return int
         */
        public static function get_review_count_for_product(&$product)
        {
        }
        /**
         * Get product rating count for a product. Please note this is not cached.
         *
         * @since 3.0.0
         * @param WC_Product $product Product instance.
         * @return int[]
         */
        public static function get_rating_counts_for_product(&$product)
        {
        }
        /**
         * Update comment type of product reviews.
         *
         * @since 3.5.0
         * @param array $comment_data Comment data.
         * @return array
         */
        public static function update_comment_type($comment_data)
        {
        }
        /**
         * Validate product reviews if requires a verified owner.
         *
         * @param int $comment_post_id Post ID.
         */
        public static function validate_product_review_verified_owners($comment_post_id)
        {
        }
        /**
         * Determines if a comment is of the default type.
         *
         * Prior to WordPress 5.5, '' was the default comment type.
         * As of 5.5, the default type is 'comment'.
         *
         * @since 4.3.0
         * @param string $comment_type Comment type.
         * @return bool
         */
        private static function is_default_comment_type($comment_type)
        {
        }
    }
    /**
     * The WooCommerce countries class stores country/state data.
     */
    class WC_Countries
    {
        /**
         * Locales list.
         *
         * @var array
         */
        public $locale = array();
        /**
         * List of address formats for locales.
         *
         * @var array
         */
        public $address_formats = array();
        /**
         * Cache of geographical regions.
         *
         * Only to be used by the get_* and load_* methods, as other methods may expect the regions to be
         * loaded on demand.
         *
         * @var array
         */
        private $geo_cache = array();
        /**
         * Auto-load in-accessible properties on demand.
         *
         * @param  mixed $key Key.
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * Get all countries.
         *
         * @return array
         */
        public function get_countries()
        {
        }
        /**
         * Check if a given code represents a valid ISO 3166-1 alpha-2 code for a country known to us.
         *
         * @since 5.1.0
         * @param string $country_code The country code to check as a ISO 3166-1 alpha-2 code.
         * @return bool True if the country is known to us, false otherwise.
         */
        public function country_exists($country_code)
        {
        }
        /**
         * Get all continents.
         *
         * @return array
         */
        public function get_continents()
        {
        }
        /**
         * Get continent code for a country code.
         *
         * @since 2.6.0
         * @param string $cc Country code.
         * @return string
         */
        public function get_continent_code_for_country($cc)
        {
        }
        /**
         * Get calling code for a country code.
         *
         * @since 3.6.0
         * @param string $cc Country code.
         * @return string|array Some countries have multiple. The code will be stripped of - and spaces and always be prefixed with +.
         */
        public function get_country_calling_code($cc)
        {
        }
        /**
         * Get continents that the store ships to.
         *
         * @since 3.6.0
         * @return array
         */
        public function get_shipping_continents()
        {
        }
        /**
         * Load the states.
         *
         * @deprecated 3.6.0 This method was used to load state files, but is no longer needed. @see get_states().
         */
        public function load_country_states()
        {
        }
        /**
         * Get the states for a country.
         *
         * @param  string $cc Country code.
         * @return false|array of states
         */
        public function get_states($cc = \null)
        {
        }
        /**
         * Get the base address (first line) for the store.
         *
         * @since 3.1.1
         * @return string
         */
        public function get_base_address()
        {
        }
        /**
         * Get the base address (second line) for the store.
         *
         * @since 3.1.1
         * @return string
         */
        public function get_base_address_2()
        {
        }
        /**
         * Get the base country for the store.
         *
         * @return string
         */
        public function get_base_country()
        {
        }
        /**
         * Get the base state for the store.
         *
         * @return string
         */
        public function get_base_state()
        {
        }
        /**
         * Get the base city for the store.
         *
         * @version 3.1.1
         * @return string
         */
        public function get_base_city()
        {
        }
        /**
         * Get the base postcode for the store.
         *
         * @since 3.1.1
         * @return string
         */
        public function get_base_postcode()
        {
        }
        /**
         * Get countries that the store sells to.
         *
         * @return array
         */
        public function get_allowed_countries()
        {
        }
        /**
         * Get countries that the store ships to.
         *
         * @return array
         */
        public function get_shipping_countries()
        {
        }
        /**
         * Get allowed country states.
         *
         * @return array
         */
        public function get_allowed_country_states()
        {
        }
        /**
         * Get shipping country states.
         *
         * @return array
         */
        public function get_shipping_country_states()
        {
        }
        /**
         * Gets an array of countries in the EU.
         *
         * @param  string $type Type of countries to retrieve. Blank for EU member countries. eu_vat for EU VAT countries.
         * @return string[]
         */
        public function get_european_union_countries($type = '')
        {
        }
        /**
         * Gets an array of Non-EU countries that use VAT as the Local name for their taxes based on this list - https://en.wikipedia.org/wiki/Value-added_tax#Non-European_Union_countries
         *
         * @deprecated 4.0.0
         * @since 3.9.0
         * @return string[]
         */
        public function countries_using_vat()
        {
        }
        /**
         * Gets an array of countries using VAT.
         *
         * @since 4.0.0
         * @return string[] of country codes.
         */
        public function get_vat_countries()
        {
        }
        /**
         * Gets the correct string for shipping - either 'to the' or 'to'.
         *
         * @param string $country_code Country code.
         * @return string
         */
        public function shipping_to_prefix($country_code = '')
        {
        }
        /**
         * Prefix certain countries with 'the'.
         *
         * @param string $country_code Country code.
         * @return string
         */
        public function estimated_for_prefix($country_code = '')
        {
        }
        /**
         * Correctly name tax in some countries VAT on the frontend.
         *
         * @return string
         */
        public function tax_or_vat()
        {
        }
        /**
         * Include the Inc Tax label.
         *
         * @return string
         */
        public function inc_tax_or_vat()
        {
        }
        /**
         * Include the Ex Tax label.
         *
         * @return string
         */
        public function ex_tax_or_vat()
        {
        }
        /**
         * Outputs the list of countries and states for use in dropdown boxes.
         *
         * @param string $selected_country Selected country.
         * @param string $selected_state   Selected state.
         * @param bool   $escape           If we should escape HTML.
         */
        public function country_dropdown_options($selected_country = '', $selected_state = '', $escape = \false)
        {
        }
        /**
         * Get country address formats.
         *
         * These define how addresses are formatted for display in various countries.
         *
         * @return array
         */
        public function get_address_formats()
        {
        }
        /**
         * Get country address format.
         *
         * @param  array  $args Arguments.
         * @param  string $separator How to separate address lines. @since 3.5.0.
         * @return string
         */
        public function get_formatted_address($args = array(), $separator = '<br/>')
        {
        }
        /**
         * Trim white space and commas off a line.
         *
         * @param  string $line Line.
         * @return string
         */
        private function trim_formatted_address_line($line)
        {
        }
        /**
         * Returns the fields we show by default. This can be filtered later on.
         *
         * @return array
         */
        public function get_default_address_fields()
        {
        }
        /**
         * Get JS selectors for fields which are shown/hidden depending on the locale.
         *
         * @return array
         */
        public function get_country_locale_field_selectors()
        {
        }
        /**
         * Get country locale settings.
         *
         * These locales override the default country selections after a country is chosen.
         *
         * @return array
         */
        public function get_country_locale()
        {
        }
        /**
         * Apply locale and get address fields.
         *
         * @param  mixed  $country Country.
         * @param  string $type    Address type, defaults to 'billing_'.
         * @return array
         */
        public function get_address_fields($country = '', $type = 'billing_')
        {
        }
    }
    /**
     * Legacy Coupon.
     *
     * Legacy and deprecated functions are here to keep the WC_Legacy_Coupon class clean.
     * This class will be removed in future versions.
     *
     * @class       WC_Legacy_Coupon
     * @version     3.0.0
     * @package     WooCommerce\Classes
     * @category    Class
     * @author      WooThemes
     */
    abstract class WC_Legacy_Coupon extends \WC_Data
    {
        /**
         * Magic __isset method for backwards compatibility. Legacy properties which could be accessed directly in the past.
         * @param  string $key
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic __get method for backwards compatibility. Maps legacy vars to new getters.
         * @param  string $key
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * Format loaded data as array.
         * @param  string|array $array
         * @return array
         */
        public function format_array($array)
        {
        }
        /**
         * Check if coupon needs applying before tax.
         *
         * @return bool
         */
        public function apply_before_tax()
        {
        }
        /**
         * Check if a coupon enables free shipping.
         *
         * @return bool
         */
        public function enable_free_shipping()
        {
        }
        /**
         * Check if a coupon excludes sale items.
         *
         * @return bool
         */
        public function exclude_sale_items()
        {
        }
        /**
         * Increase usage count for current coupon.
         *
         * @param string $used_by Either user ID or billing email
         */
        public function inc_usage_count($used_by = '')
        {
        }
        /**
         * Decrease usage count for current coupon.
         *
         * @param string $used_by Either user ID or billing email
         */
        public function dcr_usage_count($used_by = '')
        {
        }
    }
    /**
     * Coupon class.
     */
    class WC_Coupon extends \WC_Legacy_Coupon
    {
        /**
         * Data array, with defaults.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('code' => '', 'amount' => 0, 'status' => \null, 'date_created' => \null, 'date_modified' => \null, 'date_expires' => \null, 'discount_type' => 'fixed_cart', 'description' => '', 'usage_count' => 0, 'individual_use' => \false, 'product_ids' => array(), 'excluded_product_ids' => array(), 'usage_limit' => 0, 'usage_limit_per_user' => 0, 'limit_usage_to_x_items' => \null, 'free_shipping' => \false, 'product_categories' => array(), 'excluded_product_categories' => array(), 'exclude_sale_items' => \false, 'minimum_amount' => '', 'maximum_amount' => '', 'email_restrictions' => array(), 'used_by' => array(), 'virtual' => \false);
        // Coupon message codes.
        const E_WC_COUPON_INVALID_FILTERED = 100;
        const E_WC_COUPON_INVALID_REMOVED = 101;
        const E_WC_COUPON_NOT_YOURS_REMOVED = 102;
        const E_WC_COUPON_ALREADY_APPLIED = 103;
        const E_WC_COUPON_ALREADY_APPLIED_INDIV_USE_ONLY = 104;
        const E_WC_COUPON_NOT_EXIST = 105;
        const E_WC_COUPON_USAGE_LIMIT_REACHED = 106;
        const E_WC_COUPON_EXPIRED = 107;
        const E_WC_COUPON_MIN_SPEND_LIMIT_NOT_MET = 108;
        const E_WC_COUPON_NOT_APPLICABLE = 109;
        const E_WC_COUPON_NOT_VALID_SALE_ITEMS = 110;
        const E_WC_COUPON_PLEASE_ENTER = 111;
        const E_WC_COUPON_MAX_SPEND_LIMIT_MET = 112;
        const E_WC_COUPON_EXCLUDED_PRODUCTS = 113;
        const E_WC_COUPON_EXCLUDED_CATEGORIES = 114;
        const E_WC_COUPON_USAGE_LIMIT_COUPON_STUCK = 115;
        const E_WC_COUPON_USAGE_LIMIT_COUPON_STUCK_GUEST = 116;
        const WC_COUPON_SUCCESS = 200;
        const WC_COUPON_REMOVED = 201;
        /**
         * Cache group.
         *
         * @var string
         */
        protected $cache_group = 'coupons';
        /**
         * Coupon constructor. Loads coupon data.
         *
         * @param mixed $data Coupon data, object, ID or code.
         */
        public function __construct($data = '')
        {
        }
        /**
         * If the object has an ID, read using the data store.
         *
         * @since 3.4.1
         */
        protected function read_object_from_database()
        {
        }
        /**
         * Checks the coupon type.
         *
         * @param  string|array $type Array or string of types.
         * @return bool
         */
        public function is_type($type)
        {
        }
        /**
         * Prefix for action and filter hooks on data.
         *
         * @since  3.0.0
         * @return string
         */
        protected function get_hook_prefix()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        |
        | Methods for getting data from the coupon object.
        |
        */
        /**
         * Get coupon code.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_code($context = 'view')
        {
        }
        /**
         * Get coupon description.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_description($context = 'view')
        {
        }
        /**
         * Get coupon status.
         *
         * @since  6.2.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_status($context = 'view')
        {
        }
        /**
         * Get discount type.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_discount_type($context = 'view')
        {
        }
        /**
         * Get coupon amount.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return float
         */
        public function get_amount($context = 'view')
        {
        }
        /**
         * Get coupon expiration date.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_expires($context = 'view')
        {
        }
        /**
         * Get date_created
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_created($context = 'view')
        {
        }
        /**
         * Get date_modified
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_modified($context = 'view')
        {
        }
        /**
         * Get coupon usage count.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_usage_count($context = 'view')
        {
        }
        /**
         * Get the "individual use" checkbox status.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return bool
         */
        public function get_individual_use($context = 'view')
        {
        }
        /**
         * Get product IDs this coupon can apply to.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_product_ids($context = 'view')
        {
        }
        /**
         * Get product IDs that this coupon should not apply to.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_excluded_product_ids($context = 'view')
        {
        }
        /**
         * Get coupon usage limit.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_usage_limit($context = 'view')
        {
        }
        /**
         * Get coupon usage limit per customer (for a single customer)
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_usage_limit_per_user($context = 'view')
        {
        }
        /**
         * Usage limited to certain amount of items
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer|null
         */
        public function get_limit_usage_to_x_items($context = 'view')
        {
        }
        /**
         * If this coupon grants free shipping or not.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return bool
         */
        public function get_free_shipping($context = 'view')
        {
        }
        /**
         * Get product categories this coupon can apply to.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_product_categories($context = 'view')
        {
        }
        /**
         * Get product categories this coupon cannot not apply to.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_excluded_product_categories($context = 'view')
        {
        }
        /**
         * If this coupon should exclude items on sale.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return bool
         */
        public function get_exclude_sale_items($context = 'view')
        {
        }
        /**
         * Get minimum spend amount.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return float
         */
        public function get_minimum_amount($context = 'view')
        {
        }
        /**
         * Get maximum spend amount.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return float
         */
        public function get_maximum_amount($context = 'view')
        {
        }
        /**
         * Get emails to check customer usage restrictions.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_email_restrictions($context = 'view')
        {
        }
        /**
         * Get records of all users who have used the current coupon.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_used_by($context = 'view')
        {
        }
        /**
         * If the filter is added through the woocommerce_get_shop_coupon_data filter, it's virtual and not in the DB.
         *
         * @since 3.2.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return boolean
         */
        public function get_virtual($context = 'view')
        {
        }
        /**
         * Get discount amount for a cart item.
         *
         * @param  float      $discounting_amount Amount the coupon is being applied to.
         * @param  array|null $cart_item          Cart item being discounted if applicable.
         * @param  boolean    $single             True if discounting a single qty item, false if its the line.
         * @return float Amount this coupon has discounted.
         */
        public function get_discount_amount($discounting_amount, $cart_item = \null, $single = \false)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Functions for setting coupon data. These should not update anything in the
        | database itself and should only change what is stored in the class
        | object.
        |
        */
        /**
         * Set coupon code.
         *
         * @since 3.0.0
         * @param string $code Coupon code.
         */
        public function set_code($code)
        {
        }
        /**
         * Set coupon description.
         *
         * @since 3.0.0
         * @param string $description Description.
         */
        public function set_description($description)
        {
        }
        /**
         * Set coupon status.
         *
         * @since 3.0.0
         * @param string $status Status.
         */
        public function set_status($status)
        {
        }
        /**
         * Set discount type.
         *
         * @since 3.0.0
         * @param string $discount_type Discount type.
         */
        public function set_discount_type($discount_type)
        {
        }
        /**
         * Set amount.
         *
         * @since 3.0.0
         * @param float $amount Amount.
         */
        public function set_amount($amount)
        {
        }
        /**
         * Set expiration date.
         *
         * @since  3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if there is no date.
         */
        public function set_date_expires($date)
        {
        }
        /**
         * Set date_created
         *
         * @since  3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if there is no date.
         */
        public function set_date_created($date)
        {
        }
        /**
         * Set date_modified
         *
         * @since  3.0.0
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if there is no date.
         */
        public function set_date_modified($date)
        {
        }
        /**
         * Set how many times this coupon has been used.
         *
         * @since 3.0.0
         * @param int $usage_count Usage count.
         */
        public function set_usage_count($usage_count)
        {
        }
        /**
         * Set if this coupon can only be used once.
         *
         * @since 3.0.0
         * @param bool $is_individual_use If is for individual use.
         */
        public function set_individual_use($is_individual_use)
        {
        }
        /**
         * Set the product IDs this coupon can be used with.
         *
         * @since 3.0.0
         * @param array $product_ids Products IDs.
         */
        public function set_product_ids($product_ids)
        {
        }
        /**
         * Set the product IDs this coupon cannot be used with.
         *
         * @since 3.0.0
         * @param array $excluded_product_ids Exclude product IDs.
         */
        public function set_excluded_product_ids($excluded_product_ids)
        {
        }
        /**
         * Set the amount of times this coupon can be used.
         *
         * @since 3.0.0
         * @param int $usage_limit Usage limit.
         */
        public function set_usage_limit($usage_limit)
        {
        }
        /**
         * Set the amount of times this coupon can be used per user.
         *
         * @since 3.0.0
         * @param int $usage_limit Usage limit.
         */
        public function set_usage_limit_per_user($usage_limit)
        {
        }
        /**
         * Set usage limit to x number of items.
         *
         * @since 3.0.0
         * @param int|null $limit_usage_to_x_items Limit usage to X items.
         */
        public function set_limit_usage_to_x_items($limit_usage_to_x_items)
        {
        }
        /**
         * Set if this coupon enables free shipping or not.
         *
         * @since 3.0.0
         * @param bool $free_shipping If grant free shipping.
         */
        public function set_free_shipping($free_shipping)
        {
        }
        /**
         * Set the product category IDs this coupon can be used with.
         *
         * @since 3.0.0
         * @param array $product_categories List of product categories.
         */
        public function set_product_categories($product_categories)
        {
        }
        /**
         * Set the product category IDs this coupon cannot be used with.
         *
         * @since 3.0.0
         * @param array $excluded_product_categories List of excluded product categories.
         */
        public function set_excluded_product_categories($excluded_product_categories)
        {
        }
        /**
         * Set if this coupon should excluded sale items or not.
         *
         * @since 3.0.0
         * @param bool $exclude_sale_items If should exclude sale items.
         */
        public function set_exclude_sale_items($exclude_sale_items)
        {
        }
        /**
         * Set the minimum spend amount.
         *
         * @since 3.0.0
         * @param float $amount Minimum amount.
         */
        public function set_minimum_amount($amount)
        {
        }
        /**
         * Set the maximum spend amount.
         *
         * @since 3.0.0
         * @param float $amount Maximum amount.
         */
        public function set_maximum_amount($amount)
        {
        }
        /**
         * Set email restrictions.
         *
         * @since 3.0.0
         * @param array $emails List of emails.
         */
        public function set_email_restrictions($emails = array())
        {
        }
        /**
         * Set which users have used this coupon.
         *
         * @since 3.0.0
         * @param array $used_by List of user IDs.
         */
        public function set_used_by($used_by)
        {
        }
        /**
         * Set coupon virtual state.
         *
         * @param boolean $virtual Whether it is virtual or not.
         * @since 3.2.0
         */
        public function set_virtual($virtual)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Other Actions
        |--------------------------------------------------------------------------
        */
        /**
         * Developers can programmatically return coupons. This function will read those values into our WC_Coupon class.
         *
         * @since 3.0.0
         * @param string $code   Coupon code.
         * @param array  $coupon Array of coupon properties.
         */
        public function read_manual_coupon($code, $coupon)
        {
        }
        /**
         * Increase usage count for current coupon.
         *
         * @param string   $used_by  Either user ID or billing email.
         * @param WC_Order $order  If provided, will clear the coupons held by this order.
         */
        public function increase_usage_count($used_by = '', $order = \null)
        {
        }
        /**
         * Decrease usage count for current coupon.
         *
         * @param string $used_by Either user ID or billing email.
         */
        public function decrease_usage_count($used_by = '')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Validation & Error Handling
        |--------------------------------------------------------------------------
        */
        /**
         * Returns the error_message string.
         * @return string
         */
        public function get_error_message()
        {
        }
        /**
         * Check if a coupon is valid for the cart.
         *
         * @deprecated 3.2.0 In favor of WC_Discounts->is_coupon_valid.
         * @return bool
         */
        public function is_valid()
        {
        }
        /**
         * Check if a coupon is valid.
         *
         * @return bool
         */
        public function is_valid_for_cart()
        {
        }
        /**
         * Check if a coupon is valid for a product.
         *
         * @param WC_Product $product Product instance.
         * @param array      $values  Values.
         * @return bool
         */
        public function is_valid_for_product($product, $values = array())
        {
        }
        /**
         * Converts one of the WC_Coupon message/error codes to a message string and.
         * displays the message/error.
         *
         * @param int $msg_code Message/error code.
         */
        public function add_coupon_message($msg_code)
        {
        }
        /**
         * Map one of the WC_Coupon message codes to a message string.
         *
         * @param integer $msg_code Message code.
         * @return string Message/error string.
         */
        public function get_coupon_message($msg_code)
        {
        }
        /**
         * Map one of the WC_Coupon error codes to a message string.
         *
         * @param int $err_code Message/error code.
         * @return string Message/error string
         */
        public function get_coupon_error($err_code)
        {
        }
        /**
         * Map one of the WC_Coupon error codes to an error string.
         * No coupon instance will be available where a coupon does not exist,
         * so this static method exists.
         *
         * @param int $err_code Error code.
         * @return string Error string.
         */
        public static function get_generic_coupon_error($err_code)
        {
        }
    }
    /**
     * Customer download log class.
     */
    class WC_Customer_Download_Log extends \WC_Data
    {
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'customer_download_log';
        /**
         * Download Log Data array.
         *
         * @var array
         */
        protected $data = array('timestamp' => \null, 'permission_id' => 0, 'user_id' => \null, 'user_ip_address' => \null);
        /**
         * Constructor.
         *
         * @param int|object|array $download_log Download log ID.
         */
        public function __construct($download_log = 0)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get timestamp.
         *
         * @param  string $context Get context.
         * @return WC_DateTime|null Object if the date is set or null if there is no date.
         */
        public function get_timestamp($context = 'view')
        {
        }
        /**
         * Get permission id.
         *
         * @param  string $context Get context.
         * @return integer
         */
        public function get_permission_id($context = 'view')
        {
        }
        /**
         * Get user id.
         *
         * @param  string $context Get context.
         * @return integer
         */
        public function get_user_id($context = 'view')
        {
        }
        /**
         * Get user ip address.
         *
         * @param  string $context Get context.
         * @return string
         */
        public function get_user_ip_address($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set timestamp.
         *
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_timestamp($date = \null)
        {
        }
        /**
         * Set permission id.
         *
         * @param int $value Value to set.
         */
        public function set_permission_id($value)
        {
        }
        /**
         * Set user id.
         *
         * @param int $value Value to set.
         */
        public function set_user_id($value)
        {
        }
        /**
         * Set user ip address.
         *
         * @param string $value Value to set.
         */
        public function set_user_ip_address($value)
        {
        }
    }
    /**
     * Customer download class.
     */
    class WC_Customer_Download extends \WC_Data implements \ArrayAccess
    {
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'customer_download';
        /**
         * Download Data array.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('download_id' => '', 'product_id' => 0, 'user_id' => 0, 'user_email' => '', 'order_id' => 0, 'order_key' => '', 'downloads_remaining' => '', 'access_granted' => \null, 'access_expires' => \null, 'download_count' => 0);
        /**
         * Constructor.
         *
         * @param int|object|array $download Download ID, instance or data.
         */
        public function __construct($download = 0)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get download id.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_download_id($context = 'view')
        {
        }
        /**
         * Get product id.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_product_id($context = 'view')
        {
        }
        /**
         * Get user id.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_user_id($context = 'view')
        {
        }
        /**
         * Get user_email.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_user_email($context = 'view')
        {
        }
        /**
         * Get order_id.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_order_id($context = 'view')
        {
        }
        /**
         * Get order_key.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_order_key($context = 'view')
        {
        }
        /**
         * Get downloads_remaining.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer|string
         */
        public function get_downloads_remaining($context = 'view')
        {
        }
        /**
         * Get access_granted.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|null Object if the date is set or null if there is no date.
         */
        public function get_access_granted($context = 'view')
        {
        }
        /**
         * Get access_expires.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|null Object if the date is set or null if there is no date.
         */
        public function get_access_expires($context = 'view')
        {
        }
        /**
         * Get download_count.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return integer
         */
        public function get_download_count($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set download id.
         *
         * @param string $value Download ID.
         */
        public function set_download_id($value)
        {
        }
        /**
         * Set product id.
         *
         * @param int $value Product ID.
         */
        public function set_product_id($value)
        {
        }
        /**
         * Set user id.
         *
         * @param int $value User ID.
         */
        public function set_user_id($value)
        {
        }
        /**
         * Set user_email.
         *
         * @param int $value User email.
         */
        public function set_user_email($value)
        {
        }
        /**
         * Set order_id.
         *
         * @param int $value Order ID.
         */
        public function set_order_id($value)
        {
        }
        /**
         * Set order_key.
         *
         * @param string $value Order key.
         */
        public function set_order_key($value)
        {
        }
        /**
         * Set downloads_remaining.
         *
         * @param integer|string $value Amount of downloads remaining.
         */
        public function set_downloads_remaining($value)
        {
        }
        /**
         * Set access_granted.
         *
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_access_granted($date = \null)
        {
        }
        /**
         * Set access_expires.
         *
         * @param string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_access_expires($date = \null)
        {
        }
        /**
         * Set download_count.
         *
         * @param int $value Download count.
         */
        public function set_download_count($value)
        {
        }
        /**
         * Track a download on this permission.
         *
         * @since 3.3.0
         * @throws Exception When permission ID is invalid.
         * @param int    $user_id         Id of the user performing the download.
         * @param string $user_ip_address IP Address of the user performing the download.
         */
        public function track_download($user_id = \null, $user_ip_address = \null)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | ArrayAccess/Backwards compatibility.
        |--------------------------------------------------------------------------
        */
        /**
         * OffsetGet.
         *
         * @param mixed $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet.
         *
         * @param mixed $offset Offset.
         * @param mixed $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetUnset
         *
         * @param mixed $offset Offset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * OffsetExists.
         *
         * @param mixed $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
        /**
         * Magic __isset method for backwards compatibility. Legacy properties which could be accessed directly in the past.
         *
         * @param  string $key Key name.
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic __get method for backwards compatibility. Maps legacy vars to new getters.
         *
         * @param  string $key Key name.
         * @return mixed
         */
        public function __get($key)
        {
        }
    }
    /**
     * Legacy Customer.
     *
     * @version  3.0.0
     * @package  WooCommerce\Classes
     * @category Class
     * @author   WooThemes
     */
    abstract class WC_Legacy_Customer extends \WC_Data
    {
        /**
         * __isset legacy.
         * @param mixed $key
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * __get function.
         * @param string $key
         * @return string
         */
        public function __get($key)
        {
        }
        /**
         * __set function.
         *
         * @param string $key
         * @param mixed $value
         */
        public function __set($key, $value)
        {
        }
        /**
         * Address and shipping_address are aliased, so we want to get the 'real' key name.
         * For all other keys, we can just return it.
         * @since 3.0.0
         * @param  string $key
         * @return string
         */
        private function filter_legacy_key($key)
        {
        }
        /**
         * Sets session data for the location.
         *
         * @param string $country
         * @param string $state
         * @param string $postcode (default: '')
         * @param string $city (default: '')
         */
        public function set_location($country, $state, $postcode = '', $city = '')
        {
        }
        /**
         * Get default country for a customer.
         * @return string
         */
        public function get_default_country()
        {
        }
        /**
         * Get default state for a customer.
         * @return string
         */
        public function get_default_state()
        {
        }
        /**
         * Set customer address to match shop base address.
         */
        public function set_to_base()
        {
        }
        /**
         * Set customer shipping address to base address.
         */
        public function set_shipping_to_base()
        {
        }
        /**
         * Calculated shipping.
         * @param boolean $calculated
         */
        public function calculated_shipping($calculated = \true)
        {
        }
        /**
         * Set default data for a customer.
         */
        public function set_default_data()
        {
        }
        /**
         * Save data function.
         */
        public function save_data()
        {
        }
        /**
         * Is the user a paying customer?
         *
         * @param int $user_id
         *
         * @return bool
         */
        function is_paying_customer($user_id = '')
        {
        }
        /**
         * Legacy get address.
         */
        function get_address()
        {
        }
        /**
         * Legacy get address 2.
         */
        function get_address_2()
        {
        }
        /**
         * Legacy get country.
         */
        function get_country()
        {
        }
        /**
         * Legacy get state.
         */
        function get_state()
        {
        }
        /**
         * Legacy get postcode.
         */
        function get_postcode()
        {
        }
        /**
         * Legacy get city.
         */
        function get_city()
        {
        }
        /**
         * Legacy set country.
         *
         * @param string $country
         */
        function set_country($country)
        {
        }
        /**
         * Legacy set state.
         *
         * @param string $state
         */
        function set_state($state)
        {
        }
        /**
         * Legacy set postcode.
         *
         * @param string $postcode
         */
        function set_postcode($postcode)
        {
        }
        /**
         * Legacy set city.
         *
         * @param string $city
         */
        function set_city($city)
        {
        }
        /**
         * Legacy set address.
         *
         * @param string $address
         */
        function set_address($address)
        {
        }
        /**
         * Legacy set address.
         *
         * @param string $address
         */
        function set_address_2($address)
        {
        }
    }
    /**
     * Customer class.
     */
    class WC_Customer extends \WC_Legacy_Customer
    {
        /**
         * Stores customer data.
         *
         * @var array
         */
        protected $data = array('date_created' => \null, 'date_modified' => \null, 'email' => '', 'first_name' => '', 'last_name' => '', 'display_name' => '', 'role' => 'customer', 'username' => '', 'billing' => array('first_name' => '', 'last_name' => '', 'company' => '', 'address_1' => '', 'address_2' => '', 'city' => '', 'postcode' => '', 'country' => '', 'state' => '', 'email' => '', 'phone' => ''), 'shipping' => array('first_name' => '', 'last_name' => '', 'company' => '', 'address_1' => '', 'address_2' => '', 'city' => '', 'postcode' => '', 'country' => '', 'state' => '', 'phone' => ''), 'is_paying_customer' => \false);
        /**
         * Stores a password if this needs to be changed. Write-only and hidden from _data.
         *
         * @var string
         */
        protected $password = '';
        /**
         * Stores if user is VAT exempt for this session.
         *
         * @var string
         */
        protected $is_vat_exempt = \false;
        /**
         * Stores if user has calculated shipping in this session.
         *
         * @var string
         */
        protected $calculated_shipping = \false;
        /**
         * This is the name of this object type.
         *
         * @since 5.6.0
         * @var string
         */
        protected $object_type = 'customer';
        /**
         * Load customer data based on how WC_Customer is called.
         *
         * If $customer is 'new', you can build a new WC_Customer object. If it's empty, some
         * data will be pulled from the session for the current user/customer.
         *
         * @param WC_Customer|int $data       Customer ID or data.
         * @param bool            $is_session True if this is the customer session.
         * @throws Exception If customer cannot be read/found and $data is set.
         */
        public function __construct($data = 0, $is_session = \false)
        {
        }
        /**
         * Delete a customer and reassign posts..
         *
         * @param int $reassign Reassign posts and links to new User ID.
         * @since 3.0.0
         * @return bool
         */
        public function delete_and_reassign($reassign = \null)
        {
        }
        /**
         * Is customer outside base country (for tax purposes)?
         *
         * @return bool
         */
        public function is_customer_outside_base()
        {
        }
        /**
         * Return this customer's avatar.
         *
         * @since 3.0.0
         * @return string
         */
        public function get_avatar_url()
        {
        }
        /**
         * Get taxable address.
         *
         * @return array
         */
        public function get_taxable_address()
        {
        }
        /**
         * Gets a customer's downloadable products.
         *
         * @return array Array of downloadable products
         */
        public function get_downloadable_products()
        {
        }
        /**
         * Is customer VAT exempt?
         *
         * @return bool
         */
        public function is_vat_exempt()
        {
        }
        /**
         * Has calculated shipping?
         *
         * @return bool
         */
        public function has_calculated_shipping()
        {
        }
        /**
         * Indicates if the customer has a non-empty shipping address.
         *
         * Note that this does not indicate if the customer's shipping address
         * is complete, only that one or more fields are populated.
         *
         * @since 5.3.0
         *
         * @return bool
         */
        public function has_shipping_address()
        {
        }
        /**
         * Get if customer is VAT exempt?
         *
         * @since 3.0.0
         * @return bool
         */
        public function get_is_vat_exempt()
        {
        }
        /**
         * Get password (only used when updating the user object).
         *
         * @return string
         */
        public function get_password()
        {
        }
        /**
         * Has customer calculated shipping?
         *
         * @return bool
         */
        public function get_calculated_shipping()
        {
        }
        /**
         * Set if customer has tax exemption.
         *
         * @param bool $is_vat_exempt If is vat exempt.
         */
        public function set_is_vat_exempt($is_vat_exempt)
        {
        }
        /**
         * Calculated shipping?
         *
         * @param bool $calculated If shipping is calculated.
         */
        public function set_calculated_shipping($calculated = \true)
        {
        }
        /**
         * Set customer's password.
         *
         * @since 3.0.0
         * @param string $password Password.
         */
        public function set_password($password)
        {
        }
        /**
         * Gets the customers last order.
         *
         * @return WC_Order|false
         */
        public function get_last_order()
        {
        }
        /**
         * Return the number of orders this customer has.
         *
         * @return integer
         */
        public function get_order_count()
        {
        }
        /**
         * Return how much money this customer has spent.
         *
         * @return float
         */
        public function get_total_spent()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Return the customer's username.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_username($context = 'view')
        {
        }
        /**
         * Return the customer's email.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_email($context = 'view')
        {
        }
        /**
         * Return customer's first name.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_first_name($context = 'view')
        {
        }
        /**
         * Return customer's last name.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_last_name($context = 'view')
        {
        }
        /**
         * Return customer's display name.
         *
         * @since  3.1.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_display_name($context = 'view')
        {
        }
        /**
         * Return customer's user role.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_role($context = 'view')
        {
        }
        /**
         * Return the date this customer was created.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|null object if the date is set or null if there is no date.
         */
        public function get_date_created($context = 'view')
        {
        }
        /**
         * Return the date this customer was last updated.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return WC_DateTime|null object if the date is set or null if there is no date.
         */
        public function get_date_modified($context = 'view')
        {
        }
        /**
         * Gets a prop for a getter method.
         *
         * @since  3.0.0
         * @param  string $prop Name of prop to get.
         * @param  string $address_type Type of address; 'billing' or 'shipping'.
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return mixed
         */
        protected function get_address_prop($prop, $address_type = 'billing', $context = 'view')
        {
        }
        /**
         * Get billing.
         *
         * @since  3.2.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_billing($context = 'view')
        {
        }
        /**
         * Get billing_first_name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_first_name($context = 'view')
        {
        }
        /**
         * Get billing_last_name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_last_name($context = 'view')
        {
        }
        /**
         * Get billing_company.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_company($context = 'view')
        {
        }
        /**
         * Get billing_address_1.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_address($context = 'view')
        {
        }
        /**
         * Get billing_address_1.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_address_1($context = 'view')
        {
        }
        /**
         * Get billing_address_2.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string $value
         */
        public function get_billing_address_2($context = 'view')
        {
        }
        /**
         * Get billing_city.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string $value
         */
        public function get_billing_city($context = 'view')
        {
        }
        /**
         * Get billing_state.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_state($context = 'view')
        {
        }
        /**
         * Get billing_postcode.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_postcode($context = 'view')
        {
        }
        /**
         * Get billing_country.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_country($context = 'view')
        {
        }
        /**
         * Get billing_email.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_email($context = 'view')
        {
        }
        /**
         * Get billing_phone.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_billing_phone($context = 'view')
        {
        }
        /**
         * Get shipping.
         *
         * @since  3.2.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_shipping($context = 'view')
        {
        }
        /**
         * Get shipping_first_name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_first_name($context = 'view')
        {
        }
        /**
         * Get shipping_last_name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_last_name($context = 'view')
        {
        }
        /**
         * Get shipping_company.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_company($context = 'view')
        {
        }
        /**
         * Get shipping_address_1.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_address($context = 'view')
        {
        }
        /**
         * Get shipping_address_1.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_address_1($context = 'view')
        {
        }
        /**
         * Get shipping_address_2.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_address_2($context = 'view')
        {
        }
        /**
         * Get shipping_city.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_city($context = 'view')
        {
        }
        /**
         * Get shipping_state.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_state($context = 'view')
        {
        }
        /**
         * Get shipping_postcode.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_postcode($context = 'view')
        {
        }
        /**
         * Get shipping_country.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_country($context = 'view')
        {
        }
        /**
         * Get shipping phone.
         *
         * @since 5.6.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_phone($context = 'view')
        {
        }
        /**
         * Is the user a paying customer?
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return bool
         */
        public function get_is_paying_customer($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set customer's username.
         *
         * @since 3.0.0
         * @param string $username Username.
         */
        public function set_username($username)
        {
        }
        /**
         * Set customer's email.
         *
         * @since 3.0.0
         * @param string $value Email.
         */
        public function set_email($value)
        {
        }
        /**
         * Set customer's first name.
         *
         * @since 3.0.0
         * @param string $first_name First name.
         */
        public function set_first_name($first_name)
        {
        }
        /**
         * Set customer's last name.
         *
         * @since 3.0.0
         * @param string $last_name Last name.
         */
        public function set_last_name($last_name)
        {
        }
        /**
         * Set customer's display name.
         *
         * @since 3.1.0
         * @param string $display_name Display name.
         */
        public function set_display_name($display_name)
        {
        }
        /**
         * Set customer's user role(s).
         *
         * @since 3.0.0
         * @param mixed $role User role.
         */
        public function set_role($role)
        {
        }
        /**
         * Set the date this customer was last updated.
         *
         * @since  3.0.0
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_created($date = \null)
        {
        }
        /**
         * Set the date this customer was last updated.
         *
         * @since  3.0.0
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         */
        public function set_date_modified($date = \null)
        {
        }
        /**
         * Set customer address to match shop base address.
         *
         * @since 3.0.0
         */
        public function set_billing_address_to_base()
        {
        }
        /**
         * Set customer shipping address to base address.
         *
         * @since 3.0.0
         */
        public function set_shipping_address_to_base()
        {
        }
        /**
         * Sets all address info at once.
         *
         * @param string $country  Country.
         * @param string $state    State.
         * @param string $postcode Postcode.
         * @param string $city     City.
         */
        public function set_billing_location($country, $state = '', $postcode = '', $city = '')
        {
        }
        /**
         * Sets all shipping info at once.
         *
         * @param string $country  Country.
         * @param string $state    State.
         * @param string $postcode Postcode.
         * @param string $city     City.
         */
        public function set_shipping_location($country, $state = '', $postcode = '', $city = '')
        {
        }
        /**
         * Sets a prop for a setter method.
         *
         * @since 3.0.0
         * @param string $prop         Name of prop to set.
         * @param string $address_type Type of address; 'billing' or 'shipping'.
         * @param mixed  $value        Value of the prop.
         */
        protected function set_address_prop($prop, $address_type, $value)
        {
        }
        /**
         * Set billing_first_name.
         *
         * @param string $value Billing first name.
         */
        public function set_billing_first_name($value)
        {
        }
        /**
         * Set billing_last_name.
         *
         * @param string $value Billing last name.
         */
        public function set_billing_last_name($value)
        {
        }
        /**
         * Set billing_company.
         *
         * @param string $value Billing company.
         */
        public function set_billing_company($value)
        {
        }
        /**
         * Set billing_address_1.
         *
         * @param string $value Billing address line 1.
         */
        public function set_billing_address($value)
        {
        }
        /**
         * Set billing_address_1.
         *
         * @param string $value Billing address line 1.
         */
        public function set_billing_address_1($value)
        {
        }
        /**
         * Set billing_address_2.
         *
         * @param string $value Billing address line 2.
         */
        public function set_billing_address_2($value)
        {
        }
        /**
         * Set billing_city.
         *
         * @param string $value Billing city.
         */
        public function set_billing_city($value)
        {
        }
        /**
         * Set billing_state.
         *
         * @param string $value Billing state.
         */
        public function set_billing_state($value)
        {
        }
        /**
         * Set billing_postcode.
         *
         * @param string $value Billing postcode.
         */
        public function set_billing_postcode($value)
        {
        }
        /**
         * Set billing_country.
         *
         * @param string $value Billing country.
         */
        public function set_billing_country($value)
        {
        }
        /**
         * Set billing_email.
         *
         * @param string $value Billing email.
         */
        public function set_billing_email($value)
        {
        }
        /**
         * Set billing_phone.
         *
         * @param string $value Billing phone.
         */
        public function set_billing_phone($value)
        {
        }
        /**
         * Set shipping_first_name.
         *
         * @param string $value Shipping first name.
         */
        public function set_shipping_first_name($value)
        {
        }
        /**
         * Set shipping_last_name.
         *
         * @param string $value Shipping last name.
         */
        public function set_shipping_last_name($value)
        {
        }
        /**
         * Set shipping_company.
         *
         * @param string $value Shipping company.
         */
        public function set_shipping_company($value)
        {
        }
        /**
         * Set shipping_address_1.
         *
         * @param string $value Shipping address line 1.
         */
        public function set_shipping_address($value)
        {
        }
        /**
         * Set shipping_address_1.
         *
         * @param string $value Shipping address line 1.
         */
        public function set_shipping_address_1($value)
        {
        }
        /**
         * Set shipping_address_2.
         *
         * @param string $value Shipping address line 2.
         */
        public function set_shipping_address_2($value)
        {
        }
        /**
         * Set shipping_city.
         *
         * @param string $value Shipping city.
         */
        public function set_shipping_city($value)
        {
        }
        /**
         * Set shipping_state.
         *
         * @param string $value Shipping state.
         */
        public function set_shipping_state($value)
        {
        }
        /**
         * Set shipping_postcode.
         *
         * @param string $value Shipping postcode.
         */
        public function set_shipping_postcode($value)
        {
        }
        /**
         * Set shipping_country.
         *
         * @param string $value Shipping country.
         */
        public function set_shipping_country($value)
        {
        }
        /**
         * Set shipping phone.
         *
         * @since 5.6.0
         * @param string $value Shipping phone.
         */
        public function set_shipping_phone($value)
        {
        }
        /**
         * Set if the user a paying customer.
         *
         * @since 3.0.0
         * @param bool $is_paying_customer If is a paying customer.
         */
        public function set_is_paying_customer($is_paying_customer)
        {
        }
    }
    /**
     * Data exception class.
     */
    class WC_Data_Exception extends \Exception
    {
        /**
         * Sanitized error code.
         *
         * @var string
         */
        protected $error_code;
        /**
         * Error extra data.
         *
         * @var array
         */
        protected $error_data;
        /**
         * Setup exception.
         *
         * @param string $code             Machine-readable error code, e.g `woocommerce_invalid_product_id`.
         * @param string $message          User-friendly translated error message, e.g. 'Product ID is invalid'.
         * @param int    $http_status_code Proper HTTP status code to respond with, e.g. 400.
         * @param array  $data             Extra error data.
         */
        public function __construct($code, $message, $http_status_code = 400, $data = array())
        {
        }
        /**
         * Returns the error code.
         *
         * @return string
         */
        public function getErrorCode()
        {
        }
        /**
         * Returns error data.
         *
         * @return array
         */
        public function getErrorData()
        {
        }
    }
    /**
     * Data store class.
     */
    class WC_Data_Store
    {
        /**
         * Contains an instance of the data store class that we are working with.
         *
         * @var WC_Data_Store
         */
        private $instance = \null;
        /**
         * Contains an array of default WC supported data stores.
         * Format of object name => class name.
         * Example: 'product' => 'WC_Product_Data_Store_CPT'
         * You can also pass something like product_<type> for product stores and
         * that type will be used first when available, if a store is requested like
         * this and doesn't exist, then the store would fall back to 'product'.
         * Ran through `woocommerce_data_stores`.
         *
         * @var array
         */
        private $stores = array('coupon' => 'WC_Coupon_Data_Store_CPT', 'customer' => 'WC_Customer_Data_Store', 'customer-download' => 'WC_Customer_Download_Data_Store', 'customer-download-log' => 'WC_Customer_Download_Log_Data_Store', 'customer-session' => 'WC_Customer_Data_Store_Session', 'order' => 'WC_Order_Data_Store_CPT', 'order-refund' => 'WC_Order_Refund_Data_Store_CPT', 'order-item' => 'WC_Order_Item_Data_Store', 'order-item-coupon' => 'WC_Order_Item_Coupon_Data_Store', 'order-item-fee' => 'WC_Order_Item_Fee_Data_Store', 'order-item-product' => 'WC_Order_Item_Product_Data_Store', 'order-item-shipping' => 'WC_Order_Item_Shipping_Data_Store', 'order-item-tax' => 'WC_Order_Item_Tax_Data_Store', 'payment-token' => 'WC_Payment_Token_Data_Store', 'product' => 'WC_Product_Data_Store_CPT', 'product-grouped' => 'WC_Product_Grouped_Data_Store_CPT', 'product-variable' => 'WC_Product_Variable_Data_Store_CPT', 'product-variation' => 'WC_Product_Variation_Data_Store_CPT', 'shipping-zone' => 'WC_Shipping_Zone_Data_Store', 'webhook' => 'WC_Webhook_Data_Store');
        /**
         * Contains the name of the current data store's class name.
         *
         * @var string
         */
        private $current_class_name = '';
        /**
         * The object type this store works with.
         *
         * @var string
         */
        private $object_type = '';
        /**
         * Tells WC_Data_Store which object (coupon, product, order, etc)
         * store we want to work with.
         *
         * @throws Exception When validation fails.
         * @param string $object_type Name of object.
         */
        public function __construct($object_type)
        {
        }
        /**
         * Only store the object type to avoid serializing the data store instance.
         *
         * @return array
         */
        public function __sleep()
        {
        }
        /**
         * Re-run the constructor with the object type.
         *
         * @throws Exception When validation fails.
         */
        public function __wakeup()
        {
        }
        /**
         * Loads a data store.
         *
         * @param string $object_type Name of object.
         *
         * @since 3.0.0
         * @throws Exception When validation fails.
         * @return WC_Data_Store
         */
        public static function load($object_type)
        {
        }
        /**
         * Returns the class name of the current data store.
         *
         * @since 3.0.0
         * @return string
         */
        public function get_current_class_name()
        {
        }
        /**
         * Reads an object from the data store.
         *
         * @since 3.0.0
         * @param WC_Data $data WooCommerce data instance.
         */
        public function read(&$data)
        {
        }
        /**
         * Reads multiple objects from the data store.
         *
         * @since 6.9.0
         * @param array[WC_Data] $objects Array of object instances to read.
         */
        public function read_multiple(&$objects = array())
        {
        }
        /**
         * Create an object in the data store.
         *
         * @since 3.0.0
         * @param WC_Data $data WooCommerce data instance.
         */
        public function create(&$data)
        {
        }
        /**
         * Update an object in the data store.
         *
         * @since 3.0.0
         * @param WC_Data $data WooCommerce data instance.
         */
        public function update(&$data)
        {
        }
        /**
         * Delete an object from the data store.
         *
         * @since 3.0.0
         * @param WC_Data $data WooCommerce data instance.
         * @param array   $args Array of args to pass to the delete method.
         */
        public function delete(&$data, $args = array())
        {
        }
        /**
         * Data stores can define additional functions (for example, coupons have
         * some helper methods for increasing or decreasing usage). This passes
         * through to the instance if that function exists.
         *
         * @since 3.0.0
         * @param string $method     Method.
         * @param mixed  $parameters Parameters.
         * @return mixed
         */
        public function __call($method, $parameters)
        {
        }
        /**
         * Check if the data store we are working with has a callable method.
         *
         * @param string $method Method name.
         *
         * @return bool Whether the passed method is callable.
         */
        public function has_callable(string $method) : bool
        {
        }
    }
    /**
     * Datetime class.
     */
    class WC_DateTime extends \DateTime
    {
        /**
         * UTC Offset, if needed. Only used when a timezone is not set. When
         * timezones are used this will equal 0.
         *
         * @var integer
         */
        protected $utc_offset = 0;
        /**
         * Output an ISO 8601 date string in local (WordPress) timezone.
         *
         * @since  3.0.0
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Set UTC offset - this is a fixed offset instead of a timezone.
         *
         * @param int $offset Offset.
         */
        public function set_utc_offset($offset)
        {
        }
        /**
         * Get UTC offset if set, or default to the DateTime object's offset.
         */
        #[\ReturnTypeWillChange]
        public function getOffset()
        {
        }
        /**
         * Set timezone.
         *
         * @param DateTimeZone $timezone DateTimeZone instance.
         * @return DateTime
         */
        #[\ReturnTypeWillChange]
        public function setTimezone($timezone)
        {
        }
        /**
         * Missing in PHP 5.2 so just here so it can be supported consistently.
         *
         * @since  3.0.0
         * @return int
         */
        #[\ReturnTypeWillChange]
        public function getTimestamp()
        {
        }
        /**
         * Get the timestamp with the WordPress timezone offset added or subtracted.
         *
         * @since  3.0.0
         * @return int
         */
        public function getOffsetTimestamp()
        {
        }
        /**
         * Format a date based on the offset timestamp.
         *
         * @since  3.0.0
         * @param  string $format Date format.
         * @return string
         */
        public function date($format)
        {
        }
        /**
         * Return a localised date based on offset timestamp. Wrapper for date_i18n function.
         *
         * @since  3.0.0
         * @param  string $format Date format.
         * @return string
         */
        public function date_i18n($format = 'Y-m-d')
        {
        }
    }
    /**
     * Handles deprecation notices and triggering of legacy action hooks.
     */
    class WC_Deprecated_Action_Hooks extends \WC_Deprecated_Hooks
    {
        /**
         * Array of deprecated hooks we need to handle. Format of 'new' => 'old'.
         *
         * @var array
         */
        protected $deprecated_hooks = array('woocommerce_new_order_item' => array('woocommerce_order_add_shipping', 'woocommerce_order_add_coupon', 'woocommerce_order_add_tax', 'woocommerce_order_add_fee', 'woocommerce_add_shipping_order_item', 'woocommerce_add_order_item_meta', 'woocommerce_add_order_fee_meta'), 'woocommerce_update_order_item' => array('woocommerce_order_edit_product', 'woocommerce_order_update_coupon', 'woocommerce_order_update_shipping', 'woocommerce_order_update_fee', 'woocommerce_order_update_tax'), 'woocommerce_new_payment_token' => 'woocommerce_payment_token_created', 'woocommerce_new_product_variation' => 'woocommerce_create_product_variation', 'woocommerce_order_details_after_order_table_items' => 'woocommerce_order_items_table', 'woocommerce_settings_advanced_page_options' => array('woocommerce_settings_checkout_page_options', 'woocommerce_settings_account_page_options'), 'woocommerce_settings_advanced_page_options_end' => array('woocommerce_settings_checkout_page_options_end', 'woocommerce_settings_account_page_options_end'), 'woocommerce_settings_advanced_page_options_after' => array('woocommerce_settings_checkout_page_options_after', 'woocommerce_settings_account_page_options_after'));
        /**
         * Array of versions on each hook has been deprecated.
         *
         * @var array
         */
        protected $deprecated_version = array('woocommerce_order_add_shipping' => '3.0.0', 'woocommerce_order_add_coupon' => '3.0.0', 'woocommerce_order_add_tax' => '3.0.0', 'woocommerce_order_add_fee' => '3.0.0', 'woocommerce_add_shipping_order_item' => '3.0.0', 'woocommerce_add_order_item_meta' => '3.0.0', 'woocommerce_add_order_fee_meta' => '3.0.0', 'woocommerce_order_edit_product' => '3.0.0', 'woocommerce_order_update_coupon' => '3.0.0', 'woocommerce_order_update_shipping' => '3.0.0', 'woocommerce_order_update_fee' => '3.0.0', 'woocommerce_order_update_tax' => '3.0.0', 'woocommerce_payment_token_created' => '3.0.0', 'woocommerce_create_product_variation' => '3.0.0', 'woocommerce_order_items_table' => '3.0.0', 'woocommerce_settings_checkout_page_options' => '3.4.0', 'woocommerce_settings_account_page_options' => '3.4.0', 'woocommerce_settings_checkout_page_options_end' => '3.4.0', 'woocommerce_settings_account_page_options_end' => '3.4.0', 'woocommerce_settings_checkout_page_options_after' => '3.4.0', 'woocommerce_settings_account_page_options_after' => '3.4.0');
        /**
         * Hook into the new hook so we can handle deprecated hooks once fired.
         *
         * @param string $hook_name Hook name.
         */
        public function hook_in($hook_name)
        {
        }
        /**
         * If the old hook is in-use, trigger it.
         *
         * @param  string $new_hook          New hook name.
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @param  mixed  $return_value      Returned value.
         * @return mixed
         */
        public function handle_deprecated_hook($new_hook, $old_hook, $new_callback_args, $return_value)
        {
        }
        /**
         * Fire off a legacy hook with it's args.
         *
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @return mixed
         */
        protected function trigger_hook($old_hook, $new_callback_args)
        {
        }
    }
    /**
     * Handles deprecation notices and triggering of legacy filter hooks
     */
    class WC_Deprecated_Filter_Hooks extends \WC_Deprecated_Hooks
    {
        /**
         * Array of deprecated hooks we need to handle.
         * Format of 'new' => 'old'.
         *
         * @var array
         */
        protected $deprecated_hooks = array('woocommerce_account_orders_columns' => 'woocommerce_my_account_my_orders_columns', 'woocommerce_structured_data_order' => 'woocommerce_email_order_schema_markup', 'woocommerce_add_to_cart_fragments' => 'add_to_cart_fragments', 'woocommerce_add_to_cart_redirect' => 'add_to_cart_redirect', 'woocommerce_product_get_width' => 'woocommerce_product_width', 'woocommerce_product_get_height' => 'woocommerce_product_height', 'woocommerce_product_get_length' => 'woocommerce_product_length', 'woocommerce_product_get_weight' => 'woocommerce_product_weight', 'woocommerce_product_get_sku' => 'woocommerce_get_sku', 'woocommerce_product_get_price' => 'woocommerce_get_price', 'woocommerce_product_get_regular_price' => 'woocommerce_get_regular_price', 'woocommerce_product_get_sale_price' => 'woocommerce_get_sale_price', 'woocommerce_product_get_tax_class' => 'woocommerce_product_tax_class', 'woocommerce_product_get_stock_quantity' => 'woocommerce_get_stock_quantity', 'woocommerce_product_get_attributes' => 'woocommerce_get_product_attributes', 'woocommerce_product_get_gallery_image_ids' => 'woocommerce_product_gallery_attachment_ids', 'woocommerce_product_get_review_count' => 'woocommerce_product_review_count', 'woocommerce_product_get_downloads' => 'woocommerce_product_files', 'woocommerce_order_get_currency' => 'woocommerce_get_currency', 'woocommerce_order_get_discount_total' => 'woocommerce_order_amount_discount_total', 'woocommerce_order_get_discount_tax' => 'woocommerce_order_amount_discount_tax', 'woocommerce_order_get_shipping_total' => 'woocommerce_order_amount_shipping_total', 'woocommerce_order_get_shipping_tax' => 'woocommerce_order_amount_shipping_tax', 'woocommerce_order_get_cart_tax' => 'woocommerce_order_amount_cart_tax', 'woocommerce_order_get_total' => 'woocommerce_order_amount_total', 'woocommerce_order_get_total_tax' => 'woocommerce_order_amount_total_tax', 'woocommerce_order_get_total_discount' => 'woocommerce_order_amount_total_discount', 'woocommerce_order_get_subtotal' => 'woocommerce_order_amount_subtotal', 'woocommerce_order_get_tax_totals' => 'woocommerce_order_tax_totals', 'woocommerce_get_order_refund_get_amount' => 'woocommerce_refund_amount', 'woocommerce_get_order_refund_get_reason' => 'woocommerce_refund_reason', 'default_checkout_billing_country' => 'default_checkout_country', 'default_checkout_billing_state' => 'default_checkout_state', 'default_checkout_billing_postcode' => 'default_checkout_postcode', 'woocommerce_system_status_environment_rows' => 'woocommerce_debug_posting', 'woocommerce_credit_card_type_labels' => 'wocommerce_credit_card_type_labels', 'woocommerce_settings_tabs_advanced' => 'woocommerce_settings_tabs_api', 'woocommerce_settings_advanced' => 'woocommerce_settings_api', 'woocommerce_csv_importer_check_import_file_path' => 'woocommerce_product_csv_importer_check_import_file_path');
        /**
         * Array of versions on each hook has been deprecated.
         *
         * @var array
         */
        protected $deprecated_version = array('woocommerce_my_account_my_orders_columns' => '2.6.0', 'woocommerce_email_order_schema_markup' => '3.0.0', 'add_to_cart_fragments' => '3.0.0', 'add_to_cart_redirect' => '3.0.0', 'woocommerce_product_width' => '3.0.0', 'woocommerce_product_height' => '3.0.0', 'woocommerce_product_length' => '3.0.0', 'woocommerce_product_weight' => '3.0.0', 'woocommerce_get_sku' => '3.0.0', 'woocommerce_get_price' => '3.0.0', 'woocommerce_get_regular_price' => '3.0.0', 'woocommerce_get_sale_price' => '3.0.0', 'woocommerce_product_tax_class' => '3.0.0', 'woocommerce_get_stock_quantity' => '3.0.0', 'woocommerce_get_product_attributes' => '3.0.0', 'woocommerce_product_gallery_attachment_ids' => '3.0.0', 'woocommerce_product_review_count' => '3.0.0', 'woocommerce_product_files' => '3.0.0', 'woocommerce_get_currency' => '3.0.0', 'woocommerce_order_amount_discount_total' => '3.0.0', 'woocommerce_order_amount_discount_tax' => '3.0.0', 'woocommerce_order_amount_shipping_total' => '3.0.0', 'woocommerce_order_amount_shipping_tax' => '3.0.0', 'woocommerce_order_amount_cart_tax' => '3.0.0', 'woocommerce_order_amount_total' => '3.0.0', 'woocommerce_order_amount_total_tax' => '3.0.0', 'woocommerce_order_amount_total_discount' => '3.0.0', 'woocommerce_order_amount_subtotal' => '3.0.0', 'woocommerce_order_tax_totals' => '3.0.0', 'woocommerce_refund_amount' => '3.0.0', 'woocommerce_refund_reason' => '3.0.0', 'default_checkout_country' => '3.0.0', 'default_checkout_state' => '3.0.0', 'default_checkout_postcode' => '3.0.0', 'woocommerce_debug_posting' => '3.0.0', 'wocommerce_credit_card_type_labels' => '3.0.0', 'woocommerce_settings_tabs_api' => '3.4.0', 'woocommerce_settings_api' => '3.4.0', 'woocommerce_product_csv_importer_check_import_file_path' => '6.5.0');
        /**
         * Hook into the new hook so we can handle deprecated hooks once fired.
         *
         * @param string $hook_name Hook name.
         */
        public function hook_in($hook_name)
        {
        }
        /**
         * If the old hook is in-use, trigger it.
         *
         * @param  string $new_hook          New hook name.
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @param  mixed  $return_value      Returned value.
         * @return mixed
         */
        public function handle_deprecated_hook($new_hook, $old_hook, $new_callback_args, $return_value)
        {
        }
        /**
         * Fire off a legacy hook with it's args.
         *
         * @param  string $old_hook          Old hook name.
         * @param  array  $new_callback_args New callback args.
         * @return mixed
         */
        protected function trigger_hook($old_hook, $new_callback_args)
        {
        }
    }
    /**
     * Discounts class.
     */
    class WC_Discounts
    {
        /**
         * Reference to cart or order object.
         *
         * @since 3.2.0
         * @var WC_Cart|WC_Order
         */
        protected $object;
        /**
         * An array of items to discount.
         *
         * @var array
         */
        protected $items = array();
        /**
         * An array of discounts which have been applied to items.
         *
         * @var array[] Code => Item Key => Value
         */
        protected $discounts = array();
        /**
         * WC_Discounts Constructor.
         *
         * @param WC_Cart|WC_Order $object Cart or order object.
         */
        public function __construct($object = \null)
        {
        }
        /**
         * Set items directly. Used by WC_Cart_Totals.
         *
         * @since 3.2.3
         * @param array $items Items to set.
         */
        public function set_items($items)
        {
        }
        /**
         * Normalise cart items which will be discounted.
         *
         * @since 3.2.0
         * @param WC_Cart $cart Cart object.
         */
        public function set_items_from_cart($cart)
        {
        }
        /**
         * Normalise order items which will be discounted.
         *
         * @since 3.2.0
         * @param WC_Order $order Order object.
         */
        public function set_items_from_order($order)
        {
        }
        /**
         * Get the object concerned.
         *
         * @since  3.3.2
         * @return object
         */
        public function get_object()
        {
        }
        /**
         * Get items.
         *
         * @since  3.2.0
         * @return object[]
         */
        public function get_items()
        {
        }
        /**
         * Get items to validate.
         *
         * @since  3.3.2
         * @return object[]
         */
        public function get_items_to_validate()
        {
        }
        /**
         * Get discount by key with or without precision.
         *
         * @since  3.2.0
         * @param  string $key name of discount row to return.
         * @param  bool   $in_cents Should the totals be returned in cents, or without precision.
         * @return float
         */
        public function get_discount($key, $in_cents = \false)
        {
        }
        /**
         * Get all discount totals.
         *
         * @since  3.2.0
         * @param  bool $in_cents Should the totals be returned in cents, or without precision.
         * @return array
         */
        public function get_discounts($in_cents = \false)
        {
        }
        /**
         * Get all discount totals per item.
         *
         * @since  3.2.0
         * @param  bool $in_cents Should the totals be returned in cents, or without precision.
         * @return array
         */
        public function get_discounts_by_item($in_cents = \false)
        {
        }
        /**
         * Get all discount totals per coupon.
         *
         * @since  3.2.0
         * @param  bool $in_cents Should the totals be returned in cents, or without precision.
         * @return array
         */
        public function get_discounts_by_coupon($in_cents = \false)
        {
        }
        /**
         * Get discounted price of an item without precision.
         *
         * @since  3.2.0
         * @param  object $item Get data for this item.
         * @return float
         */
        public function get_discounted_price($item)
        {
        }
        /**
         * Get discounted price of an item to precision (in cents).
         *
         * @since  3.2.0
         * @param  object $item Get data for this item.
         * @return int
         */
        public function get_discounted_price_in_cents($item)
        {
        }
        /**
         * Apply a discount to all items using a coupon.
         *
         * @since  3.2.0
         * @param  WC_Coupon $coupon Coupon object being applied to the items.
         * @param  bool      $validate Set to false to skip coupon validation.
         * @throws Exception Error message when coupon isn't valid.
         * @return bool|WP_Error True if applied or WP_Error instance in failure.
         */
        public function apply_coupon($coupon, $validate = \true)
        {
        }
        /**
         * Sort by price.
         *
         * @since  3.2.0
         * @param  array $a First element.
         * @param  array $b Second element.
         * @return int
         */
        protected function sort_by_price($a, $b)
        {
        }
        /**
         * Filter out all products which have been fully discounted to 0.
         * Used as array_filter callback.
         *
         * @since  3.2.0
         * @param  object $item Get data for this item.
         * @return bool
         */
        protected function filter_products_with_price($item)
        {
        }
        /**
         * Get items which the coupon should be applied to.
         *
         * @since  3.2.0
         * @param  object $coupon Coupon object.
         * @return array
         */
        protected function get_items_to_apply_coupon($coupon)
        {
        }
        /**
         * Apply percent discount to items and return an array of discounts granted.
         *
         * @since  3.2.0
         * @param  WC_Coupon $coupon Coupon object. Passed through filters.
         * @param  array     $items_to_apply Array of items to apply the coupon to.
         * @return int Total discounted.
         */
        protected function apply_coupon_percent($coupon, $items_to_apply)
        {
        }
        /**
         * Apply fixed product discount to items.
         *
         * @since  3.2.0
         * @param  WC_Coupon $coupon Coupon object. Passed through filters.
         * @param  array     $items_to_apply Array of items to apply the coupon to.
         * @param  int       $amount Fixed discount amount to apply in cents. Leave blank to pull from coupon.
         * @return int Total discounted.
         */
        protected function apply_coupon_fixed_product($coupon, $items_to_apply, $amount = \null)
        {
        }
        /**
         * Apply fixed cart discount to items.
         *
         * @since  3.2.0
         * @param  WC_Coupon $coupon Coupon object. Passed through filters.
         * @param  array     $items_to_apply Array of items to apply the coupon to.
         * @param  int       $amount Fixed discount amount to apply in cents. Leave blank to pull from coupon.
         * @return int Total discounted.
         */
        protected function apply_coupon_fixed_cart($coupon, $items_to_apply, $amount = \null)
        {
        }
        /**
         * Apply custom coupon discount to items.
         *
         * @since  3.3
         * @param  WC_Coupon $coupon Coupon object. Passed through filters.
         * @param  array     $items_to_apply Array of items to apply the coupon to.
         * @return int Total discounted.
         */
        protected function apply_coupon_custom($coupon, $items_to_apply)
        {
        }
        /**
         * Deal with remaining fractional discounts by splitting it over items
         * until the amount is expired, discounting 1 cent at a time.
         *
         * @since 3.2.0
         * @param  WC_Coupon $coupon Coupon object if applicable. Passed through filters.
         * @param  array     $items_to_apply Array of items to apply the coupon to.
         * @param  int       $amount Fixed discount amount to apply.
         * @return int Total discounted.
         */
        protected function apply_coupon_remainder($coupon, $items_to_apply, $amount)
        {
        }
        /**
         * Ensure coupon exists or throw exception.
         *
         * A coupon is also considered to no longer exist if it has been placed in the trash, even if the trash has not yet
         * been emptied.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_exists($coupon)
        {
        }
        /**
         * Ensure coupon usage limit is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_usage_limit($coupon)
        {
        }
        /**
         * Ensure coupon user usage limit is valid or throw exception.
         *
         * Per user usage limit - check here if user is logged in (against user IDs).
         * Checked again for emails later on in WC_Cart::check_customer_coupons().
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon  Coupon data.
         * @param  int       $user_id User ID.
         * @return bool
         */
        protected function validate_coupon_user_usage_limit($coupon, $user_id = 0)
        {
        }
        /**
         * Ensure coupon date is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_expiry_date($coupon)
        {
        }
        /**
         * Ensure coupon amount is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon   Coupon data.
         * @return bool
         */
        protected function validate_coupon_minimum_amount($coupon)
        {
        }
        /**
         * Ensure coupon amount is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon   Coupon data.
         * @return bool
         */
        protected function validate_coupon_maximum_amount($coupon)
        {
        }
        /**
         * Ensure coupon is valid for products in the list is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_product_ids($coupon)
        {
        }
        /**
         * Ensure coupon is valid for product categories in the list is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_product_categories($coupon)
        {
        }
        /**
         * Ensure coupon is valid for sale items in the list is valid or throw exception.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_sale_items($coupon)
        {
        }
        /**
         * All exclusion rules must pass at the same time for a product coupon to be valid.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_excluded_items($coupon)
        {
        }
        /**
         * Cart discounts cannot be added if non-eligible product is found.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_eligible_items($coupon)
        {
        }
        /**
         * Exclude products.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_excluded_product_ids($coupon)
        {
        }
        /**
         * Exclude categories from product list.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool
         */
        protected function validate_coupon_excluded_product_categories($coupon)
        {
        }
        /**
         * Get the object subtotal
         *
         * @return int
         */
        protected function get_object_subtotal()
        {
        }
        /**
         * Check if a coupon is valid.
         *
         * Error Codes:
         * - 100: Invalid filtered.
         * - 101: Invalid removed.
         * - 102: Not yours removed.
         * - 103: Already applied.
         * - 104: Individual use only.
         * - 105: Not exists.
         * - 106: Usage limit reached.
         * - 107: Expired.
         * - 108: Minimum spend limit not met.
         * - 109: Not applicable.
         * - 110: Not valid for sale items.
         * - 111: Missing coupon code.
         * - 112: Maximum spend limit met.
         * - 113: Excluded products.
         * - 114: Excluded categories.
         *
         * @since  3.2.0
         * @throws Exception Error message.
         * @param  WC_Coupon $coupon Coupon data.
         * @return bool|WP_Error
         */
        public function is_coupon_valid($coupon)
        {
        }
    }
    /**
     * Download handler class.
     */
    class WC_Download_Handler
    {
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Check if we need to download a file and check validity.
         */
        public static function download_product()
        {
        }
        /**
         * Check if an order is valid for downloading from.
         *
         * @param WC_Customer_Download $download Download instance.
         */
        private static function check_order_is_valid($download)
        {
        }
        /**
         * Check if there are downloads remaining.
         *
         * @param WC_Customer_Download $download Download instance.
         */
        private static function check_downloads_remaining($download)
        {
        }
        /**
         * Check if the download has expired.
         *
         * @param WC_Customer_Download $download Download instance.
         */
        private static function check_download_expiry($download)
        {
        }
        /**
         * Check if a download requires the user to login first.
         *
         * @param WC_Customer_Download $download Download instance.
         */
        private static function check_download_login_required($download)
        {
        }
        /**
         * Count download.
         *
         * @deprecated 4.4.0
         * @param array $download_data Download data.
         */
        public static function count_download($download_data)
        {
        }
        /**
         * Download a file - hook into init function.
         *
         * @param string  $file_path  URL to file.
         * @param integer $product_id Product ID of the product being downloaded.
         */
        public static function download($file_path, $product_id)
        {
        }
        /**
         * Redirect to a file to start the download.
         *
         * @param string $file_path File path.
         * @param string $filename  File name.
         */
        public static function download_file_redirect($file_path, $filename = '')
        {
        }
        /**
         * Parse file path and see if its remote or local.
         *
         * @param  string $file_path File path.
         * @return array
         */
        public static function parse_file_path($file_path)
        {
        }
        /**
         * Download a file using X-Sendfile, X-Lighttpd-Sendfile, or X-Accel-Redirect if available.
         *
         * @param string $file_path File path.
         * @param string $filename  File name.
         */
        public static function download_file_xsendfile($file_path, $filename)
        {
        }
        /**
         * Parse the HTTP_RANGE request from iOS devices.
         * Does not support multi-range requests.
         *
         * @param int $file_size Size of file in bytes.
         * @return array {
         *     Information about range download request: beginning and length of
         *     file chunk, whether the range is valid/supported and whether the request is a range request.
         *
         *     @type int  $start            Byte offset of the beginning of the range. Default 0.
         *     @type int  $length           Length of the requested file chunk in bytes. Optional.
         *     @type bool $is_range_valid   Whether the requested range is a valid and supported range.
         *     @type bool $is_range_request Whether the request is a range request.
         * }
         */
        protected static function get_download_range($file_size)
        {
        }
        /**
         * Force download - this is the default method.
         *
         * @param string $file_path File path.
         * @param string $filename  File name.
         */
        public static function download_file_force($file_path, $filename)
        {
        }
        /**
         * Get content type of a download.
         *
         * @param  string $file_path File path.
         * @return string
         */
        private static function get_download_content_type($file_path)
        {
        }
        /**
         * Set headers for the download.
         *
         * @param string $file_path      File path.
         * @param string $filename       File name.
         * @param array  $download_range Array containing info about range download request (see {@see get_download_range} for structure).
         */
        private static function download_headers($file_path, $filename, $download_range = array())
        {
        }
        /**
         * Check and set certain server config variables to ensure downloads work as intended.
         */
        private static function check_server_config()
        {
        }
        /**
         * Clean all output buffers.
         *
         * Can prevent errors, for example: transfer closed with 3 bytes remaining to read.
         */
        private static function clean_buffers()
        {
        }
        /**
         *
         * Get selected content disposition
         *
         * Defaults to attachment if `woocommerce_downloads_deliver_inline` setting is not selected.
         *
         * @return string Content disposition value.
         */
        private static function get_content_disposition() : string
        {
        }
        /**
         * Read file chunked.
         *
         * Reads file in chunks so big downloads are possible without changing PHP.INI - http://codeigniter.com/wiki/Download_helper_for_large_files/.
         *
         * @param  string $file   File.
         * @param  int    $start  Byte offset/position of the beginning from which to read from the file.
         * @param  int    $length Length of the chunk to be read from the file in bytes, 0 means full file.
         * @return bool Success or fail
         */
        public static function readfile_chunked($file, $start = 0, $length = 0)
        {
        }
        /**
         * Filter headers for IE to fix issues over SSL.
         *
         * IE bug prevents download via SSL when Cache Control and Pragma no-cache headers set.
         *
         * @param array $headers HTTP headers.
         * @return array
         */
        public static function ie_nocache_headers_fix($headers)
        {
        }
        /**
         * Die with an error message if the download fails.
         *
         * @param string  $message Error message.
         * @param string  $title   Error title.
         * @param integer $status  Error status.
         */
        private static function download_error($message, $title = '', $status = 404)
        {
        }
    }
    /**
     * Emails class.
     */
    class WC_Emails
    {
        /**
         * Array of email notification classes
         *
         * @var WC_Email[]
         */
        public $emails = array();
        /**
         * The single instance of the class
         *
         * @var WC_Emails
         */
        protected static $_instance = \null;
        /**
         * Background emailer class.
         *
         * @var WC_Background_Emailer
         */
        protected static $background_emailer = \null;
        /**
         * Main WC_Emails Instance.
         *
         * Ensures only one instance of WC_Emails is loaded or can be loaded.
         *
         * @since 2.1
         * @static
         * @return WC_Emails Main instance
         */
        public static function instance()
        {
        }
        /**
         * Cloning is forbidden.
         *
         * @since 2.1
         */
        public function __clone()
        {
        }
        /**
         * Unserializing instances of this class is forbidden.
         *
         * @since 2.1
         */
        public function __wakeup()
        {
        }
        /**
         * Hook in all transactional emails.
         */
        public static function init_transactional_emails()
        {
        }
        /**
         * Queues transactional email so it's not sent in current request if enabled,
         * otherwise falls back to send now.
         *
         * @param mixed ...$args Optional arguments.
         */
        public static function queue_transactional_email(...$args)
        {
        }
        /**
         * Init the mailer instance and call the notifications for the current filter.
         *
         * @internal
         *
         * @param string $filter Filter name.
         * @param array  $args Email args (default: []).
         */
        public static function send_queued_transactional_email($filter = '', $args = array())
        {
        }
        /**
         * Init the mailer instance and call the notifications for the current filter.
         *
         * @internal
         *
         * @param array $args Email args (default: []).
         */
        public static function send_transactional_email($args = array())
        {
        }
        /**
         * Constructor for the email class hooks in all emails that can be sent.
         */
        public function __construct()
        {
        }
        /**
         * Init email classes.
         */
        public function init()
        {
        }
        /**
         * Return the email classes - used in admin to load settings.
         *
         * @return WC_Email[]
         */
        public function get_emails()
        {
        }
        /**
         * Get from name for email.
         *
         * @return string
         */
        public function get_from_name()
        {
        }
        /**
         * Get from email address.
         *
         * @return string
         */
        public function get_from_address()
        {
        }
        /**
         * Get the email header.
         *
         * @param mixed $email_heading Heading for the email.
         */
        public function email_header($email_heading)
        {
        }
        /**
         * Get the email footer.
         */
        public function email_footer()
        {
        }
        /**
         * Replace placeholder text in strings.
         *
         * @since  3.7.0
         * @param  string $string Email footer text.
         * @return string         Email footer text with any replacements done.
         */
        public function replace_placeholders($string)
        {
        }
        /**
         * Filter callback to replace {site_title} in email footer
         *
         * @since  3.3.0
         * @deprecated 3.7.0
         * @param  string $string Email footer text.
         * @return string         Email footer text with any replacements done.
         */
        public function email_footer_replace_site_title($string)
        {
        }
        /**
         * Wraps a message in the woocommerce mail template.
         *
         * @param string $email_heading Heading text.
         * @param string $message       Email message.
         * @param bool   $plain_text    Set true to send as plain text. Default to false.
         *
         * @return string
         */
        public function wrap_message($email_heading, $message, $plain_text = \false)
        {
        }
        /**
         * Send the email.
         *
         * @param mixed  $to          Receiver.
         * @param mixed  $subject     Email subject.
         * @param mixed  $message     Message.
         * @param string $headers     Email headers (default: "Content-Type: text/html\r\n").
         * @param string $attachments Attachments (default: "").
         * @return bool
         */
        public function send($to, $subject, $message, $headers = "Content-Type: text/html\r\n", $attachments = '')
        {
        }
        /**
         * Prepare and send the customer invoice email on demand.
         *
         * @param int|WC_Order $order Order instance or ID.
         */
        public function customer_invoice($order)
        {
        }
        /**
         * Customer new account welcome email.
         *
         * @param int   $customer_id        Customer ID.
         * @param array $new_customer_data  New customer data.
         * @param bool  $password_generated If password is generated.
         */
        public function customer_new_account($customer_id, $new_customer_data = array(), $password_generated = \false)
        {
        }
        /**
         * Show the order details table
         *
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         * @param string   $email         Email address.
         */
        public function order_details($order, $sent_to_admin = \false, $plain_text = \false, $email = '')
        {
        }
        /**
         * Show order downloads in a table.
         *
         * @since 3.2.0
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         * @param string   $email         Email address.
         */
        public function order_downloads($order, $sent_to_admin = \false, $plain_text = \false, $email = '')
        {
        }
        /**
         * Add order meta to email templates.
         *
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         */
        public function order_meta($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
        /**
         * Is customer detail field valid?
         *
         * @param  array $field Field data to check if is valid.
         * @return boolean
         */
        public function customer_detail_field_is_valid($field)
        {
        }
        /**
         * Allows developers to add additional customer details to templates.
         *
         * In versions prior to 3.2 this was used for notes, phone and email but this data has moved.
         *
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         */
        public function customer_details($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
        /**
         * Get the email addresses.
         *
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         */
        public function email_addresses($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
        /**
         * Get blog name formatted for emails.
         *
         * @return string
         */
        private function get_blogname()
        {
        }
        /**
         * Low stock notification email.
         *
         * @param WC_Product $product Product instance.
         */
        public function low_stock($product)
        {
        }
        /**
         * No stock notification email.
         *
         * @param WC_Product $product Product instance.
         */
        public function no_stock($product)
        {
        }
        /**
         * Backorder notification email.
         *
         * @param array $args Arguments.
         */
        public function backorder($args)
        {
        }
        /**
         * Adds Schema.org markup for order in JSON-LD format.
         *
         * @deprecated 3.0.0
         * @see WC_Structured_Data::generate_order_data()
         *
         * @since 2.6.0
         * @param WC_Order $order         Order instance.
         * @param bool     $sent_to_admin If should sent to admin.
         * @param bool     $plain_text    If is plain text email.
         */
        public function order_schema_markup($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
    }
    /**
     * Embed Class which handles any WooCommerce Products that are embedded on this site or another site.
     */
    class WC_Embed
    {
        /**
         * Init embed class.
         *
         * @since 2.4.11
         */
        public static function init()
        {
        }
        /**
         * Remove comments button on product embeds.
         *
         * @since 2.6.0
         */
        public static function remove_comments_button()
        {
        }
        /**
         * Check if this is an embedded product - to make sure we don't mess up regular posts.
         *
         * @since 2.4.11
         * @return bool
         */
        public static function is_embedded_product()
        {
        }
        /**
         * Create the excerpt for embedded products - we want to add the buy button to it.
         *
         * @since 2.4.11
         * @param string $excerpt Embed short description.
         * @return string
         */
        public static function the_excerpt($excerpt)
        {
        }
        /**
         * Create the button to go to the product page for embedded products.
         *
         * @since 2.4.11
         * @return string
         */
        public static function product_buttons()
        {
        }
        /**
         * Prints the markup for the rating stars.
         *
         * @since 2.4.11
         */
        public static function get_ratings()
        {
        }
        /**
         * Basic styling.
         */
        public static function print_embed_styles()
        {
        }
    }
    /**
     * WC_Form_Handler class.
     */
    class WC_Form_Handler
    {
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Remove key and user ID (or user login, as a fallback) from query string, set cookie, and redirect to account page to show the form.
         */
        public static function redirect_reset_password_link()
        {
        }
        /**
         * Save and and update a billing or shipping address if the
         * form was submitted through the user account page.
         */
        public static function save_address()
        {
        }
        /**
         * Save the password/account details and redirect back to the my account page.
         */
        public static function save_account_details()
        {
        }
        /**
         * Process the checkout form.
         */
        public static function checkout_action()
        {
        }
        /**
         * Process the pay form.
         *
         * @throws Exception On payment error.
         */
        public static function pay_action()
        {
        }
        /**
         * Process the add payment method form.
         */
        public static function add_payment_method_action()
        {
        }
        /**
         * Process the delete payment method form.
         */
        public static function delete_payment_method_action()
        {
        }
        /**
         * Process the delete payment method form.
         */
        public static function set_default_payment_method_action()
        {
        }
        /**
         * Remove from cart/update.
         */
        public static function update_cart_action()
        {
        }
        /**
         * Place a previous order again.
         *
         * @deprecated 3.5.0 Logic moved to cart session handling.
         */
        public static function order_again()
        {
        }
        /**
         * Cancel a pending order.
         */
        public static function cancel_order()
        {
        }
        /**
         * Add to cart action.
         *
         * Checks for a valid request, does validation (via hooks) and then redirects if valid.
         *
         * @param bool $url (default: false) URL to redirect to.
         */
        public static function add_to_cart_action($url = \false)
        {
        }
        /**
         * Handle adding simple products to the cart.
         *
         * @since 2.4.6 Split from add_to_cart_action.
         * @param int $product_id Product ID to add to the cart.
         * @return bool success or not
         */
        private static function add_to_cart_handler_simple($product_id)
        {
        }
        /**
         * Handle adding grouped products to the cart.
         *
         * @since 2.4.6 Split from add_to_cart_action.
         * @param int $product_id Product ID to add to the cart.
         * @return bool success or not
         */
        private static function add_to_cart_handler_grouped($product_id)
        {
        }
        /**
         * Handle adding variable products to the cart.
         *
         * @since 2.4.6 Split from add_to_cart_action.
         * @throws Exception If add to cart fails.
         * @param int $product_id Product ID to add to the cart.
         * @return bool success or not
         */
        private static function add_to_cart_handler_variable($product_id)
        {
        }
        /**
         * Process the login form.
         *
         * @throws Exception On login error.
         */
        public static function process_login()
        {
        }
        /**
         * Handle lost password form.
         */
        public static function process_lost_password()
        {
        }
        /**
         * Handle reset password form.
         */
        public static function process_reset_password()
        {
        }
        /**
         * Process the registration form.
         *
         * @throws Exception On registration error.
         */
        public static function process_registration()
        {
        }
    }
    /**
     * Frontend scripts class.
     */
    class WC_Frontend_Scripts
    {
        /**
         * Contains an array of script handles registered by WC.
         *
         * @var array
         */
        private static $scripts = array();
        /**
         * Contains an array of script handles registered by WC.
         *
         * @var array
         */
        private static $styles = array();
        /**
         * Contains an array of script handles localized by WC.
         *
         * @var array
         */
        private static $wp_localize_scripts = array();
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Get styles for the frontend.
         *
         * @return array
         */
        public static function get_styles()
        {
        }
        /**
         * Return asset URL.
         *
         * @param string $path Assets path.
         * @return string
         */
        private static function get_asset_url($path)
        {
        }
        /**
         * Register a script for use.
         *
         * @uses   wp_register_script()
         * @param  string   $handle    Name of the script. Should be unique.
         * @param  string   $path      Full URL of the script, or path of the script relative to the WordPress root directory.
         * @param  string[] $deps      An array of registered script handles this script depends on.
         * @param  string   $version   String specifying script version number, if it has one, which is added to the URL as a query string for cache busting purposes. If version is set to false, a version number is automatically added equal to current installed WordPress version. If set to null, no version is added.
         * @param  boolean  $in_footer Whether to enqueue the script before </body> instead of in the <head>. Default 'false'.
         */
        private static function register_script($handle, $path, $deps = array('jquery'), $version = \WC_VERSION, $in_footer = array('strategy' => 'defer'))
        {
        }
        /**
         * Register and enqueue a script for use.
         *
         * @uses   wp_enqueue_script()
         * @param  string   $handle    Name of the script. Should be unique.
         * @param  string   $path      Full URL of the script, or path of the script relative to the WordPress root directory.
         * @param  string[] $deps      An array of registered script handles this script depends on.
         * @param  string   $version   String specifying script version number, if it has one, which is added to the URL as a query string for cache busting purposes. If version is set to false, a version number is automatically added equal to current installed WordPress version. If set to null, no version is added.
         * @param  boolean  $in_footer Whether to enqueue the script before </body> instead of in the <head>. Default 'false'.
         */
        private static function enqueue_script($handle, $path = '', $deps = array('jquery'), $version = \WC_VERSION, $in_footer = array('strategy' => 'defer'))
        {
        }
        /**
         * Register a style for use.
         *
         * @uses   wp_register_style()
         * @param  string   $handle  Name of the stylesheet. Should be unique.
         * @param  string   $path    Full URL of the stylesheet, or path of the stylesheet relative to the WordPress root directory.
         * @param  string[] $deps    An array of registered stylesheet handles this stylesheet depends on.
         * @param  string   $version String specifying stylesheet version number, if it has one, which is added to the URL as a query string for cache busting purposes. If version is set to false, a version number is automatically added equal to current installed WordPress version. If set to null, no version is added.
         * @param  string   $media   The media for which this stylesheet has been defined. Accepts media types like 'all', 'print' and 'screen', or media queries like '(orientation: portrait)' and '(max-width: 640px)'.
         * @param  boolean  $has_rtl If has RTL version to load too.
         */
        private static function register_style($handle, $path, $deps = array(), $version = \WC_VERSION, $media = 'all', $has_rtl = \false)
        {
        }
        /**
         * Register and enqueue a styles for use.
         *
         * @uses   wp_enqueue_style()
         * @param  string   $handle  Name of the stylesheet. Should be unique.
         * @param  string   $path    Full URL of the stylesheet, or path of the stylesheet relative to the WordPress root directory.
         * @param  string[] $deps    An array of registered stylesheet handles this stylesheet depends on.
         * @param  string   $version String specifying stylesheet version number, if it has one, which is added to the URL as a query string for cache busting purposes. If version is set to false, a version number is automatically added equal to current installed WordPress version. If set to null, no version is added.
         * @param  string   $media   The media for which this stylesheet has been defined. Accepts media types like 'all', 'print' and 'screen', or media queries like '(orientation: portrait)' and '(max-width: 640px)'.
         * @param  boolean  $has_rtl If has RTL version to load too.
         */
        private static function enqueue_style($handle, $path = '', $deps = array(), $version = \WC_VERSION, $media = 'all', $has_rtl = \false)
        {
        }
        /**
         * Register all WC scripts.
         */
        private static function register_scripts()
        {
        }
        /**
         * Register all WC styles.
         */
        private static function register_styles()
        {
        }
        /**
         * Register/queue frontend scripts.
         */
        public static function load_scripts()
        {
        }
        /**
         * Localize a WC script once.
         *
         * @since 2.3.0 this needs less wp_script_is() calls due to https://core.trac.wordpress.org/ticket/28404 being added in WP 4.0.
         * @param string $handle Script handle the data will be attached to.
         */
        private static function localize_script($handle)
        {
        }
        /**
         * Return data for script handles.
         *
         * @param  string $handle Script handle the data will be attached to.
         * @return array|bool
         */
        private static function get_script_data($handle)
        {
        }
        /**
         * Localize scripts only when enqueued.
         */
        public static function localize_printed_scripts()
        {
        }
    }
    /**
     * WC_Geo_IP Class.
     *
     * @deprecated 3.4.0
     */
    class WC_Geo_IP
    {
        const GEOIP_COUNTRY_BEGIN = 16776960;
        const GEOIP_STATE_BEGIN_REV0 = 16700000;
        const GEOIP_STATE_BEGIN_REV1 = 16000000;
        const GEOIP_MEMORY_CACHE = 1;
        const GEOIP_SHARED_MEMORY = 2;
        const STRUCTURE_INFO_MAX_SIZE = 20;
        const GEOIP_COUNTRY_EDITION = 1;
        const GEOIP_PROXY_EDITION = 8;
        const GEOIP_ASNUM_EDITION = 9;
        const GEOIP_NETSPEED_EDITION = 10;
        const GEOIP_REGION_EDITION_REV0 = 7;
        const GEOIP_REGION_EDITION_REV1 = 3;
        const GEOIP_CITY_EDITION_REV0 = 6;
        const GEOIP_CITY_EDITION_REV1 = 2;
        const GEOIP_ORG_EDITION = 5;
        const GEOIP_ISP_EDITION = 4;
        const SEGMENT_RECORD_LENGTH = 3;
        const STANDARD_RECORD_LENGTH = 3;
        const ORG_RECORD_LENGTH = 4;
        const GEOIP_SHM_KEY = 0x4f415401;
        const GEOIP_DOMAIN_EDITION = 11;
        const GEOIP_COUNTRY_EDITION_V6 = 12;
        const GEOIP_LOCATIONA_EDITION = 13;
        const GEOIP_ACCURACYRADIUS_EDITION = 14;
        const GEOIP_CITY_EDITION_REV1_V6 = 30;
        const GEOIP_CITY_EDITION_REV0_V6 = 31;
        const GEOIP_NETSPEED_EDITION_REV1 = 32;
        const GEOIP_NETSPEED_EDITION_REV1_V6 = 33;
        const GEOIP_USERTYPE_EDITION = 28;
        const GEOIP_USERTYPE_EDITION_V6 = 29;
        const GEOIP_ASNUM_EDITION_V6 = 21;
        const GEOIP_ISP_EDITION_V6 = 22;
        const GEOIP_ORG_EDITION_V6 = 23;
        const GEOIP_DOMAIN_EDITION_V6 = 24;
        /**
         * Flags.
         *
         * @var int
         */
        public $flags;
        /**
         * File handler.
         *
         * @var resource
         */
        public $filehandle;
        /**
         * Memory buffer.
         *
         * @var string
         */
        public $memory_buffer;
        /**
         * Database type.
         *
         * @var int
         */
        public $databaseType;
        /**
         * Database segments.
         *
         * @var int
         */
        public $databaseSegments;
        /**
         * Record length.
         *
         * @var int
         */
        public $record_length;
        /**
         * Shmid.
         *
         * @var string
         */
        public $shmid;
        /**
         * Two letters country codes.
         *
         * @var array
         */
        public $GEOIP_COUNTRY_CODES = array('', 'AP', 'EU', 'AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'CW', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BM', 'BN', 'BO', 'BR', 'BS', 'BT', 'BV', 'BW', 'BY', 'BZ', 'CA', 'CC', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CX', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'EH', 'ER', 'ES', 'ET', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'SX', 'GA', 'GB', 'GD', 'GE', 'GF', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GS', 'GT', 'GU', 'GW', 'GY', 'HK', 'HM', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PN', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SJ', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'ST', 'SV', 'SY', 'SZ', 'TC', 'TD', 'TF', 'TG', 'TH', 'TJ', 'TK', 'TM', 'TN', 'TO', 'TL', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'UM', 'US', 'UY', 'UZ', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'YE', 'YT', 'RS', 'ZA', 'ZM', 'ME', 'ZW', 'A1', 'A2', 'O1', 'AX', 'GG', 'IM', 'JE', 'BL', 'MF', 'BQ', 'SS', 'O1');
        /**
         * 3 letters country codes.
         *
         * @var array
         */
        public $GEOIP_COUNTRY_CODES3 = array('', 'AP', 'EU', 'AND', 'ARE', 'AFG', 'ATG', 'AIA', 'ALB', 'ARM', 'CUW', 'AGO', 'ATA', 'ARG', 'ASM', 'AUT', 'AUS', 'ABW', 'AZE', 'BIH', 'BRB', 'BGD', 'BEL', 'BFA', 'BGR', 'BHR', 'BDI', 'BEN', 'BMU', 'BRN', 'BOL', 'BRA', 'BHS', 'BTN', 'BVT', 'BWA', 'BLR', 'BLZ', 'CAN', 'CCK', 'COD', 'CAF', 'COG', 'CHE', 'CIV', 'COK', 'CHL', 'CMR', 'CHN', 'COL', 'CRI', 'CUB', 'CPV', 'CXR', 'CYP', 'CZE', 'DEU', 'DJI', 'DNK', 'DMA', 'DOM', 'DZA', 'ECU', 'EST', 'EGY', 'ESH', 'ERI', 'ESP', 'ETH', 'FIN', 'FJI', 'FLK', 'FSM', 'FRO', 'FRA', 'SXM', 'GAB', 'GBR', 'GRD', 'GEO', 'GUF', 'GHA', 'GIB', 'GRL', 'GMB', 'GIN', 'GLP', 'GNQ', 'GRC', 'SGS', 'GTM', 'GUM', 'GNB', 'GUY', 'HKG', 'HMD', 'HND', 'HRV', 'HTI', 'HUN', 'IDN', 'IRL', 'ISR', 'IND', 'IOT', 'IRQ', 'IRN', 'ISL', 'ITA', 'JAM', 'JOR', 'JPN', 'KEN', 'KGZ', 'KHM', 'KIR', 'COM', 'KNA', 'PRK', 'KOR', 'KWT', 'CYM', 'KAZ', 'LAO', 'LBN', 'LCA', 'LIE', 'LKA', 'LBR', 'LSO', 'LTU', 'LUX', 'LVA', 'LBY', 'MAR', 'MCO', 'MDA', 'MDG', 'MHL', 'MKD', 'MLI', 'MMR', 'MNG', 'MAC', 'MNP', 'MTQ', 'MRT', 'MSR', 'MLT', 'MUS', 'MDV', 'MWI', 'MEX', 'MYS', 'MOZ', 'NAM', 'NCL', 'NER', 'NFK', 'NGA', 'NIC', 'NLD', 'NOR', 'NPL', 'NRU', 'NIU', 'NZL', 'OMN', 'PAN', 'PER', 'PYF', 'PNG', 'PHL', 'PAK', 'POL', 'SPM', 'PCN', 'PRI', 'PSE', 'PRT', 'PLW', 'PRY', 'QAT', 'REU', 'ROU', 'RUS', 'RWA', 'SAU', 'SLB', 'SYC', 'SDN', 'SWE', 'SGP', 'SHN', 'SVN', 'SJM', 'SVK', 'SLE', 'SMR', 'SEN', 'SOM', 'SUR', 'STP', 'SLV', 'SYR', 'SWZ', 'TCA', 'TCD', 'ATF', 'TGO', 'THA', 'TJK', 'TKL', 'TKM', 'TUN', 'TON', 'TLS', 'TUR', 'TTO', 'TUV', 'TWN', 'TZA', 'UKR', 'UGA', 'UMI', 'USA', 'URY', 'UZB', 'VAT', 'VCT', 'VEN', 'VGB', 'VIR', 'VNM', 'VUT', 'WLF', 'WSM', 'YEM', 'MYT', 'SRB', 'ZAF', 'ZMB', 'MNE', 'ZWE', 'A1', 'A2', 'O1', 'ALA', 'GGY', 'IMN', 'JEY', 'BLM', 'MAF', 'BES', 'SSD', 'O1');
        /**
         * Contry names.
         *
         * @var array
         */
        public $GEOIP_COUNTRY_NAMES = array('', 'Asia/Pacific Region', 'Europe', 'Andorra', 'United Arab Emirates', 'Afghanistan', 'Antigua and Barbuda', 'Anguilla', 'Albania', 'Armenia', 'Curacao', 'Angola', 'Antarctica', 'Argentina', 'American Samoa', 'Austria', 'Australia', 'Aruba', 'Azerbaijan', 'Bosnia and Herzegovina', 'Barbados', 'Bangladesh', 'Belgium', 'Burkina Faso', 'Bulgaria', 'Bahrain', 'Burundi', 'Benin', 'Bermuda', 'Brunei Darussalam', 'Bolivia', 'Brazil', 'Bahamas', 'Bhutan', 'Bouvet Island', 'Botswana', 'Belarus', 'Belize', 'Canada', 'Cocos (Keeling) Islands', 'Congo, The Democratic Republic of the', 'Central African Republic', 'Congo', 'Switzerland', "Cote D'Ivoire", 'Cook Islands', 'Chile', 'Cameroon', 'China', 'Colombia', 'Costa Rica', 'Cuba', 'Cape Verde', 'Christmas Island', 'Cyprus', 'Czech Republic', 'Germany', 'Djibouti', 'Denmark', 'Dominica', 'Dominican Republic', 'Algeria', 'Ecuador', 'Estonia', 'Egypt', 'Western Sahara', 'Eritrea', 'Spain', 'Ethiopia', 'Finland', 'Fiji', 'Falkland Islands (Malvinas)', 'Micronesia, Federated States of', 'Faroe Islands', 'France', 'Sint Maarten (Dutch part)', 'Gabon', 'United Kingdom', 'Grenada', 'Georgia', 'French Guiana', 'Ghana', 'Gibraltar', 'Greenland', 'Gambia', 'Guinea', 'Guadeloupe', 'Equatorial Guinea', 'Greece', 'South Georgia and the South Sandwich Islands', 'Guatemala', 'Guam', 'Guinea-Bissau', 'Guyana', 'Hong Kong', 'Heard Island and McDonald Islands', 'Honduras', 'Croatia', 'Haiti', 'Hungary', 'Indonesia', 'Ireland', 'Israel', 'India', 'British Indian Ocean Territory', 'Iraq', 'Iran, Islamic Republic of', 'Iceland', 'Italy', 'Jamaica', 'Jordan', 'Japan', 'Kenya', 'Kyrgyzstan', 'Cambodia', 'Kiribati', 'Comoros', 'Saint Kitts and Nevis', "Korea, Democratic People's Republic of", 'Korea, Republic of', 'Kuwait', 'Cayman Islands', 'Kazakhstan', "Lao People's Democratic Republic", 'Lebanon', 'Saint Lucia', 'Liechtenstein', 'Sri Lanka', 'Liberia', 'Lesotho', 'Lithuania', 'Luxembourg', 'Latvia', 'Libya', 'Morocco', 'Monaco', 'Moldova, Republic of', 'Madagascar', 'Marshall Islands', 'Macedonia', 'Mali', 'Myanmar', 'Mongolia', 'Macau', 'Northern Mariana Islands', 'Martinique', 'Mauritania', 'Montserrat', 'Malta', 'Mauritius', 'Maldives', 'Malawi', 'Mexico', 'Malaysia', 'Mozambique', 'Namibia', 'New Caledonia', 'Niger', 'Norfolk Island', 'Nigeria', 'Nicaragua', 'Netherlands', 'Norway', 'Nepal', 'Nauru', 'Niue', 'New Zealand', 'Oman', 'Panama', 'Peru', 'French Polynesia', 'Papua New Guinea', 'Philippines', 'Pakistan', 'Poland', 'Saint Pierre and Miquelon', 'Pitcairn Islands', 'Puerto Rico', 'Palestinian Territory', 'Portugal', 'Palau', 'Paraguay', 'Qatar', 'Reunion', 'Romania', 'Russian Federation', 'Rwanda', 'Saudi Arabia', 'Solomon Islands', 'Seychelles', 'Sudan', 'Sweden', 'Singapore', 'Saint Helena', 'Slovenia', 'Svalbard and Jan Mayen', 'Slovakia', 'Sierra Leone', 'San Marino', 'Senegal', 'Somalia', 'Suriname', 'Sao Tome and Principe', 'El Salvador', 'Syrian Arab Republic', 'Eswatini', 'Turks and Caicos Islands', 'Chad', 'French Southern Territories', 'Togo', 'Thailand', 'Tajikistan', 'Tokelau', 'Turkmenistan', 'Tunisia', 'Tonga', 'Timor-Leste', 'Turkey', 'Trinidad and Tobago', 'Tuvalu', 'Taiwan', 'Tanzania, United Republic of', 'Ukraine', 'Uganda', 'United States Minor Outlying Islands', 'United States', 'Uruguay', 'Uzbekistan', 'Holy See (Vatican City State)', 'Saint Vincent and the Grenadines', 'Venezuela', 'Virgin Islands, British', 'Virgin Islands, U.S.', 'Vietnam', 'Vanuatu', 'Wallis and Futuna', 'Samoa', 'Yemen', 'Mayotte', 'Serbia', 'South Africa', 'Zambia', 'Montenegro', 'Zimbabwe', 'Anonymous Proxy', 'Satellite Provider', 'Other', 'Aland Islands', 'Guernsey', 'Isle of Man', 'Jersey', 'Saint Barthelemy', 'Saint Martin', 'Bonaire, Saint Eustatius and Saba', 'South Sudan', 'Other');
        /**
         * 2 letters continent codes.
         *
         * @var array
         */
        public $GEOIP_CONTINENT_CODES = array('--', 'AS', 'EU', 'EU', 'AS', 'AS', 'NA', 'NA', 'EU', 'AS', 'NA', 'AF', 'AN', 'SA', 'OC', 'EU', 'OC', 'NA', 'AS', 'EU', 'NA', 'AS', 'EU', 'AF', 'EU', 'AS', 'AF', 'AF', 'NA', 'AS', 'SA', 'SA', 'NA', 'AS', 'AN', 'AF', 'EU', 'NA', 'NA', 'AS', 'AF', 'AF', 'AF', 'EU', 'AF', 'OC', 'SA', 'AF', 'AS', 'SA', 'NA', 'NA', 'AF', 'AS', 'AS', 'EU', 'EU', 'AF', 'EU', 'NA', 'NA', 'AF', 'SA', 'EU', 'AF', 'AF', 'AF', 'EU', 'AF', 'EU', 'OC', 'SA', 'OC', 'EU', 'EU', 'NA', 'AF', 'EU', 'NA', 'AS', 'SA', 'AF', 'EU', 'NA', 'AF', 'AF', 'NA', 'AF', 'EU', 'AN', 'NA', 'OC', 'AF', 'SA', 'AS', 'AN', 'NA', 'EU', 'NA', 'EU', 'AS', 'EU', 'AS', 'AS', 'AS', 'AS', 'AS', 'EU', 'EU', 'NA', 'AS', 'AS', 'AF', 'AS', 'AS', 'OC', 'AF', 'NA', 'AS', 'AS', 'AS', 'NA', 'AS', 'AS', 'AS', 'NA', 'EU', 'AS', 'AF', 'AF', 'EU', 'EU', 'EU', 'AF', 'AF', 'EU', 'EU', 'AF', 'OC', 'EU', 'AF', 'AS', 'AS', 'AS', 'OC', 'NA', 'AF', 'NA', 'EU', 'AF', 'AS', 'AF', 'NA', 'AS', 'AF', 'AF', 'OC', 'AF', 'OC', 'AF', 'NA', 'EU', 'EU', 'AS', 'OC', 'OC', 'OC', 'AS', 'NA', 'SA', 'OC', 'OC', 'AS', 'AS', 'EU', 'NA', 'OC', 'NA', 'AS', 'EU', 'OC', 'SA', 'AS', 'AF', 'EU', 'EU', 'AF', 'AS', 'OC', 'AF', 'AF', 'EU', 'AS', 'AF', 'EU', 'EU', 'EU', 'AF', 'EU', 'AF', 'AF', 'SA', 'AF', 'NA', 'AS', 'AF', 'NA', 'AF', 'AN', 'AF', 'AS', 'AS', 'OC', 'AS', 'AF', 'OC', 'AS', 'EU', 'NA', 'OC', 'AS', 'AF', 'EU', 'AF', 'OC', 'NA', 'SA', 'AS', 'EU', 'NA', 'SA', 'NA', 'NA', 'AS', 'OC', 'OC', 'OC', 'AS', 'AF', 'EU', 'AF', 'AF', 'EU', 'AF', '--', '--', '--', 'EU', 'EU', 'EU', 'EU', 'NA', 'NA', 'NA', 'AF', '--');
        /** @var WC_Logger Logger instance */
        public static $log = \false;
        /**
         * Logging method.
         *
         * @param string $message Log message.
         * @param string $level   Optional. Default 'info'.
         *     emergency|alert|critical|error|warning|notice|info|debug
         */
        public static function log($message, $level = 'info')
        {
        }
        /**
         * Open geoip file.
         *
         * @param string $filename
         * @param int    $flags
         */
        public function geoip_open($filename, $flags)
        {
        }
        /**
         * Setup segments.
         *
         * @return WC_Geo_IP instance
         */
        private function _setup_segments()
        {
        }
        /**
         * Close geoip file.
         *
         * @return bool
         */
        public function geoip_close()
        {
        }
        /**
         * Common get record.
         *
         * @param  string $seek_country
         * @return WC_Geo_IP_Record instance
         */
        private function _common_get_record($seek_country)
        {
        }
        /**
         * Get record.
         *
         * @param  int $ipnum
         * @return WC_Geo_IP_Record instance
         */
        private function _get_record($ipnum)
        {
        }
        /**
         * Seek country IPv6.
         *
         * @param  int $ipnum
         * @return string
         */
        public function _geoip_seek_country_v6($ipnum)
        {
        }
        /**
         * Seek country.
         *
         * @param  int $ipnum
         * @return string
         */
        private function _geoip_seek_country($ipnum)
        {
        }
        /**
         * Record by addr.
         *
         * @param  string $addr
         *
         * @return WC_Geo_IP_Record
         */
        public function geoip_record_by_addr($addr)
        {
        }
        /**
         * Country ID by addr IPv6.
         *
         * @param  string $addr
         * @return int|bool
         */
        public function geoip_country_id_by_addr_v6($addr)
        {
        }
        /**
         * Country ID by addr.
         *
         * @param  string $addr
         * @return int
         */
        public function geoip_country_id_by_addr($addr)
        {
        }
        /**
         * Country code by addr IPv6.
         *
         * @param  string $addr
         * @return string
         */
        public function geoip_country_code_by_addr_v6($addr)
        {
        }
        /**
         * Country code by addr.
         *
         * @param  string $addr
         * @return string
         */
        public function geoip_country_code_by_addr($addr)
        {
        }
        /**
         * Encode string.
         *
         * @param  string $string
         * @param  int    $start
         * @param  int    $length
         * @return string
         */
        private function _safe_substr($string, $start, $length)
        {
        }
    }
    /**
     * Geo IP Record class.
     */
    class WC_Geo_IP_Record
    {
        /**
         * Country code.
         *
         * @var string
         */
        public $country_code;
        /**
         * 3 letters country code.
         *
         * @var string
         */
        public $country_code3;
        /**
         * Country name.
         *
         * @var string
         */
        public $country_name;
        /**
         * Region.
         *
         * @var string
         */
        public $region;
        /**
         * City.
         *
         * @var string
         */
        public $city;
        /**
         * Postal code.
         *
         * @var string
         */
        public $postal_code;
        /**
         * Latitude
         *
         * @var int
         */
        public $latitude;
        /**
         * Longitude.
         *
         * @var int
         */
        public $longitude;
        /**
         * Area code.
         *
         * @var int
         */
        public $area_code;
        /**
         * DMA Code.
         *
         * Metro and DMA code are the same.
         * Use metro code instead.
         *
         * @var float
         */
        public $dma_code;
        /**
         * Metro code.
         *
         * @var float
         */
        public $metro_code;
        /**
         * Continent code.
         *
         * @var string
         */
        public $continent_code;
    }
    /**
     * Geolite integration class.
     *
     * @deprecated 3.9.0
     */
    class WC_Geolite_Integration
    {
        /**
         * MaxMind GeoLite2 database path.
         *
         * @var string
         */
        private $database = '';
        /**
         * Logger instance.
         *
         * @var WC_Logger
         */
        private $log = \null;
        /**
         * Constructor.
         *
         * @param string $database MaxMind GeoLite2 database path.
         */
        public function __construct($database)
        {
        }
        /**
         * Get country 2-letters ISO by IP address.
         * Returns empty string when not able to find any ISO code.
         *
         * @param string $ip_address User IP address.
         * @return string
         * @deprecated 3.9.0
         */
        public function get_country_iso($ip_address)
        {
        }
        /**
         * Logging method.
         *
         * @param string $message Log message.
         * @param string $level   Log level.
         *                        Available options: 'emergency', 'alert',
         *                        'critical', 'error', 'warning', 'notice',
         *                        'info' and 'debug'.
         *                        Defaults to 'info'.
         */
        private function log($message, $level = 'info')
        {
        }
    }
    /**
     * WC_Geolocation Class.
     */
    class WC_Geolocation
    {
        /**
         * GeoLite IPv4 DB.
         *
         * @deprecated 3.4.0
         */
        const GEOLITE_DB = 'http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz';
        /**
         * GeoLite IPv6 DB.
         *
         * @deprecated 3.4.0
         */
        const GEOLITE_IPV6_DB = 'http://geolite.maxmind.com/download/geoip/database/GeoIPv6.dat.gz';
        /**
         * GeoLite2 DB.
         *
         * @since 3.4.0
         * @deprecated 3.9.0
         */
        const GEOLITE2_DB = 'http://geolite.maxmind.com/download/geoip/database/GeoLite2-Country.tar.gz';
        /**
         * API endpoints for looking up user IP address.
         *
         * @var array
         */
        private static $ip_lookup_apis = array('ipify' => 'http://api.ipify.org/', 'ipecho' => 'http://ipecho.net/plain', 'ident' => 'http://ident.me', 'tnedi' => 'http://tnedi.me');
        /**
         * API endpoints for geolocating an IP address
         *
         * @var array
         */
        private static $geoip_apis = array('ipinfo.io' => 'https://ipinfo.io/%s/json', 'ip-api.com' => 'http://ip-api.com/json/%s');
        /**
         * Check if geolocation is enabled.
         *
         * @since 3.4.0
         * @param string $current_settings Current geolocation settings.
         * @return bool
         */
        private static function is_geolocation_enabled($current_settings)
        {
        }
        /**
         * Get current user IP Address.
         *
         * @return string
         */
        public static function get_ip_address()
        {
        }
        /**
         * Get user IP Address using an external service.
         * This can be used as a fallback for users on localhost where
         * get_ip_address() will be a local IP and non-geolocatable.
         *
         * @return string
         */
        public static function get_external_ip_address()
        {
        }
        /**
         * Geolocate an IP address.
         *
         * @param  string $ip_address   IP Address.
         * @param  bool   $fallback     If true, fallbacks to alternative IP detection (can be slower).
         * @param  bool   $api_fallback If true, uses geolocation APIs if the database file doesn't exist (can be slower).
         * @return array
         */
        public static function geolocate_ip($ip_address = '', $fallback = \false, $api_fallback = \true)
        {
        }
        /**
         * Path to our local db.
         *
         * @deprecated 3.9.0
         * @param  string $deprecated Deprecated since 3.4.0.
         * @return string
         */
        public static function get_local_database_path($deprecated = '2')
        {
        }
        /**
         * Update geoip database.
         *
         * @deprecated 3.9.0
         * Extract files with PharData. Tool built into PHP since 5.3.
         */
        public static function update_database()
        {
        }
        /**
         * Fetches the country code from the request headers, if one is available.
         *
         * @since 3.9.0
         * @return string The country code pulled from the headers, or empty string if one was not found.
         */
        private static function get_country_code_from_headers()
        {
        }
        /**
         * Use APIs to Geolocate the user.
         *
         * Geolocation APIs can be added through the use of the woocommerce_geolocation_geoip_apis filter.
         * Provide a name=>value pair for service-slug=>endpoint.
         *
         * If APIs are defined, one will be chosen at random to fulfil the request. After completing, the result
         * will be cached in a transient.
         *
         * @param  string $ip_address IP address.
         * @return string
         */
        private static function geolocate_via_api($ip_address)
        {
        }
        /**
         * Hook in geolocation functionality.
         *
         * @deprecated 3.9.0
         * @return null
         */
        public static function init()
        {
        }
        /**
         * Prevent geolocation via MaxMind when using legacy versions of php.
         *
         * @deprecated 3.9.0
         * @since 3.4.0
         * @param string $default_customer_address current value.
         * @return string
         */
        public static function disable_geolocation_on_legacy_php($default_customer_address)
        {
        }
        /**
         * Maybe trigger a DB update for the first time.
         *
         * @deprecated 3.9.0
         * @param  string $new_value New value.
         * @param  string $old_value Old value.
         * @return string
         */
        public static function maybe_update_database($new_value, $old_value)
        {
        }
    }
    /**
     * WC_HTTPS class.
     *
     * @class    WC_HTTPS
     * @version  2.2.0
     * @package  WooCommerce\Classes
     * @category Class
     * @author   WooThemes
     */
    class WC_HTTPS
    {
        /**
         * Hook in our HTTPS functions if we're on the frontend. This will ensure any links output to a page (when viewing via HTTPS) are also served over HTTPS.
         */
        public static function init()
        {
        }
        /**
         * Force https for urls.
         *
         * @param mixed $content
         * @return string
         */
        public static function force_https_url($content)
        {
        }
        /**
         * Force a post link to be SSL if needed.
         *
         * @param string $link
         * @param int $page_id
         *
         * @return string
         */
        public static function force_https_page_link($link, $page_id)
        {
        }
        /**
         * Template redirect - if we end up on a page ensure it has the correct http/https url.
         */
        public static function force_https_template_redirect()
        {
        }
        /**
         * Template redirect - if we end up on a page ensure it has the correct http/https url.
         */
        public static function unforce_https_template_redirect()
        {
        }
        /**
         * Force posts to PayPal to use TLS v1.2. See:
         *        https://core.trac.wordpress.org/ticket/36320
         *        https://core.trac.wordpress.org/ticket/34924#comment:13
         *        https://www.paypal-knowledge.com/infocenter/index?page=content&widgetview=true&id=FAQ1914&viewlocale=en_US
         *
         * @param string $handle
         * @param mixed $r
         * @param string $url
         */
        public static function http_api_curl($handle, $r, $url)
        {
        }
    }
    /**
     * WC_Install Class.
     */
    class WC_Install
    {
        use \Automattic\WooCommerce\Internal\Traits\AccessiblePrivateMethods;
        /**
         * DB updates and callbacks that need to be run per version.
         *
         * Please note that these functions are invoked when WooCommerce is updated from a previous version,
         * but NOT when WooCommerce is newly installed.
         *
         * Database schema changes must be incorporated to the SQL returned by get_schema, which is applied
         * via dbDelta at both install and update time. If any other kind of database change is required
         * at install time (e.g. populating tables), use the 'woocommerce_installed' hook.
         *
         * @var array
         */
        private static $db_updates = array('2.0.0' => array('wc_update_200_file_paths', 'wc_update_200_permalinks', 'wc_update_200_subcat_display', 'wc_update_200_taxrates', 'wc_update_200_line_items', 'wc_update_200_images', 'wc_update_200_db_version'), '2.0.9' => array('wc_update_209_brazillian_state', 'wc_update_209_db_version'), '2.1.0' => array('wc_update_210_remove_pages', 'wc_update_210_file_paths', 'wc_update_210_db_version'), '2.2.0' => array('wc_update_220_shipping', 'wc_update_220_order_status', 'wc_update_220_variations', 'wc_update_220_attributes', 'wc_update_220_db_version'), '2.3.0' => array('wc_update_230_options', 'wc_update_230_db_version'), '2.4.0' => array('wc_update_240_options', 'wc_update_240_shipping_methods', 'wc_update_240_api_keys', 'wc_update_240_refunds', 'wc_update_240_db_version'), '2.4.1' => array('wc_update_241_variations', 'wc_update_241_db_version'), '2.5.0' => array('wc_update_250_currency', 'wc_update_250_db_version'), '2.6.0' => array('wc_update_260_options', 'wc_update_260_termmeta', 'wc_update_260_zones', 'wc_update_260_zone_methods', 'wc_update_260_refunds', 'wc_update_260_db_version'), '3.0.0' => array('wc_update_300_grouped_products', 'wc_update_300_settings', 'wc_update_300_product_visibility', 'wc_update_300_db_version'), '3.1.0' => array('wc_update_310_downloadable_products', 'wc_update_310_old_comments', 'wc_update_310_db_version'), '3.1.2' => array('wc_update_312_shop_manager_capabilities', 'wc_update_312_db_version'), '3.2.0' => array('wc_update_320_mexican_states', 'wc_update_320_db_version'), '3.3.0' => array('wc_update_330_image_options', 'wc_update_330_webhooks', 'wc_update_330_product_stock_status', 'wc_update_330_set_default_product_cat', 'wc_update_330_clear_transients', 'wc_update_330_set_paypal_sandbox_credentials', 'wc_update_330_db_version'), '3.4.0' => array('wc_update_340_states', 'wc_update_340_state', 'wc_update_340_last_active', 'wc_update_340_db_version'), '3.4.3' => array('wc_update_343_cleanup_foreign_keys', 'wc_update_343_db_version'), '3.4.4' => array('wc_update_344_recreate_roles', 'wc_update_344_db_version'), '3.5.0' => array('wc_update_350_reviews_comment_type', 'wc_update_350_db_version'), '3.5.2' => array('wc_update_352_drop_download_log_fk'), '3.5.4' => array('wc_update_354_modify_shop_manager_caps', 'wc_update_354_db_version'), '3.6.0' => array('wc_update_360_product_lookup_tables', 'wc_update_360_term_meta', 'wc_update_360_downloadable_product_permissions_index', 'wc_update_360_db_version'), '3.7.0' => array('wc_update_370_tax_rate_classes', 'wc_update_370_mro_std_currency', 'wc_update_370_db_version'), '3.9.0' => array('wc_update_390_move_maxmind_database', 'wc_update_390_change_geolocation_database_update_cron', 'wc_update_390_db_version'), '4.0.0' => array('wc_update_product_lookup_tables', 'wc_update_400_increase_size_of_column', 'wc_update_400_reset_action_scheduler_migration_status', 'wc_admin_update_0201_order_status_index', 'wc_admin_update_0230_rename_gross_total', 'wc_admin_update_0251_remove_unsnooze_action', 'wc_update_400_db_version'), '4.4.0' => array('wc_update_440_insert_attribute_terms_for_variable_products', 'wc_admin_update_110_remove_facebook_note', 'wc_admin_update_130_remove_dismiss_action_from_tracking_opt_in_note', 'wc_update_440_db_version'), '4.5.0' => array('wc_update_450_sanitize_coupons_code', 'wc_update_450_db_version'), '5.0.0' => array('wc_update_500_fix_product_review_count', 'wc_admin_update_160_remove_facebook_note', 'wc_admin_update_170_homescreen_layout', 'wc_update_500_db_version'), '5.6.0' => array('wc_update_560_create_refund_returns_page', 'wc_update_560_db_version'), '6.0.0' => array('wc_update_600_migrate_rate_limit_options', 'wc_admin_update_270_delete_report_downloads', 'wc_admin_update_271_update_task_list_options', 'wc_admin_update_280_order_status', 'wc_admin_update_290_update_apperance_task_option', 'wc_admin_update_290_delete_default_homepage_layout_option', 'wc_update_600_db_version'), '6.3.0' => array('wc_update_630_create_product_attributes_lookup_table', 'wc_admin_update_300_update_is_read_from_last_read', 'wc_update_630_db_version'), '6.4.0' => array('wc_update_640_add_primary_key_to_product_attributes_lookup_table', 'wc_admin_update_340_remove_is_primary_from_note_action', 'wc_update_640_db_version'), '6.5.0' => array('wc_update_650_approved_download_directories'), '6.5.1' => array('wc_update_651_approved_download_directories'), '6.7.0' => array('wc_update_670_purge_comments_count_cache', 'wc_update_670_delete_deprecated_remote_inbox_notifications_option'), '7.0.0' => array('wc_update_700_remove_download_log_fk', 'wc_update_700_remove_recommended_marketing_plugins_transient'), '7.2.1' => array('wc_update_721_adjust_new_zealand_states', 'wc_update_721_adjust_ukraine_states'), '7.2.2' => array('wc_update_722_adjust_new_zealand_states', 'wc_update_722_adjust_ukraine_states'), '7.5.0' => array('wc_update_750_add_columns_to_order_stats_table', 'wc_update_750_disable_new_product_management_experience'), '7.7.0' => array('wc_update_770_remove_multichannel_marketing_feature_options'), '8.1.0' => array('wc_update_810_migrate_transactional_metadata_for_hpos'));
        /**
         * Option name used to track new installations of WooCommerce.
         *
         * @var string
         */
        const NEWLY_INSTALLED_OPTION = 'woocommerce_newly_installed';
        /**
         * Option name used to uniquely identify installations of WooCommerce.
         *
         * @var string
         */
        const STORE_ID_OPTION = 'woocommerce_store_id';
        /**
         * Hook in tabs.
         */
        public static function init()
        {
        }
        /**
         * Trigger `woocommerce_newly_installed` action for new installations.
         *
         * @since 8.0.0
         */
        private static function newly_installed()
        {
        }
        /**
         * Check WooCommerce version and run the updater is required.
         *
         * This check is done on all requests and runs if the versions do not match.
         */
        public static function check_version()
        {
        }
        /**
         * Performan manual database update when triggered by WooCommerce System Tools.
         *
         * @since 3.6.5
         */
        public static function manual_database_update()
        {
        }
        /**
         * Add WC Admin based db update notice.
         *
         * @since 4.0.0
         */
        public static function wc_admin_db_update_notice()
        {
        }
        /**
         * Run manual database update.
         */
        public static function run_manual_database_update()
        {
        }
        /**
         * Run an update callback when triggered by ActionScheduler.
         *
         * @param string $update_callback Callback name.
         *
         * @since 3.6.0
         */
        public static function run_update_callback($update_callback)
        {
        }
        /**
         * Triggered when a callback will run.
         *
         * @since 3.6.0
         * @param string $callback Callback name.
         */
        protected static function run_update_callback_start($callback)
        {
        }
        /**
         * Triggered when a callback has ran.
         *
         * @since 3.6.0
         * @param string $callback Callback name.
         * @param bool   $result Return value from callback. Non-false need to run again.
         */
        protected static function run_update_callback_end($callback, $result)
        {
        }
        /**
         * Install actions when a update button is clicked within the admin area.
         *
         * This function is hooked into admin_init to affect admin only.
         */
        public static function install_actions()
        {
        }
        /**
         * Install WC.
         */
        public static function install()
        {
        }
        /**
         * Returns true if we're installing.
         *
         * @return bool
         */
        private static function is_installing()
        {
        }
        /**
         * Check if all the base tables are present.
         *
         * @param bool $modify_notice Whether to modify notice based on if all tables are present.
         * @param bool $execute       Whether to execute get_schema queries as well.
         *
         * @return array List of queries.
         */
        public static function verify_base_tables($modify_notice = \true, $execute = \false)
        {
        }
        /**
         * Reset any notices added to admin.
         *
         * @since 3.2.0
         */
        private static function remove_admin_notices()
        {
        }
        /**
         * Setup WC environment - post types, taxonomies, endpoints.
         *
         * @since 3.2.0
         */
        private static function setup_environment()
        {
        }
        /**
         * Is this a brand new WC install?
         *
         * A brand new install has no version yet. Also treat empty installs as 'new'.
         *
         * @since  3.2.0
         * @return boolean
         */
        public static function is_new_install()
        {
        }
        /**
         * Is a DB update needed?
         *
         * @since  3.2.0
         * @return boolean
         */
        public static function needs_db_update()
        {
        }
        /**
         * See if we need to set redirect transients for activation or not.
         *
         * @since 4.6.0
         */
        private static function maybe_set_activation_transients()
        {
        }
        /**
         * See if we need to show or run database updates during install.
         *
         * @since 3.2.0
         */
        private static function maybe_update_db_version()
        {
        }
        /**
         * Set the Store ID if not already present.
         *
         * @since 8.4.0
         */
        public static function maybe_set_store_id()
        {
        }
        /**
         * Update WC version to current.
         */
        private static function update_wc_version()
        {
        }
        /**
         * Get list of DB update callbacks.
         *
         * @since  3.0.0
         * @return array
         */
        public static function get_db_update_callbacks()
        {
        }
        /**
         * Push all needed DB updates to the queue for processing.
         */
        private static function update()
        {
        }
        /**
         * Update DB version to current.
         *
         * @param string|null $version New WooCommerce DB version or null.
         */
        public static function update_db_version($version = \null)
        {
        }
        /**
         * Add more cron schedules.
         *
         * @param array $schedules List of WP scheduled cron jobs.
         *
         * @return array
         */
        public static function cron_schedules($schedules)
        {
        }
        /**
         * Create cron jobs (clear them first).
         */
        private static function create_cron_jobs()
        {
        }
        /**
         * Create pages on installation.
         */
        public static function maybe_create_pages()
        {
        }
        /**
         * Create pages that the plugin relies on, storing page IDs in variables.
         */
        public static function create_pages()
        {
        }
        /**
         * Default options.
         *
         * Sets up the default options used on the settings page.
         */
        private static function create_options()
        {
        }
        /**
         * Enable HPOS by default for new shops.
         *
         * @since 8.2.0
         */
        public static function maybe_enable_hpos()
        {
        }
        /**
         * Checks whether HPOS should be enabled for new shops.
         *
         * @return bool
         */
        private static function should_enable_hpos_for_new_shop()
        {
        }
        /**
         * Delete obsolete notes.
         */
        public static function delete_obsolete_notes()
        {
        }
        /**
         * Migrate option values to their new keys/names.
         */
        public static function migrate_options()
        {
        }
        /**
         * Add the default terms for WC taxonomies - product types and order statuses. Modify this at your own risk.
         */
        public static function create_terms()
        {
        }
        /**
         * Set up the database tables which the plugin needs to function.
         * WARNING: If you are modifying this method, make sure that its safe to call regardless of the state of database.
         *
         * This is called from `install` method and is executed in-sync when WC is installed or updated. This can also be called optionally from `verify_base_tables`.
         *
         * TODO: Add all crucial tables that we have created from workers in the past.
         *
         * Tables:
         *      woocommerce_attribute_taxonomies - Table for storing attribute taxonomies - these are user defined
         *      woocommerce_downloadable_product_permissions - Table for storing user and guest download permissions.
         *          KEY(order_id, product_id, download_id) used for organizing downloads on the My Account page
         *      woocommerce_order_items - Order line items are stored in a table to make them easily queryable for reports
         *      woocommerce_order_itemmeta - Order line item meta is stored in a table for storing extra data.
         *      woocommerce_tax_rates - Tax Rates are stored inside 2 tables making tax queries simple and efficient.
         *      woocommerce_tax_rate_locations - Each rate can be applied to more than one postcode/city hence the second table.
         *
         * @return array Strings containing the results of the various update queries as returned by dbDelta.
         */
        public static function create_tables()
        {
        }
        /**
         * Get Table schema.
         *
         * See https://github.com/woocommerce/woocommerce/wiki/Database-Description/
         *
         * A note on indexes; Indexes have a maximum size of 767 bytes. Historically, we haven't need to be concerned about that.
         * As of WordPress 4.2, however, we moved to utf8mb4, which uses 4 bytes per character. This means that an index which
         * used to have room for floor(767/3) = 255 characters, now only has room for floor(767/4) = 191 characters.
         *
         * Changing indexes may cause duplicate index notices in logs due to https://core.trac.wordpress.org/ticket/34870 but dropping
         * indexes first causes too much load on some servers/larger DB.
         *
         * When adding or removing a table, make sure to update the list of tables in WC_Install::get_tables().
         *
         * @return string
         */
        private static function get_schema()
        {
        }
        /**
         * Return a list of WooCommerce tables. Used to make sure all WC tables are dropped when uninstalling the plugin
         * in a single site or multi site environment.
         *
         * @return array WC tables.
         */
        public static function get_tables()
        {
        }
        /**
         * Drop WooCommerce tables.
         *
         * @return void
         */
        public static function drop_tables()
        {
        }
        /**
         * Uninstall tables when MU blog is deleted.
         *
         * @param array $tables List of tables that will be deleted by WP.
         *
         * @return string[]
         */
        public static function wpmu_drop_tables($tables)
        {
        }
        /**
         * Create roles and capabilities.
         */
        public static function create_roles()
        {
        }
        /**
         * Get capabilities for WooCommerce - these are assigned to admin/shop manager during installation or reset.
         *
         * @return array
         */
        public static function get_core_capabilities()
        {
        }
        /**
         * Remove WooCommerce roles.
         */
        public static function remove_roles()
        {
        }
        /**
         * Create files/directories.
         */
        private static function create_files()
        {
        }
        /**
         * Create a placeholder image in the media library.
         *
         * @since 3.5.0
         */
        private static function create_placeholder_image()
        {
        }
        /**
         * Show action links on the plugin screen.
         *
         * @param mixed $links Plugin Action links.
         *
         * @return array
         */
        public static function plugin_action_links($links)
        {
        }
        /**
         * Show row meta on the plugin screen.
         *
         * @param mixed $links Plugin Row Meta.
         * @param mixed $file  Plugin Base file.
         *
         * @return array
         */
        public static function plugin_row_meta($links, $file)
        {
        }
        /**
         * Get slug from path and associate it with the path.
         *
         * @param array  $plugins Associative array of plugin files to paths.
         * @param string $key Plugin relative path. Example: woocommerce/woocommerce.php.
         */
        private static function associate_plugin_file($plugins, $key)
        {
        }
        /**
         * Install a plugin from .org in the background via a cron job (used by
         * installer - opt in).
         *
         * @param string $plugin_to_install_id Plugin ID.
         * @param array  $plugin_to_install Plugin information.
         *
         * @throws Exception If unable to proceed with plugin installation.
         * @since  2.6.0
         */
        public static function background_installer($plugin_to_install_id, $plugin_to_install)
        {
        }
        /**
         * Removes redirect added during MailChimp plugin's activation.
         *
         * @param string $option Option name.
         * @param string $value  Option value.
         */
        public static function remove_mailchimps_redirect($option, $value)
        {
        }
        /**
         * Install a theme from .org in the background via a cron job (used by installer - opt in).
         *
         * @param string $theme_slug Theme slug.
         *
         * @throws Exception If unable to proceed with theme installation.
         * @since  3.1.0
         */
        public static function theme_background_installer($theme_slug)
        {
        }
        /**
         * Sets whether PayPal Standard will be loaded on install.
         *
         * @since 5.5.0
         */
        private static function set_paypal_standard_load_eligibility()
        {
        }
        /**
         * Gets the content of the sample refunds and return policy page.
         *
         * @since 5.6.0
         * @return string The content for the page
         */
        private static function get_refunds_return_policy_page_content()
        {
        }
        /**
         * Adds an admin inbox note after a page has been created to notify
         * user. For example to take action to edit the page such as the
         * Refund and returns page.
         *
         * @since 5.6.0
         * @return void
         */
        public static function add_admin_note_after_page_created()
        {
        }
        /**
         * When pages are created, we might want to take some action.
         * In this case we want to set an option when refund and returns
         * page is created.
         *
         * @since 5.6.0
         * @param int   $page_id ID of the page.
         * @param array $page_data The data of the page created.
         * @return void
         */
        public static function page_created($page_id, $page_data)
        {
        }
        /**
         * Get the Cart block content.
         *
         * @since 8.3.0
         * @return string
         */
        protected static function get_cart_block_content()
        {
        }
        /**
         * Get the Checkout block content.
         *
         * @since 8.3.0
         * @return string
         */
        protected static function get_checkout_block_content()
        {
        }
    }
    /**
     * Integrations class.
     */
    class WC_Integrations
    {
        /**
         * Array of integrations.
         *
         * @var array
         */
        public $integrations = array();
        /**
         * Initialize integrations.
         */
        public function __construct()
        {
        }
        /**
         * Return loaded integrations.
         *
         * @return array
         */
        public function get_integrations()
        {
        }
        /**
         * Return a desired integration.
         *
         * @since 3.9.0
         * @param string $id The id of the integration to get.
         * @return mixed|null The integration if one is found, otherwise null.
         */
        public function get_integration($id)
        {
        }
    }
    /**
     * Log levels class.
     */
    abstract class WC_Log_Levels
    {
        /**
         * Log Levels
         *
         * Description of levels:
         *     'emergency': System is unusable.
         *     'alert': Action must be taken immediately.
         *     'critical': Critical conditions.
         *     'error': Error conditions.
         *     'warning': Warning conditions.
         *     'notice': Normal but significant condition.
         *     'info': Informational messages.
         *     'debug': Debug-level messages.
         *
         * @see @link {https://tools.ietf.org/html/rfc5424}
         */
        const EMERGENCY = 'emergency';
        const ALERT = 'alert';
        const CRITICAL = 'critical';
        const ERROR = 'error';
        const WARNING = 'warning';
        const NOTICE = 'notice';
        const INFO = 'info';
        const DEBUG = 'debug';
        /**
         * Level strings mapped to integer severity.
         *
         * @var array
         */
        protected static $level_to_severity = array(self::EMERGENCY => 800, self::ALERT => 700, self::CRITICAL => 600, self::ERROR => 500, self::WARNING => 400, self::NOTICE => 300, self::INFO => 200, self::DEBUG => 100);
        /**
         * Severity integers mapped to level strings.
         *
         * This is the inverse of $level_severity.
         *
         * @var array
         */
        protected static $severity_to_level = array(800 => self::EMERGENCY, 700 => self::ALERT, 600 => self::CRITICAL, 500 => self::ERROR, 400 => self::WARNING, 300 => self::NOTICE, 200 => self::INFO, 100 => self::DEBUG);
        /**
         * Validate a level string.
         *
         * @param string $level Log level.
         * @return bool True if $level is a valid level.
         */
        public static function is_valid_level($level)
        {
        }
        /**
         * Translate level string to integer.
         *
         * @param string $level Log level, options: emergency|alert|critical|error|warning|notice|info|debug.
         * @return int 100 (debug) - 800 (emergency) or 0 if not recognized
         */
        public static function get_level_severity($level)
        {
        }
        /**
         * Get an associative array with `level name => numerical severity` key/value pairs.
         *
         * @return int[]
         */
        public static function get_all_level_severities()
        {
        }
        /**
         * Translate severity integer to level string.
         *
         * @param int $severity Severity level.
         * @return bool|string False if not recognized. Otherwise string representation of level.
         */
        public static function get_severity_level($severity)
        {
        }
        /**
         * Get an associative array with `numerical severity => level name` key/value pairs.
         *
         * @return string[]
         */
        public static function get_all_severity_levels()
        {
        }
    }
    /**
     * Logger Interface
     *
     * @version 3.0.0
     * @package WooCommerce\Interface
     */
    /**
     * WC Logger Interface
     *
     * Functions that must be defined to correctly fulfill logger API.
     *
     * @version 3.0.0
     */
    interface WC_Logger_Interface
    {
        /**
         * Add a log entry.
         *
         * This is not the preferred method for adding log messages. Please use log() or any one of
         * the level methods (debug(), info(), etc.). This method may be deprecated in the future.
         *
         * @param string $handle File handle.
         * @param string $message Log message.
         * @param string $level Log level.
         *
         * @return bool True if log was added, otherwise false.
         */
        public function add($handle, $message, $level = \WC_Log_Levels::NOTICE);
        /**
         * Add a log entry.
         *
         * @param string $level One of the following:
         *     'emergency': System is unusable.
         *     'alert': Action must be taken immediately.
         *     'critical': Critical conditions.
         *     'error': Error conditions.
         *     'warning': Warning conditions.
         *     'notice': Normal but significant condition.
         *     'info': Informational messages.
         *     'debug': Debug-level messages.
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function log($level, $message, $context = array());
        /**
         * Adds an emergency level message.
         *
         * System is unusable.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function emergency($message, $context = array());
        /**
         * Adds an alert level message.
         *
         * Action must be taken immediately.
         * Example: Entire website down, database unavailable, etc.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function alert($message, $context = array());
        /**
         * Adds a critical level message.
         *
         * Critical conditions.
         * Example: Application component unavailable, unexpected exception.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function critical($message, $context = array());
        /**
         * Adds an error level message.
         *
         * Runtime errors that do not require immediate action but should typically be logged
         * and monitored.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function error($message, $context = array());
        /**
         * Adds a warning level message.
         *
         * Exceptional occurrences that are not errors.
         *
         * Example: Use of deprecated APIs, poor use of an API, undesirable things that are not
         * necessarily wrong.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function warning($message, $context = array());
        /**
         * Adds a notice level message.
         *
         * Normal but significant events.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function notice($message, $context = array());
        /**
         * Adds a info level message.
         *
         * Interesting events.
         * Example: User logs in, SQL logs.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function info($message, $context = array());
        /**
         * Adds a debug level message.
         *
         * Detailed debug information.
         *
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function debug($message, $context = array());
    }
    /**
     * WC_Logger class.
     */
    class WC_Logger implements \WC_Logger_Interface
    {
        /**
         * Stores registered log handlers.
         *
         * @var array
         */
        protected $handlers;
        /**
         * Minimum log level this handler will process.
         *
         * @var int Integer representation of minimum log level to handle.
         */
        protected $threshold;
        /**
         * Constructor for the logger.
         *
         * @param array  $handlers Optional. Array of log handlers. If $handlers is not provided, the filter 'woocommerce_register_log_handlers' will be used to define the handlers. If $handlers is provided, the filter will not be applied and the handlers will be used directly.
         * @param string $threshold Optional. Define an explicit threshold. May be configured via  WC_LOG_THRESHOLD. By default, all logs will be processed.
         */
        public function __construct($handlers = \null, $threshold = \null)
        {
        }
        /**
         * Determine whether to handle or ignore log.
         *
         * @param string $level emergency|alert|critical|error|warning|notice|info|debug.
         * @return bool True if the log should be handled.
         */
        protected function should_handle($level)
        {
        }
        /**
         * Add a log entry.
         *
         * This is not the preferred method for adding log messages. Please use log() or any one of
         * the level methods (debug(), info(), etc.). This method may be deprecated in the future.
         *
         * @param string $handle File handle.
         * @param string $message Message to log.
         * @param string $level Logging level.
         * @return bool
         */
        public function add($handle, $message, $level = \WC_Log_Levels::NOTICE)
        {
        }
        /**
         * Add a log entry.
         *
         * @param string $level One of the following:
         *     'emergency': System is unusable.
         *     'alert': Action must be taken immediately.
         *     'critical': Critical conditions.
         *     'error': Error conditions.
         *     'warning': Warning conditions.
         *     'notice': Normal but significant condition.
         *     'info': Informational messages.
         *     'debug': Debug-level messages.
         * @param string $message Log message.
         * @param array  $context Optional. Additional information for log handlers.
         */
        public function log($level, $message, $context = array())
        {
        }
        /**
         * Adds an emergency level message.
         *
         * System is unusable.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function emergency($message, $context = array())
        {
        }
        /**
         * Adds an alert level message.
         *
         * Action must be taken immediately.
         * Example: Entire website down, database unavailable, etc.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function alert($message, $context = array())
        {
        }
        /**
         * Adds a critical level message.
         *
         * Critical conditions.
         * Example: Application component unavailable, unexpected exception.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function critical($message, $context = array())
        {
        }
        /**
         * Adds an error level message.
         *
         * Runtime errors that do not require immediate action but should typically be logged
         * and monitored.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function error($message, $context = array())
        {
        }
        /**
         * Adds a warning level message.
         *
         * Exceptional occurrences that are not errors.
         *
         * Example: Use of deprecated APIs, poor use of an API, undesirable things that are not
         * necessarily wrong.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function warning($message, $context = array())
        {
        }
        /**
         * Adds a notice level message.
         *
         * Normal but significant events.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function notice($message, $context = array())
        {
        }
        /**
         * Adds a info level message.
         *
         * Interesting events.
         * Example: User logs in, SQL logs.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function info($message, $context = array())
        {
        }
        /**
         * Adds a debug level message.
         *
         * Detailed debug information.
         *
         * @see WC_Logger::log
         *
         * @param string $message Message to log.
         * @param array  $context Log context.
         */
        public function debug($message, $context = array())
        {
        }
        /**
         * Clear entries for a chosen file/source.
         *
         * @param string $source Source/handle to clear.
         * @return bool
         */
        public function clear($source = '')
        {
        }
        /**
         * Clear all logs older than a defined number of days. Defaults to 30 days.
         *
         * @since 3.4.0
         */
        public function clear_expired_logs()
        {
        }
    }
    /**
     * Meta data class.
     */
    class WC_Meta_Data implements \JsonSerializable
    {
        /**
         * Current data for metadata
         *
         * @since 3.2.0
         * @var array
         */
        protected $current_data;
        /**
         * Metadata data
         *
         * @since 3.2.0
         * @var array
         */
        protected $data;
        /**
         * Constructor.
         *
         * @param array $meta Data to wrap behind this function.
         */
        public function __construct($meta = array())
        {
        }
        /**
         * When converted to JSON.
         *
         * @return object|array
         */
        #[\ReturnTypeWillChange]
        public function jsonSerialize()
        {
        }
        /**
         * Merge changes with data and clear.
         */
        public function apply_changes()
        {
        }
        /**
         * Creates or updates a property in the metadata object.
         *
         * @param string $key Key to set.
         * @param mixed  $value Value to set.
         */
        public function __set($key, $value)
        {
        }
        /**
         * Checks if a given key exists in our data. This is called internally
         * by `empty` and `isset`.
         *
         * @param string $key Key to check if set.
         *
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Returns the value of any property.
         *
         * @param string $key Key to get.
         * @return mixed Property value or NULL if it does not exists
         */
        public function __get($key)
        {
        }
        /**
         * Return data changes only.
         *
         * @return array
         */
        public function get_changes()
        {
        }
        /**
         * Return all data as an array.
         *
         * @return array
         */
        public function get_data()
        {
        }
    }
    /**
     * Order factory class
     */
    class WC_Order_Factory
    {
        /**
         * Get order.
         *
         * @param  mixed $order_id (default: false) Order ID to get.
         * @return \WC_Order|bool
         */
        public static function get_order($order_id = \false)
        {
        }
        /**
         * Get multiple orders (by ID).
         *
         * @param array[mixed] $order_ids                     Array of order IDs to get.
         * @param boolean      $skip_invalid (default: false) TRUE if invalid IDs or orders should be ignored.
         * @return array[\WC_Order]
         *
         * @throws \Exception When an invalid order is found.
         */
        public static function get_orders($order_ids = array(), $skip_invalid = \false)
        {
        }
        /**
         * Get order item.
         *
         * @param int $item_id Order item ID to get.
         * @return WC_Order_Item|false if not found
         */
        public static function get_order_item($item_id = 0)
        {
        }
        /**
         * Get the order ID depending on what was passed.
         *
         * @since 3.0.0
         * @param  mixed $order Order data to convert to an ID.
         * @return int|bool false on failure
         */
        public static function get_order_id($order)
        {
        }
        /**
         * Try to determine the current order ID based on available global state.
         *
         * @return false|int
         */
        private static function get_global_order_id()
        {
        }
        /**
         * Gets the class name bunch of order instances should have based on their IDs.
         *
         * @param array $order_ids Order IDs to get the class name for.
         *
         * @return array Array of order_id => class_name.
         */
        public static function get_class_names_for_order_ids($order_ids)
        {
        }
        /**
         * Gets the class name an order instance should have based on its ID.
         *
         * @since 6.9.0
         * @param int $order_id The order ID.
         * @return string The class name or FALSE if the class does not exist.
         */
        private static function get_class_name_for_order_id($order_id)
        {
        }
    }
    /**
     * Order item class.
     */
    class WC_Order_Item extends \WC_Data implements \ArrayAccess
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('order_id' => 0, 'name' => '');
        /**
         * Stores meta in cache for future reads.
         * A group must be set to to enable caching.
         *
         * @var string
         */
        protected $cache_group = 'order-items';
        /**
         * Meta type. This should match up with
         * the types available at https://developer.wordpress.org/reference/functions/add_metadata/.
         * WP defines 'post', 'user', 'comment', and 'term'.
         *
         * @var string
         */
        protected $meta_type = 'order_item';
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'order_item';
        /**
         * Constructor.
         *
         * @param int|object|array $item ID to load from the DB, or WC_Order_Item object.
         */
        public function __construct($item = 0)
        {
        }
        /**
         * Merge changes with data and clear.
         * Overrides WC_Data::apply_changes.
         * array_replace_recursive does not work well for order items because it merges taxes instead
         * of replacing them.
         *
         * @since 3.2.0
         */
        public function apply_changes()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get order ID this meta belongs to.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return int
         */
        public function get_order_id($context = 'view')
        {
        }
        /**
         * Get order item name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get order item type. Overridden by child classes.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get quantity.
         *
         * @return int
         */
        public function get_quantity()
        {
        }
        /**
         * Get tax status.
         *
         * @return string
         */
        public function get_tax_status()
        {
        }
        /**
         * Get tax class.
         *
         * @return string
         */
        public function get_tax_class()
        {
        }
        /**
         * Get parent order object.
         *
         * @return WC_Order
         */
        public function get_order()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set order ID.
         *
         * @param int $value Order ID.
         */
        public function set_order_id($value)
        {
        }
        /**
         * Set order item name.
         *
         * @param string $value Item name.
         */
        public function set_name($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Other Methods
        |--------------------------------------------------------------------------
        */
        /**
         * Type checking.
         *
         * @param  string|array $type Type.
         * @return boolean
         */
        public function is_type($type)
        {
        }
        /**
         * Calculate item taxes.
         *
         * @since  3.2.0
         * @param  array $calculate_tax_for Location data to get taxes for. Required.
         * @return bool  True if taxes were calculated.
         */
        public function calculate_taxes($calculate_tax_for = array())
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Meta Data Handling
        |--------------------------------------------------------------------------
        */
        /**
         * Wrapper for get_formatted_meta_data that includes all metadata by default. See https://github.com/woocommerce/woocommerce/pull/30948
         *
         * @param string $hideprefix  Meta data prefix, (default: _).
         * @param bool   $include_all Include all meta data, this stop skip items with values already in the product name.
         * @return array
         */
        public function get_all_formatted_meta_data($hideprefix = '_', $include_all = \true)
        {
        }
        /**
         * Expands things like term slugs before return.
         *
         * @param string $hideprefix  Meta data prefix, (default: _).
         * @param bool   $include_all Include all meta data, this stop skip items with values already in the product name.
         * @return array
         */
        public function get_formatted_meta_data($hideprefix = '_', $include_all = \false)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * OffsetSet for ArrayAccess.
         *
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetUnset for ArrayAccess.
         *
         * @param string $offset Offset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * OffsetExists for ArrayAccess.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
        /**
         * OffsetGet for ArrayAccess.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
    }
    /**
     * Order item coupon class.
     */
    class WC_Order_Item_Coupon extends \WC_Order_Item
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array('code' => '', 'discount' => 0, 'discount_tax' => 0);
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set order item name.
         *
         * @param string $value Coupon code.
         */
        public function set_name($value)
        {
        }
        /**
         * Set code.
         *
         * @param string $value Coupon code.
         */
        public function set_code($value)
        {
        }
        /**
         * Set discount amount.
         *
         * @param string $value Discount.
         */
        public function set_discount($value)
        {
        }
        /**
         * Set discounted tax amount.
         *
         * @param string $value Discount tax.
         */
        public function set_discount_tax($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get order item type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get order item name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get coupon code.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_code($context = 'view')
        {
        }
        /**
         * Get discount amount.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_discount($context = 'view')
        {
        }
        /**
         * Get discounted tax amount.
         *
         * @param string $context What the value is for. Valid values are 'view' and 'edit'.
         *
         * @return string
         */
        public function get_discount_tax($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * OffsetGet for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetExists for ArrayAccess.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Order item fee.
     */
    class WC_Order_Item_Fee extends \WC_Order_Item
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array('tax_class' => '', 'tax_status' => 'taxable', 'amount' => '', 'total' => '', 'total_tax' => '', 'taxes' => array('total' => array()));
        /**
         * Get item costs grouped by tax class.
         *
         * @since  3.2.0
         * @param  WC_Order $order Order object.
         * @return array
         */
        protected function get_tax_class_costs($order)
        {
        }
        /**
         * Calculate item taxes.
         *
         * @since  3.2.0
         * @param  array $calculate_tax_for Location data to get taxes for. Required.
         * @return bool  True if taxes were calculated.
         */
        public function calculate_taxes($calculate_tax_for = array())
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set fee amount.
         *
         * @param string $value Amount.
         */
        public function set_amount($value)
        {
        }
        /**
         * Set tax class.
         *
         * @param string $value Tax class.
         */
        public function set_tax_class($value)
        {
        }
        /**
         * Set tax_status.
         *
         * @param string $value Tax status.
         */
        public function set_tax_status($value)
        {
        }
        /**
         * Set total.
         *
         * @param string $amount Fee amount (do not enter negative amounts).
         */
        public function set_total($amount)
        {
        }
        /**
         * Set total tax.
         *
         * @param string $amount Amount.
         */
        public function set_total_tax($amount)
        {
        }
        /**
         * Set taxes.
         *
         * This is an array of tax ID keys with total amount values.
         *
         * @param array $raw_tax_data Raw tax data.
         */
        public function set_taxes($raw_tax_data)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get fee amount.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_amount($context = 'view')
        {
        }
        /**
         * Get order item name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get order item type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get tax class.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_tax_class($context = 'view')
        {
        }
        /**
         * Get tax status.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_tax_status($context = 'view')
        {
        }
        /**
         * Get total fee.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_total($context = 'view')
        {
        }
        /**
         * Get total tax.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_total_tax($context = 'view')
        {
        }
        /**
         * Get fee taxes.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_taxes($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * OffsetGet for ArrayAccess/Backwards compatibility.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetExists for ArrayAccess
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Order item meta class.
     */
    class WC_Order_Item_Meta
    {
        /**
         * For handling backwards compatibility.
         *
         * @var bool
         */
        private $legacy = \false;
        /**
         * Order item
         *
         * @var array|null
         */
        private $item = \null;
        /**
         * Post meta data
         *
         * @var array|null
         */
        public $meta = \null;
        /**
         * Product object.
         *
         * @var WC_Product|null
         */
        public $product = \null;
        /**
         * Constructor.
         *
         * @param array       $item defaults to array().
         * @param \WC_Product $product defaults to null.
         */
        public function __construct($item = array(), $product = \null)
        {
        }
        /**
         * Display meta in a formatted list.
         *
         * @param bool   $flat       Flat (default: false).
         * @param bool   $return     Return (default: false).
         * @param string $hideprefix Hide prefix (default: _).
         * @param  string $delimiter Delimiter used to separate items when $flat is true.
         * @return string|void
         */
        public function display($flat = \false, $return = \false, $hideprefix = '_', $delimiter = ", \n")
        {
        }
        /**
         * Return an array of formatted item meta in format e.g.
         *
         * Returns: array(
         *   'pa_size' => array(
         *     'label' => 'Size',
         *     'value' => 'Medium',
         *   )
         * )
         *
         * @since 2.4
         * @param string $hideprefix exclude meta when key is prefixed with this, defaults to '_'.
         * @return array
         */
        public function get_formatted($hideprefix = '_')
        {
        }
        /**
         * Return an array of formatted item meta in format e.g.
         * Handles @deprecated args.
         *
         * @param string $hideprefix Hide prefix.
         *
         * @return array
         */
        public function get_formatted_legacy($hideprefix = '_')
        {
        }
    }
    /**
     * Order item product class.
     */
    class WC_Order_Item_Product extends \WC_Order_Item
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array('product_id' => 0, 'variation_id' => 0, 'quantity' => 1, 'tax_class' => '', 'subtotal' => 0, 'subtotal_tax' => 0, 'total' => 0, 'total_tax' => 0, 'taxes' => array('subtotal' => array(), 'total' => array()));
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set quantity.
         *
         * @param int $value Quantity.
         */
        public function set_quantity($value)
        {
        }
        /**
         * Set tax class.
         *
         * @param string $value Tax class.
         */
        public function set_tax_class($value)
        {
        }
        /**
         * Set Product ID
         *
         * @param int $value Product ID.
         */
        public function set_product_id($value)
        {
        }
        /**
         * Set variation ID.
         *
         * @param int $value Variation ID.
         */
        public function set_variation_id($value)
        {
        }
        /**
         * Line subtotal (before discounts).
         *
         * @param string $value Subtotal.
         */
        public function set_subtotal($value)
        {
        }
        /**
         * Line total (after discounts).
         *
         * @param string $value Total.
         */
        public function set_total($value)
        {
        }
        /**
         * Line subtotal tax (before discounts).
         *
         * @param string $value Subtotal tax.
         */
        public function set_subtotal_tax($value)
        {
        }
        /**
         * Line total tax (after discounts).
         *
         * @param string $value Total tax.
         */
        public function set_total_tax($value)
        {
        }
        /**
         * Set line taxes and totals for passed in taxes.
         *
         * @param array $raw_tax_data Raw tax data.
         */
        public function set_taxes($raw_tax_data)
        {
        }
        /**
         * Set variation data (stored as meta data - write only).
         *
         * @param array $data Key/Value pairs.
         */
        public function set_variation($data = array())
        {
        }
        /**
         * Set properties based on passed in product object.
         *
         * @param WC_Product $product Product instance.
         */
        public function set_product($product)
        {
        }
        /**
         * Set meta data for backordered products.
         */
        public function set_backorder_meta()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get order item type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get product ID.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return int
         */
        public function get_product_id($context = 'view')
        {
        }
        /**
         * Get variation ID.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return int
         */
        public function get_variation_id($context = 'view')
        {
        }
        /**
         * Get quantity.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return int
         */
        public function get_quantity($context = 'view')
        {
        }
        /**
         * Get tax class.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_tax_class($context = 'view')
        {
        }
        /**
         * Gets the item subtotal. This is the price of the item times the quantity
         * excluding taxes before coupon discounts.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_subtotal($context = 'view')
        {
        }
        /**
         * Get subtotal tax.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_subtotal_tax($context = 'view')
        {
        }
        /**
         * Gets the item total. This is the price of the item times the quantity
         * excluding taxes after coupon discounts.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_total($context = 'view')
        {
        }
        /**
         * Get total tax.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_total_tax($context = 'view')
        {
        }
        /**
         * Get taxes.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return array
         */
        public function get_taxes($context = 'view')
        {
        }
        /**
         * Get the associated product.
         *
         * @return WC_Product|bool
         */
        public function get_product()
        {
        }
        /**
         * Get the Download URL.
         *
         * @param  int $download_id Download ID.
         * @return string
         */
        public function get_item_download_url($download_id)
        {
        }
        /**
         * Get any associated downloadable files.
         *
         * @return array
         */
        public function get_item_downloads()
        {
        }
        /**
         * Get tax status.
         *
         * @return string
         */
        public function get_tax_status()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * OffsetGet for ArrayAccess/Backwards compatibility.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetExists for ArrayAccess.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Order item shipping class.
     */
    class WC_Order_Item_Shipping extends \WC_Order_Item
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array('method_title' => '', 'method_id' => '', 'instance_id' => '', 'total' => 0, 'total_tax' => 0, 'taxes' => array('total' => array()));
        /**
         * Calculate item taxes.
         *
         * @since  3.2.0
         * @param  array $calculate_tax_for Location data to get taxes for. Required.
         * @return bool  True if taxes were calculated.
         */
        public function calculate_taxes($calculate_tax_for = array())
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set order item name.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_name($value)
        {
        }
        /**
         * Set method title.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_method_title($value)
        {
        }
        /**
         * Set shipping method id.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_method_id($value)
        {
        }
        /**
         * Set shipping instance id.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_instance_id($value)
        {
        }
        /**
         * Set total.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_total($value)
        {
        }
        /**
         * Set total tax.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        protected function set_total_tax($value)
        {
        }
        /**
         * Set taxes.
         *
         * This is an array of tax ID keys with total amount values.
         *
         * @param array $raw_tax_data Value to set.
         * @throws WC_Data_Exception May throw exception if data is invalid.
         */
        public function set_taxes($raw_tax_data)
        {
        }
        /**
         * Set properties based on passed in shipping rate object.
         *
         * @param WC_Shipping_Rate $shipping_rate Shipping rate to set.
         */
        public function set_shipping_rate($shipping_rate)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get order item type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get order item name.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get title.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_method_title($context = 'view')
        {
        }
        /**
         * Get method ID.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_method_id($context = 'view')
        {
        }
        /**
         * Get instance ID.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_instance_id($context = 'view')
        {
        }
        /**
         * Get total cost.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_total($context = 'view')
        {
        }
        /**
         * Get total tax.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_total_tax($context = 'view')
        {
        }
        /**
         * Get taxes.
         *
         * @param  string $context View or edit context.
         * @return array
         */
        public function get_taxes($context = 'view')
        {
        }
        /**
         * Get tax class.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_tax_class($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * Offset get: for ArrayAccess/Backwards compatibility.
         *
         * @param string $offset Key.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * Offset set: for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Key.
         * @param mixed  $value Value to set.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * Offset exists: for ArrayAccess.
         *
         * @param string $offset Key.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Order item tax.
     */
    class WC_Order_Item_Tax extends \WC_Order_Item
    {
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $extra_data = array('rate_code' => '', 'rate_id' => 0, 'label' => '', 'compound' => \false, 'tax_total' => 0, 'shipping_tax_total' => 0, 'rate_percent' => \null);
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set order item name.
         *
         * @param string $value Name.
         */
        public function set_name($value)
        {
        }
        /**
         * Set item name.
         *
         * @param string $value Rate code.
         */
        public function set_rate_code($value)
        {
        }
        /**
         * Set item name.
         *
         * @param string $value Label.
         */
        public function set_label($value)
        {
        }
        /**
         * Set tax rate id.
         *
         * @param int $value Rate ID.
         */
        public function set_rate_id($value)
        {
        }
        /**
         * Set tax total.
         *
         * @param string $value Tax total.
         */
        public function set_tax_total($value)
        {
        }
        /**
         * Set shipping tax total.
         *
         * @param string $value Shipping tax total.
         */
        public function set_shipping_tax_total($value)
        {
        }
        /**
         * Set compound.
         *
         * @param bool $value If tax is compound.
         */
        public function set_compound($value)
        {
        }
        /**
         * Set rate value.
         *
         * @param float $value tax rate value.
         */
        public function set_rate_percent($value)
        {
        }
        /**
         * Set properties based on passed in tax rate by ID.
         *
         * @param int $tax_rate_id Tax rate ID.
         */
        public function set_rate($tax_rate_id)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get order item type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get rate code/name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_name($context = 'view')
        {
        }
        /**
         * Get rate code/name.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_rate_code($context = 'view')
        {
        }
        /**
         * Get label.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_label($context = 'view')
        {
        }
        /**
         * Get tax rate ID.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return int
         */
        public function get_rate_id($context = 'view')
        {
        }
        /**
         * Get tax_total
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_tax_total($context = 'view')
        {
        }
        /**
         * Get shipping_tax_total
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_shipping_tax_total($context = 'view')
        {
        }
        /**
         * Get compound.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return bool
         */
        public function get_compound($context = 'view')
        {
        }
        /**
         * Is this a compound tax rate?
         *
         * @return boolean
         */
        public function is_compound()
        {
        }
        /**
         * Get rate value
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return float
         */
        public function get_rate_percent($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Array Access Methods
        |--------------------------------------------------------------------------
        |
        | For backwards compatibility with legacy arrays.
        |
        */
        /**
         * O for ArrayAccess/Backwards compatibility.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet for ArrayAccess/Backwards compatibility.
         *
         * @deprecated 4.4.0
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetExists for ArrayAccess.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Order query class.
     */
    class WC_Order_Query extends \WC_Object_Query
    {
        /**
         * Valid query vars for orders.
         *
         * @return array
         */
        protected function get_default_query_vars()
        {
        }
        /**
         * Get orders matching the current query vars.
         *
         * @return array|object of WC_Order objects
         *
         * @throws Exception When WC_Data_Store validation fails.
         */
        public function get_orders()
        {
        }
    }
    /**
     * Order refund class.
     */
    class WC_Order_Refund extends \WC_Abstract_Order
    {
        /**
         * Which data store to load.
         *
         * @var string
         */
        protected $data_store_name = 'order-refund';
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'order_refund';
        /**
         * Stores product data.
         *
         * @var array
         */
        protected $extra_data = array('amount' => '', 'reason' => '', 'refunded_by' => 0, 'refunded_payment' => \false);
        /**
         * List of properties that were earlier managed by data store. However, since DataStore is a not a stored entity in itself, they used to store data in metadata of the data object.
         * With custom tables, some of these are moved from metadata to their own columns, but existing code will still try to add them to metadata. This array is used to keep track of such properties.
         *
         * Only reason to add a property here is that you are moving properties from DataStore instance to data object. Otherwise, if you are adding a new property, consider adding it to $data array instead.
         *
         * @var array
         */
        protected $legacy_datastore_props = array('_refund_amount', '_refund_reason', '_refunded_by', '_refunded_payment');
        /**
         * Get internal type (post type.)
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get status - always completed for refunds.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_status($context = 'view')
        {
        }
        /**
         * Get a title for the new post type.
         */
        public function get_post_title()
        {
        }
        /**
         * Get refunded amount.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int|float
         */
        public function get_amount($context = 'view')
        {
        }
        /**
         * Get refund reason.
         *
         * @since 2.2
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_reason($context = 'view')
        {
        }
        /**
         * Get ID of user who did the refund.
         *
         * @since 3.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_refunded_by($context = 'view')
        {
        }
        /**
         * Return if the payment was refunded via API.
         *
         * @since  3.3
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_refunded_payment($context = 'view')
        {
        }
        /**
         * Get formatted refunded amount.
         *
         * @since 2.4
         * @return string
         */
        public function get_formatted_refund_amount()
        {
        }
        /**
         * Set refunded amount.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception if the amount is invalid.
         */
        public function set_amount($value)
        {
        }
        /**
         * Set refund reason.
         *
         * @param string $value Value to set.
         * @throws WC_Data_Exception Exception if the amount is invalid.
         */
        public function set_reason($value)
        {
        }
        /**
         * Set refunded by.
         *
         * @param int $value Value to set.
         * @throws WC_Data_Exception Exception if the amount is invalid.
         */
        public function set_refunded_by($value)
        {
        }
        /**
         * Set if the payment was refunded via API.
         *
         * @since 3.3
         * @param bool $value Value to set.
         */
        public function set_refunded_payment($value)
        {
        }
        /**
         * Magic __get method for backwards compatibility.
         *
         * @param string $key Value to get.
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * Gets an refund from the database.
         *
         * @deprecated 3.0
         * @param int $id (default: 0).
         * @return bool
         */
        public function get_refund($id = 0)
        {
        }
        /**
         * Get refund amount.
         *
         * @deprecated 3.0
         * @return int|float
         */
        public function get_refund_amount()
        {
        }
        /**
         * Get refund reason.
         *
         * @deprecated 3.0
         * @return string
         */
        public function get_refund_reason()
        {
        }
    }
    /**
     * Order Class.
     *
     * These are regular WooCommerce orders, which extend the abstract order class.
     */
    class WC_Order extends \WC_Abstract_Order
    {
        /**
         * Stores data about status changes so relevant hooks can be fired.
         *
         * @var bool|array
         */
        protected $status_transition = \false;
        /**
         * Order Data array. This is the core order data exposed in APIs since 3.0.0.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array(
            // Abstract order props.
            'parent_id' => 0,
            'status' => '',
            'currency' => '',
            'version' => '',
            'prices_include_tax' => \false,
            'date_created' => \null,
            'date_modified' => \null,
            'discount_total' => 0,
            'discount_tax' => 0,
            'shipping_total' => 0,
            'shipping_tax' => 0,
            'cart_tax' => 0,
            'total' => 0,
            'total_tax' => 0,
            // Order props.
            'customer_id' => 0,
            'order_key' => '',
            'billing' => array('first_name' => '', 'last_name' => '', 'company' => '', 'address_1' => '', 'address_2' => '', 'city' => '', 'state' => '', 'postcode' => '', 'country' => '', 'email' => '', 'phone' => ''),
            'shipping' => array('first_name' => '', 'last_name' => '', 'company' => '', 'address_1' => '', 'address_2' => '', 'city' => '', 'state' => '', 'postcode' => '', 'country' => '', 'phone' => ''),
            'payment_method' => '',
            'payment_method_title' => '',
            'transaction_id' => '',
            'customer_ip_address' => '',
            'customer_user_agent' => '',
            'created_via' => '',
            'customer_note' => '',
            'date_completed' => \null,
            'date_paid' => \null,
            'cart_hash' => '',
            // Operational data.
            'order_stock_reduced' => \false,
            'download_permissions_granted' => \false,
            'new_order_email_sent' => \false,
            'recorded_sales' => \false,
            'recorded_coupon_usage_counts' => \false,
        );
        /**
         * List of properties that were earlier managed by data store. However, since DataStore is a not a stored entity in itself, they used to store data in metadata of the data object.
         * With custom tables, some of these are moved from metadata to their own columns, but existing code will still try to add them to metadata. This array is used to keep track of such properties.
         *
         * Only reason to add a property here is that you are moving properties from DataStore instance to data object. Otherwise, if you are adding a new property, consider adding it to $data array instead.
         *
         * @var array
         */
        protected $legacy_datastore_props = array('_recorded_sales', '_recorded_coupon_usage_counts', '_download_permissions_granted', '_order_stock_reduced', '_new_order_email_sent');
        /**
         * Refunds for an order. Use {@see get_refunds()} instead.
         *
         * @deprecated 2.2.0
         * @var stdClass|WC_Order[]
         */
        public $refunds;
        /**
         * When a payment is complete this function is called.
         *
         * Most of the time this should mark an order as 'processing' so that admin can process/post the items.
         * If the cart contains only downloadable items then the order is 'completed' since the admin needs to take no action.
         * Stock levels are reduced at this point.
         * Sales are also recorded for products.
         * Finally, record the date of payment.
         *
         * @param string $transaction_id Optional transaction id to store in post meta.
         * @return bool success
         */
        public function payment_complete($transaction_id = '')
        {
        }
        /**
         * Gets order total - formatted for display.
         *
         * @param string $tax_display      Type of tax display.
         * @param bool   $display_refunded If should include refunded value.
         *
         * @return string
         */
        public function get_formatted_order_total($tax_display = '', $display_refunded = \true)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | CRUD methods
        |--------------------------------------------------------------------------
        |
        | Methods which create, read, update and delete orders from the database.
        | Written in abstract fashion so that the way orders are stored can be
        | changed more easily in the future.
        |
        | A save method is included for convenience (chooses update or create based
        | on if the order exists yet).
        |
        */
        /**
         * Save data to the database.
         *
         * @since 3.0.0
         * @return int order ID
         */
        public function save()
        {
        }
        /**
         * Log an error about this order is exception is encountered.
         *
         * @param Exception $e Exception object.
         * @param string    $message Message regarding exception thrown.
         * @since 3.7.0
         */
        protected function handle_exception($e, $message = 'Error')
        {
        }
        /**
         * Set order status.
         *
         * @since 3.0.0
         * @param string $new_status    Status to change the order to. No internal wc- prefix is required.
         * @param string $note          Optional note to add.
         * @param bool   $manual_update Is this a manual order status change?.
         * @return array
         */
        public function set_status($new_status, $note = '', $manual_update = \false)
        {
        }
        /**
         * Maybe set date paid.
         *
         * Sets the date paid variable when transitioning to the payment complete
         * order status. This is either processing or completed. This is not filtered
         * to avoid infinite loops e.g. if loading an order via the filter.
         *
         * Date paid is set once in this manner - only when it is not already set.
         * This ensures the data exists even if a gateway does not use the
         * `payment_complete` method.
         *
         * @since 3.0.0
         */
        public function maybe_set_date_paid()
        {
        }
        /**
         * Maybe set date completed.
         *
         * Sets the date completed variable when transitioning to completed status.
         *
         * @since 3.0.0
         */
        protected function maybe_set_date_completed()
        {
        }
        /**
         * Updates status of order immediately.
         *
         * @uses WC_Order::set_status()
         * @param string $new_status    Status to change the order to. No internal wc- prefix is required.
         * @param string $note          Optional note to add.
         * @param bool   $manual        Is this a manual order status change?.
         * @return bool
         */
        public function update_status($new_status, $note = '', $manual = \false)
        {
        }
        /**
         * Handle the status transition.
         */
        protected function status_transition()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        |
        | Methods for getting data from the order object.
        |
        */
        /**
         * Get basic order data in array format.
         *
         * @return array
         */
        public function get_base_data()
        {
        }
        /**
         * Get all class data in array format.
         *
         * @since 3.0.0
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Expands the shipping and billing information in the changes array.
         */
        public function get_changes()
        {
        }
        /**
         * Gets the order number for display (by default, order ID).
         *
         * @return string
         */
        public function get_order_number()
        {
        }
        /**
         * Get order key.
         *
         * @since  3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_order_key($context = 'view')
        {
        }
        /**
         * Get customer_id.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_customer_id($context = 'view')
        {
        }
        /**
         * Alias for get_customer_id().
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_user_id($context = 'view')
        {
        }
        /**
         * Get the user associated with the order. False for guests.
         *
         * @return WP_User|false
         */
        public function get_user()
        {
        }
        /**
         * Gets a prop for a getter method.
         *
         * @since  3.0.0
         * @param  string $prop Name of prop to get.
         * @param  string $address_type Type of address; 'billing' or 'shipping'.
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return mixed
         */
        protected function get_address_prop($prop, $address_type = 'billing', $context = 'view')
        {
        }
        /**
         * Get billing first name.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_first_name($context = 'view')
        {
        }
        /**
         * Get billing last name.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_last_name($context = 'view')
        {
        }
        /**
         * Get billing company.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_company($context = 'view')
        {
        }
        /**
         * Get billing address line 1.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_address_1($context = 'view')
        {
        }
        /**
         * Get billing address line 2.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_address_2($context = 'view')
        {
        }
        /**
         * Get billing city.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_city($context = 'view')
        {
        }
        /**
         * Get billing state.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_state($context = 'view')
        {
        }
        /**
         * Get billing postcode.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_postcode($context = 'view')
        {
        }
        /**
         * Get billing country.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_country($context = 'view')
        {
        }
        /**
         * Get billing email.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_email($context = 'view')
        {
        }
        /**
         * Get billing phone.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_billing_phone($context = 'view')
        {
        }
        /**
         * Get shipping first name.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_first_name($context = 'view')
        {
        }
        /**
         * Get shipping_last_name.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_last_name($context = 'view')
        {
        }
        /**
         * Get shipping company.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_company($context = 'view')
        {
        }
        /**
         * Get shipping address line 1.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_address_1($context = 'view')
        {
        }
        /**
         * Get shipping address line 2.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_address_2($context = 'view')
        {
        }
        /**
         * Get shipping city.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_city($context = 'view')
        {
        }
        /**
         * Get shipping state.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_state($context = 'view')
        {
        }
        /**
         * Get shipping postcode.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_postcode($context = 'view')
        {
        }
        /**
         * Get shipping country.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_country($context = 'view')
        {
        }
        /**
         * Get shipping phone.
         *
         * @since  5.6.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_shipping_phone($context = 'view')
        {
        }
        /**
         * Get the payment method.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_payment_method($context = 'view')
        {
        }
        /**
         * Get payment method title.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_payment_method_title($context = 'view')
        {
        }
        /**
         * Get transaction id.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_transaction_id($context = 'view')
        {
        }
        /**
         * Get customer ip address.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_customer_ip_address($context = 'view')
        {
        }
        /**
         * Get customer user agent.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_customer_user_agent($context = 'view')
        {
        }
        /**
         * Get created via.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_created_via($context = 'view')
        {
        }
        /**
         * Get customer note.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_customer_note($context = 'view')
        {
        }
        /**
         * Get date completed.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_completed($context = 'view')
        {
        }
        /**
         * Get date paid.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return WC_DateTime|NULL object if the date is set or null if there is no date.
         */
        public function get_date_paid($context = 'view')
        {
        }
        /**
         * Get cart hash.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_cart_hash($context = 'view')
        {
        }
        /**
         * Returns the requested address in raw, non-formatted way.
         * Note: Merges raw data with get_prop data so changes are returned too.
         *
         * @since  2.4.0
         * @param  string $address_type Type of address; 'billing' or 'shipping'.
         * @return array The stored address after filter.
         */
        public function get_address($address_type = 'billing')
        {
        }
        /**
         * Get a formatted shipping address for the order.
         *
         * @return string
         */
        public function get_shipping_address_map_url()
        {
        }
        /**
         * Get a formatted billing full name.
         *
         * @return string
         */
        public function get_formatted_billing_full_name()
        {
        }
        /**
         * Get a formatted shipping full name.
         *
         * @return string
         */
        public function get_formatted_shipping_full_name()
        {
        }
        /**
         * Get a formatted billing address for the order.
         *
         * @param string $empty_content Content to show if no address is present. @since 3.3.0.
         * @return string
         */
        public function get_formatted_billing_address($empty_content = '')
        {
        }
        /**
         * Get a formatted shipping address for the order.
         *
         * @param string $empty_content Content to show if no address is present. @since 3.3.0.
         * @return string
         */
        public function get_formatted_shipping_address($empty_content = '')
        {
        }
        /**
         * Returns true if the order has a billing address.
         *
         * @since  3.0.4
         * @return boolean
         */
        public function has_billing_address()
        {
        }
        /**
         * Returns true if the order has a shipping address.
         *
         * @since  3.0.4
         * @return boolean
         */
        public function has_shipping_address()
        {
        }
        /**
         * Gets information about whether stock was reduced.
         *
         * @since 7.0.0
         * @param string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_order_stock_reduced(string $context = 'view')
        {
        }
        /**
         * Gets information about whether permissions were generated yet.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         *
         * @return bool True if permissions were generated, false otherwise.
         */
        public function get_download_permissions_granted(string $context = 'view')
        {
        }
        /**
         * Whether email have been sent for this order.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         *
         * @return bool
         */
        public function get_new_order_email_sent(string $context = 'view')
        {
        }
        /**
         * Gets information about whether sales were recorded.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         *
         * @return bool True if sales were recorded, false otherwise.
         */
        public function get_recorded_sales(string $context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Functions for setting order data. These should not update anything in the
        | database itself and should only change what is stored in the class
        | object. However, for backwards compatibility pre 3.0.0 some of these
        | setters may handle both.
        |
        */
        /**
         * Sets a prop for a setter method.
         *
         * @since 3.0.0
         * @param string $prop Name of prop to set.
         * @param string $address_type Type of address; 'billing' or 'shipping'.
         * @param mixed  $value Value of the prop.
         */
        protected function set_address_prop($prop, $address_type, $value)
        {
        }
        /**
         * Setter for billing address, expects the $address parameter to be key value pairs for individual address props.
         *
         * @param array $address Address to set.
         *
         * @return void
         */
        public function set_billing_address(array $address)
        {
        }
        /**
         * Shortcut for calling set_billing_address.
         *
         * This is useful in scenarios where set_$prop_name is invoked, and since we store the billing address as 'billing' prop in data, it can be called directly.
         *
         * @param array $address Address to set.
         *
         * @return void
         */
        public function set_billing(array $address)
        {
        }
        /**
         * Setter for shipping address, expects the $address parameter to be key value pairs for individual address props.
         *
         * @param array $address Address to set.
         *
         * @return void
         */
        public function set_shipping_address(array $address)
        {
        }
        /**
         * Shortcut for calling set_shipping_address. This is useful in scenarios where set_$prop_name is invoked, and since we store the shipping address as 'shipping' prop in data, it can be called directly.
         *
         * @param array $address Address to set.
         *
         * @return void
         */
        public function set_shipping(array $address)
        {
        }
        /**
         * Set order key.
         *
         * @param string $value Max length 22 chars.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_order_key($value)
        {
        }
        /**
         * Set customer id.
         *
         * @param int $value Customer ID.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_customer_id($value)
        {
        }
        /**
         * Set billing first name.
         *
         * @param string $value Billing first name.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_first_name($value)
        {
        }
        /**
         * Set billing last name.
         *
         * @param string $value Billing last name.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_last_name($value)
        {
        }
        /**
         * Set billing company.
         *
         * @param string $value Billing company.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_company($value)
        {
        }
        /**
         * Set billing address line 1.
         *
         * @param string $value Billing address line 1.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_address_1($value)
        {
        }
        /**
         * Set billing address line 2.
         *
         * @param string $value Billing address line 2.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_address_2($value)
        {
        }
        /**
         * Set billing city.
         *
         * @param string $value Billing city.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_city($value)
        {
        }
        /**
         * Set billing state.
         *
         * @param string $value Billing state.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_state($value)
        {
        }
        /**
         * Set billing postcode.
         *
         * @param string $value Billing postcode.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_postcode($value)
        {
        }
        /**
         * Set billing country.
         *
         * @param string $value Billing country.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_country($value)
        {
        }
        /**
         * Maybe set empty billing email to that of the user who owns the order.
         */
        protected function maybe_set_user_billing_email()
        {
        }
        /**
         * Set billing email.
         *
         * @param string $value Billing email.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_email($value)
        {
        }
        /**
         * Set billing phone.
         *
         * @param string $value Billing phone.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_billing_phone($value)
        {
        }
        /**
         * Set shipping first name.
         *
         * @param string $value Shipping first name.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_first_name($value)
        {
        }
        /**
         * Set shipping last name.
         *
         * @param string $value Shipping last name.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_last_name($value)
        {
        }
        /**
         * Set shipping company.
         *
         * @param string $value Shipping company.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_company($value)
        {
        }
        /**
         * Set shipping address line 1.
         *
         * @param string $value Shipping address line 1.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_address_1($value)
        {
        }
        /**
         * Set shipping address line 2.
         *
         * @param string $value Shipping address line 2.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_address_2($value)
        {
        }
        /**
         * Set shipping city.
         *
         * @param string $value Shipping city.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_city($value)
        {
        }
        /**
         * Set shipping state.
         *
         * @param string $value Shipping state.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_state($value)
        {
        }
        /**
         * Set shipping postcode.
         *
         * @param string $value Shipping postcode.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_postcode($value)
        {
        }
        /**
         * Set shipping country.
         *
         * @param string $value Shipping country.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_country($value)
        {
        }
        /**
         * Set shipping phone.
         *
         * @since 5.6.0
         * @param string $value Shipping phone.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_shipping_phone($value)
        {
        }
        /**
         * Set the payment method.
         *
         * @param string $payment_method Supports WC_Payment_Gateway for bw compatibility with < 3.0.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_payment_method($payment_method = '')
        {
        }
        /**
         * Set payment method title.
         *
         * @param string $value Payment method title.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_payment_method_title($value)
        {
        }
        /**
         * Set transaction id.
         *
         * @param string $value Transaction id.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_transaction_id($value)
        {
        }
        /**
         * Set customer ip address.
         *
         * @param string $value Customer ip address.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_customer_ip_address($value)
        {
        }
        /**
         * Set customer user agent.
         *
         * @param string $value Customer user agent.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_customer_user_agent($value)
        {
        }
        /**
         * Set created via.
         *
         * @param string $value Created via.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_created_via($value)
        {
        }
        /**
         * Set customer note.
         *
         * @param string $value Customer note.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_customer_note($value)
        {
        }
        /**
         * Set date completed.
         *
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_date_completed($date = \null)
        {
        }
        /**
         * Set date paid.
         *
         * @param  string|integer|null $date UTC timestamp, or ISO 8601 DateTime. If the DateTime string has no timezone or offset, WordPress site timezone will be assumed. Null if their is no date.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_date_paid($date = \null)
        {
        }
        /**
         * Set cart hash.
         *
         * @param string $value Cart hash.
         * @throws WC_Data_Exception Throws exception when invalid data is found.
         */
        public function set_cart_hash($value)
        {
        }
        /**
         * Stores information about whether stock was reduced.
         *
         * @param bool|string $value True if stock was reduced, false if not.
         *
         * @return void
         */
        public function set_order_stock_reduced($value)
        {
        }
        /**
         * Stores information about whether permissions were generated yet.
         *
         * @param bool|string $value True if permissions were generated, false if not.
         *
         * @return void
         */
        public function set_download_permissions_granted($value)
        {
        }
        /**
         * Stores information about whether email was sent.
         *
         * @param bool|string $value True if email was sent, false if not.
         *
         * @return void
         */
        public function set_new_order_email_sent($value)
        {
        }
        /**
         * Stores information about whether sales were recorded.
         *
         * @param bool|string $value True if sales were recorded, false if not.
         *
         * @return void
         */
        public function set_recorded_sales($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Conditionals
        |--------------------------------------------------------------------------
        |
        | Checks if a condition is true or false.
        |
        */
        /**
         * Check if an order key is valid.
         *
         * @param string $key Order key.
         * @return bool
         */
        public function key_is_valid($key)
        {
        }
        /**
         * See if order matches cart_hash.
         *
         * @param string $cart_hash Cart hash.
         * @return bool
         */
        public function has_cart_hash($cart_hash = '')
        {
        }
        /**
         * Checks if an order can be edited, specifically for use on the Edit Order screen.
         *
         * @return bool
         */
        public function is_editable()
        {
        }
        /**
         * Returns if an order has been paid for based on the order status.
         *
         * @since 2.5.0
         * @return bool
         */
        public function is_paid()
        {
        }
        /**
         * Checks if product download is permitted.
         *
         * @return bool
         */
        public function is_download_permitted()
        {
        }
        /**
         * Checks if an order needs display the shipping address, based on shipping method.
         *
         * @return bool
         */
        public function needs_shipping_address()
        {
        }
        /**
         * Returns true if the order contains a downloadable product.
         *
         * @return bool
         */
        public function has_downloadable_item()
        {
        }
        /**
         * Get downloads from all line items for this order.
         *
         * @since  3.2.0
         * @return array
         */
        public function get_downloadable_items()
        {
        }
        /**
         * Checks if an order needs payment, based on status and order total.
         *
         * @return bool
         */
        public function needs_payment()
        {
        }
        /**
         * See if the order needs processing before it can be completed.
         *
         * Orders which only contain virtual, downloadable items do not need admin
         * intervention.
         *
         * Uses a transient so these calls are not repeated multiple times, and because
         * once the order is processed this code/transient does not need to persist.
         *
         * @since 3.0.0
         * @return bool
         */
        public function needs_processing()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | URLs and Endpoints
        |--------------------------------------------------------------------------
        */
        /**
         * Generates a URL so that a customer can pay for their (unpaid - pending) order. Pass 'true' for the checkout version which doesn't offer gateway choices.
         *
         * @param  bool $on_checkout If on checkout.
         * @return string
         */
        public function get_checkout_payment_url($on_checkout = \false)
        {
        }
        /**
         * Generates a URL for the thanks page (order received).
         *
         * @return string
         */
        public function get_checkout_order_received_url()
        {
        }
        /**
         * Generates a URL so that a customer can cancel their (unpaid - pending) order.
         *
         * @param string $redirect Redirect URL.
         * @return string
         */
        public function get_cancel_order_url($redirect = '')
        {
        }
        /**
         * Generates a raw (unescaped) cancel-order URL for use by payment gateways.
         *
         * @param string $redirect Redirect URL.
         * @return string The unescaped cancel-order URL.
         */
        public function get_cancel_order_url_raw($redirect = '')
        {
        }
        /**
         * Helper method to return the cancel endpoint.
         *
         * @return string the cancel endpoint; either the cart page or the home page.
         */
        public function get_cancel_endpoint()
        {
        }
        /**
         * Generates a URL to view an order from the my account page.
         *
         * @return string
         */
        public function get_view_order_url()
        {
        }
        /**
         * Get's the URL to edit the order in the backend.
         *
         * @since 3.3.0
         * @return string
         */
        public function get_edit_order_url()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Order notes.
        |--------------------------------------------------------------------------
        */
        /**
         * Adds a note (comment) to the order. Order must exist.
         *
         * @param  string $note              Note to add.
         * @param  int    $is_customer_note  Is this a note for the customer?.
         * @param  bool   $added_by_user     Was the note added by a user?.
         * @return int                       Comment ID.
         */
        public function add_order_note($note, $is_customer_note = 0, $added_by_user = \false)
        {
        }
        /**
         * Add an order note for status transition
         *
         * @since 3.9.0
         * @uses WC_Order::add_order_note()
         * @param string $note          Note to be added giving status transition from and to details.
         * @param bool   $transition    Details of the status transition.
         * @return int                  Comment ID.
         */
        private function add_status_transition_note($note, $transition)
        {
        }
        /**
         * List order notes (public) for the customer.
         *
         * @return array
         */
        public function get_customer_order_notes()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Refunds
        |--------------------------------------------------------------------------
        */
        /**
         * Get order refunds.
         *
         * @since 2.2
         * @return array of WC_Order_Refund objects
         */
        public function get_refunds()
        {
        }
        /**
         * Get amount already refunded.
         *
         * @since 2.2
         * @return string
         */
        public function get_total_refunded()
        {
        }
        /**
         * Get the total tax refunded.
         *
         * @since  2.3
         * @return float
         */
        public function get_total_tax_refunded()
        {
        }
        /**
         * Get the total shipping refunded.
         *
         * @since  2.4
         * @return float
         */
        public function get_total_shipping_refunded()
        {
        }
        /**
         * Gets the count of order items of a certain type that have been refunded.
         *
         * @since  2.4.0
         * @param string $item_type Item type.
         * @return string
         */
        public function get_item_count_refunded($item_type = '')
        {
        }
        /**
         * Get the total number of items refunded.
         *
         * @since  2.4.0
         *
         * @param  string $item_type Type of the item we're checking, if not a line_item.
         * @return int
         */
        public function get_total_qty_refunded($item_type = 'line_item')
        {
        }
        /**
         * Get the refunded amount for a line item.
         *
         * @param  int    $item_id   ID of the item we're checking.
         * @param  string $item_type Type of the item we're checking, if not a line_item.
         * @return int
         */
        public function get_qty_refunded_for_item($item_id, $item_type = 'line_item')
        {
        }
        /**
         * Get the refunded amount for a line item.
         *
         * @param  int    $item_id   ID of the item we're checking.
         * @param  string $item_type Type of the item we're checking, if not a line_item.
         * @return int
         */
        public function get_total_refunded_for_item($item_id, $item_type = 'line_item')
        {
        }
        /**
         * Get the refunded tax amount for a line item.
         *
         * @param  int    $item_id   ID of the item we're checking.
         * @param  int    $tax_id    ID of the tax we're checking.
         * @param  string $item_type Type of the item we're checking, if not a line_item.
         * @return double
         */
        public function get_tax_refunded_for_item($item_id, $tax_id, $item_type = 'line_item')
        {
        }
        /**
         * Get total tax refunded by rate ID.
         *
         * @param  int $rate_id Rate ID.
         * @return float
         */
        public function get_total_tax_refunded_by_rate_id($rate_id)
        {
        }
        /**
         * How much money is left to refund?
         *
         * @return string
         */
        public function get_remaining_refund_amount()
        {
        }
        /**
         * How many items are left to refund?
         *
         * @return int
         */
        public function get_remaining_refund_items()
        {
        }
        /**
         * Add total row for the payment method.
         *
         * @param array  $total_rows  Total rows.
         * @param string $tax_display Tax to display.
         */
        protected function add_order_item_totals_payment_method_row(&$total_rows, $tax_display)
        {
        }
        /**
         * Add total row for refunds.
         *
         * @param array  $total_rows  Total rows.
         * @param string $tax_display Tax to display.
         */
        protected function add_order_item_totals_refund_rows(&$total_rows, $tax_display)
        {
        }
        /**
         * Get totals for display on pages and in emails.
         *
         * @param string $tax_display Tax to display.
         * @return array
         */
        public function get_order_item_totals($tax_display = '')
        {
        }
        /**
         * Check if order has been created via admin, checkout, or in another way.
         *
         * @since 4.0.0
         * @param string $modus Way of creating the order to test for.
         * @return bool
         */
        public function is_created_via($modus)
        {
        }
        /**
         * Attempts to restore the specified order back to its original status (after having been trashed).
         *
         * @return bool If the operation was successful.
         */
        public function untrash() : bool
        {
        }
    }
    /**
     * Payment gateways class.
     */
    class WC_Payment_Gateways
    {
        use \Automattic\WooCommerce\Internal\Traits\AccessiblePrivateMethods;
        /**
         * Payment gateway classes.
         *
         * @var array
         */
        public $payment_gateways = array();
        /**
         * The single instance of the class.
         *
         * @var WC_Payment_Gateways
         * @since 2.1.0
         */
        protected static $_instance = \null;
        /**
         * Main WC_Payment_Gateways Instance.
         *
         * Ensures only one instance of WC_Payment_Gateways is loaded or can be loaded.
         *
         * @since 2.1
         * @return WC_Payment_Gateways Main instance
         */
        public static function instance()
        {
        }
        /**
         * Cloning is forbidden.
         *
         * @since 2.1
         */
        public function __clone()
        {
        }
        /**
         * Unserializing instances of this class is forbidden.
         *
         * @since 2.1
         */
        public function __wakeup()
        {
        }
        /**
         * Initialize payment gateways.
         */
        public function __construct()
        {
        }
        /**
         * Load gateways and hook in functions.
         */
        public function init()
        {
        }
        /**
         * Hook into payment gateway settings changes.
         *
         * @param WC_Payment_Gateways $wc_payment_gateways The WC_Payment_Gateways instance.
         * @since 8.5.0
         */
        private function on_payment_gateways_initialized(\WC_Payment_Gateways $wc_payment_gateways)
        {
        }
        /**
         * Callback for when a gateway settings option was added or updated.
         *
         * @param WC_Payment_Gateway $gateway   The gateway for which the option was added or updated.
         * @param mixed              $value     New value.
         * @param string             $option    Option name.
         * @param mixed              $old_value Old value. `null` when called via add_option_ hook.
         * @since 8.5.0
         */
        private function payment_gateway_settings_option_changed($gateway, $value, $option, $old_value = \null)
        {
        }
        /**
         * Email the site admin when a payment gateway has been enabled.
         *
         * @param WC_Payment_Gateway $gateway The gateway that was enabled.
         * @return bool Whether the email was sent or not.
         * @since 8.5.0
         */
        private function notify_admin_payment_gateway_enabled($gateway)
        {
        }
        /**
         * Determines from changes in settings if a gateway was enabled.
         *
         * @param array $value New value.
         * @param array $old_value Old value.
         * @return bool Whether the gateway was enabled or not.
         */
        private function was_gateway_enabled($value, $old_value = \null)
        {
        }
        /**
         * Get gateways.
         *
         * @return array
         */
        public function payment_gateways()
        {
        }
        /**
         * Get array of registered gateway ids
         *
         * @since 2.6.0
         * @return array of strings
         */
        public function get_payment_gateway_ids()
        {
        }
        /**
         * Get available gateways.
         *
         * @return array
         */
        public function get_available_payment_gateways()
        {
        }
        /**
         * Callback for array filter. Returns true if gateway is of correct type.
         *
         * @since 3.6.0
         * @param object $gateway Gateway to check.
         * @return bool
         */
        protected function filter_valid_gateway_class($gateway)
        {
        }
        /**
         * Set the current, active gateway.
         *
         * @param array $gateways Available payment gateways.
         */
        public function set_current_gateway($gateways)
        {
        }
        /**
         * Save options in admin.
         */
        public function process_admin_options()
        {
        }
        /**
         * Determines if PayPal Standard should be loaded.
         *
         * @since 5.5.0
         * @return bool Whether PayPal Standard should be loaded or not.
         */
        protected function should_load_paypal_standard()
        {
        }
    }
    /**
     * Payment tokens class.
     */
    class WC_Payment_Tokens
    {
        /**
         * Gets valid tokens from the database based on user defined criteria.
         *
         * @since  2.6.0
         * @param  array $args Query arguments {
         *     Array of query parameters.
         *
         *     @type string $token_id   Token ID.
         *     @type string $user_id    User ID.
         *     @type string $gateway_id Gateway ID.
         *     @type string $type       Token type.
         * }
         * @return WC_Payment_Token[]
         */
        public static function get_tokens($args)
        {
        }
        /**
         * Returns an array of payment token objects associated with the passed customer ID.
         *
         * @since 2.6.0
         * @param  int    $customer_id Customer ID.
         * @param  string $gateway_id  Optional Gateway ID for getting tokens for a specific gateway.
         * @return WC_Payment_Token[]  Array of token objects.
         */
        public static function get_customer_tokens($customer_id, $gateway_id = '')
        {
        }
        /**
         * Returns a customers default token or NULL if there is no default token.
         *
         * @since  2.6.0
         * @param  int $customer_id Customer ID.
         * @return WC_Payment_Token|null
         */
        public static function get_customer_default_token($customer_id)
        {
        }
        /**
         * Returns an array of payment token objects associated with the passed order ID.
         *
         * @since 2.6.0
         * @param int $order_id       Order ID.
         * @return WC_Payment_Token[] Array of token objects.
         */
        public static function get_order_tokens($order_id)
        {
        }
        /**
         * Get a token object by ID.
         *
         * @since 2.6.0
         *
         * @param int    $token_id Token ID.
         * @param object $token_result Token result.
         * @return null|WC_Payment_Token Returns a valid payment token or null if no token can be found.
         */
        public static function get($token_id, $token_result = \null)
        {
        }
        /**
         * Remove a payment token from the database by ID.
         *
         * @since 2.6.0
         * @param int $token_id Token ID.
         */
        public static function delete($token_id)
        {
        }
        /**
         * Loops through all of a users payment tokens and sets is_default to false for all but a specific token.
         *
         * @since 2.6.0
         * @param int $user_id  User to set a default for.
         * @param int $token_id The ID of the token that should be default.
         */
        public static function set_users_default($user_id, $token_id)
        {
        }
        /**
         * Returns what type (credit card, echeck, etc) of token a token is by ID.
         *
         * @since  2.6.0
         * @param  int $token_id Token ID.
         * @return string        Type.
         */
        public static function get_token_type_by_id($token_id)
        {
        }
        /**
         * Get classname based on token type.
         *
         * @since 3.8.0
         * @param string $type Token type.
         * @return string
         */
        protected static function get_token_classname($type)
        {
        }
    }
    /**
     * Post data class.
     */
    class WC_Post_Data
    {
        /**
         * Editing term.
         *
         * @var object
         */
        private static $editing_term = \null;
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Link to parent products when getting permalink for variation.
         *
         * @param string  $permalink Permalink.
         * @param WP_Post $post      Post data.
         *
         * @return string
         */
        public static function variation_post_link($permalink, $post)
        {
        }
        /**
         * Sync products queued to sync.
         */
        public static function do_deferred_product_sync()
        {
        }
        /**
         * Sync a product.
         *
         * @param int $product_id Product ID.
         */
        public static function deferred_product_sync($product_id)
        {
        }
        /**
         * When a post status changes.
         *
         * @param string  $new_status New status.
         * @param string  $old_status Old status.
         * @param WP_Post $post       Post data.
         */
        public static function transition_post_status($new_status, $old_status, $post)
        {
        }
        /**
         * Delete product view transients when needed e.g. when post status changes, or visibility/stock status is modified.
         */
        public static function delete_product_query_transients()
        {
        }
        /**
         * Handle type changes.
         *
         * @since 3.0.0
         *
         * @param WC_Product $product Product data.
         * @param string     $from    Origin type.
         * @param string     $to      New type.
         */
        public static function product_type_changed($product, $from, $to)
        {
        }
        /**
         * When editing a term, check for product attributes.
         *
         * @param  int    $term_id  Term ID.
         * @param  int    $tt_id    Term taxonomy ID.
         * @param  string $taxonomy Taxonomy slug.
         */
        public static function edit_term($term_id, $tt_id, $taxonomy)
        {
        }
        /**
         * When a term is edited, check for product attributes and update variations.
         *
         * @param  int    $term_id  Term ID.
         * @param  int    $tt_id    Term taxonomy ID.
         * @param  string $taxonomy Taxonomy slug.
         */
        public static function edited_term($term_id, $tt_id, $taxonomy)
        {
        }
        /**
         * Ensure floats are correctly converted to strings based on PHP locale.
         *
         * @param  null   $check      Whether to allow updating metadata for the given type.
         * @param  int    $object_id  Object ID.
         * @param  string $meta_key   Meta key.
         * @param  mixed  $meta_value Meta value. Must be serializable if non-scalar.
         * @param  mixed  $prev_value If specified, only update existing metadata entries with the specified value. Otherwise, update all entries.
         * @return null|bool
         */
        public static function update_order_item_metadata($check, $object_id, $meta_key, $meta_value, $prev_value)
        {
        }
        /**
         * Ensure floats are correctly converted to strings based on PHP locale.
         *
         * @param  null   $check      Whether to allow updating metadata for the given type.
         * @param  int    $object_id  Object ID.
         * @param  string $meta_key   Meta key.
         * @param  mixed  $meta_value Meta value. Must be serializable if non-scalar.
         * @param  mixed  $prev_value If specified, only update existing metadata entries with the specified value. Otherwise, update all entries.
         * @return null|bool
         */
        public static function update_post_metadata($check, $object_id, $meta_key, $meta_value, $prev_value)
        {
        }
        /**
         * Forces the order posts to have a title in a certain format (containing the date).
         * Forces certain product data based on the product's type, e.g. grouped products cannot have a parent.
         *
         * @param array $data An array of slashed post data.
         * @return array
         */
        public static function wp_insert_post_data($data)
        {
        }
        /**
         * Change embed data for certain post types.
         *
         * @since 3.2.0
         * @param array   $data The response data.
         * @param WP_Post $post The post object.
         * @return array
         */
        public static function filter_oembed_response_data($data, $post)
        {
        }
        /**
         * Removes variations etc belonging to a deleted post, and clears transients.
         *
         * @param mixed $id ID of post being deleted.
         */
        public static function delete_post($id)
        {
        }
        /**
         * Trash post.
         *
         * @param mixed $id Post ID.
         */
        public static function trash_post($id)
        {
        }
        /**
         * Untrash post.
         *
         * @param mixed $id Post ID.
         */
        public static function untrash_post($id)
        {
        }
        /**
         * Get the post type for a given post.
         *
         * @param int $id The post id.
         * @return string The post type.
         */
        private static function get_post_type($id)
        {
        }
        /**
         * Before deleting an order, do some cleanup.
         *
         * @since 3.2.0
         * @param int $order_id Order ID.
         */
        public static function before_delete_order($order_id)
        {
        }
        /**
         * Remove item meta on permanent deletion.
         *
         * @param int $postid Post ID.
         */
        public static function delete_order_items($postid)
        {
        }
        /**
         * Remove downloadable permissions on permanent order deletion.
         *
         * @param int $postid Post ID.
         */
        public static function delete_order_downloadable_permissions($postid)
        {
        }
        /**
         * Flush meta cache for CRUD objects on direct update.
         *
         * @param  int    $meta_id    Meta ID.
         * @param  int    $object_id  Object ID.
         * @param  string $meta_key   Meta key.
         * @param  mixed  $meta_value Meta value.
         */
        public static function flush_object_meta_cache($meta_id, $object_id, $meta_key, $meta_value)
        {
        }
        /**
         * Ensure default category gets set.
         *
         * @since 3.3.0
         * @param int    $object_id Product ID.
         * @param array  $terms     Terms array.
         * @param array  $tt_ids    Term ids array.
         * @param string $taxonomy  Taxonomy name.
         * @param bool   $append    Are we appending or setting terms.
         */
        public static function force_default_term($object_id, $terms, $tt_ids, $taxonomy, $append)
        {
        }
        /**
         * Ensure statuses are correctly reassigned when restoring orders and products.
         *
         * @param string $new_status      The new status of the post being restored.
         * @param int    $post_id         The ID of the post being restored.
         * @param string $previous_status The status of the post at the point where it was trashed.
         * @return string
         */
        public static function wp_untrash_post_status($new_status, $post_id, $previous_status)
        {
        }
        /**
         * When setting stock level, ensure the stock status is kept in sync.
         *
         * @param  int    $meta_id    Meta ID.
         * @param  int    $object_id  Object ID.
         * @param  string $meta_key   Meta key.
         * @param  mixed  $meta_value Meta value.
         * @deprecated    3.3
         */
        public static function sync_product_stock_status($meta_id, $object_id, $meta_key, $meta_value)
        {
        }
        /**
         * Update changed downloads.
         *
         * @deprecated  3.3.0 No action is necessary on changes to download paths since download_id is no longer based on file hash.
         * @param int   $product_id   Product ID.
         * @param int   $variation_id Variation ID. Optional product variation identifier.
         * @param array $downloads    Newly set files.
         */
        public static function process_product_file_download_paths($product_id, $variation_id, $downloads)
        {
        }
        /**
         * Delete transients when terms are set.
         *
         * @deprecated   3.6
         * @param int    $object_id  Object ID.
         * @param mixed  $terms      An array of object terms.
         * @param array  $tt_ids     An array of term taxonomy IDs.
         * @param string $taxonomy   Taxonomy slug.
         * @param mixed  $append     Whether to append new terms to the old terms.
         * @param array  $old_tt_ids Old array of term taxonomy IDs.
         */
        public static function set_object_terms($object_id, $terms, $tt_ids, $taxonomy, $append, $old_tt_ids)
        {
        }
    }
    /**
     * Post types Class.
     */
    class WC_Post_Types
    {
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Register core taxonomies.
         */
        public static function register_taxonomies()
        {
        }
        /**
         * Register core post types.
         */
        public static function register_post_types()
        {
        }
        /**
         * Customize taxonomies update messages.
         *
         * @param array $messages The list of available messages.
         * @since 4.4.0
         * @return bool
         */
        public static function updated_term_messages($messages)
        {
        }
        /**
         * Register our custom post statuses, used for order status.
         */
        public static function register_post_status()
        {
        }
        /**
         * Flush rules if the event is queued.
         *
         * @since 3.3.0
         */
        public static function maybe_flush_rewrite_rules()
        {
        }
        /**
         * Flush rewrite rules.
         */
        public static function flush_rewrite_rules()
        {
        }
        /**
         * Disable Gutenberg for products.
         *
         * @param bool   $can_edit Whether the post type can be edited or not.
         * @param string $post_type The post type being checked.
         * @return bool
         */
        public static function gutenberg_can_edit_post_type($can_edit, $post_type)
        {
        }
        /**
         * Add Product Support to Jetpack Omnisearch.
         */
        public static function support_jetpack_omnisearch()
        {
        }
        /**
         * Added product for Jetpack related posts.
         *
         * @param  array $post_types Post types.
         * @return array
         */
        public static function rest_api_allowed_post_types($post_types)
        {
        }
    }
    /**
     * WC_Privacy_Background_Process class.
     */
    class WC_Privacy_Background_Process extends \WC_Background_Process
    {
        /**
         * Initiate new background process.
         */
        public function __construct()
        {
        }
        /**
         * Code to execute for each item in the queue
         *
         * @param string $item Queue item to iterate over.
         * @return bool
         */
        protected function task($item)
        {
        }
    }
    /**
     * WC_Privacy_Erasers Class.
     */
    class WC_Privacy_Erasers
    {
        /**
         * Finds and erases customer data by email address.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function customer_data_eraser($email_address, $page)
        {
        }
        /**
         * Finds and erases data which could be used to identify a person from WooCommerce data associated with an email address.
         *
         * Orders are erased in blocks of 10 to avoid timeouts.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function order_data_eraser($email_address, $page)
        {
        }
        /**
         * Finds and removes customer download logs by email address.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function download_data_eraser($email_address, $page)
        {
        }
        /**
         * Remove personal data specific to WooCommerce from an order object.
         *
         * Note; this will hinder order processing for obvious reasons!
         *
         * @param WC_Order $order Order object.
         */
        public static function remove_order_personal_data($order)
        {
        }
        /**
         * Finds and erases customer tokens by email address.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function customer_tokens_eraser($email_address, $page)
        {
        }
    }
    /**
     * WC_Privacy_Exporters Class.
     */
    class WC_Privacy_Exporters
    {
        /**
         * Finds and exports customer data by email address.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @return array An array of personal data in name value pairs
         */
        public static function customer_data_exporter($email_address)
        {
        }
        /**
         * Finds and exports data which could be used to identify a person from WooCommerce data associated with an email address.
         *
         * Orders are exported in blocks of 10 to avoid timeouts.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function order_data_exporter($email_address, $page)
        {
        }
        /**
         * Finds and exports customer download logs by email address.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @throws Exception When WC_Data_Store validation fails.
         * @return array An array of personal data in name value pairs
         */
        public static function download_data_exporter($email_address, $page)
        {
        }
        /**
         * Get personal data (key/value pairs) for a user object.
         *
         * @since 3.4.0
         * @param WP_User $user user object.
         * @throws Exception If customer cannot be read/found and $data is set to WC_Customer class.
         * @return array
         */
        protected static function get_customer_personal_data($user)
        {
        }
        /**
         * Get personal data (key/value pairs) for an order object.
         *
         * @since 3.4.0
         * @param WC_Order $order Order object.
         * @return array
         */
        protected static function get_order_personal_data($order)
        {
        }
        /**
         * Get personal data (key/value pairs) for a download object.
         *
         * @since 3.4.0
         * @param WC_Order $download Download object.
         * @return array
         */
        protected static function get_download_personal_data($download)
        {
        }
        /**
         * Finds and exports payment tokens by email address for a customer.
         *
         * @since 3.4.0
         * @param string $email_address The user email address.
         * @param int    $page  Page.
         * @return array An array of personal data in name value pairs
         */
        public static function customer_tokens_exporter($email_address, $page)
        {
        }
    }
    /**
     * WC_Privacy Class.
     */
    class WC_Privacy extends \WC_Abstract_Privacy
    {
        /**
         * Background process to clean up orders.
         *
         * @var WC_Privacy_Background_Process
         */
        protected static $background_process;
        /**
         * Init - hook into events.
         */
        public function __construct()
        {
        }
        /**
         * Initial registration of privacy erasers and exporters.
         *
         * Due to the use of translation functions, this should run only after plugins loaded.
         */
        public function register_erasers_exporters()
        {
        }
        /**
         * Add privacy policy content for the privacy policy page.
         *
         * @since 3.4.0
         */
        public function get_privacy_message()
        {
        }
        /**
         * Spawn events for order cleanup.
         */
        public function queue_cleanup_personal_data()
        {
        }
        /**
         * Handle some custom types of data and anonymize them.
         *
         * @param string $anonymous Anonymized string.
         * @param string $type Type of data.
         * @param string $data The data being anonymized.
         * @return string Anonymized string.
         */
        public function anonymize_custom_data_types($anonymous, $type, $data)
        {
        }
        /**
         * Find and trash old orders.
         *
         * @since 3.4.0
         * @param  int $limit Limit orders to process per batch.
         * @return int Number of orders processed.
         */
        public static function trash_pending_orders($limit = 20)
        {
        }
        /**
         * Find and trash old orders.
         *
         * @since 3.4.0
         * @param  int $limit Limit orders to process per batch.
         * @return int Number of orders processed.
         */
        public static function trash_failed_orders($limit = 20)
        {
        }
        /**
         * Find and trash old orders.
         *
         * @since 3.4.0
         * @param  int $limit Limit orders to process per batch.
         * @return int Number of orders processed.
         */
        public static function trash_cancelled_orders($limit = 20)
        {
        }
        /**
         * For a given query trash all matches.
         *
         * @since 3.4.0
         * @param array $query Query array to pass to wc_get_orders().
         * @return int Count of orders that were trashed.
         */
        protected static function trash_orders_query($query)
        {
        }
        /**
         * Anonymize old completed orders.
         *
         * @since 3.4.0
         * @param  int $limit Limit orders to process per batch.
         * @return int Number of orders processed.
         */
        public static function anonymize_completed_orders($limit = 20)
        {
        }
        /**
         * For a given query, anonymize all matches.
         *
         * @since 3.4.0
         * @param array $query Query array to pass to wc_get_orders().
         * @return int Count of orders that were anonymized.
         */
        protected static function anonymize_orders_query($query)
        {
        }
        /**
         * Delete inactive accounts.
         *
         * @since 3.4.0
         * @param  int $limit Limit users to process per batch.
         * @return int Number of users processed.
         */
        public static function delete_inactive_accounts($limit = 20)
        {
        }
        /**
         * Delete inactive accounts.
         *
         * @since 3.4.0
         * @param int $timestamp Timestamp to delete customers before.
         * @param int $limit     Limit number of users to delete per run.
         * @return int Count of customers that were deleted.
         */
        protected static function delete_inactive_accounts_query($timestamp, $limit = 20)
        {
        }
    }
    /**
     * Product attribute class.
     */
    class WC_Product_Attribute implements \ArrayAccess
    {
        /**
         * Data array.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('id' => 0, 'name' => '', 'options' => array(), 'position' => 0, 'visible' => \false, 'variation' => \false);
        /**
         * Return if this attribute is a taxonomy.
         *
         * @return boolean
         */
        public function is_taxonomy()
        {
        }
        /**
         * Get taxonomy name if applicable.
         *
         * @return string
         */
        public function get_taxonomy()
        {
        }
        /**
         * Get taxonomy object.
         *
         * @return array|null
         */
        public function get_taxonomy_object()
        {
        }
        /**
         * Gets terms from the stored options.
         *
         * @return array|null
         */
        public function get_terms()
        {
        }
        /**
         * Gets slugs from the stored options, or just the string if text based.
         *
         * @return array
         */
        public function get_slugs()
        {
        }
        /**
         * Returns all data for this object.
         *
         * @return array
         */
        public function get_data()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set ID (this is the attribute ID).
         *
         * @param int $value Attribute ID.
         */
        public function set_id($value)
        {
        }
        /**
         * Set name (this is the attribute name or taxonomy).
         *
         * @param string $value Attribute name.
         */
        public function set_name($value)
        {
        }
        /**
         * Set options.
         *
         * @param array $value Attribute options.
         */
        public function set_options($value)
        {
        }
        /**
         * Set position.
         *
         * @param int $value Attribute position.
         */
        public function set_position($value)
        {
        }
        /**
         * Set if visible.
         *
         * @param bool $value If is visible on Product's additional info tab.
         */
        public function set_visible($value)
        {
        }
        /**
         * Set if variation.
         *
         * @param bool $value If is used for variations.
         */
        public function set_variation($value)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get the ID.
         *
         * @return int
         */
        public function get_id()
        {
        }
        /**
         * Get name.
         *
         * @return string
         */
        public function get_name()
        {
        }
        /**
         * Get options.
         *
         * @return array
         */
        public function get_options()
        {
        }
        /**
         * Get position.
         *
         * @return int
         */
        public function get_position()
        {
        }
        /**
         * Get if visible.
         *
         * @return bool
         */
        public function get_visible()
        {
        }
        /**
         * Get if variation.
         *
         * @return bool
         */
        public function get_variation()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | ArrayAccess/Backwards compatibility.
        |--------------------------------------------------------------------------
        */
        /**
         * OffsetGet.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet.
         *
         * @param string $offset Offset.
         * @param mixed  $value  Value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetUnset.
         *
         * @param string $offset Offset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * OffsetExists.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Product download class.
     */
    class WC_Product_Download implements \ArrayAccess
    {
        /**
         * Data array.
         *
         * @since 3.0.0
         * @var array
         */
        protected $data = array('id' => '', 'name' => '', 'file' => '', 'enabled' => \true);
        /**
         * Returns all data for this object.
         *
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Get allowed mime types.
         *
         * @return array
         */
        public function get_allowed_mime_types()
        {
        }
        /**
         * Get type of file path set.
         *
         * @param  string $file_path optional.
         * @return string absolute, relative, or shortcode.
         */
        public function get_type_of_file_path($file_path = '')
        {
        }
        /**
         * Get file type.
         *
         * @return string
         */
        public function get_file_type()
        {
        }
        /**
         * Get file extension.
         *
         * @return string
         */
        public function get_file_extension()
        {
        }
        /**
         * Confirms that the download is of an allowed filetype, that it exists and that it is
         * contained within an approved directory. Used before adding to a product's list of
         * downloads.
         *
         * @internal
         * @throws Exception If the download is determined to be invalid.
         *
         * @param bool $auto_add_to_approved_directory_list If the download is not already in the approved directory list, automatically add it if possible.
         */
        public function check_is_valid(bool $auto_add_to_approved_directory_list = \true)
        {
        }
        /**
         * Check if file is allowed.
         *
         * @return boolean
         */
        public function is_allowed_filetype()
        {
        }
        /**
         * Validate file exists.
         *
         * @return boolean
         */
        public function file_exists()
        {
        }
        /**
         * Confirms that the download exists within an approved directory.
         *
         * If it is not within an approved directory but the current user has sufficient
         * capabilities, then the method will try to add the download's directory to the
         * approved directory list.
         *
         * @throws Exception If the download is not in an approved directory.
         *
         * @param bool $auto_add_to_approved_directory_list If the download is not already in the approved directory list, automatically add it if possible.
         */
        private function approved_directory_checks(bool $auto_add_to_approved_directory_list = \true)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Set ID.
         *
         * @param string $value Download ID.
         */
        public function set_id($value)
        {
        }
        /**
         * Set name.
         *
         * @param string $value Download name.
         */
        public function set_name($value)
        {
        }
        /**
         * Set previous_hash.
         *
         * @deprecated 3.3.0 No longer using filename based hashing to keep track of files.
         * @param string $value Previous hash.
         */
        public function set_previous_hash($value)
        {
        }
        /**
         * Set file.
         *
         * @param string $value File URL/Path.
         */
        public function set_file($value)
        {
        }
        /**
         * Sets the status of the download to enabled (true) or disabled (false).
         *
         * @param bool $enabled True indicates the downloadable file is enabled, false indicates it is disabled.
         */
        public function set_enabled(bool $enabled = \true)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get id.
         *
         * @return string
         */
        public function get_id()
        {
        }
        /**
         * Get name.
         *
         * @return string
         */
        public function get_name()
        {
        }
        /**
         * Get previous_hash.
         *
         * @deprecated 3.3.0 No longer using filename based hashing to keep track of files.
         * @return string
         */
        public function get_previous_hash()
        {
        }
        /**
         * Get file.
         *
         * @return string
         */
        public function get_file()
        {
        }
        /**
         * Get status of the download.
         *
         * @return bool
         */
        public function get_enabled() : bool
        {
        }
        /*
        |--------------------------------------------------------------------------
        | ArrayAccess/Backwards compatibility.
        |--------------------------------------------------------------------------
        */
        /**
         * OffsetGet.
         *
         * @param string $offset Offset.
         * @return mixed
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * OffsetSet.
         *
         * @param string $offset Offset.
         * @param mixed  $value Offset value.
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * OffsetUnset.
         *
         * @param string $offset Offset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * OffsetExists.
         *
         * @param string $offset Offset.
         * @return bool
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
    }
    /**
     * Product external class.
     */
    class WC_Product_External extends \WC_Product
    {
        /**
         * Stores product data.
         *
         * @var array
         */
        protected $extra_data = array('product_url' => '', 'button_text' => '');
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        |
        | Methods for getting data from the product object.
        */
        /**
         * Get product url.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_product_url($context = 'view')
        {
        }
        /**
         * Get button text.
         *
         * @param  string $context What the value is for. Valid values are 'view' and 'edit'.
         * @return string
         */
        public function get_button_text($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Functions for setting product data. These should not update anything in the
        | database itself and should only change what is stored in the class
        | object.
        */
        /**
         * Set product URL.
         *
         * @since 3.0.0
         * @param string $product_url Product URL.
         */
        public function set_product_url($product_url)
        {
        }
        /**
         * Set button text.
         *
         * @since 3.0.0
         * @param string $button_text Button text.
         */
        public function set_button_text($button_text)
        {
        }
        /**
         * External products cannot be stock managed.
         *
         * @since 3.0.0
         * @param bool $manage_stock If manage stock.
         */
        public function set_manage_stock($manage_stock)
        {
        }
        /**
         * External products cannot be stock managed.
         *
         * @since 3.0.0
         *
         * @param string $stock_status Stock status.
         */
        public function set_stock_status($stock_status = '')
        {
        }
        /**
         * External products cannot be backordered.
         *
         * @since 3.0.0
         * @param string $backorders Options: 'yes', 'no' or 'notify'.
         */
        public function set_backorders($backorders)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Other Actions
        |--------------------------------------------------------------------------
        */
        /**
         * Returns false if the product cannot be bought.
         *
         * @access public
         * @return bool
         */
        public function is_purchasable()
        {
        }
        /**
         * Get the add to url used mainly in loops.
         *
         * @access public
         * @return string
         */
        public function add_to_cart_url()
        {
        }
        /**
         * Get the add to cart button text for the single page.
         *
         * @access public
         * @return string
         */
        public function single_add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text.
         *
         * @access public
         * @return string
         */
        public function add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text description - used in aria tags.
         *
         * @since 3.3.0
         * @return string
         */
        public function add_to_cart_description()
        {
        }
    }
    /**
     * Product factory class.
     */
    class WC_Product_Factory
    {
        /**
         * Get a product.
         *
         * @param mixed $product_id WC_Product|WP_Post|int|bool $product Product instance, post instance, numeric or false to use global $post.
         * @param array $deprecated Previously used to pass arguments to the factory, e.g. to force a type.
         * @return WC_Product|bool Product object or false if the product cannot be loaded.
         */
        public function get_product($product_id = \false, $deprecated = array())
        {
        }
        /**
         * Gets a product classname and allows filtering. Returns WC_Product_Simple if the class does not exist.
         *
         * @since  3.0.0
         * @param  int    $product_id   Product ID.
         * @param  string $product_type Product type.
         * @return string
         */
        public static function get_product_classname($product_id, $product_type)
        {
        }
        /**
         * Get the product type for a product.
         *
         * @since 3.0.0
         * @param  int $product_id Product ID.
         * @return string|false
         */
        public static function get_product_type($product_id)
        {
        }
        /**
         * Create a WC coding standards compliant class name e.g. WC_Product_Type_Class instead of WC_Product_type-class.
         *
         * @param  string $product_type Product type.
         * @return string|false
         */
        public static function get_classname_from_product_type($product_type)
        {
        }
        /**
         * Get the product ID depending on what was passed.
         *
         * @since  3.0.0
         * @param  WC_Product|WP_Post|int|bool $product Product instance, post instance, numeric or false to use global $post.
         * @return int|bool false on failure
         */
        private function get_product_id($product)
        {
        }
    }
    /**
     * Product grouped class.
     */
    class WC_Product_Grouped extends \WC_Product
    {
        /**
         * Stores product data.
         *
         * @var array
         */
        protected $extra_data = array('children' => array());
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get the add to cart button text.
         *
         * @return string
         */
        public function add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text description - used in aria tags.
         *
         * @since 3.3.0
         * @return string
         */
        public function add_to_cart_description()
        {
        }
        /**
         * Returns whether or not the product is on sale.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function is_on_sale($context = 'view')
        {
        }
        /**
         * Returns false if the product cannot be bought.
         *
         * @return bool
         */
        public function is_purchasable()
        {
        }
        /**
         * Returns the price in html format.
         *
         * @param string $price (default: '').
         * @return string
         */
        public function get_price_html($price = '')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        |
        | Methods for getting data from the product object.
        */
        /**
         * Return the children of this product.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return array
         */
        public function get_children($context = 'view')
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        |
        | Methods for getting data from the product object.
        */
        /**
         * Return the children of this product.
         *
         * @param array $children List of product children.
         */
        public function set_children($children)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Sync with children.
        |--------------------------------------------------------------------------
        */
        /**
         * Sync a grouped product with it's children. These sync functions sync
         * upwards (from child to parent) when the variation is saved.
         *
         * @param WC_Product|int $product Product object or ID for which you wish to sync.
         * @param bool           $save If true, the product object will be saved to the DB before returning it.
         * @return WC_Product Synced product object.
         */
        public static function sync($product, $save = \true)
        {
        }
    }
    /**
     * Product query class.
     */
    class WC_Product_Query extends \WC_Object_Query
    {
        /**
         * Valid query vars for products.
         *
         * @return array
         */
        protected function get_default_query_vars()
        {
        }
        /**
         * Get products matching the current query vars.
         *
         * @return array|object of WC_Product objects
         */
        public function get_products()
        {
        }
    }
    /**
     * Simple product class.
     */
    class WC_Product_Simple extends \WC_Product
    {
        /**
         * Initialize simple product.
         *
         * @param WC_Product|int $product Product instance or ID.
         */
        public function __construct($product = 0)
        {
        }
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Get the add to url used mainly in loops.
         *
         * @return string
         */
        public function add_to_cart_url()
        {
        }
        /**
         * Get the add to cart button text.
         *
         * @return string
         */
        public function add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text description - used in aria tags.
         *
         * @since 3.3.0
         * @return string
         */
        public function add_to_cart_description()
        {
        }
    }
    /**
     * Variable product class.
     */
    class WC_Product_Variable extends \WC_Product
    {
        /**
         * Array of children variation IDs. Determined by children.
         *
         * @var array
         */
        protected $children = \null;
        /**
         * Array of visible children variation IDs. Determined by children.
         *
         * @var array
         */
        protected $visible_children = \null;
        /**
         * Array of variation attributes IDs. Determined by children.
         *
         * @var array
         */
        protected $variation_attributes = \null;
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Getters
        |--------------------------------------------------------------------------
        */
        /**
         * Get the aria-describedby description for the add to cart button.
         *
         * @return string
         */
        public function add_to_cart_aria_describedby()
        {
        }
        /**
         * Get the add to cart button text.
         *
         * @return string
         */
        public function add_to_cart_text()
        {
        }
        /**
         * Get the add to cart button text description - used in aria tags.
         *
         * @since 3.3.0
         * @return string
         */
        public function add_to_cart_description()
        {
        }
        /**
         * Get an array of all sale and regular prices from all variations. This is used for example when displaying the price range at variable product level or seeing if the variable product is on sale.
         *
         * @param  bool $for_display If true, prices will be adapted for display based on the `woocommerce_tax_display_shop` setting (including or excluding taxes).
         * @return array Array of RAW prices, regular prices, and sale prices with keys set to variation ID.
         */
        public function get_variation_prices($for_display = \false)
        {
        }
        /**
         * Get the min or max variation regular price.
         *
         * @param  string  $min_or_max Min or max price.
         * @param  boolean $for_display If true, prices will be adapted for display based on the `woocommerce_tax_display_shop` setting (including or excluding taxes).
         * @return string
         */
        public function get_variation_regular_price($min_or_max = 'min', $for_display = \false)
        {
        }
        /**
         * Get the min or max variation sale price.
         *
         * @param  string  $min_or_max Min or max price.
         * @param  boolean $for_display If true, prices will be adapted for display based on the `woocommerce_tax_display_shop` setting (including or excluding taxes).
         * @return string
         */
        public function get_variation_sale_price($min_or_max = 'min', $for_display = \false)
        {
        }
        /**
         * Get the min or max variation (active) price.
         *
         * @param  string  $min_or_max Min or max price.
         * @param  boolean $for_display If true, prices will be adapted for display based on the `woocommerce_tax_display_shop` setting (including or excluding taxes).
         * @return string
         */
        public function get_variation_price($min_or_max = 'min', $for_display = \false)
        {
        }
        /**
         * Returns the price in html format.
         *
         * Note: Variable prices do not show suffixes like other product types. This
         * is due to some things like tax classes being set at variation level which
         * could differ from the parent price. The only way to show accurate prices
         * would be to load the variation and get it's price, which adds extra
         * overhead and still has edge cases where the values would be inaccurate.
         *
         * Additionally, ranges of prices no longer show 'striked out' sale prices
         * due to the strings being very long and unclear/confusing. A single range
         * is shown instead.
         *
         * @param string $price Price (default: '').
         * @return string
         */
        public function get_price_html($price = '')
        {
        }
        /**
         * Get the suffix to display after prices > 0.
         *
         * This is skipped if the suffix
         * has dynamic values such as {price_excluding_tax} for variable products.
         *
         * @see get_price_html for an explanation as to why.
         * @param  string  $price Price to calculate, left blank to just use get_price().
         * @param  integer $qty   Quantity passed on to get_price_including_tax() or get_price_excluding_tax().
         * @return string
         */
        public function get_price_suffix($price = '', $qty = 1)
        {
        }
        /**
         * Return a products child ids.
         *
         * This is lazy loaded as it's not used often and does require several queries.
         *
         * @param bool|string $visible_only Visible only.
         * @return array Children ids
         */
        public function get_children($visible_only = '')
        {
        }
        /**
         * Return a products child ids - visible only.
         *
         * This is lazy loaded as it's not used often and does require several queries.
         *
         * @since 3.0.0
         * @return array Children ids
         */
        public function get_visible_children()
        {
        }
        /**
         * Return an array of attributes used for variations, as well as their possible values.
         *
         * This is lazy loaded as it's not used often and does require several queries.
         *
         * @return array Attributes and their available values
         */
        public function get_variation_attributes()
        {
        }
        /**
         * If set, get the default attributes for a variable product.
         *
         * @param string $attribute_name Attribute name.
         * @return string
         */
        public function get_variation_default_attribute($attribute_name)
        {
        }
        /**
         * Variable products themselves cannot be downloadable.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_downloadable($context = 'view')
        {
        }
        /**
         * Variable products themselves cannot be virtual.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function get_virtual($context = 'view')
        {
        }
        /**
         * Get an array of available variations for the current product.
         *
         * @param string $return Optional. The format to return the results in. Can be 'array' to return an array of variation data or 'objects' for the product objects. Default 'array'.
         *
         * @return array[]|WC_Product_Variation[]
         */
        public function get_available_variations($return = 'array')
        {
        }
        /**
         * Check if a given variation is currently available.
         *
         * @param WC_Product_Variation $variation Variation to check.
         *
         * @return bool True if the variation is available, false otherwise.
         */
        private function variation_is_available(\WC_Product_Variation $variation)
        {
        }
        /**
         * Returns an array of data for a variation. Used in the add to cart form.
         *
         * @since  2.4.0
         * @param  WC_Product $variation Variation product object or ID.
         * @return array|bool
         */
        public function get_available_variation($variation)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Setters
        |--------------------------------------------------------------------------
        */
        /**
         * Sets an array of variation attributes.
         *
         * @since 3.0.0
         * @param array $variation_attributes Attributes list.
         */
        public function set_variation_attributes($variation_attributes)
        {
        }
        /**
         * Sets an array of children for the product.
         *
         * @since 3.0.0
         * @param array $children Children products.
         */
        public function set_children($children)
        {
        }
        /**
         * Sets an array of visible children only.
         *
         * @since 3.0.0
         * @param array $visible_children List of visible children products.
         */
        public function set_visible_children($visible_children)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | CRUD methods
        |--------------------------------------------------------------------------
        */
        /**
         * Ensure properties are set correctly before save.
         *
         * @since 3.0.0
         */
        public function validate_props()
        {
        }
        /**
         * Do any extra processing needed before the actual product save
         * (but after triggering the 'woocommerce_before_..._object_save' action)
         *
         * @return mixed A state value that will be passed to after_data_store_save_or_update.
         */
        protected function before_data_store_save_or_update()
        {
        }
        /**
         * Do any extra processing needed after the actual product save
         * (but before triggering the 'woocommerce_after_..._object_save' action)
         *
         * @param mixed $state The state object that was returned by before_data_store_save_or_update.
         */
        protected function after_data_store_save_or_update($state)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Conditionals
        |--------------------------------------------------------------------------
        */
        /**
         * Returns whether or not the product is on sale.
         *
         * @param  string $context What the value is for. Valid values are view and edit. What the value is for. Valid values are view and edit.
         * @return bool
         */
        public function is_on_sale($context = 'view')
        {
        }
        /**
         * Is a child in stock?
         *
         * @return boolean
         */
        public function child_is_in_stock()
        {
        }
        /**
         * Is a child on backorder?
         *
         * @since 3.3.0
         * @return boolean
         */
        public function child_is_on_backorder()
        {
        }
        /**
         * Does a child have a weight set?
         *
         * @return boolean
         */
        public function child_has_weight()
        {
        }
        /**
         * Does a child have dimensions set?
         *
         * @return boolean
         */
        public function child_has_dimensions()
        {
        }
        /**
         * Returns whether or not the product has dimensions set.
         *
         * @return bool
         */
        public function has_dimensions()
        {
        }
        /**
         * Returns whether or not the product has weight set.
         *
         * @return bool
         */
        public function has_weight()
        {
        }
        /**
         * Returns whether or not the product has additional options that need
         * selecting before adding to cart.
         *
         * @since  3.0.0
         * @return boolean
         */
        public function has_options()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Sync with child variations.
        |--------------------------------------------------------------------------
        */
        /**
         * Sync a variable product with it's children. These sync functions sync
         * upwards (from child to parent) when the variation is saved.
         *
         * @param WC_Product|int $product Product object or ID for which you wish to sync.
         * @param bool           $save If true, the product object will be saved to the DB before returning it.
         * @return WC_Product Synced product object.
         */
        public static function sync($product, $save = \true)
        {
        }
        /**
         * Sync parent stock status with the status of all children and save.
         *
         * @param WC_Product|int $product Product object or ID for which you wish to sync.
         * @param bool           $save If true, the product object will be saved to the DB before returning it.
         * @return WC_Product Synced product object.
         */
        public static function sync_stock_status($product, $save = \true)
        {
        }
        /**
         * Sort an associative array of $variation_id => $price pairs in order of min and max prices.
         *
         * @param array $prices associative array of $variation_id => $price pairs.
         * @return array
         */
        protected function sort_variation_prices($prices)
        {
        }
    }
    /**
     * Product variation class.
     */
    class WC_Product_Variation extends \WC_Product_Simple
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $post_type = 'product_variation';
        /**
         * Parent data.
         *
         * @var array
         */
        protected $parent_data = array('title' => '', 'sku' => '', 'manage_stock' => '', 'backorders' => '', 'stock_quantity' => '', 'weight' => '', 'length' => '', 'width' => '', 'height' => '', 'tax_class' => '', 'shipping_class_id' => '', 'image_id' => '', 'purchase_note' => '');
        /**
         * Override the default constructor to set custom defaults.
         *
         * @param int|WC_Product|object $product Product to init.
         */
        public function __construct($product = 0)
        {
        }
        /**
         * Prefix for action and filter hooks on data.
         *
         * @since  3.0.0
         * @return string
         */
        protected function get_hook_prefix()
        {
        }
        /**
         * Get internal type.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * If the stock level comes from another product ID.
         *
         * @since  3.0.0
         * @return int
         */
        public function get_stock_managed_by_id()
        {
        }
        /**
         * Get the product's title. For variations this is the parent product name.
         *
         * @return string
         */
        public function get_title()
        {
        }
        /**
         * Get product name with SKU or ID. Used within admin.
         *
         * @return string Formatted product name
         */
        public function get_formatted_name()
        {
        }
        /**
         * Get variation attribute values. Keys are prefixed with attribute_, as stored, unless $with_prefix is false.
         *
         * @param bool $with_prefix Whether keys should be prepended with attribute_ or not, default is true.
         * @return array of attributes and their values for this variation.
         */
        public function get_variation_attributes($with_prefix = \true)
        {
        }
        /**
         * Returns a single product attribute as a string.
         *
         * @param  string $attribute to get.
         * @return string
         */
        public function get_attribute($attribute)
        {
        }
        /**
         * Wrapper for get_permalink. Adds this variations attributes to the URL.
         *
         * @param  array|null $item_object item array If a cart or order item is passed, we can get a link containing the exact attributes selected for the variation, rather than the default attributes.
         * @return string
         */
        public function get_permalink($item_object = \null)
        {
        }
        /**
         * Get the add to url used mainly in loops.
         *
         * @return string
         */
        public function add_to_cart_url()
        {
        }
        /**
         * Get SKU (Stock-keeping unit) - product unique ID.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_sku($context = 'view')
        {
        }
        /**
         * Returns the product's weight.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_weight($context = 'view')
        {
        }
        /**
         * Returns the product length.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_length($context = 'view')
        {
        }
        /**
         * Returns the product width.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_width($context = 'view')
        {
        }
        /**
         * Returns the product height.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_height($context = 'view')
        {
        }
        /**
         * Returns the tax class.
         *
         * Does not use get_prop so it can handle 'parent' inheritance correctly.
         *
         * @param  string $context view, edit, or unfiltered.
         * @return string
         */
        public function get_tax_class($context = 'view')
        {
        }
        /**
         * Return if product manage stock.
         *
         * @since 3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return boolean|string true, false, or parent.
         */
        public function get_manage_stock($context = 'view')
        {
        }
        /**
         * Returns number of items available for sale.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int|null
         */
        public function get_stock_quantity($context = 'view')
        {
        }
        /**
         * Get backorders.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @since 3.0.0
         * @return string yes no or notify
         */
        public function get_backorders($context = 'view')
        {
        }
        /**
         * Get main image ID.
         *
         * @since 3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_image_id($context = 'view')
        {
        }
        /**
         * Get purchase note.
         *
         * @since 3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_purchase_note($context = 'view')
        {
        }
        /**
         * Get shipping class ID.
         *
         * @since 3.0.0
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return int
         */
        public function get_shipping_class_id($context = 'view')
        {
        }
        /**
         * Get catalog visibility.
         *
         * @param  string $context What the value is for. Valid values are view and edit.
         * @return string
         */
        public function get_catalog_visibility($context = 'view')
        {
        }
        /**
         * Get attribute summary.
         *
         * By default, attribute summary contains comma-delimited 'attribute_name: attribute_value' pairs for all attributes.
         *
         * @param string $context What the value is for. Valid values are view and edit.
         *
         * @since 3.6.0
         * @return string
         */
        public function get_attribute_summary($context = 'view')
        {
        }
        /**
         * Set attribute summary.
         *
         * By default, attribute summary contains comma-delimited 'attribute_name: attribute_value' pairs for all attributes.
         *
         * @since 3.6.0
         * @param string $attribute_summary Summary of attribute names and values assigned to the variation.
         */
        public function set_attribute_summary($attribute_summary)
        {
        }
        /*
        |--------------------------------------------------------------------------
        | CRUD methods
        |--------------------------------------------------------------------------
        */
        /**
         * Set the parent data array for this variation.
         *
         * @since 3.0.0
         * @param array $parent_data parent data array for this variation.
         */
        public function set_parent_data($parent_data)
        {
        }
        /**
         * Get the parent data array for this variation.
         *
         * @since  3.0.0
         * @return array
         */
        public function get_parent_data()
        {
        }
        /**
         * Set attributes. Unlike the parent product which uses terms, variations are assigned
         * specific attributes using name value pairs.
         *
         * @param array $raw_attributes array of raw attributes.
         */
        public function set_attributes($raw_attributes)
        {
        }
        /**
         * Returns whether or not the product has any visible attributes.
         *
         * Variations are mapped to specific attributes unlike products, and the return
         * value of ->get_attributes differs. Therefore this returns false.
         *
         * @return boolean
         */
        public function has_attributes()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Conditionals
        |--------------------------------------------------------------------------
        */
        /**
         * Returns false if the product cannot be bought.
         * Override abstract method so that: i) Disabled variations are not be purchasable by admins. ii) Enabled variations are not purchasable if the parent product is not purchasable.
         *
         * @return bool
         */
        public function is_purchasable()
        {
        }
        /**
         * Controls whether this particular variation will appear greyed-out (inactive) or not (active).
         * Used by extensions to make incompatible variations appear greyed-out, etc.
         * Other possible uses: prevent out-of-stock variations from being selected.
         *
         * @return bool
         */
        public function variation_is_active()
        {
        }
        /**
         * Checks if this particular variation is visible. Invisible variations are enabled and can be selected, but no price / stock info is displayed.
         * Instead, a suitable 'unavailable' message is displayed.
         * Invisible by default: Disabled variations and variations with an empty price.
         *
         * @return bool
         */
        public function variation_is_visible()
        {
        }
        /**
         * Return valid tax classes. Adds 'parent' to the default list of valid tax classes.
         *
         * @return array valid tax classes
         */
        protected function get_valid_tax_classes()
        {
        }
    }
    /**
     * WC_Query Class.
     */
    class WC_Query
    {
        use \Automattic\WooCommerce\Internal\Traits\AccessiblePrivateMethods;
        /**
         * Query vars to add to wp.
         *
         * @var array
         */
        public $query_vars = array();
        /**
         * Reference to the main product query on the page.
         *
         * @var WP_Query
         */
        private static $product_query;
        /**
         * Stores chosen attributes.
         *
         * @var array
         */
        private static $chosen_attributes;
        /**
         * The instance of the class that helps filtering with the product attributes lookup table.
         *
         * @var Filterer
         */
        private $filterer;
        /**
         * Constructor for the query class. Hooks in methods.
         */
        public function __construct()
        {
        }
        /**
         * Reset the chosen attributes so that get_layered_nav_chosen_attributes will get them from the query again.
         */
        public static function reset_chosen_attributes()
        {
        }
        /**
         * Get any errors from querystring.
         */
        public function get_errors()
        {
        }
        /**
         * Init query vars by loading options.
         */
        public function init_query_vars()
        {
        }
        /**
         * Get page title for an endpoint.
         *
         * @param string $endpoint Endpoint key.
         * @param string $action Optional action or variation within the endpoint.
         *
         * @since 2.3.0
         * @since 4.6.0 Added $action parameter.
         * @return string The page title.
         */
        public function get_endpoint_title($endpoint, $action = '')
        {
        }
        /**
         * Endpoint mask describing the places the endpoint should be added.
         *
         * @since 2.6.2
         * @return int
         */
        public function get_endpoints_mask()
        {
        }
        /**
         * Add endpoints for query vars.
         */
        public function add_endpoints()
        {
        }
        /**
         * Add query vars.
         *
         * @param array $vars Query vars.
         * @return array
         */
        public function add_query_vars($vars)
        {
        }
        /**
         * Get query vars.
         *
         * @return array
         */
        public function get_query_vars()
        {
        }
        /**
         * Get query current active query var.
         *
         * @return string
         */
        public function get_current_endpoint()
        {
        }
        /**
         * Parse the request and look for query vars - endpoints may not be supported.
         */
        public function parse_request()
        {
        }
        /**
         * Are we currently on the front page?
         *
         * @param WP_Query $q Query instance.
         * @return bool
         */
        private function is_showing_page_on_front($q)
        {
        }
        /**
         * Is the front page a page we define?
         *
         * @param int $page_id Page ID.
         * @return bool
         */
        private function page_on_front_is($page_id)
        {
        }
        /**
         * Returns a copy of `$query` with all query vars that are allowed on the front page stripped.
         * Used when the shop page is also the front page.
         *
         * @param array $query The unfiltered array.
         * @return array The filtered query vars.
         */
        private function filter_out_valid_front_page_query_vars($query)
        {
        }
        /**
         * Checks whether a query var is allowed on the front page or not.
         *
         * @param string $query_var Query var name.
         * @return boolean TRUE when query var is allowed on the front page. FALSE otherwise.
         */
        private function is_query_var_valid_on_front_page($query_var)
        {
        }
        /**
         * Hook into pre_get_posts to do the main product query.
         *
         * @param WP_Query $q Query instance.
         */
        public function pre_get_posts($q)
        {
        }
        /**
         * Handler for the 'the_posts' WP filter.
         *
         * @param array    $posts Posts from WP Query.
         * @param WP_Query $query Current query.
         *
         * @return array
         */
        public function handle_get_posts($posts, $query)
        {
        }
        /**
         * Pre_get_posts above may adjust the main query to add WooCommerce logic. When this query is done, we need to ensure
         * all custom filters are removed.
         *
         * This is done here during the_posts filter. The input is not changed.
         *
         * @param array $posts Posts from WP Query.
         * @return array
         */
        public function remove_product_query_filters($posts)
        {
        }
        /**
         * This function used to be hooked to found_posts and adjust the posts count when the filtering by attribute
         * widget was used and variable products were present. Now it isn't hooked anymore and does nothing but return
         * the input unchanged, since the pull request in which it was introduced has been reverted.
         *
         * @since 4.4.0
         * @param int      $count Original posts count, as supplied by the found_posts filter.
         * @param WP_Query $query The current WP_Query object.
         *
         * @return int Adjusted posts count.
         */
        public function adjust_posts_count($count, $query)
        {
        }
        /**
         * Instance version of get_layered_nav_chosen_attributes, needed for unit tests.
         *
         * @return array
         */
        protected function get_layered_nav_chosen_attributes_inst()
        {
        }
        /**
         * Get the posts (or the ids of the posts) found in the current WP loop.
         *
         * @return array Array of posts or post ids.
         */
        protected function get_current_posts()
        {
        }
        /**
         * WP SEO meta description.
         *
         * Hooked into wpseo_ hook already, so no need for function_exist.
         *
         * @return string
         */
        public function wpseo_metadesc()
        {
        }
        /**
         * WP SEO meta key.
         *
         * Hooked into wpseo_ hook already, so no need for function_exist.
         *
         * @return string
         */
        public function wpseo_metakey()
        {
        }
        /**
         * Query the products, applying sorting/ordering etc.
         * This applies to the main WordPress loop.
         *
         * @param WP_Query $q Query instance.
         */
        public function product_query($q)
        {
        }
        /**
         * Add extra clauses to the product query.
         *
         * @param array    $args Product query clauses.
         * @param WP_Query $wp_query The current product query.
         * @return array The updated product query clauses array.
         */
        private function product_query_post_clauses($args, $wp_query)
        {
        }
        /**
         * Remove the query.
         */
        public function remove_product_query()
        {
        }
        /**
         * Remove ordering queries.
         */
        public function remove_ordering_args()
        {
        }
        /**
         * Returns an array of arguments for ordering products based on the selected values.
         *
         * @param string $orderby Order by param.
         * @param string $order Order param.
         * @return array
         */
        public function get_catalog_ordering_args($orderby = '', $order = '')
        {
        }
        /**
         * Custom query used to filter products by price.
         *
         * @since 3.6.0
         *
         * @param array    $args Query args.
         * @param WP_Query $wp_query WP_Query object.
         *
         * @return array
         */
        public function price_filter_post_clauses($args, $wp_query)
        {
        }
        /**
         * Handle numeric price sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_price_asc_post_clauses($args)
        {
        }
        /**
         * Handle numeric price sorting.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_price_desc_post_clauses($args)
        {
        }
        /**
         * WP Core does not let us change the sort direction for individual orderby params - https://core.trac.wordpress.org/ticket/17065.
         *
         * This lets us sort by meta value desc, and have a second orderby param.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_popularity_post_clauses($args)
        {
        }
        /**
         * Order by rating post clauses.
         *
         * @param array $args Query args.
         * @return array
         */
        public function order_by_rating_post_clauses($args)
        {
        }
        /**
         * Join wc_product_meta_lookup to posts if not already joined.
         *
         * @param string $sql SQL join.
         * @return string
         */
        private function append_product_sorting_table_join($sql)
        {
        }
        /**
         * Appends meta queries to an array.
         *
         * @param  array $meta_query Meta query.
         * @param  bool  $main_query If is main query.
         * @return array
         */
        public function get_meta_query($meta_query = array(), $main_query = \false)
        {
        }
        /**
         * Appends tax queries to an array.
         *
         * @param  array $tax_query  Tax query.
         * @param  bool  $main_query If is main query.
         * @return array
         */
        public function get_tax_query($tax_query = array(), $main_query = \false)
        {
        }
        /**
         * Get the main query which product queries ran against.
         *
         * @return WP_Query
         */
        public static function get_main_query()
        {
        }
        /**
         * Get the tax query which was used by the main query.
         *
         * @return array
         */
        public static function get_main_tax_query()
        {
        }
        /**
         * Get the meta query which was used by the main query.
         *
         * @return array
         */
        public static function get_main_meta_query()
        {
        }
        /**
         * Based on WP_Query::parse_search
         */
        public static function get_main_search_query_sql()
        {
        }
        /**
         * Get an array of attributes and terms selected with the layered nav widget.
         *
         * @return array
         */
        public static function get_layered_nav_chosen_attributes()
        {
        }
        /**
         * Remove the add-to-cart param from pagination urls.
         *
         * @param string $url URL.
         * @return string
         */
        public function remove_add_to_cart_pagination($url)
        {
        }
        /**
         * Return a meta query for filtering by rating.
         *
         * @deprecated 3.0.0 Replaced with taxonomy.
         * @return array
         */
        public function rating_filter_meta_query()
        {
        }
        /**
         * Returns a meta query to handle product visibility.
         *
         * @deprecated 3.0.0 Replaced with taxonomy.
         * @param string $compare (default: 'IN').
         * @return array
         */
        public function visibility_meta_query($compare = 'IN')
        {
        }
        /**
         * Returns a meta query to handle product stock status.
         *
         * @deprecated 3.0.0 Replaced with taxonomy.
         * @param string $status (default: 'instock').
         * @return array
         */
        public function stock_status_meta_query($status = 'instock')
        {
        }
        /**
         * Layered nav init.
         *
         * @deprecated 2.6.0
         */
        public function layered_nav_init()
        {
        }
        /**
         * Get an unpaginated list all product IDs (both filtered and unfiltered). Makes use of transients.
         *
         * @deprecated 2.6.0 due to performance concerns
         */
        public function get_products_in_view()
        {
        }
        /**
         * Layered Nav post filter.
         *
         * @deprecated 2.6.0 due to performance concerns
         *
         * @param mixed $deprecated Deprecated.
         */
        public function layered_nav_query($deprecated)
        {
        }
        /**
         * Search post excerpt.
         *
         * @param string $where Where clause.
         *
         * @deprecated 3.2.0 - Not needed anymore since WordPress 4.5.
         */
        public function search_post_excerpt($where = '')
        {
        }
        /**
         * Remove the posts_where filter.
         *
         * @deprecated 3.2.0 - Nothing to remove anymore because search_post_excerpt() is deprecated.
         */
        public function remove_posts_where()
        {
        }
    }
    /**
     * Rate limit class.
     */
    class WC_Rate_Limiter
    {
        /**
         * Cache group.
         */
        const CACHE_GROUP = 'wc_rate_limit';
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Constructs key name from action identifier.
         * Left in for backwards compatibility.
         *
         * @param string $action_id Identifier of the action.
         * @return string
         */
        public static function storage_id($action_id)
        {
        }
        /**
         * Gets a cache prefix.
         *
         * @param string $action_id Identifier of the action.
         * @return string
         */
        protected static function get_cache_key($action_id)
        {
        }
        /**
         * Retrieve a cached rate limit.
         *
         * @param string $action_id Identifier of the action.
         * @return bool|int
         */
        protected static function get_cached($action_id)
        {
        }
        /**
         * Cache a rate limit.
         *
         * @param string $action_id Identifier of the action.
         * @param int    $expiry Timestamp when the limit expires.
         * @return bool
         */
        protected static function set_cache($action_id, $expiry)
        {
        }
        /**
         * Returns true if the action is not allowed to be run by the rate limiter yet, false otherwise.
         *
         * @param string $action_id Identifier of the action.
         * @return bool
         */
        public static function retried_too_soon($action_id)
        {
        }
        /**
         * Sets the rate limit delay in seconds for action with identifier $id.
         *
         * @param string $action_id Identifier of the action.
         * @param int    $delay Delay in seconds.
         * @return bool True if the option setting was successful, false otherwise.
         */
        public static function set_rate_limit($action_id, $delay)
        {
        }
        /**
         * Cleanup expired rate limits from the database and clear caches.
         */
        public static function cleanup()
        {
        }
    }
    /**
     * Class that extends WC_Background_Process to process image regeneration in the background.
     */
    class WC_Regenerate_Images_Request extends \WC_Background_Process
    {
        /**
         * Stores the attachment ID being processed.
         *
         * @var integer
         */
        protected $attachment_id = 0;
        /**
         * Initiate new background process.
         */
        public function __construct()
        {
        }
        /**
         * Is job running?
         *
         * @return boolean
         */
        public function is_running()
        {
        }
        /**
         * Limit each task ran per batch to 1 for image regen.
         *
         * @return bool
         */
        protected function batch_limit_exceeded()
        {
        }
        /**
         * Determines whether an attachment can have its thumbnails regenerated.
         *
         * Adapted from Regenerate Thumbnails by Alex Mills.
         *
         * @param WP_Post $attachment An attachment's post object.
         * @return bool Whether the given attachment can have its thumbnails regenerated.
         */
        protected function is_regeneratable($attachment)
        {
        }
        /**
         * Code to execute for each item in the queue
         *
         * @param mixed $item Queue item to iterate over.
         * @return bool
         */
        protected function task($item)
        {
        }
        /**
         * Filters the list of thumbnail sizes to only include those which have missing files.
         *
         * @param array $sizes         An associative array of registered thumbnail image sizes.
         * @param array $metadata      An associative array of fullsize image metadata: width, height, file.
         * @param int   $attachment_id Attachment ID. Only passed from WP 5.0+.
         * @return array An associative array of image sizes.
         */
        public function filter_image_sizes_to_only_missing_thumbnails($sizes, $metadata, $attachment_id = \null)
        {
        }
        /**
         * Returns the sizes we want to regenerate.
         *
         * @param array $sizes Sizes to generate.
         * @return array
         */
        public function adjust_intermediate_image_sizes($sizes)
        {
        }
        /**
         * This runs once the job has completed all items on the queue.
         *
         * @return void
         */
        protected function complete()
        {
        }
    }
    /**
     * Regenerate Images Class
     */
    class WC_Regenerate_Images
    {
        /**
         * Background process to regenerate all images
         *
         * @var WC_Regenerate_Images_Request
         */
        protected static $background_process;
        /**
         * Stores size being generated on the fly.
         *
         * @var string
         */
        protected static $regenerate_size;
        /**
         * Init function
         */
        public static function init()
        {
        }
        /**
         * If an intermediate size meta differs from the actual image size (settings were changed?) return false so the wrong size is not used.
         *
         * @param array  $data Size data.
         * @param int    $attachment_id Attachment ID.
         * @param string $size Size name.
         * @return array
         */
        public static function filter_image_get_intermediate_size($data, $attachment_id, $size)
        {
        }
        /**
         * We need to track if uncropped was on or off when generating the images.
         *
         * @param array $meta_data Array of meta data.
         * @return array
         */
        public static function add_uncropped_metadata($meta_data)
        {
        }
        /**
         * See if an image's dimensions match actual settings.
         *
         * @param array  $image Image dimensions array.
         * @param string $size Named size.
         * @return bool True if they match. False if they do not (may trigger regen).
         */
        protected static function image_size_matches_settings($image, $size)
        {
        }
        /**
         * Show notice when job is running in background.
         */
        public static function regenerating_notice()
        {
        }
        /**
         * Dismiss notice and cancel jobs.
         */
        public static function dismiss_regenerating_notice()
        {
        }
        /**
         * Regenerate images if the settings have changed since last re-generation.
         *
         * @return void
         */
        public static function maybe_regenerate_images()
        {
        }
        /**
         * Check if we should maybe generate a new image size if not already there.
         *
         * @param array        $image Properties of the image.
         * @param int          $attachment_id Attachment ID.
         * @param string|array $size Image size.
         * @param bool         $icon If icon or not.
         * @return array
         */
        public static function maybe_resize_image($image, $attachment_id, $size, $icon)
        {
        }
        /**
         * Get full size image dimensions.
         *
         * @param int $attachment_id Attachment ID of image.
         * @return array Width and height. Empty array if the dimensions cannot be found.
         */
        private static function get_full_size_image_dimensions($attachment_id)
        {
        }
        /**
         * Ensure we are dealing with the correct image attachment
         *
         * @param int|WP_Post $attachment Attachment object or ID.
         * @return boolean
         */
        public static function is_regeneratable($attachment)
        {
        }
        /**
         * Only regenerate images for the requested size.
         *
         * @param array $sizes Array of image sizes.
         * @return array
         */
        public static function adjust_intermediate_image_sizes($sizes)
        {
        }
        /**
         * Generate the thumbnail filename and dimensions for a given file.
         *
         * @param string $fullsizepath Path to full size image.
         * @param int    $thumbnail_width  The width of the thumbnail.
         * @param int    $thumbnail_height The height of the thumbnail.
         * @param bool   $crop             Whether to crop or not.
         * @return array|false An array of the filename, thumbnail width, and thumbnail height, or false on failure to resize such as the thumbnail being larger than the fullsize image.
         */
        private static function get_image($fullsizepath, $thumbnail_width, $thumbnail_height, $crop)
        {
        }
        /**
         * Regenerate the image according to the required size
         *
         * @param int    $attachment_id Attachment ID.
         * @param array  $image Original Image.
         * @param string $size Size to return for new URL.
         * @param bool   $icon If icon or not.
         * @return string
         */
        private static function resize_and_return_image($attachment_id, $image, $size, $icon)
        {
        }
        /**
         * Image downsize, without this classes filtering on the results.
         *
         * @param int    $attachment_id Attachment ID.
         * @param string $size Size to downsize to.
         * @return string New image URL.
         */
        private static function unfiltered_image_downsize($attachment_id, $size)
        {
        }
        /**
         * Get list of images and queue them for regeneration
         *
         * @return void
         */
        public static function queue_image_regeneration()
        {
        }
    }
    /**
     * Register WP admin settings class.
     */
    class WC_Register_WP_Admin_Settings
    {
        /**
         * Contains the current class to pull settings from.
         * Either a admin page object or WC_Email object
         *
         * @var WC_Register_WP_Admin_Settings
         */
        protected $object;
        /**
         * Hooks into the settings API and starts registering our settings.
         *
         * @since 3.0.0
         * @param WC_Email|WC_Settings_Page $object The object that contains the settings to register.
         * @param string                    $type   Type of settings to register (email or page).
         */
        public function __construct($object, $type)
        {
        }
        /**
         * Register's all of our different notification emails as sub groups
         * of email settings.
         *
         * @since  3.0.0
         * @param  array $groups Existing registered groups.
         * @return array
         */
        public function register_email_group($groups)
        {
        }
        /**
         * Registers all of the setting form fields for emails to each email type's group.
         *
         * @since  3.0.0
         * @param  array $settings Existing registered settings.
         * @return array
         */
        public function register_email_settings($settings)
        {
        }
        /**
         * Registers a setting group, based on admin page ID & label as parent group.
         *
         * @since  3.0.0
         * @param  array $groups Array of previously registered groups.
         * @return array
         */
        public function register_page_group($groups)
        {
        }
        /**
         * Registers settings to a specific group.
         *
         * @since  3.0.0
         * @param  array $settings Existing registered settings.
         * @return array
         */
        public function register_page_settings($settings)
        {
        }
        /**
         * Register a setting into the format expected for the Settings REST API.
         *
         * @since 3.0.0
         * @param  array $setting Setting data.
         * @return array|bool
         */
        public function register_setting($setting)
        {
        }
    }
    /**
     * REST API authentication class.
     */
    class WC_REST_Authentication
    {
        /**
         * Authentication error.
         *
         * @var WP_Error
         */
        protected $error = \null;
        /**
         * Logged in user data.
         *
         * @var stdClass
         */
        protected $user = \null;
        /**
         * Current auth method.
         *
         * @var string
         */
        protected $auth_method = '';
        /**
         * Initialize authentication actions.
         */
        public function __construct()
        {
        }
        /**
         * Check if is request to our REST API.
         *
         * @return bool
         */
        protected function is_request_to_rest_api()
        {
        }
        /**
         * Authenticate user.
         *
         * @param int|false $user_id User ID if one has been determined, false otherwise.
         * @return int|false
         */
        public function authenticate($user_id)
        {
        }
        /**
         * Authenticate the user if authentication wasn't performed during the
         * determine_current_user action.
         *
         * Necessary in cases where wp_get_current_user() is called before WooCommerce is loaded.
         *
         * @see https://github.com/woocommerce/woocommerce/issues/26847
         *
         * @param WP_Error|null|bool $error Error data.
         * @return WP_Error|null|bool
         */
        public function authentication_fallback($error)
        {
        }
        /**
         * Check for authentication error.
         *
         * @param WP_Error|null|bool $error Error data.
         * @return WP_Error|null|bool
         */
        public function check_authentication_error($error)
        {
        }
        /**
         * Set authentication error.
         *
         * @param WP_Error $error Authentication error data.
         */
        protected function set_error($error)
        {
        }
        /**
         * Get authentication error.
         *
         * @return WP_Error|null.
         */
        protected function get_error()
        {
        }
        /**
         * Basic Authentication.
         *
         * SSL-encrypted requests are not subject to sniffing or man-in-the-middle
         * attacks, so the request can be authenticated by simply looking up the user
         * associated with the given consumer key and confirming the consumer secret
         * provided is valid.
         *
         * @return int|bool
         */
        private function perform_basic_authentication()
        {
        }
        /**
         * Parse the Authorization header into parameters.
         *
         * @since 3.0.0
         *
         * @param string $header Authorization header value (not including "Authorization: " prefix).
         *
         * @return array Map of parameter values.
         */
        public function parse_header($header)
        {
        }
        /**
         * Get the authorization header.
         *
         * On certain systems and configurations, the Authorization header will be
         * stripped out by the server or PHP. Typically this is then used to
         * generate `PHP_AUTH_USER`/`PHP_AUTH_PASS` but not passed on. We use
         * `getallheaders` here to try and grab it out instead.
         *
         * @since 3.0.0
         *
         * @return string Authorization header if set.
         */
        public function get_authorization_header()
        {
        }
        /**
         * Get oAuth parameters from $_GET, $_POST or request header.
         *
         * @since 3.0.0
         *
         * @return array|WP_Error
         */
        public function get_oauth_parameters()
        {
        }
        /**
         * Perform OAuth 1.0a "one-legged" (http://oauthbible.com/#oauth-10a-one-legged) authentication for non-SSL requests.
         *
         * This is required so API credentials cannot be sniffed or intercepted when making API requests over plain HTTP.
         *
         * This follows the spec for simple OAuth 1.0a authentication (RFC 5849) as closely as possible, with two exceptions:
         *
         * 1) There is no token associated with request/responses, only consumer keys/secrets are used.
         *
         * 2) The OAuth parameters are included as part of the request query string instead of part of the Authorization header,
         *    This is because there is no cross-OS function within PHP to get the raw Authorization header.
         *
         * @link http://tools.ietf.org/html/rfc5849 for the full spec.
         *
         * @return int|bool
         */
        private function perform_oauth_authentication()
        {
        }
        /**
         * Verify that the consumer-provided request signature matches our generated signature,
         * this ensures the consumer has a valid key/secret.
         *
         * @param stdClass $user   User data.
         * @param array    $params The request parameters.
         * @return true|WP_Error
         */
        private function check_oauth_signature($user, $params)
        {
        }
        /**
         * Creates an array of urlencoded strings out of each array key/value pairs.
         *
         * @param  array  $params       Array of parameters to convert.
         * @param  array  $query_params Array to extend.
         * @param  string $key          Optional Array key to append.
         * @return string               Array of urlencoded strings.
         */
        private function join_with_equals_sign($params, $query_params = array(), $key = '')
        {
        }
        /**
         * Normalize each parameter by assuming each parameter may have already been
         * encoded, so attempt to decode, and then re-encode according to RFC 3986.
         *
         * Note both the key and value is normalized so a filter param like:
         *
         * 'filter[period]' => 'week'
         *
         * is encoded to:
         *
         * 'filter%255Bperiod%255D' => 'week'
         *
         * This conforms to the OAuth 1.0a spec which indicates the entire query string
         * should be URL encoded.
         *
         * @see rawurlencode()
         * @param array $parameters Un-normalized parameters.
         * @return array Normalized parameters.
         */
        private function normalize_parameters($parameters)
        {
        }
        /**
         * Verify that the timestamp and nonce provided with the request are valid. This prevents replay attacks where
         * an attacker could attempt to re-send an intercepted request at a later time.
         *
         * - A timestamp is valid if it is within 15 minutes of now.
         * - A nonce is valid if it has not been used within the last 15 minutes.
         *
         * @param stdClass $user      User data.
         * @param int      $timestamp The unix timestamp for when the request was made.
         * @param string   $nonce     A unique (for the given user) 32 alphanumeric string, consumer-generated.
         * @return bool|WP_Error
         */
        private function check_oauth_timestamp_and_nonce($user, $timestamp, $nonce)
        {
        }
        /**
         * Return the user data for the given consumer_key.
         *
         * @param string $consumer_key Consumer key.
         * @return array
         */
        private function get_user_data_by_consumer_key($consumer_key)
        {
        }
        /**
         * Check that the API keys provided have the proper key-specific permissions to either read or write API resources.
         *
         * @param string $method Request method.
         * @return bool|WP_Error
         */
        private function check_permissions($method)
        {
        }
        /**
         * Updated API Key last access datetime.
         */
        private function update_last_access()
        {
        }
        /**
         * If the consumer_key and consumer_secret $_GET parameters are NOT provided
         * and the Basic auth headers are either not present or the consumer secret does not match the consumer
         * key provided, then return the correct Basic headers and an error message.
         *
         * @param WP_REST_Response $response Current response being served.
         * @return WP_REST_Response
         */
        public function send_unauthorized_headers($response)
        {
        }
        /**
         * Check for user permissions and register last access.
         *
         * @param mixed           $result  Response to replace the requested version with.
         * @param WP_REST_Server  $server  Server instance.
         * @param WP_REST_Request $request Request used to generate the response.
         * @return mixed
         */
        public function check_user_permissions($result, $server, $request)
        {
        }
    }
    /**
     * WC_REST_Exception class.
     */
    class WC_REST_Exception extends \WC_Data_Exception
    {
    }
    /**
     * Session handler class.
     */
    class WC_Session_Handler extends \WC_Session
    {
        /**
         * Cookie name used for the session.
         *
         * @var string cookie name
         */
        protected $_cookie;
        /**
         * Stores session expiry.
         *
         * @var string session due to expire timestamp
         */
        protected $_session_expiring;
        /**
         * Stores session due to expire timestamp.
         *
         * @var string session expiration timestamp
         */
        protected $_session_expiration;
        /**
         * True when the cookie exists.
         *
         * @var bool Based on whether a cookie exists.
         */
        protected $_has_cookie = \false;
        /**
         * Table name for session data.
         *
         * @var string Custom session table name
         */
        protected $_table;
        /**
         * Constructor for the session class.
         */
        public function __construct()
        {
        }
        /**
         * Init hooks and session data.
         *
         * @since 3.3.0
         */
        public function init()
        {
        }
        /**
         * Setup cookie and customer ID.
         *
         * @since 3.6.0
         */
        public function init_session_cookie()
        {
        }
        /**
         * Checks if session cookie is expired, or belongs to a logged out user.
         *
         * @return bool Whether session cookie is valid.
         */
        private function is_session_cookie_valid()
        {
        }
        /**
         * Sets the session cookie on-demand (usually after adding an item to the cart).
         *
         * Since the cookie name (as of 2.1) is prepended with wp, cache systems like batcache will not cache pages when set.
         *
         * Warning: Cookies will only be set if this is called before the headers are sent.
         *
         * @param bool $set Should the session cookie be set.
         */
        public function set_customer_session_cookie($set)
        {
        }
        /**
         * Should the session cookie be secure?
         *
         * @since 3.6.0
         * @return bool
         */
        protected function use_secure_cookie()
        {
        }
        /**
         * Return true if the current user has an active session, i.e. a cookie to retrieve values.
         *
         * @return bool
         */
        public function has_session()
        {
        }
        /**
         * Set session expiration.
         */
        public function set_session_expiration()
        {
        }
        /**
         * Generate a unique customer ID for guests, or return user ID if logged in.
         *
         * Uses Portable PHP password hashing framework to generate a unique cryptographically strong ID.
         *
         * @return string
         */
        public function generate_customer_id()
        {
        }
        /**
         * Checks if this is an auto-generated customer ID.
         *
         * @param string|int $customer_id Customer ID to check.
         *
         * @return bool Whether customer ID is randomly generated.
         */
        private function is_customer_guest($customer_id)
        {
        }
        /**
         * Get session unique ID for requests if session is initialized or user ID if logged in.
         * Introduced to help with unit tests.
         *
         * @since 5.3.0
         * @return string
         */
        public function get_customer_unique_id()
        {
        }
        /**
         * Get the session cookie, if set. Otherwise return false.
         *
         * Session cookies without a customer ID are invalid.
         *
         * @return bool|array
         */
        public function get_session_cookie()
        {
        }
        /**
         * Get session data.
         *
         * @return array
         */
        public function get_session_data()
        {
        }
        /**
         * Gets a cache prefix. This is used in session names so the entire cache can be invalidated with 1 function call.
         *
         * @return string
         */
        private function get_cache_prefix()
        {
        }
        /**
         * Save data and delete guest session.
         *
         * @param int $old_session_key session ID before user logs in.
         */
        public function save_data($old_session_key = 0)
        {
        }
        /**
         * Destroy all session data.
         */
        public function destroy_session()
        {
        }
        /**
         * Forget all session data without destroying it.
         */
        public function forget_session()
        {
        }
        /**
         * When a user is logged out, ensure they have a unique nonce by using the customer/session ID.
         *
         * @deprecated 5.3.0
         * @param int $uid User ID.
         * @return int|string
         */
        public function nonce_user_logged_out($uid)
        {
        }
        /**
         * When a user is logged out, ensure they have a unique nonce to manage cart and more using the customer/session ID.
         * This filter runs everything `wp_verify_nonce()` and `wp_create_nonce()` gets called.
         *
         * @since 5.3.0
         * @param int    $uid    User ID.
         * @param string $action The nonce action.
         * @return int|string
         */
        public function maybe_update_nonce_user_logged_out($uid, $action)
        {
        }
        /**
         * Cleanup session data from the database and clear caches.
         */
        public function cleanup_sessions()
        {
        }
        /**
         * Returns the session.
         *
         * @param string $customer_id Customer ID.
         * @param mixed  $default Default session value.
         * @return string|array
         */
        public function get_session($customer_id, $default = \false)
        {
        }
        /**
         * Delete the session from the cache and database.
         *
         * @param int $customer_id Customer ID.
         */
        public function delete_session($customer_id)
        {
        }
        /**
         * Update the session expiry timestamp.
         *
         * @param string $customer_id Customer ID.
         * @param int    $timestamp Timestamp to expire the cookie.
         */
        public function update_session_timestamp($customer_id, $timestamp)
        {
        }
    }
    /**
     * Shipping rate class.
     */
    class WC_Shipping_Rate
    {
        /**
         * Stores data for this rate.
         *
         * @since 3.2.0
         * @var   array
         */
        protected $data = array('id' => '', 'method_id' => '', 'instance_id' => 0, 'label' => '', 'cost' => 0, 'taxes' => array());
        /**
         * Stores meta data for this rate.
         *
         * @since 2.6.0
         * @var   array
         */
        protected $meta_data = array();
        /**
         * Constructor.
         *
         * @param string  $id          Shipping rate ID.
         * @param string  $label       Shipping rate label.
         * @param integer $cost        Cost.
         * @param array   $taxes       Taxes applied to shipping rate.
         * @param string  $method_id   Shipping method ID.
         * @param int     $instance_id Shipping instance ID.
         */
        public function __construct($id = '', $label = '', $cost = 0, $taxes = array(), $method_id = '', $instance_id = 0)
        {
        }
        /**
         * Magic methods to support direct access to props.
         *
         * @since 3.2.0
         * @param string $key Key.
         * @return bool
         */
        public function __isset($key)
        {
        }
        /**
         * Magic methods to support direct access to props.
         *
         * @since 3.2.0
         * @param string $key Key.
         * @return mixed
         */
        public function __get($key)
        {
        }
        /**
         * Magic methods to support direct access to props.
         *
         * @since 3.2.0
         * @param string $key   Key.
         * @param mixed  $value Value.
         */
        public function __set($key, $value)
        {
        }
        /**
         * Set ID for the rate. This is usually a combination of the method and instance IDs.
         *
         * @since 3.2.0
         * @param string $id Shipping rate ID.
         */
        public function set_id($id)
        {
        }
        /**
         * Set shipping method ID the rate belongs to.
         *
         * @since 3.2.0
         * @param string $method_id Shipping method ID.
         */
        public function set_method_id($method_id)
        {
        }
        /**
         * Set instance ID the rate belongs to.
         *
         * @since 3.2.0
         * @param int $instance_id Instance ID.
         */
        public function set_instance_id($instance_id)
        {
        }
        /**
         * Set rate label.
         *
         * @since 3.2.0
         * @param string $label Shipping rate label.
         */
        public function set_label($label)
        {
        }
        /**
         * Set rate cost.
         *
         * @todo 4.0 Prevent negative value being set. #19293
         * @since 3.2.0
         * @param string $cost Shipping rate cost.
         */
        public function set_cost($cost)
        {
        }
        /**
         * Set rate taxes.
         *
         * @since 3.2.0
         * @param array $taxes List of taxes applied to shipping rate.
         */
        public function set_taxes($taxes)
        {
        }
        /**
         * Get ID for the rate. This is usually a combination of the method and instance IDs.
         *
         * @since 3.2.0
         * @return string
         */
        public function get_id()
        {
        }
        /**
         * Get shipping method ID the rate belongs to.
         *
         * @since 3.2.0
         * @return string
         */
        public function get_method_id()
        {
        }
        /**
         * Get instance ID the rate belongs to.
         *
         * @since 3.2.0
         * @return int
         */
        public function get_instance_id()
        {
        }
        /**
         * Get rate label.
         *
         * @return string
         */
        public function get_label()
        {
        }
        /**
         * Get rate cost.
         *
         * @since 3.2.0
         * @return string
         */
        public function get_cost()
        {
        }
        /**
         * Get rate taxes.
         *
         * @since 3.2.0
         * @return array
         */
        public function get_taxes()
        {
        }
        /**
         * Get shipping tax.
         *
         * @return float
         */
        public function get_shipping_tax()
        {
        }
        /**
         * Add some meta data for this rate.
         *
         * @since 2.6.0
         * @param string $key   Key.
         * @param string $value Value.
         */
        public function add_meta_data($key, $value)
        {
        }
        /**
         * Get all meta data for this rate.
         *
         * @since 2.6.0
         * @return array
         */
        public function get_meta_data()
        {
        }
    }
    /**
     * Legacy Shipping Zone.
     *
     * @version  3.0.0
     * @package  WooCommerce\Classes
     * @category Class
     * @author   WooThemes
     */
    abstract class WC_Legacy_Shipping_Zone extends \WC_Data
    {
        /**
         * Get zone ID
         * @return int|null Null if the zone does not exist. 0 is the default zone.
         * @deprecated 3.0
         */
        public function get_zone_id()
        {
        }
        /**
         * Read a shipping zone by ID.
         * @deprecated 3.0.0 - Init a shipping zone with an ID.
         *
         * @param int $zone_id
         */
        public function read($zone_id)
        {
        }
        /**
         * Update a zone.
         * @deprecated 3.0.0 - Use ::save instead.
         */
        public function update()
        {
        }
        /**
         * Create a zone.
         * @deprecated 3.0.0 - Use ::save instead.
         */
        public function create()
        {
        }
    }
    /**
     * WC_Shipping_Zone class.
     */
    class WC_Shipping_Zone extends \WC_Legacy_Shipping_Zone
    {
        /**
         * Zone ID
         *
         * @var int|null
         */
        protected $id = \null;
        /**
         * This is the name of this object type.
         *
         * @var string
         */
        protected $object_type = 'shipping_zone';
        /**
         * Zone Data.
         *
         * @var array
         */
        protected $data = array('zone_name' => '', 'zone_order' => 0, 'zone_locations' => array());
        /**
         * Constructor for zones.
         *
         * @param int|object $zone Zone ID to load from the DB or zone object.
         */
        public function __construct($zone = \null)
        {
        }
        /**
         * --------------------------------------------------------------------------
         * Getters
         * --------------------------------------------------------------------------
         */
        /**
         * Get zone name.
         *
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_zone_name($context = 'view')
        {
        }
        /**
         * Get zone order.
         *
         * @param  string $context View or edit context.
         * @return int
         */
        public function get_zone_order($context = 'view')
        {
        }
        /**
         * Get zone locations.
         *
         * @param  string $context View or edit context.
         * @return array of zone objects
         */
        public function get_zone_locations($context = 'view')
        {
        }
        /**
         * Return a text string representing what this zone is for.
         *
         * @param  int    $max Max locations to return.
         * @param  string $context View or edit context.
         * @return string
         */
        public function get_formatted_location($max = 10, $context = 'view')
        {
        }
        /**
         * Get shipping methods linked to this zone.
         *
         * @param bool   $enabled_only Only return enabled methods.
         * @param string $context Getting shipping methods for what context. Valid values, admin, json.
         * @return array of objects
         */
        public function get_shipping_methods($enabled_only = \false, $context = 'admin')
        {
        }
        /**
         * --------------------------------------------------------------------------
         * Setters
         * --------------------------------------------------------------------------
         */
        /**
         * Set zone name.
         *
         * @param string $set Value to set.
         */
        public function set_zone_name($set)
        {
        }
        /**
         * Set zone order. Value to set.
         *
         * @param int $set Value to set.
         */
        public function set_zone_order($set)
        {
        }
        /**
         * Set zone locations.
         *
         * @since 3.0.0
         * @param array $locations Value to set.
         */
        public function set_zone_locations($locations)
        {
        }
        /**
         * --------------------------------------------------------------------------
         * Other
         * --------------------------------------------------------------------------
         */
        /**
         * Save zone data to the database.
         *
         * @return int
         */
        public function save()
        {
        }
        /**
         * Generate a zone name based on location.
         *
         * @return string
         */
        protected function generate_zone_name()
        {
        }
        /**
         * Location type detection.
         *
         * @param  object $location Location to check.
         * @return boolean
         */
        private function location_is_continent($location)
        {
        }
        /**
         * Location type detection.
         *
         * @param  object $location Location to check.
         * @return boolean
         */
        private function location_is_country($location)
        {
        }
        /**
         * Location type detection.
         *
         * @param  object $location Location to check.
         * @return boolean
         */
        private function location_is_state($location)
        {
        }
        /**
         * Location type detection.
         *
         * @param  object $location Location to check.
         * @return boolean
         */
        private function location_is_postcode($location)
        {
        }
        /**
         * Is passed location type valid?
         *
         * @param  string $type Type to check.
         * @return boolean
         */
        public function is_valid_location_type($type)
        {
        }
        /**
         * Add location (state or postcode) to a zone.
         *
         * @param string $code Location code.
         * @param string $type state or postcode.
         */
        public function add_location($code, $type)
        {
        }
        /**
         * Clear all locations for this zone.
         *
         * @param array|string $types of location to clear.
         */
        public function clear_locations($types = array('postcode', 'state', 'country', 'continent'))
        {
        }
        /**
         * Set locations.
         *
         * @param array $locations Array of locations.
         */
        public function set_locations($locations = array())
        {
        }
        /**
         * Add a shipping method to this zone.
         *
         * @param string $type shipping method type.
         * @return int new instance_id, 0 on failure
         */
        public function add_shipping_method($type)
        {
        }
        /**
         * Delete a shipping method from a zone.
         *
         * @param int $instance_id Shipping method instance ID.
         * @return True on success, false on failure
         */
        public function delete_shipping_method($instance_id)
        {
        }
    }
    /**
     * Shipping zones class.
     */
    class WC_Shipping_Zones
    {
        /**
         * Get shipping zones from the database.
         *
         * @since 2.6.0
         * @param string $context Getting shipping methods for what context. Valid values, admin, json.
         * @return array Array of arrays.
         */
        public static function get_zones($context = 'admin')
        {
        }
        /**
         * Get shipping zone using it's ID
         *
         * @since 2.6.0
         * @param int $zone_id Zone ID.
         * @return WC_Shipping_Zone|bool
         */
        public static function get_zone($zone_id)
        {
        }
        /**
         * Get shipping zone by an ID.
         *
         * @since 2.6.0
         * @param string $by Get by 'zone_id' or 'instance_id'.
         * @param int    $id ID.
         * @return WC_Shipping_Zone|bool
         */
        public static function get_zone_by($by = 'zone_id', $id = 0)
        {
        }
        /**
         * Get shipping zone using it's ID.
         *
         * @since 2.6.0
         * @param int $instance_id Instance ID.
         * @return bool|WC_Shipping_Method
         */
        public static function get_shipping_method($instance_id)
        {
        }
        /**
         * Delete a zone using it's ID
         *
         * @param int $zone_id Zone ID.
         * @since 2.6.0
         */
        public static function delete_zone($zone_id)
        {
        }
        /**
         * Find a matching zone for a given package.
         *
         * @since  2.6.0
         * @uses   wc_make_numeric_postcode()
         * @param  array $package Shipping package.
         * @return WC_Shipping_Zone
         */
        public static function get_zone_matching_package($package)
        {
        }
    }
    /**
     * Shipping class.
     */
    class WC_Shipping
    {
        /**
         * True if shipping is enabled.
         *
         * @var bool
         */
        public $enabled = \false;
        /**
         * Stores methods loaded into woocommerce.
         *
         * @var array|null
         */
        public $shipping_methods = \null;
        /**
         * Stores the shipping classes.
         *
         * @var array
         */
        public $shipping_classes = array();
        /**
         * Stores packages to ship and to get quotes for.
         *
         * @var array
         */
        public $packages = array();
        /**
         * The single instance of the class
         *
         * @var WC_Shipping
         * @since 2.1
         */
        protected static $_instance = \null;
        /**
         * Main WC_Shipping Instance.
         *
         * Ensures only one instance of WC_Shipping is loaded or can be loaded.
         *
         * @since 2.1
         * @return WC_Shipping Main instance
         */
        public static function instance()
        {
        }
        /**
         * Cloning is forbidden.
         *
         * @since 2.1
         */
        public function __clone()
        {
        }
        /**
         * Unserializing instances of this class is forbidden.
         *
         * @since 2.1
         */
        public function __wakeup()
        {
        }
        /**
         * Magic getter.
         *
         * @param string $name Property name.
         * @return mixed
         */
        public function __get($name)
        {
        }
        /**
         * Initialize shipping.
         */
        public function __construct()
        {
        }
        /**
         * Initialize shipping.
         */
        public function init()
        {
        }
        /**
         * Shipping methods register themselves by returning their main class name through the woocommerce_shipping_methods filter.
         *
         * @return array
         */
        public function get_shipping_method_class_names()
        {
        }
        /**
         * Loads all shipping methods which are hooked in.
         * If a $package is passed, some methods may add themselves conditionally and zones will be used.
         *
         * @param array $package Package information.
         * @return WC_Shipping_Method[]
         */
        public function load_shipping_methods($package = array())
        {
        }
        /**
         * Register a shipping method.
         *
         * @param object|string $method Either the name of the method's class, or an instance of the method's class.
         *
         * @return bool|void
         */
        public function register_shipping_method($method)
        {
        }
        /**
         * Unregister shipping methods.
         */
        public function unregister_shipping_methods()
        {
        }
        /**
         * Returns all registered shipping methods for usage.
         *
         * @return WC_Shipping_Method[]
         */
        public function get_shipping_methods()
        {
        }
        /**
         * Get an array of shipping classes.
         *
         * @return array
         */
        public function get_shipping_classes()
        {
        }
        /**
         * Calculate shipping for (multiple) packages of cart items.
         *
         * @param array $packages multi-dimensional array of cart items to calc shipping for.
         * @return array Array of calculated packages.
         */
        public function calculate_shipping($packages = array())
        {
        }
        /**
         * See if package is shippable.
         *
         * Packages are shippable until proven otherwise e.g. after getting a shipping country.
         *
         * @param  array $package Package of cart items.
         * @return bool
         */
        public function is_package_shippable($package)
        {
        }
        /**
         * Calculate shipping rates for a package,
         *
         * Calculates each shipping methods cost. Rates are stored in the session based on the package hash to avoid re-calculation every page load.
         *
         * @param array $package Package of cart items.
         * @param int   $package_key Index of the package being calculated. Used to cache multiple package rates.
         *
         * @return array|bool
         */
        public function calculate_shipping_for_package($package = array(), $package_key = 0)
        {
        }
        /**
         * Get packages.
         *
         * @return array
         */
        public function get_packages()
        {
        }
        /**
         * Reset shipping.
         *
         * Reset the totals for shipping as a whole.
         */
        public function reset_shipping()
        {
        }
        /**
         * Deprecated
         *
         * @deprecated 2.6.0 Was previously used to determine sort order of methods, but this is now controlled by zones and thus unused.
         */
        public function sort_shipping_methods()
        {
        }
    }
    /**
     * WooCommerce Shortcodes class.
     */
    class WC_Shortcodes
    {
        /**
         * Init shortcodes.
         */
        public static function init()
        {
        }
        /**
         * Shortcode Wrapper.
         *
         * @param string[] $function Callback function.
         * @param array    $atts     Attributes. Default to empty array.
         * @param array    $wrapper  Customer wrapper data.
         *
         * @return string
         */
        public static function shortcode_wrapper($function, $atts = array(), $wrapper = array('class' => 'woocommerce', 'before' => \null, 'after' => \null))
        {
        }
        /**
         * Cart page shortcode.
         *
         * @return string
         */
        public static function cart()
        {
        }
        /**
         * Checkout page shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function checkout($atts)
        {
        }
        /**
         * Order tracking page shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function order_tracking($atts)
        {
        }
        /**
         * My account page shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function my_account($atts)
        {
        }
        /**
         * List products in a category shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_category($atts)
        {
        }
        /**
         * List all (or limited) product categories.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_categories($atts)
        {
        }
        /**
         * Recent Products shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function recent_products($atts)
        {
        }
        /**
         * List multiple products shortcode.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function products($atts)
        {
        }
        /**
         * Display a single product.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product($atts)
        {
        }
        /**
         * Display a single product price + cart button.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_add_to_cart($atts)
        {
        }
        /**
         * Get the add to cart URL for a product.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_add_to_cart_url($atts)
        {
        }
        /**
         * List all products on sale.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function sale_products($atts)
        {
        }
        /**
         * List best selling products on sale.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function best_selling_products($atts)
        {
        }
        /**
         * List top rated products on sale.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function top_rated_products($atts)
        {
        }
        /**
         * Output featured products.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function featured_products($atts)
        {
        }
        /**
         * Show a single product page.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_page($atts)
        {
        }
        /**
         * Show messages.
         *
         * @return string
         */
        public static function shop_messages()
        {
        }
        /**
         * Order by rating.
         *
         * @deprecated 3.2.0 Use WC_Shortcode_Products::order_by_rating_post_clauses().
         * @param      array $args Query args.
         * @return     array
         */
        public static function order_by_rating_post_clauses($args)
        {
        }
        /**
         * List products with an attribute shortcode.
         * Example [product_attribute attribute="color" filter="black"].
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function product_attribute($atts)
        {
        }
        /**
         * List related products.
         *
         * @param array $atts Attributes.
         * @return string
         */
        public static function related_products($atts)
        {
        }
    }
    /**
     * Structured data class.
     */
    class WC_Structured_Data
    {
        /**
         * Stores the structured data.
         *
         * @var array $_data Array of structured data.
         */
        private $_data = array();
        /**
         * Constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets data.
         *
         * @param  array $data  Structured data.
         * @param  bool  $reset Unset data (default: false).
         * @return bool
         */
        public function set_data($data, $reset = \false)
        {
        }
        /**
         * Gets data.
         *
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Structures and returns data.
         *
         * List of types available by default for specific request:
         *
         * 'product',
         * 'review',
         * 'breadcrumblist',
         * 'website',
         * 'order',
         *
         * @param  array $types Structured data types.
         * @return array
         */
        public function get_structured_data($types)
        {
        }
        /**
         * Get data types for pages.
         *
         * @return array
         */
        protected function get_data_type_for_page()
        {
        }
        /**
         * Makes sure email structured data only outputs on non-plain text versions.
         *
         * @param WP_Order $order         Order data.
         * @param bool     $sent_to_admin Send to admin (default: false).
         * @param bool     $plain_text    Plain text email (default: false).
         */
        public function output_email_structured_data($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
        /**
         * Sanitizes, encodes and outputs structured data.
         *
         * Hooked into `wp_footer` action hook.
         * Hooked into `woocommerce_email_order_details` action hook.
         */
        public function output_structured_data()
        {
        }
        /*
        |--------------------------------------------------------------------------
        | Generators
        |--------------------------------------------------------------------------
        |
        | Methods for generating specific structured data types:
        |
        | - Product
        | - Review
        | - BreadcrumbList
        | - WebSite
        | - Order
        |
        | The generated data is stored into `$this->_data`.
        | See the methods above for handling `$this->_data`.
        |
        */
        /**
         * Generates Product structured data.
         *
         * Hooked into `woocommerce_single_product_summary` action hook.
         *
         * @param WC_Product $product Product data (default: null).
         */
        public function generate_product_data($product = \null)
        {
        }
        /**
         * Generates Review structured data.
         *
         * Hooked into `woocommerce_review_meta` action hook.
         *
         * @param WP_Comment $comment Comment data.
         */
        public function generate_review_data($comment)
        {
        }
        /**
         * Generates BreadcrumbList structured data.
         *
         * Hooked into `woocommerce_breadcrumb` action hook.
         *
         * @param WC_Breadcrumb $breadcrumbs Breadcrumb data.
         */
        public function generate_breadcrumblist_data($breadcrumbs)
        {
        }
        /**
         * Generates WebSite structured data.
         *
         * Hooked into `woocommerce_before_main_content` action hook.
         */
        public function generate_website_data()
        {
        }
        /**
         * Generates Order structured data.
         *
         * Hooked into `woocommerce_email_order_details` action hook.
         *
         * @param WP_Order $order         Order data.
         * @param bool     $sent_to_admin Send to admin (default: false).
         * @param bool     $plain_text    Plain text email (default: false).
         */
        public function generate_order_data($order, $sent_to_admin = \false, $plain_text = \false)
        {
        }
    }
    /**
     * Performs tax calculations and loads tax rates
     *
     * @class WC_Tax
     */
    class WC_Tax
    {
        /**
         * Precision.
         *
         * @var int
         */
        public static $precision;
        /**
         * Round at subtotal.
         *
         * @var bool
         */
        public static $round_at_subtotal = \false;
        /**
         * Load options.
         */
        public static function init()
        {
        }
        /**
         * When the woocommerce_tax_classes option is changed, remove any orphan rates.
         *
         * @deprecated 3.7.0
         * @param  string $old_value Old rates value.
         * @param  string $value New rates value.
         */
        public static function maybe_remove_tax_class_rates($old_value, $value)
        {
        }
        /**
         * Calculate tax for a line.
         *
         * @param  float   $price              Price to calc tax on.
         * @param  array   $rates              Rates to apply.
         * @param  boolean $price_includes_tax Whether the passed price has taxes included.
         * @param  boolean $deprecated         Whether to suppress any rounding from taking place. No longer used here.
         * @return array                       Array of rates + prices after tax.
         */
        public static function calc_tax($price, $rates, $price_includes_tax = \false, $deprecated = \false)
        {
        }
        /**
         * Calculate the shipping tax using a passed array of rates.
         *
         * @param float $price Shipping cost.
         * @param array $rates Taxation Rate.
         * @return array
         */
        public static function calc_shipping_tax($price, $rates)
        {
        }
        /**
         * Round to precision.
         *
         * Filter example: to return rounding to .5 cents you'd use:
         *
         * function euro_5cent_rounding( $in ) {
         *      return round( $in / 5, 2 ) * 5;
         * }
         * add_filter( 'woocommerce_tax_round', 'euro_5cent_rounding' );
         *
         * @param float|int $in Value to round.
         * @return float
         */
        public static function round($in)
        {
        }
        /**
         * Calc tax from inclusive price.
         *
         * @param  float $price Price to calculate tax for.
         * @param  array $rates Array of tax rates.
         * @return array
         */
        public static function calc_inclusive_tax($price, $rates)
        {
        }
        /**
         * Calc tax from exclusive price.
         *
         * @param  float $price Price to calculate tax for.
         * @param  array $rates Array of tax rates.
         * @return array
         */
        public static function calc_exclusive_tax($price, $rates)
        {
        }
        /**
         * Searches for all matching country/state/postcode tax rates.
         *
         * @param array $args Args that determine the rate to find.
         * @return array
         */
        public static function find_rates($args = array())
        {
        }
        /**
         * Searches for all matching country/state/postcode tax rates.
         *
         * @param array $args Args that determine the rate to find.
         * @return array
         */
        public static function find_shipping_rates($args = array())
        {
        }
        /**
         * Does the sort comparison. Compares (in this order):
         * - Priority
         * - Country
         * - State
         * - Number of postcodes
         * - Number of cities
         * - ID
         *
         * @param object $rate1 First rate to compare.
         * @param object $rate2 Second rate to compare.
         * @return int
         */
        private static function sort_rates_callback($rate1, $rate2)
        {
        }
        /**
         * Logical sort order for tax rates based on the following in order of priority.
         *
         * @param  array $rates Rates to be sorted.
         * @return array
         */
        private static function sort_rates($rates)
        {
        }
        /**
         * Loop through a set of tax rates and get the matching rates (1 per priority).
         *
         * @param  string $country Country code to match against.
         * @param  string $state State code to match against.
         * @param  string $postcode Postcode to match against.
         * @param  string $city City to match against.
         * @param  string $tax_class Tax class to match against.
         * @return array
         */
        private static function get_matched_tax_rates($country, $state, $postcode, $city, $tax_class)
        {
        }
        /**
         * Get the customer tax location based on their status and the current page.
         *
         * Used by get_rates(), get_shipping_rates().
         *
         * @param  string $tax_class string Optional, passed to the filter for advanced tax setups.
         * @param  object $customer Override the customer object to get their location.
         * @return array
         */
        public static function get_tax_location($tax_class = '', $customer = \null)
        {
        }
        /**
         * Get's an array of matching rates for a tax class.
         *
         * @param string $tax_class Tax class to get rates for.
         * @param object $customer Override the customer object to get their location.
         * @return  array
         */
        public static function get_rates($tax_class = '', $customer = \null)
        {
        }
        /**
         * Get's an array of matching rates from location and tax class. $customer parameter is used to preserve backward compatibility for filter.
         *
         * @param string $tax_class Tax class to get rates for.
         * @param array  $location  Location to compute rates for. Should be in form: array( country, state, postcode, city).
         * @param object $customer  Only used to maintain backward compatibility for filter `woocommerce-matched_rates`.
         *
         * @return mixed|void Tax rates.
         */
        public static function get_rates_from_location($tax_class, $location, $customer = \null)
        {
        }
        /**
         * Get's an array of matching rates for the shop's base country.
         *
         * @param string $tax_class Tax Class.
         * @return array
         */
        public static function get_base_tax_rates($tax_class = '')
        {
        }
        /**
         * Alias for get_base_tax_rates().
         *
         * @deprecated 2.3
         * @param string $tax_class Tax Class.
         * @return array
         */
        public static function get_shop_base_rate($tax_class = '')
        {
        }
        /**
         * Gets an array of matching shipping tax rates for a given class.
         *
         * @param string $tax_class Tax class to get rates for.
         * @param object $customer Override the customer object to get their location.
         * @return mixed
         */
        public static function get_shipping_tax_rates($tax_class = \null, $customer = \null)
        {
        }
        /**
         * Return true/false depending on if a rate is a compound rate.
         *
         * @param mixed $key_or_rate Tax rate ID, or the db row itself in object format.
         * @return  bool
         */
        public static function is_compound($key_or_rate)
        {
        }
        /**
         * Return a given rates label.
         *
         * @param mixed $key_or_rate Tax rate ID, or the db row itself in object format.
         * @return  string
         */
        public static function get_rate_label($key_or_rate)
        {
        }
        /**
         * Return a given rates percent.
         *
         * @param mixed $key_or_rate Tax rate ID, or the db row itself in object format.
         * @return  string
         */
        public static function get_rate_percent($key_or_rate)
        {
        }
        /**
         * Return a given rates percent.
         *
         * @param mixed $key_or_rate Tax rate ID, or the db row itself in object format.
         * @return  float
         */
        public static function get_rate_percent_value($key_or_rate)
        {
        }
        /**
         * Get a rates code. Code is made up of COUNTRY-STATE-NAME-Priority. E.g GB-VAT-1, US-AL-TAX-1.
         *
         * @param mixed $key_or_rate Tax rate ID, or the db row itself in object format.
         * @return string
         */
        public static function get_rate_code($key_or_rate)
        {
        }
        /**
         * Sums a set of taxes to form a single total. Values are pre-rounded to precision from 3.6.0.
         *
         * @param  array $taxes Array of taxes.
         * @return float
         */
        public static function get_tax_total($taxes)
        {
        }
        /**
         * Gets all tax rate classes from the database.
         *
         * @since 3.7.0
         * @return array Array of tax class objects consisting of tax_rate_class_id, name, and slug.
         */
        public static function get_tax_rate_classes()
        {
        }
        /**
         * Get store tax class names.
         *
         * @return array Array of class names ("Reduced rate", "Zero rate", etc).
         */
        public static function get_tax_classes()
        {
        }
        /**
         * Get store tax classes as slugs.
         *
         * @since  3.0.0
         * @return array Array of class slugs ("reduced-rate", "zero-rate", etc).
         */
        public static function get_tax_class_slugs()
        {
        }
        /**
         * Create a new tax class.
         *
         * @since 3.7.0
         * @param string $name Name of the tax class to add.
         * @param string $slug (optional) Slug of the tax class to add. Defaults to sanitized name.
         * @return WP_Error|array Returns name and slug (array) if the tax class is created, or WP_Error if something went wrong.
         */
        public static function create_tax_class($name, $slug = '')
        {
        }
        /**
         * Get an existing tax class.
         *
         * @since 3.7.0
         * @param string     $field Field to get by. Valid values are id, name, or slug.
         * @param string|int $item Item to get.
         * @return array|bool Returns the tax class as an array. False if not found.
         */
        public static function get_tax_class_by($field, $item)
        {
        }
        /**
         * Delete an existing tax class.
         *
         * @since 3.7.0
         * @param string     $field Field to delete by. Valid values are id, name, or slug.
         * @param string|int $item Item to delete.
         * @return WP_Error|bool Returns true if deleted successfully, false if nothing was deleted, or WP_Error if there is an invalid request.
         */
        public static function delete_tax_class_by($field, $item)
        {
        }
        /**
         * Format the city.
         *
         * @param  string $city Value to format.
         * @return string
         */
        private static function format_tax_rate_city($city)
        {
        }
        /**
         * Format the state.
         *
         * @param  string $state Value to format.
         * @return string
         */
        private static function format_tax_rate_state($state)
        {
        }
        /**
         * Format the country.
         *
         * @param  string $country Value to format.
         * @return string
         */
        private static function format_tax_rate_country($country)
        {
        }
        /**
         * Format the tax rate name.
         *
         * @param  string $name Value to format.
         * @return string
         */
        private static function format_tax_rate_name($name)
        {
        }
        /**
         * Format the rate.
         *
         * @param  float $rate Value to format.
         * @return string
         */
        private static function format_tax_rate($rate)
        {
        }
        /**
         * Format the priority.
         *
         * @param  string $priority Value to format.
         * @return int
         */
        private static function format_tax_rate_priority($priority)
        {
        }
        /**
         * Format the class.
         *
         * @param  string $class Value to format.
         * @return string
         */
        public static function format_tax_rate_class($class)
        {
        }
        /**
         * Prepare and format tax rate for DB insertion.
         *
         * @param  array $tax_rate Tax rate to format.
         * @return array
         */
        private static function prepare_tax_rate($tax_rate)
        {
        }
        /**
         * Insert a new tax rate.
         *
         * Internal use only.
         *
         * @since 2.3.0
         *
         * @param  array $tax_rate Tax rate to insert.
         * @return int tax rate id
         */
        public static function _insert_tax_rate($tax_rate)
        {
        }
        /**
         * Get tax rate.
         *
         * Internal use only.
         *
         * @since 2.5.0
         *
         * @param int    $tax_rate_id Tax rate ID.
         * @param string $output_type Type of output.
         * @return array|object
         */
        public static function _get_tax_rate($tax_rate_id, $output_type = \ARRAY_A)
        {
        }
        /**
         * Update a tax rate.
         *
         * Internal use only.
         *
         * @since 2.3.0
         *
         * @param int   $tax_rate_id Tax rate to update.
         * @param array $tax_rate Tax rate values.
         */
        public static function _update_tax_rate($tax_rate_id, $tax_rate)
        {
        }
        /**
         * Delete a tax rate from the database.
         *
         * Internal use only.
         *
         * @since 2.3.0
         * @param  int $tax_rate_id Tax rate to delete.
         */
        public static function _delete_tax_rate($tax_rate_id)
        {
        }
        /**
         * Update postcodes for a tax rate in the DB.
         *
         * Internal use only.
         *
         * @since 2.3.0
         *
         * @param int    $tax_rate_id Tax rate to update.
         * @param string $postcodes String of postcodes separated by ; characters.
         */
        public static function _update_tax_rate_postcodes($tax_rate_id, $postcodes)
        {
        }
        /**
         * Update cities for a tax rate in the DB.
         *
         * Internal use only.
         *
         * @since 2.3.0
         *
         * @param int    $tax_rate_id Tax rate to update.
         * @param string $cities Cities to set.
         */
        public static function _update_tax_rate_cities($tax_rate_id, $cities)
        {
        }
        /**
         * Updates locations (postcode and city).
         *
         * Internal use only.
         *
         * @since 2.3.0
         *
         * @param int    $tax_rate_id Tax rate ID to update.
         * @param array  $values Values to set.
         * @param string $type Location type.
         */
        private static function update_tax_rate_locations($tax_rate_id, $values, $type)
        {
        }
        /**
         * Used by admin settings page.
         *
         * @param string $tax_class Tax class slug.
         *
         * @return array|null|object
         */
        public static function get_rates_for_tax_class($tax_class)
        {
        }
    }
    /**
     * Template loader class.
     */
    class WC_Template_Loader
    {
        /**
         * Store the shop page ID.
         *
         * @var integer
         */
        private static $shop_page_id = 0;
        /**
         * Store whether we're processing a product inside the_content filter.
         *
         * @var boolean
         */
        private static $in_content_filter = \false;
        /**
         * Is WooCommerce support defined?
         *
         * @var boolean
         */
        private static $theme_support = \false;
        /**
         * Hook in methods.
         */
        public static function init()
        {
        }
        /**
         * Load a template.
         *
         * Handles template usage so that we can use our own templates instead of the theme's.
         *
         * Templates are in the 'templates' folder. WooCommerce looks for theme
         * overrides in /theme/woocommerce/ by default.
         *
         * For beginners, it also looks for a woocommerce.php template first. If the user adds
         * this to the theme (containing a woocommerce() inside) this will be used for all
         * WooCommerce templates.
         *
         * @param string $template Template to load.
         * @return string
         */
        public static function template_loader($template)
        {
        }
        /**
         * Checks whether a block template for a given taxonomy exists.
         *
         * **Note:** This checks both the `templates` and `block-templates` directories
         * as both conventions should be supported.
         *
         * @param object $taxonomy Object taxonomy to check.
         * @return boolean
         */
        private static function taxonomy_has_block_template($taxonomy) : bool
        {
        }
        /**
         * Checks whether a block template with that name exists.
         *
         * **Note: ** This checks both the `templates` and `block-templates` directories
         * as both conventions should be supported.
         *
         * @since  5.5.0
         * @param string $template_name Template to check.
         * @return boolean
         */
        private static function has_block_template($template_name)
        {
        }
        /**
         * Get the default filename for a template except if a block template with
         * the same name exists.
         *
         * @since  3.0.0
         * @since  5.5.0 If a block template with the same name exists, return an
         * empty string.
         * @since  6.3.0 It checks custom product taxonomies
         * @return string
         */
        private static function get_template_loader_default_file()
        {
        }
        /**
         * Get an array of filenames to search for a given template.
         *
         * @since  3.0.0
         * @param  string $default_file The default file name.
         * @return string[]
         */
        private static function get_template_loader_files($default_file)
        {
        }
        /**
         * Load comments template.
         *
         * @param string $template template to load.
         * @return string
         */
        public static function comments_template_loader($template)
        {
        }
        /**
         * Unsupported theme compatibility methods.
         */
        /**
         * Hook in methods to enhance the unsupported theme experience on pages.
         *
         * @since 3.3.0
         */
        public static function unsupported_theme_init()
        {
        }
        /**
         * Hook in methods to enhance the unsupported theme experience on the Shop page.
         *
         * @since 3.3.0
         */
        private static function unsupported_theme_shop_page_init()
        {
        }
        /**
         * Hook in methods to enhance the unsupported theme experience on Product pages.
         *
         * @since 3.3.0
         */
        private static function unsupported_theme_product_page_init()
        {
        }
        /**
         * Add theme support for Product page gallery.
         *
         * @since x.x.x
         */
        private static function add_support_for_product_page_gallery()
        {
        }
        /**
         * Enhance the unsupported theme experience on Product Category and Attribute pages by rendering
         * those pages using the single template and shortcode-based content. To do this we make a dummy
         * post and set a shortcode as the post content. This approach is adapted from bbPress.
         *
         * @since 3.3.0
         */
        private static function unsupported_theme_tax_archive_init()
        {
        }
        /**
         * Add layered nav args to WP_Query args generated by the 'products' shortcode.
         *
         * @since 3.3.4
         * @param array $query WP_Query args.
         * @return array
         */
        public static function unsupported_archive_layered_nav_compatibility($query)
        {
        }
        /**
         * Force the loading of one of the single templates instead of whatever template was about to be loaded.
         *
         * @since 3.3.0
         * @param string $template Path to template.
         * @return string
         */
        public static function force_single_template_filter($template)
        {
        }
        /**
         * Get information about the current shop page view.
         *
         * @since 3.3.0
         * @return array
         */
        private static function get_current_shop_view_args()
        {
        }
        /**
         * Filter the title and insert WooCommerce content on the shop page.
         *
         * For non-WC themes, this will setup the main shop page to be shortcode based to improve default appearance.
         *
         * @since 3.3.0
         * @param string $title Existing title.
         * @param int    $id ID of the post being filtered.
         * @return string
         */
        public static function unsupported_theme_title_filter($title, $id)
        {
        }
        /**
         * Filter the content and insert WooCommerce content on the shop page.
         *
         * For non-WC themes, this will setup the main shop page to be shortcode based to improve default appearance.
         *
         * @since 3.3.0
         * @param string $content Existing post content.
         * @return string
         */
        public static function unsupported_theme_shop_content_filter($content)
        {
        }
        /**
         * Filter the content and insert WooCommerce content on the shop page.
         *
         * For non-WC themes, this will setup the main shop page to be shortcode based to improve default appearance.
         *
         * @since 3.3.0
         * @param string $content Existing post content.
         * @return string
         */
        public static function unsupported_theme_product_content_filter($content)
        {
        }
        /**
         * Suppress the comments number on the Shop page for unsupported themes since there is no commenting on the Shop page.
         *
         * @since 3.4.5
         * @param string $comments_number The comments number text.
         * @return string
         */
        public static function unsupported_theme_comments_number_filter($comments_number)
        {
        }
        /**
         * Are we filtering content for unsupported themes?
         *
         * @since 3.3.2
         * @return bool
         */
        public static function in_content_filter()
        {
        }
        /**
         * Prevent the main featured image on product pages because there will be another featured image
         * in the gallery.
         *
         * @since 3.3.0
         * @param string $html Img element HTML.
         * @return string
         */
        public static function unsupported_theme_single_featured_image_filter($html)
        {
        }
        /**
         * Remove the Review tab and just use the regular comment form.
         *
         * @param array $tabs Tab info.
         * @return array
         */
        public static function unsupported_theme_remove_review_tab($tabs)
        {
        }
    }
    // phpcs:disable Squiz.Classes.ClassFileName.NoMatch, Squiz.Classes.ValidClassName.NotCamelCaps -- Backwards compatibility.
    /**
     * WooCommerce Tracker Class
     */
    class WC_Tracker
    {
        // phpcs:enable
        /**
         * URL to the WooThemes Tracker API endpoint.
         *
         * @var string
         */
        private static $api_url = 'https://tracking.woocommerce.com/v1/';
        /**
         * Hook into cron event.
         */
        public static function init()
        {
        }
        /**
         * Decide whether to send tracking data or not.
         *
         * @param boolean $override Should override?.
         */
        public static function send_tracking_data($override = \false)
        {
        }
        /**
         * Get the last time tracking data was sent.
         *
         * @return int|bool
         */
        private static function get_last_send_time()
        {
        }
        /**
         * Test whether this site is a staging site according to the Jetpack criteria.
         *
         * With Jetpack 8.1+, Jetpack::is_staging_site has been deprecated.
         * \Automattic\Jetpack\Status::is_staging_site is the replacement.
         * However, there are version of JP where \Automattic\Jetpack\Status exists, but does *not* contain is_staging_site method,
         * so with those, code still needs to use the previous check as a fallback.
         *
         * @return bool
         */
        private static function is_jetpack_staging_site()
        {
        }
        /**
         * Get all the tracking data.
         *
         * @return array
         */
        public static function get_tracking_data()
        {
        }
        /**
         * Get the current theme info, theme name and version.
         *
         * @return array
         */
        public static function get_theme_info()
        {
        }
        /**
         * Get WordPress related data.
         *
         * @return array
         */
        private static function get_wordpress_info()
        {
        }
        /**
         * Get server related info.
         *
         * @return array
         */
        private static function get_server_info()
        {
        }
        /**
         * Get all plugins grouped into activated or not.
         *
         * @return array
         */
        private static function get_all_plugins()
        {
        }
        /**
         * Get the settings of WooCommerce Payments plugin
         *
         * @return array
         */
        private static function get_wcpay_settings()
        {
        }
        /**
         * Check to see if the helper is connected to Woo.com
         *
         * @return string
         */
        private static function get_helper_connected()
        {
        }
        /**
         * Get user totals based on user role.
         *
         * @return array
         */
        private static function get_user_counts()
        {
        }
        /**
         * Get product totals based on product type.
         *
         * @return array
         */
        public static function get_product_counts()
        {
        }
        /**
         * Get order counts.
         *
         * @return array
         */
        private static function get_order_counts()
        {
        }
        /**
         * Combine all order data.
         *
         * @return array
         */
        private static function get_orders()
        {
        }
        /**
         * Get order totals.
         *
         * @since 5.4.0
         * @return array
         */
        private static function get_order_totals()
        {
        }
        /**
         * Get last order date.
         *
         * @return string
         */
        private static function get_order_dates()
        {
        }
        /**
         * Extract the group key for an associative array of objects which have unique ids in the key.
         * A 'group_key' property is introduced in the object.
         * For example, two objects with keys like 'WooDataPay ** #123' and 'WooDataPay ** #78' would
         * both have a group_key of 'WooDataPay **' after this function call.
         *
         * @param array  $objects     The array of objects that need to be grouped.
         * @param string $default_key The property that will be the default group_key.
         * @return array Contains the objects with a group_key property.
         */
        private static function extract_group_key($objects, $default_key)
        {
        }
        /**
         * Get order details by gateway.
         *
         * @return array
         */
        private static function get_orders_by_gateway()
        {
        }
        /**
         * Get orders origin details.
         *
         * @return array
         */
        private static function get_orders_origins()
        {
        }
        /**
         * Get review counts for different statuses.
         *
         * @return array
         */
        private static function get_review_counts()
        {
        }
        /**
         * Get the number of product categories.
         *
         * @return int
         */
        private static function get_category_counts()
        {
        }
        /**
         * Get a list of all active payment gateways.
         *
         * @return array
         */
        private static function get_active_payment_gateways()
        {
        }
        /**
         * Get a list of all active shipping methods.
         *
         * @return array
         */
        private static function get_active_shipping_methods()
        {
        }
        /**
         * Get an ar